/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.crypto;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J3\u0010\u0013\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\b\u0010\u0019\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/microsoft/identity/common/crypto/CipherSpec;", "", "algorithmParameterSpec", "Ljava/security/spec/AlgorithmParameterSpec;", "algorithm", "", "mode", "padding", "(Ljava/security/spec/AlgorithmParameterSpec;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAlgorithmParameterSpec", "()Ljava/security/spec/AlgorithmParameterSpec;", "getPadding", "()Ljava/lang/String;", "transformation", "getTransformation", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "common_distRelease"})
public final class CipherSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final AlgorithmParameterSpec algorithmParameterSpec;
    @NotNull
    private final String algorithm;
    @NotNull
    private final String mode;
    @NotNull
    private final String padding;
    @NotNull
    private final String transformation;
    @NotNull
    private static final String RSA_ALGORITHM = "RSA";
    @NotNull
    private static final String OAEP_PADDING_WITH_256MGF1 = "OAEPwithSHA-256andMGF1Padding";
    @NotNull
    private static final String MODE_ECB = "ECB";
    @NotNull
    private static final String MODE_NONE = "NONE";
    @NotNull
    private static final String PKCS1_PADDING = "PKCS1Padding";
    @NotNull
    private static final OAEPParameterSpec OAEP_SPECS = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT);
    @NotNull
    private static final CipherSpec pkcs1CipherSpec = new CipherSpec(null, "RSA", "ECB", "PKCS1Padding");
    @NotNull
    private static final CipherSpec oaepCipherSpec = new CipherSpec(OAEP_SPECS, "RSA", "NONE", "OAEPwithSHA-256andMGF1Padding");

    public CipherSpec(@Nullable AlgorithmParameterSpec algorithmParameterSpec, @NotNull String algorithm, @NotNull String mode, @NotNull String padding) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)padding, (String)"padding");
        this.algorithmParameterSpec = algorithmParameterSpec;
        this.algorithm = algorithm;
        this.mode = mode;
        this.padding = padding;
        this.transformation = this.algorithm + '/' + this.mode + '/' + this.padding;
    }

    @Nullable
    public final AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.algorithmParameterSpec;
    }

    @NotNull
    public final String getPadding() {
        return this.padding;
    }

    @NotNull
    public final String getTransformation() {
        return this.transformation;
    }

    @NotNull
    public String toString() {
        return "CipherSpec(transformation='" + this.transformation + "')";
    }

    @Nullable
    public final AlgorithmParameterSpec component1() {
        return this.algorithmParameterSpec;
    }

    private final String component2() {
        return this.algorithm;
    }

    private final String component3() {
        return this.mode;
    }

    @NotNull
    public final String component4() {
        return this.padding;
    }

    @NotNull
    public final CipherSpec copy(@Nullable AlgorithmParameterSpec algorithmParameterSpec, @NotNull String algorithm, @NotNull String mode, @NotNull String padding) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)padding, (String)"padding");
        return new CipherSpec(algorithmParameterSpec, algorithm, mode, padding);
    }

    public static /* synthetic */ CipherSpec copy$default(CipherSpec cipherSpec, AlgorithmParameterSpec algorithmParameterSpec, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            algorithmParameterSpec = cipherSpec.algorithmParameterSpec;
        }
        if ((n & 2) != 0) {
            string = cipherSpec.algorithm;
        }
        if ((n & 4) != 0) {
            string2 = cipherSpec.mode;
        }
        if ((n & 8) != 0) {
            string3 = cipherSpec.padding;
        }
        return cipherSpec.copy(algorithmParameterSpec, string, string2, string3);
    }

    public int hashCode() {
        int result = this.algorithmParameterSpec == null ? 0 : this.algorithmParameterSpec.hashCode();
        result = result * 31 + this.algorithm.hashCode();
        result = result * 31 + this.mode.hashCode();
        result = result * 31 + this.padding.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CipherSpec)) {
            return false;
        }
        CipherSpec cipherSpec = (CipherSpec)other;
        if (!Intrinsics.areEqual((Object)this.algorithmParameterSpec, (Object)cipherSpec.algorithmParameterSpec)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.algorithm, (Object)cipherSpec.algorithm)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.mode, (Object)cipherSpec.mode)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.padding, (Object)cipherSpec.padding);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/microsoft/identity/common/crypto/CipherSpec$Companion;", "", "()V", "MODE_ECB", "", "MODE_NONE", "OAEP_PADDING_WITH_256MGF1", "OAEP_SPECS", "Ljavax/crypto/spec/OAEPParameterSpec;", "PKCS1_PADDING", "RSA_ALGORITHM", "oaepCipherSpec", "Lcom/microsoft/identity/common/crypto/CipherSpec;", "getOaepCipherSpec", "()Lcom/microsoft/identity/common/crypto/CipherSpec;", "pkcs1CipherSpec", "getPkcs1CipherSpec", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CipherSpec getPkcs1CipherSpec() {
            return pkcs1CipherSpec;
        }

        @NotNull
        public final CipherSpec getOaepCipherSpec() {
            return oaepCipherSpec;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

