/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.crypto;

import android.content.Context;
import com.microsoft.identity.common.adal.internal.AuthenticationSettings;
import com.microsoft.identity.common.crypto.KeyStoreBackedSecretKeyProviderFactory;
import com.microsoft.identity.common.java.crypto.StorageEncryptionManager;
import com.microsoft.identity.common.java.crypto.key.ISecretKeyProvider;
import com.microsoft.identity.common.java.crypto.key.PredefinedKeyProvider;
import com.microsoft.identity.common.logging.Logger;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class AndroidAuthSdkStorageEncryptionManager
extends StorageEncryptionManager {
    private static final String TAG = AndroidAuthSdkStorageEncryptionManager.class.getSimpleName();
    public static final String WRAPPING_KEY_ALIAS = "AdalKey";
    public static final String WRAPPED_KEY_FILE_NAME = "adalks";
    private final PredefinedKeyProvider mPredefinedKeyProvider;
    private final ISecretKeyProvider mKeyStoreKeyProvider;

    public AndroidAuthSdkStorageEncryptionManager(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.mPredefinedKeyProvider = AuthenticationSettings.INSTANCE.getSecretKeyData() == null ? null : new PredefinedKeyProvider("USER_DEFINED_KEY", AuthenticationSettings.INSTANCE.getSecretKeyData());
        this.mKeyStoreKeyProvider = KeyStoreBackedSecretKeyProviderFactory.INSTANCE.create(WRAPPING_KEY_ALIAS, WRAPPED_KEY_FILE_NAME, context);
    }

    @NonNull
    public ISecretKeyProvider getKeyProviderForEncryption() {
        if (this.mPredefinedKeyProvider != null) {
            return this.mPredefinedKeyProvider;
        }
        return this.mKeyStoreKeyProvider;
    }

    @NonNull
    public List<ISecretKeyProvider> getKeyProviderForDecryption(byte[] cipherText) {
        String methodTag = TAG + ":getKeyLoaderForDecryption";
        String keyIdentifier = AndroidAuthSdkStorageEncryptionManager.getKeyIdentifierFromCipherText((byte[])cipherText);
        if ("U001".equalsIgnoreCase(keyIdentifier)) {
            if (this.mPredefinedKeyProvider != null) {
                return Collections.singletonList(this.mPredefinedKeyProvider);
            }
            throw new IllegalStateException("Cipher Text is encrypted by USER_PROVIDED_KEY_IDENTIFIER, but mPredefinedKeyProvider is null.");
        }
        if (this.mKeyStoreKeyProvider.getKeyTypeIdentifier().equalsIgnoreCase(keyIdentifier)) {
            return Collections.singletonList(this.mKeyStoreKeyProvider);
        }
        Logger.warn(methodTag, "Cannot find a matching key to decrypt the given blob. Key Identifier = " + keyIdentifier);
        return Collections.emptyList();
    }
}

