/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.fido;

import android.app.PendingIntent;
import android.content.Context;
import androidx.activity.result.ActivityResultLauncher;
import com.google.android.gms.fido.fido2.Fido2ApiClient;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialRequestOptions;
import com.google.android.gms.tasks.OnCanceledListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.microsoft.identity.common.internal.fido.IFidoManager;
import com.microsoft.identity.common.internal.fido.LegacyFido2ApiException;
import com.microsoft.identity.common.internal.fido.LegacyFido2ApiObject;
import com.microsoft.identity.common.internal.providers.oauth2.WebViewAuthorizationFragment;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.logging.Logger;
import io.opentelemetry.api.trace.Span;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JA\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J@\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u001d2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b2\u0010\b\u0002\u0010!\u001a\n\u0018\u00010\"j\u0004\u0018\u0001`#H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"Lcom/microsoft/identity/common/internal/fido/LegacyFido2ApiManager;", "Lcom/microsoft/identity/common/internal/fido/IFidoManager;", "context", "Landroid/content/Context;", "fragment", "Lcom/microsoft/identity/common/internal/providers/oauth2/WebViewAuthorizationFragment;", "(Landroid/content/Context;Lcom/microsoft/identity/common/internal/providers/oauth2/WebViewAuthorizationFragment;)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "getContext", "()Landroid/content/Context;", "getFragment", "()Lcom/microsoft/identity/common/internal/providers/oauth2/WebViewAuthorizationFragment;", "legacyApi", "Lcom/google/android/gms/fido/fido2/Fido2ApiClient;", "authenticate", "challenge", "relyingPartyIdentifier", "allowedCredentials", "", "userVerificationPolicy", "span", "Lio/opentelemetry/api/trace/Span;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Lio/opentelemetry/api/trace/Span;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createAndThrowException", "", "continuation", "Lkotlinx/coroutines/CancellableContinuation;", "methodTag", "errorCode", "message", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "common_distRelease"})
@SourceDebugExtension(value={"SMAP\nLegacyFido2ApiManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyFido2ApiManager.kt\ncom/microsoft/identity/common/internal/fido/LegacyFido2ApiManager\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n*L\n1#1,165:1\n314#2,11:166\n*S KotlinDebug\n*F\n+ 1 LegacyFido2ApiManager.kt\ncom/microsoft/identity/common/internal/fido/LegacyFido2ApiManager\n*L\n65#1:166,11\n*E\n"})
public final class LegacyFido2ApiManager
implements IFidoManager {
    @NotNull
    private final Context context;
    @NotNull
    private final WebViewAuthorizationFragment fragment;
    @NotNull
    private final String TAG;
    @NotNull
    private final Fido2ApiClient legacyApi;

    public LegacyFido2ApiManager(@NotNull Context context, @NotNull WebViewAuthorizationFragment fragment) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)fragment), (String)"fragment");
        this.context = context;
        this.fragment = fragment;
        this.TAG = String.valueOf(Reflection.getOrCreateKotlinClass(LegacyFido2ApiManager.class).getSimpleName());
        this.legacyApi = new Fido2ApiClient(this.context);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final WebViewAuthorizationFragment getFragment() {
        return this.fragment;
    }

    @NotNull
    public final String getTAG() {
        return this.TAG;
    }

    @Override
    @Nullable
    public Object authenticate(@NotNull String challenge, @NotNull String relyingPartyIdentifier, @Nullable List<String> allowedCredentials, @NotNull String userVerificationPolicy, @NotNull Span span2, @NotNull Continuation<? super String> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super String> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        String methodTag = this.getTAG() + ":authenticate";
        span2.setAttribute(AttributeName.fido_manager.name(), this.getTAG());
        PublicKeyCredentialRequestOptions.Builder builder = new PublicKeyCredentialRequestOptions.Builder();
        byte[] byArray = challenge.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions = builder.setChallenge(byArray).setRpId(relyingPartyIdentifier).build();
        Intrinsics.checkNotNullExpressionValue((Object)publicKeyCredentialRequestOptions, (String)"Builder()\n            .s\u2026ier)\n            .build()");
        PublicKeyCredentialRequestOptions requestOptions = publicKeyCredentialRequestOptions;
        Logger.info(methodTag, "Calling the legacy FIDO2 API with public key credential options to get a PendingIntent.");
        Task task = this.legacyApi.getSignPendingIntent(requestOptions);
        Intrinsics.checkNotNullExpressionValue((Object)task, (String)"legacyApi.getSignPendingIntent(requestOptions)");
        Task result = task;
        result.addOnSuccessListener(new OnSuccessListener(methodTag, this, (CancellableContinuation<? super String>)continuation){
            final /* synthetic */ String $methodTag;
            final /* synthetic */ LegacyFido2ApiManager this$0;
            final /* synthetic */ CancellableContinuation<String> $continuation;
            {
                this.$methodTag = $methodTag;
                this.this$0 = $receiver;
                this.$continuation = $continuation;
            }

            public final void onSuccess(PendingIntent pendingIntent) {
                if (pendingIntent != null) {
                    Logger.info(this.$methodTag, "Launching the legacy FIDO2 API PendingIntent.");
                    ActivityResultLauncher<LegacyFido2ApiObject> fidoLauncher = this.this$0.getFragment().getFidoLauncher();
                    if (fidoLauncher != null) {
                        fidoLauncher.launch((Object)new LegacyFido2ApiObject((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this.$continuation){
                            final /* synthetic */ CancellableContinuation<String> $continuation;
                            {
                                this.$continuation = $continuation;
                                super(1);
                            }

                            public final void invoke(@NotNull String assertion) {
                                Intrinsics.checkNotNullParameter((Object)assertion, (String)"assertion");
                                if (this.$continuation.isActive()) {
                                    ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)assertion));
                                }
                            }
                        }), (Function1<? super LegacyFido2ApiException, Unit>)((Function1)new Function1<LegacyFido2ApiException, Unit>(this.$continuation){
                            final /* synthetic */ CancellableContinuation<String> $continuation;
                            {
                                this.$continuation = $continuation;
                                super(1);
                            }

                            public final void invoke(@NotNull LegacyFido2ApiException exception) {
                                Intrinsics.checkNotNullParameter((Object)((Object)exception), (String)"exception");
                                if (this.$continuation.isActive()) {
                                    ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)((Throwable)((Object)exception)))));
                                }
                            }
                        }), pendingIntent));
                    } else {
                        LegacyFido2ApiManager.createAndThrowException$default(this.this$0, this.$continuation, this.$methodTag, "null_object", "fidoLauncher is null, which indicates that the legacy FIDO2 API is being used where it shouldn't be.", null, 16, null);
                    }
                } else {
                    LegacyFido2ApiManager.createAndThrowException$default(this.this$0, this.$continuation, this.$methodTag, "null_object", "Returned PendingIntent from legacy API is null.", null, 16, null);
                }
            }
        });
        result.addOnFailureListener(new OnFailureListener(this, (CancellableContinuation<? super String>)continuation, methodTag){
            final /* synthetic */ LegacyFido2ApiManager this$0;
            final /* synthetic */ CancellableContinuation<String> $continuation;
            final /* synthetic */ String $methodTag;
            {
                this.this$0 = $receiver;
                this.$continuation = $continuation;
                this.$methodTag = $methodTag;
            }

            public final void onFailure(@NotNull Exception exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                LegacyFido2ApiManager.access$createAndThrowException(this.this$0, this.$continuation, this.$methodTag, "get_pending_intent_error", "Failed to get a PendingIntent from the legacy FIDO2 API.", exception);
            }
        });
        result.addOnCanceledListener(new OnCanceledListener(this, (CancellableContinuation<? super String>)continuation, methodTag){
            final /* synthetic */ LegacyFido2ApiManager this$0;
            final /* synthetic */ CancellableContinuation<String> $continuation;
            final /* synthetic */ String $methodTag;
            {
                this.this$0 = $receiver;
                this.$continuation = $continuation;
                this.$methodTag = $methodTag;
            }

            public final void onCanceled() {
                LegacyFido2ApiManager.createAndThrowException$default(this.this$0, this.$continuation, this.$methodTag, "get_pending_intent_canceled", "The operation to get a PendingIntent from the legacy FIDO2 API was canceled.", null, 16, null);
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private final void createAndThrowException(CancellableContinuation<? super String> continuation, String methodTag, String errorCode, String message, Exception exception) {
        LegacyFido2ApiException e = exception != null ? new LegacyFido2ApiException(errorCode, message, exception) : new LegacyFido2ApiException(errorCode, message);
        Logger.error(methodTag, message, (Throwable)((Object)e));
        if (continuation.isActive()) {
            ((Continuation)continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)((Throwable)((Object)e)))));
        }
    }

    static /* synthetic */ void createAndThrowException$default(LegacyFido2ApiManager legacyFido2ApiManager, CancellableContinuation cancellableContinuation, String string, String string2, String string3, Exception exception, int n, Object object) {
        if ((n & 0x10) != 0) {
            exception = null;
        }
        legacyFido2ApiManager.createAndThrowException((CancellableContinuation<? super String>)cancellableContinuation, string, string2, string3, exception);
    }

    public static final /* synthetic */ void access$createAndThrowException(LegacyFido2ApiManager $this, CancellableContinuation continuation, String methodTag, String errorCode, String message, Exception exception) {
        $this.createAndThrowException((CancellableContinuation<? super String>)continuation, methodTag, errorCode, message, exception);
    }
}

