/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.fido;

import com.microsoft.identity.common.internal.fido.FidoRequestField;
import com.microsoft.identity.common.java.exception.ClientException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u0018*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0018B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u0012\u001a\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\n\u001a\u00020\u0004H\u00c2\u0003J\u0010\u0010\u000b\u001a\u0004\u0018\u00018\u0000H\u00c2\u0003\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0004\u0012\u00028\u00000\u0007H\u00c2\u0003JH\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00018\u00002\u001c\b\u0002\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0004\u0012\u00028\u00000\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\u000b\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/microsoft/identity/common/internal/fido/FidoChallengeField;", "K", "", "field", "Lcom/microsoft/identity/common/internal/fido/FidoRequestField;", "value", "throwIfInvalid", "Lkotlin/Function2;", "(Lcom/microsoft/identity/common/internal/fido/FidoRequestField;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)V", "Ljava/lang/Object;", "component1", "component2", "()Ljava/lang/Object;", "component3", "copy", "(Lcom/microsoft/identity/common/internal/fido/FidoRequestField;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Lcom/microsoft/identity/common/internal/fido/FidoChallengeField;", "equals", "", "other", "getOrThrow", "hashCode", "", "toString", "", "Companion", "common_distRelease"})
public final class FidoChallengeField<K> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FidoRequestField field;
    @Nullable
    private final K value;
    @NotNull
    private final Function2<FidoRequestField, K, K> throwIfInvalid;

    public FidoChallengeField(@NotNull FidoRequestField field, @Nullable K value, @NotNull Function2<? super FidoRequestField, ? super K, ? extends K> throwIfInvalid) {
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        Intrinsics.checkNotNullParameter(throwIfInvalid, (String)"throwIfInvalid");
        this.field = field;
        this.value = value;
        this.throwIfInvalid = throwIfInvalid;
    }

    public final K getOrThrow() throws ClientException {
        return (K)this.throwIfInvalid.invoke((Object)this.field, this.value);
    }

    private final FidoRequestField component1() {
        return this.field;
    }

    private final K component2() {
        return this.value;
    }

    private final Function2<FidoRequestField, K, K> component3() {
        return this.throwIfInvalid;
    }

    @NotNull
    public final FidoChallengeField<K> copy(@NotNull FidoRequestField field, @Nullable K value, @NotNull Function2<? super FidoRequestField, ? super K, ? extends K> throwIfInvalid) {
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        Intrinsics.checkNotNullParameter(throwIfInvalid, (String)"throwIfInvalid");
        return new FidoChallengeField<K>(field, value, throwIfInvalid);
    }

    public static /* synthetic */ FidoChallengeField copy$default(FidoChallengeField fidoChallengeField, FidoRequestField fidoRequestField, Object object, Function2 function2, int n, Object object2) {
        if ((n & 1) != 0) {
            fidoRequestField = fidoChallengeField.field;
        }
        if ((n & 2) != 0) {
            object = fidoChallengeField.value;
        }
        if ((n & 4) != 0) {
            function2 = fidoChallengeField.throwIfInvalid;
        }
        return fidoChallengeField.copy(fidoRequestField, object, function2);
    }

    @NotNull
    public String toString() {
        return "FidoChallengeField(field=" + (Object)((Object)this.field) + ", value=" + this.value + ", throwIfInvalid=" + this.throwIfInvalid + ')';
    }

    public int hashCode() {
        int result = this.field.hashCode();
        result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
        result = result * 31 + this.throwIfInvalid.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FidoChallengeField)) {
            return false;
        }
        FidoChallengeField fidoChallengeField = (FidoChallengeField)other;
        if (this.field != fidoChallengeField.field) {
            return false;
        }
        if (!Intrinsics.areEqual(this.value, fidoChallengeField.value)) {
            return false;
        }
        return Intrinsics.areEqual(this.throwIfInvalid, fidoChallengeField.throwIfInvalid);
    }

    @JvmStatic
    @NotNull
    public static final String throwIfInvalidRequiredParameter(@NotNull FidoRequestField field, @Nullable String value) throws ClientException {
        return Companion.throwIfInvalidRequiredParameter(field, value);
    }

    @JvmStatic
    @NotNull
    public static final String throwIfInvalidSubmitUrl(@NotNull FidoRequestField field, @Nullable String value) throws ClientException {
        return Companion.throwIfInvalidSubmitUrl(field, value);
    }

    @JvmStatic
    @NotNull
    public static final String throwIfInvalidRelyingPartyIdentifier(@NotNull FidoRequestField field, @Nullable String value) throws ClientException {
        return Companion.throwIfInvalidRelyingPartyIdentifier(field, value);
    }

    @JvmStatic
    @NotNull
    public static final String throwIfInvalidProtocolVersion(@NotNull FidoRequestField field, @Nullable String value) throws ClientException {
        return Companion.throwIfInvalidProtocolVersion(field, value);
    }

    @JvmStatic
    @Nullable
    public static final List<String> throwIfInvalidOptionalListParameter(@NotNull FidoRequestField field, @Nullable List<String> value) throws ClientException {
        return Companion.throwIfInvalidOptionalListParameter(field, value);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0007J\u001a\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007J\u001a\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007J\u001a\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007J\u001a\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u00a8\u0006\r"}, d2={"Lcom/microsoft/identity/common/internal/fido/FidoChallengeField$Companion;", "", "()V", "throwIfInvalidOptionalListParameter", "", "", "field", "Lcom/microsoft/identity/common/internal/fido/FidoRequestField;", "value", "throwIfInvalidProtocolVersion", "throwIfInvalidRelyingPartyIdentifier", "throwIfInvalidRequiredParameter", "throwIfInvalidSubmitUrl", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String throwIfInvalidRequiredParameter(@NotNull FidoRequestField field, @Nullable String value) throws ClientException {
            Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
            if (value == null) {
                throw new ClientException("passkey_protocol_request_parsing_error", field.getFieldName() + " not provided");
            }
            if (StringsKt.isBlank((CharSequence)value)) {
                throw new ClientException("passkey_protocol_request_parsing_error", field.getFieldName() + " is empty");
            }
            return value;
        }

        @JvmStatic
        @NotNull
        public final String throwIfInvalidSubmitUrl(@NotNull FidoRequestField field, @Nullable String value) throws ClientException {
            Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
            String submitUrl = this.throwIfInvalidRequiredParameter(field, value);
            try {
                new URL(submitUrl);
            }
            catch (MalformedURLException e) {
                throw new ClientException("passkey_protocol_request_parsing_error", "submitUrl value is malformed.");
            }
            return submitUrl;
        }

        @JvmStatic
        @NotNull
        public final String throwIfInvalidRelyingPartyIdentifier(@NotNull FidoRequestField field, @Nullable String value) throws ClientException {
            Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
            String rpId = this.throwIfInvalidRequiredParameter(field, value);
            return StringsKt.removePrefix((String)rpId, (CharSequence)"https://");
        }

        @JvmStatic
        @NotNull
        public final String throwIfInvalidProtocolVersion(@NotNull FidoRequestField field, @Nullable String value) throws ClientException {
            Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
            String version = this.throwIfInvalidRequiredParameter(field, value);
            if (!Intrinsics.areEqual((Object)version, (Object)"1.0")) {
                throw new ClientException("passkey_protocol_request_parsing_error", "Provided protocol version is not currently supported.");
            }
            return version;
        }

        @JvmStatic
        @Nullable
        public final List<String> throwIfInvalidOptionalListParameter(@NotNull FidoRequestField field, @Nullable List<String> value) throws ClientException {
            Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
            if (value != null && (value.isEmpty() || Intrinsics.areEqual((Object)CollectionsKt.first(value), (Object)""))) {
                throw new ClientException("passkey_protocol_request_parsing_error", field.getFieldName() + " is empty");
            }
            return value;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

