/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker.ipc;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.os.Build;
import android.os.DeadObjectException;
import com.microsoft.identity.common.internal.broker.ipc.ContentProviderStrategy;
import com.microsoft.identity.common.internal.broker.ipc.IContentProviderStatusLoader;
import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.logging.Logger;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006BY\u0012!\u0010\u0007\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\t0\b\u0012!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u000e0\b\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\tH\u0016R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0007\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/microsoft/identity/common/internal/broker/ipc/ContentProviderStatusLoader;", "Lcom/microsoft/identity/common/internal/broker/ipc/IContentProviderStatusLoader;", "context", "Landroid/content/Context;", "components", "Lcom/microsoft/identity/common/java/interfaces/IPlatformComponents;", "(Landroid/content/Context;Lcom/microsoft/identity/common/java/interfaces/IPlatformComponents;)V", "getVersionCode", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "appPackageName", "supportedByContentProvider", "", "fileManager", "Lcom/microsoft/identity/common/java/interfaces/INameValueStorage;", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lcom/microsoft/identity/common/java/interfaces/INameValueStorage;)V", "supportsContentProvider", "packageName", "Companion", "common_distRelease"})
public final class ContentProviderStatusLoader
implements IContentProviderStatusLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<String, String> getVersionCode;
    @NotNull
    private final Function1<String, Boolean> supportedByContentProvider;
    @NotNull
    private final INameValueStorage<String> fileManager;
    private static final String TAG = ContentProviderStatusLoader.class.getSimpleName();
    @NotNull
    private static final String SHARED_PREFERENCE_NAME = "com.microsoft.common.ipc.content.provider.query.cache";

    public ContentProviderStatusLoader(@NotNull Function1<? super String, String> getVersionCode, @NotNull Function1<? super String, Boolean> supportedByContentProvider, @NotNull INameValueStorage<String> fileManager) {
        Intrinsics.checkNotNullParameter(getVersionCode, (String)"getVersionCode");
        Intrinsics.checkNotNullParameter(supportedByContentProvider, (String)"supportedByContentProvider");
        Intrinsics.checkNotNullParameter(fileManager, (String)"fileManager");
        this.getVersionCode = getVersionCode;
        this.supportedByContentProvider = supportedByContentProvider;
        this.fileManager = fileManager;
    }

    public ContentProviderStatusLoader(final @NotNull Context context, @NotNull IPlatformComponents components) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        INameValueStorage iNameValueStorage = components.getStorageSupplier().getUnencryptedNameValueStore(SHARED_PREFERENCE_NAME, String.class);
        this((Function1<? super String, String>)((Function1)new Function1<String, String>(){

            @NotNull
            public final String invoke(@NotNull String pkgName) {
                Intrinsics.checkNotNullParameter((Object)pkgName, (String)"pkgName");
                return Companion.getVersionCode(context, pkgName);
            }
        }), (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(){

            @NotNull
            public final Boolean invoke(@NotNull String pkgName) {
                Intrinsics.checkNotNullParameter((Object)pkgName, (String)"pkgName");
                return Companion.supportedByContentProvider(context, pkgName);
            }
        }), (INameValueStorage<String>)iNameValueStorage);
    }

    @Override
    public boolean supportsContentProvider(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String methodTag = TAG + ":getResult";
        try {
            String key = packageName + ':' + (String)this.getVersionCode.invoke((Object)packageName);
            String string = (String)this.fileManager.get(key);
            if (string != null) {
                String it = string;
                boolean bl = false;
                return Boolean.parseBoolean(it);
            }
            boolean queriedResult = (Boolean)this.supportedByContentProvider.invoke((Object)packageName);
            this.fileManager.put(key, (Object)String.valueOf(queriedResult));
            return queriedResult;
        }
        catch (Throwable t) {
            Logger.error(methodTag, t.getMessage(), t);
            return false;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/microsoft/identity/common/internal/broker/ipc/ContentProviderStatusLoader$Companion;", "", "()V", "SHARED_PREFERENCE_NAME", "", "TAG", "kotlin.jvm.PlatformType", "getVersionCode", "context", "Landroid/content/Context;", "appPackageName", "supportedByContentProvider", "", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        private final String getVersionCode(Context context, String appPackageName) throws PackageManager.NameNotFoundException {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(appPackageName, 0);
            return Build.VERSION.SDK_INT >= 28 ? String.valueOf(packageInfo.getLongVersionCode()) : String.valueOf(packageInfo.versionCode);
        }

        public final boolean supportedByContentProvider(@NotNull Context context, @NotNull String appPackageName) throws DeadObjectException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)appPackageName, (String)"appPackageName");
            String string = ContentProviderStrategy.getContentProviderAuthority(appPackageName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContentProviderAuthority(appPackageName)");
            String contentProviderAuthority = string;
            List list = context.getPackageManager().queryContentProviders(null, 0, 0);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"context.packageManager\n \u2026tentProviders(null, 0, 0)");
            List providers = list;
            for (ProviderInfo providerInfo : providers) {
                if (providerInfo.authority == null || !Intrinsics.areEqual((Object)providerInfo.authority, (Object)contentProviderAuthority)) continue;
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

