/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.activebrokerdiscovery;

import android.accounts.AccountManager;
import android.accounts.AuthenticatorDescription;
import android.content.Context;
import com.microsoft.identity.common.internal.broker.BrokerData;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B;\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\t\u0012\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/microsoft/identity/common/internal/activebrokerdiscovery/AccountManagerBrokerDiscoveryUtil;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "knownBrokerApps", "", "Lcom/microsoft/identity/common/internal/broker/BrokerData;", "isSignedByKnownKeys", "Lkotlin/Function1;", "", "getAccountManagerApps", "Lkotlin/Function0;", "", "Landroid/accounts/AuthenticatorDescription;", "(Ljava/util/Set;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "getActiveBrokerFromAccountManager", "Companion", "common_distRelease"})
@SourceDebugExtension(value={"SMAP\nAccountManagerBrokerDiscoveryUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountManagerBrokerDiscoveryUtil.kt\ncom/microsoft/identity/common/internal/activebrokerdiscovery/AccountManagerBrokerDiscoveryUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,100:1\n766#2:101\n857#2,2:102\n766#2:105\n857#2,2:106\n288#2,2:108\n13579#3:104\n13580#3:110\n*S KotlinDebug\n*F\n+ 1 AccountManagerBrokerDiscoveryUtil.kt\ncom/microsoft/identity/common/internal/activebrokerdiscovery/AccountManagerBrokerDiscoveryUtil\n*L\n53#1:101\n53#1:102,2\n86#1:105\n86#1:106,2\n88#1:108,2\n77#1:104\n77#1:110\n*E\n"})
public final class AccountManagerBrokerDiscoveryUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<BrokerData> knownBrokerApps;
    @NotNull
    private final Function1<BrokerData, Boolean> isSignedByKnownKeys;
    @NotNull
    private final Function0<AuthenticatorDescription[]> getAccountManagerApps;
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(AccountManagerBrokerDiscoveryUtil.class).getSimpleName();

    public AccountManagerBrokerDiscoveryUtil(@NotNull Set<BrokerData> knownBrokerApps, @NotNull Function1<? super BrokerData, Boolean> isSignedByKnownKeys, @NotNull Function0<AuthenticatorDescription[]> getAccountManagerApps) {
        Intrinsics.checkNotNullParameter(knownBrokerApps, (String)"knownBrokerApps");
        Intrinsics.checkNotNullParameter(isSignedByKnownKeys, (String)"isSignedByKnownKeys");
        Intrinsics.checkNotNullParameter(getAccountManagerApps, (String)"getAccountManagerApps");
        this.knownBrokerApps = knownBrokerApps;
        this.isSignedByKnownKeys = isSignedByKnownKeys;
        this.getAccountManagerApps = getAccountManagerApps;
    }

    /*
     * WARNING - void declaration
     */
    public AccountManagerBrokerDiscoveryUtil(final @NotNull Context context) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable iterable = BrokerData.Companion.getKnownBrokerApps();
        AccountManagerBrokerDiscoveryUtil accountManagerBrokerDiscoveryUtil = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BrokerData it = (BrokerData)element$iv$iv;
            boolean bl = false;
            if (!BrokerData.Companion.isAccountManagerSupported(it.getPackageName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        accountManagerBrokerDiscoveryUtil(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), (Function1<? super BrokerData, Boolean>)((Function1)new Function1<BrokerData, Boolean>(){

            @NotNull
            public final Boolean invoke(@NotNull BrokerData brokerData) {
                Intrinsics.checkNotNullParameter((Object)brokerData, (String)"brokerData");
                return new BrokerValidator(context).isSignedByKnownKeys(brokerData);
            }
        }), (Function0<AuthenticatorDescription[]>)((Function0)new Function0<AuthenticatorDescription[]>(){

            @NotNull
            public final AuthenticatorDescription[] invoke() {
                AuthenticatorDescription[] authenticatorDescriptionArray = AccountManager.get((Context)context).getAuthenticatorTypes();
                Intrinsics.checkNotNullExpressionValue((Object)authenticatorDescriptionArray, (String)"get(context).authenticatorTypes");
                return authenticatorDescriptionArray;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final BrokerData getActiveBrokerFromAccountManager() {
        AuthenticatorDescription[] authenticators;
        AuthenticatorDescription[] authenticatorDescriptionArray;
        String methodTag = TAG + ":getActiveBrokerFromAccountManager";
        try {
            authenticatorDescriptionArray = (AuthenticatorDescription[])this.getAccountManagerApps.invoke();
        }
        catch (Throwable t) {
            throw new ClientException("account_manager_failed", t.getMessage());
        }
        AuthenticatorDescription[] $this$forEach$iv = authenticators = authenticatorDescriptionArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Object v2;
            block5: {
                void $this$firstOrNull$iv;
                void $this$filterTo$iv$iv;
                AuthenticatorDescription element$iv;
                AuthenticatorDescription authenticator = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (authenticator.packageName == null || authenticator.type == null) continue;
                String string = authenticator.packageName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"authenticator.packageName");
                String packageName = ((Object)StringsKt.trim((CharSequence)string)).toString();
                String string2 = authenticator.type;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"authenticator.type");
                String accountType = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                if (!StringsKt.equals((String)"com.microsoft.workaccount", (String)accountType, (boolean)true)) continue;
                Iterable $this$filter$iv = this.knownBrokerApps;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    BrokerData it = (BrokerData)element$iv$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)it.getPackageName(), (String)packageName, (boolean)true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                Function1<BrokerData, Boolean> predicate$iv = this.isSignedByKnownKeys;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    if (!((Boolean)predicate$iv.invoke(element$iv2)).booleanValue()) continue;
                    v2 = element$iv2;
                    break block5;
                }
                v2 = null;
            }
            BrokerData brokerData = v2;
            if (brokerData == null) continue;
            Logger.info((String)methodTag, (String)(brokerData + " is the active AccountManager broker."));
            return brokerData;
        }
        Logger.info((String)methodTag, (String)"No valid AccountManager broker is found");
        return null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/microsoft/identity/common/internal/activebrokerdiscovery/AccountManagerBrokerDiscoveryUtil$Companion;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getTAG() {
            return TAG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

