/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.PermissionRequest;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import androidx.activity.result.ActivityResultLauncher;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.FragmentActivity;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.fido.LegacyFido2ApiObject;
import com.microsoft.identity.common.internal.fido.LegacyFidoActivityResultContract;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationActivity;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationFragment;
import com.microsoft.identity.common.internal.providers.oauth2.CameraPermissionRequestHandler;
import com.microsoft.identity.common.internal.ui.webview.AzureActiveDirectoryWebViewClient;
import com.microsoft.identity.common.internal.ui.webview.ISendResultCallback;
import com.microsoft.identity.common.internal.ui.webview.OnPageLoadedCallback;
import com.microsoft.identity.common.internal.ui.webview.ProcessUtil;
import com.microsoft.identity.common.internal.ui.webview.WebViewUtil;
import com.microsoft.identity.common.internal.ui.webview.switchbrowser.SwitchBrowserProtocolCoordinator;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.flighting.CommonFlight;
import com.microsoft.identity.common.java.flighting.CommonFlightsManager;
import com.microsoft.identity.common.java.flighting.IFlightConfig;
import com.microsoft.identity.common.java.providers.RawAuthorizationResult;
import com.microsoft.identity.common.java.ui.webview.authorization.IAuthorizationCompletionCallback;
import com.microsoft.identity.common.java.util.ClientExtraSku;
import com.microsoft.identity.common.logging.Logger;
import io.opentelemetry.api.trace.SpanContext;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;

public class WebViewAuthorizationFragment
extends AuthorizationFragment {
    private static final String TAG = WebViewAuthorizationFragment.class.getSimpleName();
    @VisibleForTesting
    private static final String PKEYAUTH_STATUS = "pkeyAuthStatus";
    private WebView mWebView;
    private AzureActiveDirectoryWebViewClient mAADWebViewClient;
    private ProgressBar mProgressBar;
    private Intent mAuthIntent;
    private boolean mPkeyAuthStatus = false;
    private String mAuthorizationRequestUrl;
    private String mRedirectUri;
    private HashMap<String, String> mRequestHeaders;
    private String mPostPageLoadedJavascript;
    private boolean webViewZoomControlsEnabled;
    private boolean webViewZoomEnabled;
    private String mUtid;
    private final CameraPermissionRequestHandler mCameraPermissionRequestHandler = new CameraPermissionRequestHandler(this);
    private ActivityResultLauncher<LegacyFido2ApiObject> mFidoLauncher;
    private SwitchBrowserProtocolCoordinator mSwitchBrowserProtocolCoordinator = null;
    private boolean isBrokerRequest = false;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String methodTag = TAG + ":onCreate";
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            WebViewUtil.setDataDirectorySuffix(activity.getApplicationContext());
        }
        if (CommonFlightsManager.INSTANCE.getFlightsProvider().isFlightEnabled((IFlightConfig)CommonFlight.ENABLE_LEGACY_FIDO_SECURITY_KEY_LOGIC) && Build.VERSION.SDK_INT < 34) {
            this.mFidoLauncher = this.registerForActivityResult(new LegacyFidoActivityResultContract(), result -> Logger.info(methodTag, "Legacy FIDO2 API result received."));
        }
    }

    public void onResume() {
        super.onResume();
        if (this.getSwitchBrowserCoordinator().isExpectingSwitchBrowserResume()) {
            this.resumeSwitchBrowser(this.getExtras());
        }
    }

    @NonNull
    private Bundle getExtras() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return Bundle.EMPTY;
        }
        Intent intent = activity.getIntent();
        if (intent == null) {
            return Bundle.EMPTY;
        }
        Bundle extras = intent.getExtras();
        return extras == null ? Bundle.EMPTY : extras;
    }

    private void resumeSwitchBrowser(@NonNull Bundle extras) {
        String methodTag = TAG + ":resumeSwitchBrowser";
        try {
            Logger.info(methodTag, "Resuming switch browser flow");
            this.getSwitchBrowserCoordinator().processSwitchBrowserResume(this.mAuthorizationRequestUrl, extras, (Function2<? super Uri, ? super HashMap<String, String>, Unit>)((Function2)(switchBrowserResumeUri, switchBrowserResumeHeaders) -> {
                this.launchWebView(switchBrowserResumeUri.toString(), (HashMap<String, String>)switchBrowserResumeHeaders);
                return null;
            }));
        }
        catch (ClientException e) {
            Logger.error(methodTag, "Error processing switch browser resume", e);
            this.sendResult(RawAuthorizationResult.fromException((BaseException)((Object)e)));
            this.finish();
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable("com.microsoft.identity.auth.intent", (Parcelable)this.mAuthIntent);
        outState.putBoolean(PKEYAUTH_STATUS, this.mPkeyAuthStatus);
        outState.putString("com.microsoft.identity.request.redirect.uri", this.mRedirectUri);
        outState.putString("com.microsoft.identity.request.url", this.mAuthorizationRequestUrl);
        outState.putSerializable("com.microsoft.identity.request.headers", this.mRequestHeaders);
        outState.putSerializable("com.microsoft.identity.post.page.loaded.url", (Serializable)((Object)this.mPostPageLoadedJavascript));
        outState.putBoolean("com.microsoft.identity.web.view.zoom.controls.enabled", this.webViewZoomControlsEnabled);
        outState.putBoolean("com.microsoft.identity.web.view.zoom.enabled", this.webViewZoomEnabled);
        outState.putString("utid", this.mUtid);
    }

    @Override
    void extractState(@NonNull Bundle state) {
        super.extractState(state);
        this.mAuthIntent = (Intent)state.getParcelable("com.microsoft.identity.auth.intent");
        this.mPkeyAuthStatus = state.getBoolean(PKEYAUTH_STATUS, false);
        this.mAuthorizationRequestUrl = state.getString("com.microsoft.identity.request.url");
        Context context = this.getContext();
        if (context != null) {
            this.isBrokerRequest = ProcessUtil.isRunningOnAuthService(context);
        }
        this.mRedirectUri = state.getString("com.microsoft.identity.request.redirect.uri");
        this.mRequestHeaders = this.getRequestHeaders(state);
        this.mPostPageLoadedJavascript = state.getString("com.microsoft.identity.post.page.loaded.url");
        this.webViewZoomEnabled = state.getBoolean("com.microsoft.identity.web.view.zoom.enabled", true);
        this.webViewZoomControlsEnabled = state.getBoolean("com.microsoft.identity.web.view.zoom.controls.enabled", true);
        this.mUtid = state.getString("utid");
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        final String methodTag = TAG + ":onCreateView";
        View view = inflater.inflate(R.layout.common_activity_authentication, container, false);
        this.mProgressBar = (ProgressBar)view.findViewById(R.id.common_auth_webview_progressbar);
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return null;
        }
        this.mAADWebViewClient = new AzureActiveDirectoryWebViewClient((Activity)activity, new AuthorizationCompletionCallback(), new OnPageLoadedCallback(){

            @Override
            public void onPageLoaded(String url) {
                String[] javascriptToExecute = new String[1];
                WebViewAuthorizationFragment.this.mProgressBar.setVisibility(4);
                try {
                    javascriptToExecute[0] = String.format("window.expectedUrl = '%s';%n%s", URLEncoder.encode(url, "UTF-8"), WebViewAuthorizationFragment.this.mPostPageLoadedJavascript);
                }
                catch (UnsupportedEncodingException e) {
                    Logger.warn(methodTag, "Inject expectedUrl failed.");
                }
                if (!WebViewAuthorizationFragment.this.mAuthResultSent && !StringExtensions.isNullOrBlank(javascriptToExecute[0])) {
                    WebViewAuthorizationFragment.this.mWebView.evaluateJavascript(javascriptToExecute[0], null);
                }
            }
        }, this.mRedirectUri, this.getSwitchBrowserCoordinator().getSwitchBrowserRequestHandler(), this.mUtid);
        this.setUpWebView(view, this.mAADWebViewClient);
        this.mAADWebViewClient.initializeAuthUxJavaScriptApi(this.mWebView, this.mAuthorizationRequestUrl);
        this.launchWebView(this.mAuthorizationRequestUrl, this.mRequestHeaders);
        return view;
    }

    @Override
    public void handleBackButtonPressed() {
        String methodTag = TAG + ":handleBackButtonPressed";
        Logger.info(methodTag, "Back button is pressed");
        if (this.mWebView.canGoBack()) {
            this.mWebView.goBack();
        } else {
            this.cancelAuthorization(true);
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "ClickableViewAccessibility"})
    private void setUpWebView(@NonNull View view, @NonNull AzureActiveDirectoryWebViewClient webViewClient) {
        final String methodTag = TAG + ":setUpWebView";
        this.mWebView = (WebView)view.findViewById(R.id.common_auth_webview);
        WebSettings userAgentSetting = this.mWebView.getSettings();
        String userAgent = userAgentSetting.getUserAgentString();
        this.mWebView.getSettings().setUserAgentString(userAgent + " PKeyAuth/1.0");
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.requestFocus(130);
        this.mWebView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                int action = event.getAction();
                if (!(action != 0 && action != 1 || view.hasFocus())) {
                    view.requestFocus();
                }
                return false;
            }
        });
        this.mWebView.getSettings().setLoadWithOverviewMode(true);
        this.mWebView.getSettings().setDomStorageEnabled(true);
        this.mWebView.getSettings().setUseWideViewPort(true);
        this.mWebView.getSettings().setBuiltInZoomControls(this.webViewZoomControlsEnabled);
        this.mWebView.getSettings().setSupportZoom(this.webViewZoomEnabled);
        this.mWebView.setVisibility(4);
        this.mWebView.setWebViewClient((WebViewClient)webViewClient);
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onPermissionRequest(PermissionRequest request) {
                WebViewAuthorizationFragment.this.requireActivity().runOnUiThread(() -> {
                    Logger.info(methodTag, "Permission requested from:" + request.getOrigin() + " for resources:" + Arrays.toString(request.getResources()));
                    WebViewAuthorizationFragment.this.mCameraPermissionRequestHandler.handle(request, WebViewAuthorizationFragment.this.requireContext());
                });
            }

            public Bitmap getDefaultVideoPoster() {
                return Bitmap.createBitmap((int)10, (int)10, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
        });
    }

    private void launchWebView(final @NonNull String authorizationRequestUrl, final @NonNull HashMap<String, String> requestHeaders) {
        final String methodTag = TAG + ":launchWebView";
        this.mWebView.post(new Runnable(){

            @Override
            public void run() {
                Logger.info(methodTag, "Launching embedded WebView for acquiring auth code.");
                Logger.infoPII(methodTag, "The start url is " + authorizationRequestUrl);
                WebViewAuthorizationFragment.this.mAADWebViewClient.setRequestHeaders(requestHeaders);
                WebViewAuthorizationFragment.this.mAADWebViewClient.setRequestUrl(authorizationRequestUrl);
                WebViewAuthorizationFragment.this.mWebView.loadUrl(authorizationRequestUrl, (Map)requestHeaders);
                WebViewAuthorizationFragment.this.mProgressBar.setVisibility(0);
            }
        });
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        String methodTag = TAG + ":onDestroy";
        if (this.mAADWebViewClient != null) {
            this.mAADWebViewClient.onDestroy();
        } else {
            Logger.error(methodTag, "Fragment destroyed, but smartcard usb discovery was unable to be stopped.", null);
        }
        if (CommonFlightsManager.INSTANCE.getFlightsProvider().isFlightEnabled((IFlightConfig)CommonFlight.ENABLE_LEGACY_FIDO_SECURITY_KEY_LOGIC) && Build.VERSION.SDK_INT < 34 && this.mFidoLauncher != null) {
            this.mFidoLauncher.unregister();
        }
    }

    private HashMap<String, String> getRequestHeaders(Bundle state) {
        try {
            HashMap<String, String> requestHeaders = (HashMap<String, String>)state.getSerializable("com.microsoft.identity.request.headers");
            if (CommonFlightsManager.INSTANCE.getFlightsProvider().isFlightEnabled((IFlightConfig)CommonFlight.ENABLE_PASSKEY_FEATURE)) {
                if (requestHeaders == null) {
                    requestHeaders = new HashMap<String, String>();
                }
                requestHeaders.put("x-ms-PassKeyAuth", "1.0/passkey");
            }
            if (this.isBrokerRequest) {
                ClientExtraSku clientExtraSku = ClientExtraSku.builder().srcSku(state.getString("x-client-SKU")).srcSkuVer(state.getString("x-client-Ver")).build();
                requestHeaders.put("x-client-xtra-sku", clientExtraSku.toString());
            }
            return requestHeaders;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public ActivityResultLauncher<LegacyFido2ApiObject> getFidoLauncher() {
        return this.mFidoLauncher;
    }

    private SwitchBrowserProtocolCoordinator getSwitchBrowserCoordinator() {
        if (this.mSwitchBrowserProtocolCoordinator == null) {
            SpanContext spanContext = this.requireActivity() instanceof AuthorizationActivity ? ((AuthorizationActivity)this.requireActivity()).getSpanContext() : null;
            this.mSwitchBrowserProtocolCoordinator = new SwitchBrowserProtocolCoordinator((Activity)this.requireActivity(), spanContext);
        }
        return this.mSwitchBrowserProtocolCoordinator;
    }

    class AuthorizationCompletionCallback
    implements IAuthorizationCompletionCallback {
        AuthorizationCompletionCallback() {
        }

        public void onChallengeResponseReceived(final @NonNull RawAuthorizationResult response) {
            String methodTag = TAG + ":onChallengeResponseReceived";
            Logger.info(methodTag, null, "onChallengeResponseReceived:" + response.getResultCode());
            if (WebViewAuthorizationFragment.this.mAADWebViewClient != null) {
                WebViewAuthorizationFragment.this.mAADWebViewClient.finalizeBeforeSendingResult(response, new ISendResultCallback(){

                    @Override
                    public void onResultReady() {
                        WebViewAuthorizationFragment.this.sendResult(response);
                        WebViewAuthorizationFragment.this.finish();
                    }
                });
                return;
            }
            WebViewAuthorizationFragment.this.sendResult(response);
            WebViewAuthorizationFragment.this.finish();
        }

        public void setPKeyAuthStatus(boolean status) {
            String methodTag = TAG + ":setPKeyAuthStatus";
            WebViewAuthorizationFragment.this.mPkeyAuthStatus = status;
            Logger.info(methodTag, null, "setPKeyAuthStatus:" + status);
        }
    }
}

