/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.fragment.app.Fragment;
import com.microsoft.identity.common.internal.msafederation.MsaFederationExtensions;
import com.microsoft.identity.common.internal.msafederation.google.SignInWithGoogleApi;
import com.microsoft.identity.common.internal.msafederation.google.SignInWithGoogleCredential;
import com.microsoft.identity.common.internal.msafederation.google.SignInWithGoogleParameters;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationActivity;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationActivityParameters;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationFragment;
import com.microsoft.identity.common.internal.providers.oauth2.BrokerAuthorizationActivity;
import com.microsoft.identity.common.internal.providers.oauth2.BrowserAuthorizationFragment;
import com.microsoft.identity.common.internal.providers.oauth2.CurrentTaskAuthorizationActivity;
import com.microsoft.identity.common.internal.providers.oauth2.CurrentTaskBrowserAuthorizationFragment;
import com.microsoft.identity.common.internal.providers.oauth2.SilentAuthorizationActivity;
import com.microsoft.identity.common.internal.providers.oauth2.SilentWebViewAuthorizationFragment;
import com.microsoft.identity.common.internal.providers.oauth2.WebViewAuthorizationFragment;
import com.microsoft.identity.common.internal.util.CommonMoshiJsonAdapter;
import com.microsoft.identity.common.internal.util.ProcessUtil;
import com.microsoft.identity.common.java.configuration.LibraryConfiguration;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.DiagnosticContext;
import com.microsoft.identity.common.java.opentelemetry.OtelContextExtension;
import com.microsoft.identity.common.java.opentelemetry.SerializableSpanContext;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.opentelemetry.TextMapPropagatorExtension;
import com.microsoft.identity.common.java.ui.AuthorizationAgent;
import com.microsoft.identity.common.java.util.CommonURIBuilder;
import io.opentelemetry.context.Context;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0007J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0007\u00a8\u0006\u0013"}, d2={"Lcom/microsoft/identity/common/internal/providers/oauth2/AuthorizationActivityFactory;", "", "()V", "getAuthorizationActivityIntent", "Landroid/content/Intent;", "parameters", "Lcom/microsoft/identity/common/internal/providers/oauth2/AuthorizationActivityParameters;", "authorizationActivityParameters", "signInWithGoogleCredential", "Lcom/microsoft/identity/common/internal/msafederation/google/SignInWithGoogleCredential;", "getAuthorizationFragmentFromStartIntent", "Landroidx/fragment/app/Fragment;", "intent", "getAuthorizationFragmentFromStartIntentWithState", "bundle", "Landroid/os/Bundle;", "signInWithGoogleAndGetAuthorizationActivityIntent", "signInWithGoogleParameters", "Lcom/microsoft/identity/common/internal/msafederation/google/SignInWithGoogleParameters;", "common_distRelease"})
public final class AuthorizationActivityFactory {
    @NotNull
    public static final AuthorizationActivityFactory INSTANCE = new AuthorizationActivityFactory();

    private AuthorizationActivityFactory() {
    }

    @JvmStatic
    @NotNull
    public static final Intent getAuthorizationActivityIntent(@NotNull AuthorizationActivityParameters parameters) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intent intent2 = null;
        LibraryConfiguration libraryConfig = LibraryConfiguration.getInstance();
        if (ProcessUtil.isBrokerProcess(parameters.getContext())) {
            intent2 = new Intent(parameters.getContext(), BrokerAuthorizationActivity.class);
            if (StringsKt.contains$default((CharSequence)parameters.getRequestUrl(), (CharSequence)"switch_browser", (boolean)false, (int)2, null)) {
                intent2.setFlags(0x10008000);
            }
        } else if (libraryConfig.isAuthorizationInCurrentTask() && parameters.getAuthorizationAgent() != AuthorizationAgent.WEBVIEW) {
            intent2 = new Intent(parameters.getContext(), CurrentTaskAuthorizationActivity.class);
        } else if (parameters.getWebViewEnableSilentAuthorizationFlowTimeOutMs() != null) {
            intent2 = new Intent(parameters.getContext(), SilentAuthorizationActivity.class);
            intent2.putExtra("com.microsoft.identity.web.view.silent.authorization.flow.timeout", parameters.getWebViewEnableSilentAuthorizationFlowTimeOutMs().longValue());
        } else {
            intent2 = new Intent(parameters.getContext(), AuthorizationActivity.class);
        }
        Intent $this$getAuthorizationActivityIntent_u24lambda_u240 = intent = intent2;
        boolean bl = false;
        $this$getAuthorizationActivityIntent_u24lambda_u240.putExtra("com.microsoft.identity.auth.intent", (Parcelable)parameters.getAuthIntent());
        $this$getAuthorizationActivityIntent_u24lambda_u240.putExtra("com.microsoft.identity.request.url", parameters.getRequestUrl());
        $this$getAuthorizationActivityIntent_u24lambda_u240.putExtra("com.microsoft.identity.request.redirect.uri", parameters.getRedirectUri());
        $this$getAuthorizationActivityIntent_u24lambda_u240.putExtra("com.microsoft.identity.request.headers", (Serializable)parameters.getRequestHeader());
        $this$getAuthorizationActivityIntent_u24lambda_u240.putExtra("com.microsoft.identity.client.authorization.agent", (Serializable)parameters.getAuthorizationAgent());
        $this$getAuthorizationActivityIntent_u24lambda_u240.putExtra("com.microsoft.identity.web.view.zoom.controls.enabled", parameters.getWebViewZoomControlsEnabled());
        $this$getAuthorizationActivityIntent_u24lambda_u240.putExtra("com.microsoft.identity.web.view.zoom.enabled", parameters.getWebViewZoomEnabled());
        $this$getAuthorizationActivityIntent_u24lambda_u240.putExtra("correlation_id", (String)DiagnosticContext.INSTANCE.getRequestContext().get((Object)"correlation_id"));
        $this$getAuthorizationActivityIntent_u24lambda_u240.putExtra("serializable_span_context", new CommonMoshiJsonAdapter().toJson(SerializableSpanContext.builder().traceId(SpanExtension.current().getSpanContext().getTraceId()).spanId(SpanExtension.current().getSpanContext().getSpanId()).traceFlags(SpanExtension.current().getSpanContext().getTraceFlags().asByte()).build()));
        $this$getAuthorizationActivityIntent_u24lambda_u240.putExtra("otel_context_carrier", (Serializable)TextMapPropagatorExtension.inject((Context)OtelContextExtension.current()));
        if (parameters.getSourceLibraryName() != null) {
            $this$getAuthorizationActivityIntent_u24lambda_u240.putExtra("x-client-SKU", parameters.getSourceLibraryName());
        }
        if (parameters.getSourceLibraryVersion() != null) {
            $this$getAuthorizationActivityIntent_u24lambda_u240.putExtra("x-client-Ver", parameters.getSourceLibraryVersion());
        }
        if (parameters.getUtid() != null) {
            $this$getAuthorizationActivityIntent_u24lambda_u240.putExtra("utid", parameters.getUtid());
        }
        return intent2;
    }

    @JvmStatic
    @NotNull
    public static final Fragment getAuthorizationFragmentFromStartIntent(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Fragment fragment = null;
        AuthorizationAgent authorizationAgent = (AuthorizationAgent)intent.getSerializableExtra("com.microsoft.identity.client.authorization.agent");
        LibraryConfiguration libraryConfig = LibraryConfiguration.getInstance();
        fragment = authorizationAgent == AuthorizationAgent.WEBVIEW ? (Fragment)(intent.hasExtra("com.microsoft.identity.web.view.silent.authorization.flow.timeout") ? (WebViewAuthorizationFragment)new SilentWebViewAuthorizationFragment() : new WebViewAuthorizationFragment()) : (Fragment)(libraryConfig.isAuthorizationInCurrentTask() ? (AuthorizationFragment)new CurrentTaskBrowserAuthorizationFragment() : (AuthorizationFragment)new BrowserAuthorizationFragment());
        return fragment;
    }

    @JvmStatic
    @NotNull
    public static final Intent signInWithGoogleAndGetAuthorizationActivityIntent(@NotNull AuthorizationActivityParameters authorizationActivityParameters, @NotNull SignInWithGoogleParameters signInWithGoogleParameters) {
        Intrinsics.checkNotNullParameter((Object)authorizationActivityParameters, (String)"authorizationActivityParameters");
        Intrinsics.checkNotNullParameter((Object)signInWithGoogleParameters, (String)"signInWithGoogleParameters");
        return AuthorizationActivityFactory.getAuthorizationActivityIntent(authorizationActivityParameters, SignInWithGoogleApi.Companion.getInstance().signInSync(signInWithGoogleParameters));
    }

    @JvmStatic
    @NotNull
    public static final Intent getAuthorizationActivityIntent(@NotNull AuthorizationActivityParameters authorizationActivityParameters, @NotNull SignInWithGoogleCredential signInWithGoogleCredential) throws ClientException {
        Intrinsics.checkNotNullParameter((Object)authorizationActivityParameters, (String)"authorizationActivityParameters");
        Intrinsics.checkNotNullParameter((Object)signInWithGoogleCredential, (String)"signInWithGoogleCredential");
        Map map = authorizationActivityParameters.getRequestHeader();
        HashMap<String, String> requestHeadersWithGoogleAuthCredential = map == null || map.isEmpty() ? new HashMap<String, String>() : new HashMap(authorizationActivityParameters.getRequestHeader());
        requestHeadersWithGoogleAuthCredential.putAll(MsaFederationExtensions.getIdProviderHeadersForAuthorization(signInWithGoogleCredential));
        String requestUrlWithIdProvider = null;
        try {
            CommonURIBuilder uriBuilder = new CommonURIBuilder(authorizationActivityParameters.getRequestUrl());
            Map.Entry<String, String> extraQueryParamForAuthorization = MsaFederationExtensions.getIdProviderExtraQueryParamForAuthorization(signInWithGoogleCredential);
            uriBuilder.addParameterIfAbsent(extraQueryParamForAuthorization.getKey(), extraQueryParamForAuthorization.getValue());
            String string = uriBuilder.build().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uriBuilder.build().toString()");
            requestUrlWithIdProvider = string;
        }
        catch (URISyntaxException e) {
            throw new ClientException("malformed_url", "Failed to add id provider query parameter to request URL", (Throwable)e);
        }
        AuthorizationActivityParameters newAuthorizationActivityParameters = AuthorizationActivityParameters.copy$default(authorizationActivityParameters, null, null, requestUrlWithIdProvider, null, requestHeadersWithGoogleAuthCredential, null, false, false, null, null, null, null, 4075, null);
        return AuthorizationActivityFactory.getAuthorizationActivityIntent(newAuthorizationActivityParameters);
    }

    @JvmStatic
    @NotNull
    public static final Fragment getAuthorizationFragmentFromStartIntentWithState(@NotNull Intent intent, @NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Fragment fragment = AuthorizationActivityFactory.getAuthorizationFragmentFromStartIntent(intent);
        if (fragment instanceof AuthorizationFragment) {
            ((AuthorizationFragment)fragment).setInstanceState(bundle);
        }
        return fragment;
    }
}

