/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.platform.AsymmetricRsaKey;
import com.microsoft.identity.common.java.crypto.IDevicePopManager;
import com.microsoft.identity.common.java.crypto.SecureHardwareState;
import com.microsoft.identity.common.java.crypto.SigningAlgorithm;
import com.microsoft.identity.common.java.exception.ClientException;
import java.security.cert.Certificate;
import java.util.Date;

public class AndroidKeystoreAsymmetricRsaKey
implements AsymmetricRsaKey {
    public static final IDevicePopManager.Cipher RSA_ECB_PKCS_1_PADDING = IDevicePopManager.Cipher.RSA_ECB_PKCS1_PADDING;
    public static final SigningAlgorithm SHA_256_WITH_RSA = SigningAlgorithm.SHA_256_WITH_RSA;
    private final IDevicePopManager mDevicePopManager;
    private final String mAlias;

    AndroidKeystoreAsymmetricRsaKey(@NonNull IDevicePopManager popManager, @NonNull String alias) throws ClientException {
        this.mDevicePopManager = popManager;
        this.mAlias = alias;
        if (!this.mDevicePopManager.asymmetricKeyExists()) {
            this.mDevicePopManager.generateAsymmetricKey();
        }
    }

    @Override
    public String getAlias() {
        return this.mAlias;
    }

    @Override
    public Date getCreatedOn() throws ClientException {
        return this.mDevicePopManager.getAsymmetricKeyCreationDate();
    }

    @Override
    public String getThumbprint() throws ClientException {
        return this.mDevicePopManager.getAsymmetricKeyThumbprint();
    }

    @Override
    public String getPublicKey() throws ClientException {
        return this.mDevicePopManager.getPublicKey(IDevicePopManager.PublicKeyFormat.JWK);
    }

    @Override
    public String sign(@NonNull String data) throws ClientException {
        return this.mDevicePopManager.sign(SHA_256_WITH_RSA, data);
    }

    @Override
    public boolean verify(@NonNull String plainText, @NonNull String signatureStr) {
        return this.mDevicePopManager.verify(SHA_256_WITH_RSA, plainText, signatureStr);
    }

    @Override
    public String encrypt(@NonNull String plaintext) throws ClientException {
        return this.mDevicePopManager.encrypt(RSA_ECB_PKCS_1_PADDING, plaintext);
    }

    @Override
    public String decrypt(@NonNull String ciphertext) throws ClientException {
        return this.mDevicePopManager.decrypt(RSA_ECB_PKCS_1_PADDING, ciphertext);
    }

    @Override
    public SecureHardwareState getSecureHardwareState() throws ClientException {
        return this.mDevicePopManager.getSecureHardwareState();
    }

    @Override
    public byte[] encrypt(byte[] plaintext) throws ClientException {
        return this.mDevicePopManager.encrypt(RSA_ECB_PKCS_1_PADDING, plaintext);
    }

    @Override
    public byte[] decrypt(byte[] ciphertext) throws ClientException {
        return this.mDevicePopManager.encrypt(RSA_ECB_PKCS_1_PADDING, ciphertext);
    }

    @Override
    public byte[] sign(byte[] text) throws ClientException {
        return this.mDevicePopManager.sign(SHA_256_WITH_RSA, text);
    }

    @Override
    public boolean verify(byte[] text, byte[] signature) throws ClientException {
        return this.mDevicePopManager.verify(SHA_256_WITH_RSA, text, signature);
    }

    @Override
    public Certificate[] getCertificateChain() throws ClientException {
        return this.mDevicePopManager.getCertificateChain();
    }
}

