/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.webkit.JavascriptInterface;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.MalformedJsonException;
import com.microsoft.identity.common.internal.broker.AuthUxJsonPayload;
import com.microsoft.identity.common.internal.broker.AuthUxJsonPayloadKTDeserializer;
import com.microsoft.identity.common.internal.broker.AuthUxParams;
import com.microsoft.identity.common.internal.numberMatch.NumberMatchHelper;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.logging.Logger;
import io.opentelemetry.api.trace.Span;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0007\u00a8\u0006\f"}, d2={"Lcom/microsoft/identity/common/internal/broker/AuthUxJavaScriptInterface;", "", "()V", "parseJsonToAuthUxJsonPayloadObject", "Lcom/microsoft/identity/common/internal/broker/AuthUxJsonPayload;", "jsonString", "", "receiveAuthUxMessage", "", "jsonPayload", "Companion", "OperationNames", "common_distRelease"})
public final class AuthUxJavaScriptInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final String TAG = AuthUxJavaScriptInterface.class.getSimpleName();
    @NotNull
    private static final String JAVASCRIPT_INTERFACE_NAME = "broker";

    @JavascriptInterface
    public final void receiveAuthUxMessage(@NotNull String jsonPayload) {
        Intrinsics.checkNotNullParameter((Object)jsonPayload, (String)"jsonPayload");
        String methodTag = TAG + ":receiveAuthUxMessage";
        Logger.info(methodTag, "Received a payload from AuthUX through JavaScript API.");
        try {
            AuthUxJsonPayload payloadObject = this.parseJsonToAuthUxJsonPayloadObject(jsonPayload);
            Logger.info(methodTag, "Correlation ID during JavaScript Call: [" + payloadObject.getCorrelationId() + ']');
            Span span2 = SpanExtension.current();
            String actionName = payloadObject.getActionName();
            span2.setAttribute(AttributeName.authux_js_action_name.name(), actionName);
            String actionComponent = payloadObject.getActionComponent();
            span2.setAttribute(AttributeName.authux_js_action_component.name(), actionComponent);
            AuthUxParams parameters = payloadObject.getParams();
            if (parameters == null) {
                Logger.warn(methodTag, "Payload from AuthUX contained no \"params\" field.");
                return;
            }
            String operation = parameters.getOperation();
            if (operation != null) {
                span2.setAttribute(AttributeName.authux_js_operation.name(), operation);
            }
            Logger.info(methodTag, "Function name: [" + operation + ']');
            if (Intrinsics.areEqual((Object)operation, (Object)"number_matching")) {
                NumberMatchHelper.Companion.storeNumberMatch(parameters.getSessionId(), parameters.getCodeMatch());
            } else {
                Logger.warn(methodTag, "Payload from AuthUX contained an unknown function name.");
            }
        }
        catch (Exception e) {
            Exception exception = e;
            if (exception instanceof NullPointerException) {
                Logger.error(methodTag, "Payload with missing mandatory fields sent through JavaScriptInterface", e);
            }
            if ((exception instanceof MalformedJsonException ? true : exception instanceof JsonSyntaxException) ? true : exception instanceof JsonParseException) {
                Logger.error(methodTag, "Error Parsing JSON payload sent through JavaScriptInterface", e);
            }
            Logger.error(methodTag, "Unknown error occurred while processing the payload.", e);
        }
    }

    private final AuthUxJsonPayload parseJsonToAuthUxJsonPayloadObject(String jsonString) {
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)AuthUxJsonPayload.class), (Object)new AuthUxJsonPayloadKTDeserializer()).create();
        Object object = gson.fromJson(jsonString, AuthUxJsonPayload.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(jsonString\u2026xJsonPayload::class.java)");
        return (AuthUxJsonPayload)object;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\u0004J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/microsoft/identity/common/internal/broker/AuthUxJavaScriptInterface$Companion;", "", "()V", "JAVASCRIPT_INTERFACE_NAME", "", "TAG", "kotlin.jvm.PlatformType", "getTAG", "()Ljava/lang/String;", "getInterfaceName", "isValidUrlForInterface", "", "urlString", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        public final String getTAG() {
            return TAG;
        }

        @NotNull
        public final String getInterfaceName() {
            return AuthUxJavaScriptInterface.JAVASCRIPT_INTERFACE_NAME;
        }

        public final boolean isValidUrlForInterface(@Nullable String urlString) {
            CharSequence charSequence = urlString;
            if (charSequence == null || charSequence.length() == 0) {
                return false;
            }
            URL url = null;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                Logger.warn(this.getTAG(), "Malformed URL passed.");
                return false;
            }
            String host = url.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)host, (String)"host");
            return StringsKt.startsWith$default((String)host, (String)"login.microsoftonline.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)host, (String)"login.live.", (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/microsoft/identity/common/internal/broker/AuthUxJavaScriptInterface$OperationNames;", "", "()V", "NUMBER_MATCHING", "", "common_distRelease"})
    public static final class OperationNames {
        @NotNull
        public static final OperationNames INSTANCE = new OperationNames();
        @NotNull
        public static final String NUMBER_MATCHING = "number_matching";

        private OperationNames() {
        }
    }
}

