/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationActivityFactory;
import com.microsoft.identity.common.internal.providers.oauth2.CurrentTaskBrowserAuthorizationFragment;
import com.microsoft.identity.common.internal.ui.DualScreenActivity;
import com.microsoft.identity.common.logging.Logger;

public class CurrentTaskAuthorizationActivity
extends DualScreenActivity {
    private static final String TAG = CurrentTaskAuthorizationActivity.class.getSimpleName();
    private CurrentTaskBrowserAuthorizationFragment mFragment;
    private boolean mCloseCustomTabs = true;
    private BroadcastReceiver redirectReceiver;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String methodTag = TAG + ":onCreate";
        Fragment fragment = AuthorizationActivityFactory.getAuthorizationFragmentFromStartIntent(this.getIntent());
        if (!(fragment instanceof CurrentTaskBrowserAuthorizationFragment)) {
            IllegalStateException ex = new IllegalStateException("Unexpected fragment type");
            Logger.error(methodTag, "Fragment provided was not of type CurrentTaskBrowserAuthorizationFragment", ex);
            throw ex;
        }
        this.mFragment = (CurrentTaskBrowserAuthorizationFragment)fragment;
        this.mFragment.setInstanceState(this.getIntent().getExtras());
        if ("redirect_returned_action".equals(this.getIntent().getAction())) {
            if (CurrentTaskBrowserAuthorizationFragment.class.isInstance((Object)this.mFragment)) {
                Bundle arguments = new Bundle();
                arguments.putBoolean("RESPONSE", true);
                this.mFragment.setArguments(arguments);
                this.mFragment.completeAuthorizationInBrowserFlow(this.getIntent().getStringExtra("RESPONSE_URI"));
                this.finish();
                return;
            }
            return;
        }
        this.setFragment(this.mFragment);
        if (savedInstanceState == null) {
            this.mCloseCustomTabs = false;
            this.redirectReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    Intent newIntent = new Intent((Context)CurrentTaskAuthorizationActivity.this, CurrentTaskAuthorizationActivity.class);
                    newIntent.setAction("refresh_to_close");
                    newIntent.addFlags(0x24000000);
                    CurrentTaskAuthorizationActivity.this.startActivity(newIntent);
                }
            };
            LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.redirectReceiver, new IntentFilter("redirect_returned_action"));
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if ("refresh_to_close".equals(intent.getAction())) {
            Intent broadcast = new Intent("destroy_redirect_receiving_activity_action");
            LocalBroadcastManager.getInstance((Context)this).sendBroadcast(broadcast);
            this.unregisterAndFinish();
        }
        this.setIntent(intent);
    }

    protected void onResume() {
        super.onResume();
        if ("redirect_returned_action".equals(this.getIntent().getAction())) {
            Bundle arguments = new Bundle();
            arguments.putBoolean("RESPONSE", true);
            this.mFragment.setArguments(arguments);
            this.mFragment.completeAuthorizationInBrowserFlow(this.getIntent().getStringExtra("RESPONSE_URI"));
            this.setResult(-1);
            this.unregisterAndFinish();
        }
        if (this.mCloseCustomTabs) {
            this.unregisterAndFinish();
        }
        this.mCloseCustomTabs = true;
    }

    private void unregisterAndFinish() {
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.redirectReceiver);
        this.finish();
    }
}

