/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.authorities;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.microsoft.identity.common.internal.authorities.UnknownAudience;
import com.microsoft.identity.common.java.authorities.AccountsInOneOrganization;
import com.microsoft.identity.common.java.authorities.AllAccounts;
import com.microsoft.identity.common.java.authorities.AnyOrganizationalAccount;
import com.microsoft.identity.common.java.authorities.AnyPersonalAccount;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryAudience;
import com.microsoft.identity.common.logging.Logger;
import java.lang.reflect.Type;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AzureActiveDirectoryAudienceDeserializer
implements JsonDeserializer<AzureActiveDirectoryAudience> {
    private static final String TAG = AzureActiveDirectoryAudienceDeserializer.class.getSimpleName();

    public AzureActiveDirectoryAudience deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String methodTag = TAG + ":deserialize";
        JsonObject audienceObject = json.getAsJsonObject();
        JsonElement type = audienceObject.get("type");
        if (type != null) {
            switch (type.getAsString()) {
                case "AzureADMyOrg": {
                    Logger.verbose(methodTag, "Type: AzureADMyOrg");
                    return (AzureActiveDirectoryAudience)context.deserialize((JsonElement)audienceObject, AccountsInOneOrganization.class);
                }
                case "AzureADMultipleOrgs": {
                    Logger.verbose(methodTag, "Type: AzureADMultipleOrgs");
                    return (AzureActiveDirectoryAudience)context.deserialize((JsonElement)audienceObject, AnyOrganizationalAccount.class);
                }
                case "AzureADandPersonalMicrosoftAccount": {
                    Logger.verbose(methodTag, "Type: AzureADandPersonalMicrosoftAccount");
                    return (AzureActiveDirectoryAudience)context.deserialize((JsonElement)audienceObject, AllAccounts.class);
                }
                case "PersonalMicrosoftAccount": {
                    Logger.verbose(methodTag, "Type: PersonalMicrosoftAccount");
                    return (AzureActiveDirectoryAudience)context.deserialize((JsonElement)audienceObject, AnyPersonalAccount.class);
                }
            }
            Logger.verbose(methodTag, "Type: Unknown");
            return (AzureActiveDirectoryAudience)context.deserialize((JsonElement)audienceObject, UnknownAudience.class);
        }
        return null;
    }
}

