/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.nativeauth.internal.controllers;

import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.common.internal.commands.RefreshOnCommand;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.ApiEndEvent;
import com.microsoft.identity.common.java.AuthenticationConstants;
import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.commands.BaseCommand;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.TokenCommandParameters;
import com.microsoft.identity.common.java.configuration.LibraryConfiguration;
import com.microsoft.identity.common.java.controllers.CommandDispatcher;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.dto.Credential;
import com.microsoft.identity.common.java.exception.ArgumentException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.nativeauth.authorities.NativeAuthCIAMAuthority;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.BaseNativeAuthCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.BaseSignInTokenCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.GetAuthMethodsCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.JITChallengeAuthMethodCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.JITContinueCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.JITIntrospectCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.MFADefaultChallengeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.MFASelectedDefaultChallengeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.MFASubmitChallengeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordResendCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordSubmitNewPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInResendCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInSubmitPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInWithContinuationTokenCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpResendCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpSubmitPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpSubmitUserAttributesCommandParameters;
import com.microsoft.identity.common.java.nativeauth.controllers.results.GetAuthMethodsCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.INativeAuthCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.JITChallengeAuthMethodCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.JITCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.JITSubmitChallengeCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.MFAChallengeCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.MFACommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.MFASubmitChallengeCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.ResetPasswordCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.ResetPasswordResendCodeCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.ResetPasswordStartCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.ResetPasswordSubmitCodeCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.ResetPasswordSubmitNewPasswordCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignInCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignInResendCodeCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignInStartCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignInSubmitCodeCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignInSubmitPasswordCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignInWithContinuationTokenCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignUpCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignUpResendCodeCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignUpStartCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignUpSubmitCodeCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignUpSubmitPasswordCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignUpSubmitUserAttributesCommandResult;
import com.microsoft.identity.common.java.nativeauth.providers.NativeAuthOAuth2Strategy;
import com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.jit.JITChallengeApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.jit.JITContinueApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.jit.JITIntrospectApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordChallengeApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordContinueApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordPollCompletionApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordStartApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordSubmitApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInChallengeApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInInitiateApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInIntrospectApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInTokenApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signup.SignUpChallengeApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signup.SignUpContinueApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signup.SignUpStartApiResult;
import com.microsoft.identity.common.java.nativeauth.util.ILoggable;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2StrategyParameters;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.java.providers.oauth2.TokenResponse;
import com.microsoft.identity.common.java.request.SdkType;
import com.microsoft.identity.common.java.result.AcquireTokenResult;
import com.microsoft.identity.common.java.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.java.result.LocalAuthenticationResult;
import com.microsoft.identity.common.java.telemetry.events.BaseEvent;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.ThreadUtils;
import com.microsoft.identity.common.nativeauth.internal.controllers.BaseNativeAuthController;
import com.microsoft.identity.common.nativeauth.internal.util.CommandUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0096\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u0093\u00012\u00020\u0001:\u0002\u0093\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\rH\u0002J.\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\rJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020 H\u0007J \u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\tH\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u001bH\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\rH\u0002J(\u0010)\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020+2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\tH\u0002J\u0018\u0010,\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020-H\u0002J\u0018\u0010.\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020/H\u0007J \u00100\u001a\u0002012\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\tH\u0002J\u0018\u00102\u001a\u0002032\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u000204H\u0002J \u00105\u001a\u0002062\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\tH\u0002J\u0018\u00107\u001a\u0002082\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u000209H\u0002J\u0018\u0010:\u001a\u00020;2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020<H\u0002J \u0010=\u001a\u00020>2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\tH\u0002J\u0018\u0010?\u001a\u00020@2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020AH\u0002J(\u0010B\u001a\u00020>2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010C\u001a\u00020\tH\u0002J \u0010D\u001a\u00020E2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\tH\u0002J\u0018\u0010F\u001a\u00020G2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020HH\u0007J\u0018\u0010I\u001a\u00020J2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020KH\u0002J\u0018\u0010L\u001a\u00020J2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020MH\u0002J\u0018\u0010N\u001a\u00020J2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020OH\u0007J\u0018\u0010P\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020QH\u0002J*\u0010R\u001a\u00020S2\u0006\u0010\u001f\u001a\u00020\u00112\b\u0010T\u001a\u0004\u0018\u00010A2\u0006\u0010U\u001a\u00020>2\u0006\u0010V\u001a\u00020WH\u0002J.\u0010X\u001a\u00020S2\u0006\u0010Y\u001a\u00020@2\n\b\u0002\u0010T\u001a\u0004\u0018\u00010A2\u0006\u0010\u001f\u001a\u00020\u00112\b\b\u0002\u0010V\u001a\u00020WH\u0007J(\u0010Z\u001a\u00020[2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010\\\u001a\u00020]H\u0002J\u000e\u0010^\u001a\u00020_2\u0006\u0010\u0005\u001a\u00020`J\u000e\u0010a\u001a\u00020b2\u0006\u0010\u0005\u001a\u000209J\u000e\u0010c\u001a\u00020d2\u0006\u0010\u0005\u001a\u000204J\u000e\u0010e\u001a\u00020[2\u0006\u0010\u0005\u001a\u00020<J \u0010f\u001a\u00020g2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010T\u001a\u00020+2\u0006\u0010h\u001a\u00020iH\u0002J&\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020\u00042\u0006\u0010T\u001a\u00020\u00062\f\u0010m\u001a\b\u0012\u0004\u0012\u00020n0\bH\u0002J\u000e\u0010o\u001a\u00020p2\u0006\u0010\u0005\u001a\u00020qJ\u000e\u0010r\u001a\u00020s2\u0006\u0010\u0005\u001a\u00020tJ\u000e\u0010u\u001a\u00020S2\u0006\u0010\u0005\u001a\u00020AJ\u000e\u0010v\u001a\u00020w2\u0006\u0010\u0005\u001a\u00020QJ\u000e\u0010x\u001a\u00020y2\u0006\u0010\u0005\u001a\u00020-J\u000e\u0010z\u001a\u00020{2\u0006\u0010\u0005\u001a\u00020/J\u000e\u0010|\u001a\u00020}2\u0006\u0010\u0005\u001a\u00020 J\u000f\u0010~\u001a\u00020\u007f2\u0007\u0010\u0005\u001a\u00030\u0080\u0001J\u0010\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u0006\u0010\u0005\u001a\u00020HJ\u0010\u0010\u0083\u0001\u001a\u00030\u0084\u00012\u0006\u0010\u0005\u001a\u00020KJ\u0010\u0010\u0085\u0001\u001a\u00030\u0086\u00012\u0006\u0010\u0005\u001a\u00020MJ\u0010\u0010\u0087\u0001\u001a\u00030\u0088\u00012\u0006\u0010\u0005\u001a\u00020OJ\r\u0010\u0089\u0001\u001a\u00020\u001a*\u00020\fH\u0002J\r\u0010\u008a\u0001\u001a\u00020p*\u00020\"H\u0002J\r\u0010\u008b\u0001\u001a\u00020b*\u000201H\u0002J\r\u0010\u008c\u0001\u001a\u00020S*\u00020*H\u0002J\u001d\u0010\u008c\u0001\u001a\u00020S*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010T\u001a\u00020AH\u0002J\u001d\u0010\u008d\u0001\u001a\u00020{*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010T\u001a\u00020/H\u0002J\u000e\u0010\u008e\u0001\u001a\u00030\u0082\u0001*\u00020EH\u0002J\u0016\u0010\u008f\u0001\u001a\u00030\u0084\u0001*\u00020J2\u0006\u0010\u001f\u001a\u00020\u0011H\u0002J\u0016\u0010\u0090\u0001\u001a\u00030\u0086\u0001*\u00020J2\u0006\u0010\u001f\u001a\u00020\u0011H\u0002J\u0016\u0010\u0091\u0001\u001a\u00030\u0088\u0001*\u00020J2\u0006\u0010\u001f\u001a\u00020\u0011H\u0002J\u000e\u0010\u0092\u0001\u001a\u00030\u0088\u0001*\u00020EH\u0002\u00a8\u0006\u0094\u0001"}, d2={"Lcom/microsoft/identity/common/nativeauth/internal/controllers/NativeAuthMsalController;", "Lcom/microsoft/identity/common/nativeauth/internal/controllers/BaseNativeAuthController;", "()V", "acquireTokenSilent", "Lcom/microsoft/identity/common/java/result/AcquireTokenResult;", "parameters", "Lcom/microsoft/identity/common/java/commands/parameters/SilentTokenCommandParameters;", "addDefaultScopes", "", "", "scopes", "completeJITFlow", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/JITSubmitChallengeCommandResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/JITContinueCommandParameters;", "createAuthorizationRequest", "Lcom/microsoft/identity/common/java/providers/microsoft/microsoftsts/MicrosoftStsAuthorizationRequest;", "strategy", "Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthOAuth2Strategy;", "clientId", "applicationIdentifier", "createOAuth2Strategy", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/BaseNativeAuthCommandParameters;", "getAuthMethods", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/GetAuthMethodsCommandResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/GetAuthMethodsCommandParameters;", "jitChallengeAuthMethod", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/JITChallengeAuthMethodCommandResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/JITChallengeAuthMethodCommandParameters;", "jitSubmitChallenge", "performContinuationTokenTokenRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInTokenApiResult;", "oAuth2Strategy", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInWithContinuationTokenCommandParameters;", "performIntrospectCall", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInIntrospectApiResult;", "continuationToken", "correlationId", "performJITChallengeCall", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/jit/JITChallengeApiResult;", "performJITContinueCall", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/jit/JITContinueApiResult;", "performJITIntrospect", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/jit/JITIntrospectApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/BaseSignInTokenCommandParameters;", "performOOBTokenRequest", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInSubmitCodeCommandParameters;", "performPasswordTokenCall", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInSubmitPasswordCommandParameters;", "performResetPasswordChallengeCall", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordChallengeApiResult;", "performResetPasswordContinueCall", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordContinueApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/ResetPasswordSubmitCodeCommandParameters;", "performResetPasswordPollCompletionCall", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordPollCompletionApiResult;", "performResetPasswordStartCall", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordStartApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/ResetPasswordStartCommandParameters;", "performResetPasswordSubmitCall", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordSubmitApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/ResetPasswordSubmitNewPasswordCommandParameters;", "performSignInDefaultChallengeCall", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInChallengeApiResult;", "performSignInInitiateCall", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInInitiateApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInStartCommandParameters;", "performSignInSelectedChallengeCall", "challengeId", "performSignUpChallengeCall", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpChallengeApiResult;", "performSignUpStartUsingPasswordRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpStartApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpStartCommandParameters;", "performSignUpSubmitCode", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpContinueApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpSubmitCodeCommandParameters;", "performSignUpSubmitPassword", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpSubmitPasswordCommandParameters;", "performSignUpSubmitUserAttributes", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpSubmitUserAttributesCommandParameters;", "performSubmitChallengeTokenRequest", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/MFASubmitChallengeCommandParameters;", "processSignInChallengeCall", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignInStartCommandResult;", "parametersWithScopes", "result", "usePassword", "", "processSignInInitiateApiResult", "initiateApiResult", "resetPasswordPollCompletion", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/ResetPasswordSubmitNewPasswordCommandResult;", "pollIntervalInSeconds", "", "resetPasswordResendCode", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/ResetPasswordResendCodeCommandResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/ResetPasswordResendCodeCommandParameters;", "resetPasswordStart", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/ResetPasswordStartCommandResult;", "resetPasswordSubmitCode", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/ResetPasswordSubmitCodeCommandResult;", "resetPasswordSubmitNewPassword", "saveAndReturnTokens", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignInCommandResult$Complete;", "tokenApiResult", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInTokenApiResult$Success;", "setAcquireTokenResult", "", "acquireTokenSilentResult", "cacheRecords", "Lcom/microsoft/identity/common/java/cache/ICacheRecord;", "signInChallenge", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/MFAChallengeCommandResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/MFADefaultChallengeCommandParameters;", "signInResendCode", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignInResendCodeCommandResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInResendCodeCommandParameters;", "signInStart", "signInSubmitChallenge", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/MFASubmitChallengeCommandResult;", "signInSubmitCode", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignInSubmitCodeCommandResult;", "signInSubmitPassword", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignInSubmitPasswordCommandResult;", "signInWithContinuationToken", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignInWithContinuationTokenCommandResult;", "signUpResendCode", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignUpResendCodeCommandResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpResendCodeCommandParameters;", "signUpStart", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignUpStartCommandResult;", "signUpSubmitCode", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignUpSubmitCodeCommandResult;", "signUpSubmitPassword", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignUpSubmitPasswordCommandResult;", "signUpSubmitUserAttributes", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignUpSubmitUserAttributesCommandResult;", "toJITChallengeAuthMethodCommandResult", "toMFAChallengeCommandResult", "toResetPasswordStartCommandResult", "toSignInStartCommandResult", "toSignInSubmitPasswordCommandResult", "toSignUpStartCommandResult", "toSignUpSubmitCodeCommandResult", "toSignUpSubmitPasswordCommandResult", "toSignUpSubmitUserAttributesCommandResult", "toSignUpSubmitUserAttrsCommandResult", "Companion", "common_distRelease"})
public final class NativeAuthMsalController
extends BaseNativeAuthController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final String TAG = NativeAuthMsalController.class.getSimpleName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SignInStartCommandResult signInStart(@NotNull SignInStartCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".signInStart");
        try {
            boolean hasPassword;
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            SignInInitiateApiResult initiateApiResult = this.performSignInInitiateCall(oAuth2Strategy, parameters);
            boolean bl = parameters.password != null ? !(parameters.password.length == 0) : (hasPassword = false);
            if (hasPassword) {
                Logger.verbose((String)TAG, (String)parameters.getCorrelationId(), (String)"Parameters has password");
                List<String> mergedScopes = this.addDefaultScopes(parameters.scopes);
                SignInStartCommandParameters parametersWithScopes = CommandUtil.createSignInStartCommandParametersWithScopes(parameters, mergedScopes);
                try {
                    SignInStartCommandResult signInStartCommandResult = this.processSignInInitiateApiResult(initiateApiResult, parametersWithScopes, oAuth2Strategy, true);
                    return signInStartCommandResult;
                }
                finally {
                    StringUtil.overwriteWithNull((char[])parametersWithScopes.password);
                }
            }
            Logger.verbose((String)TAG, (String)parameters.getCorrelationId(), (String)"Parameters doesn't have password");
            return NativeAuthMsalController.processSignInInitiateApiResult$default(this, initiateApiResult, null, oAuth2Strategy, false, 10, null);
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signInStart", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final SignInWithContinuationTokenCommandResult signInWithContinuationToken(@NotNull SignInWithContinuationTokenCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".signInWithContinuationToken");
        try {
            SignInWithContinuationTokenCommandResult signInWithContinuationTokenCommandResult;
            SignInTokenApiResult tokenApiResult;
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            List<String> mergedScopes = this.addDefaultScopes(parameters.scopes);
            SignInWithContinuationTokenCommandParameters parametersWithScopes = CommandUtil.createSignInWithContinuationTokenCommandParametersWithScopes(parameters, mergedScopes);
            Intrinsics.checkNotNullExpressionValue((Object)parametersWithScopes, (String)"parametersWithScopes");
            SignInTokenApiResult signInTokenApiResult = tokenApiResult = this.performContinuationTokenTokenRequest(oAuth2Strategy, parametersWithScopes);
            if (signInTokenApiResult instanceof SignInTokenApiResult.Success) {
                signInWithContinuationTokenCommandResult = (SignInWithContinuationTokenCommandResult)this.saveAndReturnTokens(oAuth2Strategy, (BaseSignInTokenCommandParameters)parametersWithScopes, (SignInTokenApiResult.Success)tokenApiResult);
            } else if (signInTokenApiResult instanceof SignInTokenApiResult.JITRequired) {
                SignInStartCommandResult signInStartCommandResult = this.toSignInStartCommandResult(this.performJITIntrospect(oAuth2Strategy, (BaseSignInTokenCommandParameters)parametersWithScopes, ((SignInTokenApiResult.JITRequired)tokenApiResult).getContinuationToken(), tokenApiResult.getCorrelationId()));
                Intrinsics.checkNotNull((Object)signInStartCommandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.controllers.results.SignInWithContinuationTokenCommandResult");
                signInWithContinuationTokenCommandResult = (SignInWithContinuationTokenCommandResult)signInStartCommandResult;
            } else if (signInTokenApiResult instanceof SignInTokenApiResult.Redirect) {
                signInWithContinuationTokenCommandResult = (SignInWithContinuationTokenCommandResult)new INativeAuthCommandResult.Redirect(tokenApiResult.getCorrelationId(), ((SignInTokenApiResult.Redirect)tokenApiResult).getRedirectReason());
            } else if (((((signInTokenApiResult instanceof SignInTokenApiResult.InvalidAuthenticationType ? true : signInTokenApiResult instanceof SignInTokenApiResult.MFARequired) ? true : signInTokenApiResult instanceof SignInTokenApiResult.CodeIncorrect) ? true : signInTokenApiResult instanceof SignInTokenApiResult.UserNotFound) ? true : signInTokenApiResult instanceof SignInTokenApiResult.InvalidCredentials) ? true : signInTokenApiResult instanceof SignInTokenApiResult.UnknownError) {
                Logger.warnWithObject((String)TAG, (String)tokenApiResult.getCorrelationId(), (String)"Unexpected result: ", (ILoggable)((ILoggable)tokenApiResult));
                Intrinsics.checkNotNull((Object)tokenApiResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)tokenApiResult;
                String string3 = ((ApiErrorResult)tokenApiResult).getError();
                String string4 = ((ApiErrorResult)tokenApiResult).getErrorDescription();
                List list = ((ApiErrorResult)tokenApiResult).getErrorCodes();
                String string5 = tokenApiResult.getCorrelationId();
                signInWithContinuationTokenCommandResult = (SignInWithContinuationTokenCommandResult)new INativeAuthCommandResult.APIError(string3, string4, null, string5, list, null, 36, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return signInWithContinuationTokenCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signInWithContinuationToken", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final SignInSubmitCodeCommandResult signInSubmitCode(@NotNull SignInSubmitCodeCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".signInSubmitCode");
        try {
            SignInSubmitCodeCommandResult signInSubmitCodeCommandResult;
            SignInTokenApiResult tokenApiResult;
            List<String> mergedScopes = this.addDefaultScopes(parameters.scopes);
            SignInSubmitCodeCommandParameters parametersWithScopes = CommandUtil.createSignInSubmitCodeCommandParametersWithScopes(parameters, mergedScopes);
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            Intrinsics.checkNotNullExpressionValue((Object)parametersWithScopes, (String)"parametersWithScopes");
            SignInTokenApiResult signInTokenApiResult = tokenApiResult = this.performOOBTokenRequest(oAuth2Strategy, parametersWithScopes);
            if (signInTokenApiResult instanceof SignInTokenApiResult.Success) {
                signInSubmitCodeCommandResult = (SignInSubmitCodeCommandResult)this.saveAndReturnTokens(oAuth2Strategy, (BaseSignInTokenCommandParameters)parametersWithScopes, (SignInTokenApiResult.Success)tokenApiResult);
            } else if (signInTokenApiResult instanceof SignInTokenApiResult.CodeIncorrect) {
                String string3 = ((SignInTokenApiResult.CodeIncorrect)tokenApiResult).getError();
                String string4 = ((SignInTokenApiResult.CodeIncorrect)tokenApiResult).getErrorDescription();
                List list = ((SignInTokenApiResult.CodeIncorrect)tokenApiResult).getErrorCodes();
                String string5 = ((SignInTokenApiResult.CodeIncorrect)tokenApiResult).getSubError();
                String string6 = tokenApiResult.getCorrelationId();
                signInSubmitCodeCommandResult = (SignInSubmitCodeCommandResult)new SignInCommandResult.IncorrectCode(string6, string3, string4, list, string5);
            } else if (signInTokenApiResult instanceof SignInTokenApiResult.Redirect) {
                signInSubmitCodeCommandResult = (SignInSubmitCodeCommandResult)new INativeAuthCommandResult.Redirect(tokenApiResult.getCorrelationId(), ((SignInTokenApiResult.Redirect)tokenApiResult).getRedirectReason());
            } else if (((((signInTokenApiResult instanceof SignInTokenApiResult.UnknownError ? true : signInTokenApiResult instanceof SignInTokenApiResult.InvalidAuthenticationType) ? true : signInTokenApiResult instanceof SignInTokenApiResult.MFARequired) ? true : signInTokenApiResult instanceof SignInTokenApiResult.InvalidCredentials) ? true : signInTokenApiResult instanceof SignInTokenApiResult.UserNotFound) ? true : signInTokenApiResult instanceof SignInTokenApiResult.JITRequired) {
                Logger.warnWithObject((String)TAG, (String)tokenApiResult.getCorrelationId(), (String)"Unexpected result: ", (ILoggable)((ILoggable)tokenApiResult));
                Intrinsics.checkNotNull((Object)tokenApiResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)tokenApiResult;
                String string7 = ((ApiErrorResult)tokenApiResult).getError();
                String string8 = ((ApiErrorResult)tokenApiResult).getErrorDescription();
                List list = ((ApiErrorResult)tokenApiResult).getErrorCodes();
                String string9 = tokenApiResult.getCorrelationId();
                signInSubmitCodeCommandResult = (SignInSubmitCodeCommandResult)new INativeAuthCommandResult.APIError(string7, string8, null, string9, list, null, 36, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return signInSubmitCodeCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signInSubmitCode", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final MFASubmitChallengeCommandResult signInSubmitChallenge(@NotNull MFASubmitChallengeCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".signInSubmitChallenge");
        try {
            MFASubmitChallengeCommandResult mFASubmitChallengeCommandResult;
            SignInTokenApiResult tokenApiResult;
            List<String> mergedScopes = this.addDefaultScopes(parameters.scopes);
            MFASubmitChallengeCommandParameters parametersWithScopes = CommandUtil.createMFASubmitChallengeCommandParametersWithScopes(parameters, mergedScopes);
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            Intrinsics.checkNotNullExpressionValue((Object)parametersWithScopes, (String)"parametersWithScopes");
            SignInTokenApiResult signInTokenApiResult = tokenApiResult = this.performSubmitChallengeTokenRequest(oAuth2Strategy, parametersWithScopes);
            if (signInTokenApiResult instanceof SignInTokenApiResult.Success) {
                mFASubmitChallengeCommandResult = (MFASubmitChallengeCommandResult)this.saveAndReturnTokens(oAuth2Strategy, (BaseSignInTokenCommandParameters)parametersWithScopes, (SignInTokenApiResult.Success)tokenApiResult);
            } else if (signInTokenApiResult instanceof SignInTokenApiResult.CodeIncorrect) {
                String string3 = ((SignInTokenApiResult.CodeIncorrect)tokenApiResult).getError();
                String string4 = ((SignInTokenApiResult.CodeIncorrect)tokenApiResult).getErrorDescription();
                List list = ((SignInTokenApiResult.CodeIncorrect)tokenApiResult).getErrorCodes();
                String string5 = ((SignInTokenApiResult.CodeIncorrect)tokenApiResult).getSubError();
                String string6 = tokenApiResult.getCorrelationId();
                mFASubmitChallengeCommandResult = (MFASubmitChallengeCommandResult)new SignInCommandResult.IncorrectCode(string6, string3, string4, list, string5);
            } else if (signInTokenApiResult instanceof SignInTokenApiResult.Redirect) {
                mFASubmitChallengeCommandResult = (MFASubmitChallengeCommandResult)new INativeAuthCommandResult.Redirect(tokenApiResult.getCorrelationId(), ((SignInTokenApiResult.Redirect)tokenApiResult).getRedirectReason());
            } else if (((((signInTokenApiResult instanceof SignInTokenApiResult.UnknownError ? true : signInTokenApiResult instanceof SignInTokenApiResult.InvalidAuthenticationType) ? true : signInTokenApiResult instanceof SignInTokenApiResult.InvalidCredentials) ? true : signInTokenApiResult instanceof SignInTokenApiResult.UserNotFound) ? true : signInTokenApiResult instanceof SignInTokenApiResult.MFARequired) ? true : signInTokenApiResult instanceof SignInTokenApiResult.JITRequired) {
                Logger.warnWithObject((String)TAG, (String)tokenApiResult.getCorrelationId(), (String)"Unexpected result: ", (ILoggable)((ILoggable)tokenApiResult));
                Intrinsics.checkNotNull((Object)tokenApiResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)tokenApiResult;
                String string7 = ((ApiErrorResult)tokenApiResult).getError();
                String string8 = ((ApiErrorResult)tokenApiResult).getErrorDescription();
                List list = ((ApiErrorResult)tokenApiResult).getErrorCodes();
                String string9 = tokenApiResult.getCorrelationId();
                mFASubmitChallengeCommandResult = (MFASubmitChallengeCommandResult)new INativeAuthCommandResult.APIError(string7, string8, null, string9, list, null, 36, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return mFASubmitChallengeCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signInSubmitChallenge()", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final SignInResendCodeCommandResult signInResendCode(@NotNull SignInResendCodeCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".signInResendCode");
        try {
            SignInResendCodeCommandResult signInResendCodeCommandResult;
            SignInChallengeApiResult result;
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            String string3 = parameters.continuationToken;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"parameters.continuationToken");
            String string4 = parameters.getCorrelationId();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"parameters.correlationId");
            SignInChallengeApiResult signInChallengeApiResult = result = this.performSignInDefaultChallengeCall(oAuth2Strategy, string3, string4);
            if (signInChallengeApiResult instanceof SignInChallengeApiResult.OOBRequired) {
                String string5 = ((SignInChallengeApiResult.OOBRequired)result).getContinuationToken();
                int n = ((SignInChallengeApiResult.OOBRequired)result).getCodeLength();
                String string6 = ((SignInChallengeApiResult.OOBRequired)result).getChallengeTargetLabel();
                String string7 = ((SignInChallengeApiResult.OOBRequired)result).getChallengeChannel();
                String string8 = result.getCorrelationId();
                signInResendCodeCommandResult = (SignInResendCodeCommandResult)new SignInCommandResult.CodeRequired(string8, string5, string6, string7, n);
            } else if (signInChallengeApiResult instanceof SignInChallengeApiResult.PasswordRequired) {
                Logger.warnWithObject((String)TAG, (String)result.getCorrelationId(), (String)"Unexpected result: ", (ILoggable)((ILoggable)result));
                signInResendCodeCommandResult = (SignInResendCodeCommandResult)new INativeAuthCommandResult.APIError("unexpected_api_result", "API returned unexpected result: " + result, null, result.getCorrelationId(), null, null, 52, null);
            } else if (signInChallengeApiResult instanceof SignInChallengeApiResult.Redirect) {
                signInResendCodeCommandResult = (SignInResendCodeCommandResult)new INativeAuthCommandResult.Redirect(result.getCorrelationId(), ((SignInChallengeApiResult.Redirect)result).getRedirectReason());
            } else if (signInChallengeApiResult instanceof SignInChallengeApiResult.IntrospectRequired ? true : signInChallengeApiResult instanceof SignInChallengeApiResult.UnknownError) {
                Logger.warnWithObject((String)TAG, (String)"Unexpected result: ", (ILoggable)((ILoggable)result));
                Intrinsics.checkNotNull((Object)result, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)result;
                String string9 = ((ApiErrorResult)result).getError();
                String string10 = ((ApiErrorResult)result).getErrorDescription();
                List list = ((ApiErrorResult)result).getErrorCodes();
                String string11 = result.getCorrelationId();
                signInResendCodeCommandResult = (SignInResendCodeCommandResult)new INativeAuthCommandResult.APIError(string9, string10, null, string11, list, null, 36, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return signInResendCodeCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signInResendCode", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SignInSubmitPasswordCommandResult signInSubmitPassword(@NotNull SignInSubmitPasswordCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".signInSubmitPassword");
        try {
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            List<String> mergedScopes = this.addDefaultScopes(parameters.scopes);
            SignInSubmitPasswordCommandParameters parametersWithScopes = CommandUtil.createSignInSubmitPasswordCommandParametersWithScopes(parameters, parameters.getCorrelationId(), mergedScopes);
            try {
                Intrinsics.checkNotNullExpressionValue((Object)parametersWithScopes, (String)"parametersWithScopes");
                SignInSubmitPasswordCommandResult signInSubmitPasswordCommandResult = this.toSignInSubmitPasswordCommandResult(this.performPasswordTokenCall(oAuth2Strategy, parametersWithScopes), oAuth2Strategy, parametersWithScopes);
                return signInSubmitPasswordCommandResult;
            }
            finally {
                StringUtil.overwriteWithNull((char[])parametersWithScopes.password);
            }
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signInSubmitPassword", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final MFAChallengeCommandResult signInChallenge(@NotNull MFADefaultChallengeCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".signInChallenge()");
        try {
            MFAChallengeCommandResult mFAChallengeCommandResult;
            SignInChallengeApiResult result;
            SignInChallengeApiResult signInChallengeApiResult;
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            boolean isSelectedChallenge = parameters instanceof MFASelectedDefaultChallengeCommandParameters;
            if (isSelectedChallenge) {
                String string3 = parameters.continuationToken;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"parameters.continuationToken");
                String string4 = parameters.getCorrelationId();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"parameters.correlationId");
                String string5 = ((MFASelectedDefaultChallengeCommandParameters)parameters).authMethodId;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"parameters as MFASelecte\u2026dParameters).authMethodId");
                signInChallengeApiResult = this.performSignInSelectedChallengeCall(oAuth2Strategy, string3, string4, string5);
            } else {
                String string6 = parameters.continuationToken;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"parameters.continuationToken");
                String string7 = parameters.getCorrelationId();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"parameters.correlationId");
                signInChallengeApiResult = this.performSignInDefaultChallengeCall(oAuth2Strategy, string6, string7);
            }
            SignInChallengeApiResult signInChallengeApiResult2 = result = signInChallengeApiResult;
            if (signInChallengeApiResult2 instanceof SignInChallengeApiResult.IntrospectRequired) {
                String string8 = parameters.continuationToken;
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"parameters.continuationToken");
                String string9 = parameters.getCorrelationId();
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"parameters.correlationId");
                return this.toMFAChallengeCommandResult(this.performIntrospectCall(oAuth2Strategy, string8, string9));
            }
            if (signInChallengeApiResult2 instanceof SignInChallengeApiResult.OOBRequired) {
                String string10 = result.getCorrelationId();
                String string11 = ((SignInChallengeApiResult.OOBRequired)result).getContinuationToken();
                String string12 = ((SignInChallengeApiResult.OOBRequired)result).getChallengeChannel();
                String string13 = ((SignInChallengeApiResult.OOBRequired)result).getChallengeTargetLabel();
                int n = ((SignInChallengeApiResult.OOBRequired)result).getCodeLength();
                mFAChallengeCommandResult = (MFAChallengeCommandResult)new MFACommandResult.VerificationRequired(string10, string11, string13, string12, n);
            } else if (signInChallengeApiResult2 instanceof SignInChallengeApiResult.Redirect) {
                mFAChallengeCommandResult = (MFAChallengeCommandResult)new INativeAuthCommandResult.Redirect(result.getCorrelationId(), ((SignInChallengeApiResult.Redirect)result).getRedirectReason());
            } else if (signInChallengeApiResult2 instanceof SignInChallengeApiResult.PasswordRequired) {
                Logger.warnWithObject((String)TAG, (String)result.getCorrelationId(), (String)"Unexpected result: ", (ILoggable)((ILoggable)result));
                mFAChallengeCommandResult = (MFAChallengeCommandResult)new INativeAuthCommandResult.APIError("unexpected_api_result", "API returned unexpected result: " + result, null, result.getCorrelationId(), null, null, 52, null);
            } else if (signInChallengeApiResult2 instanceof SignInChallengeApiResult.UnknownError) {
                Logger.warnWithObject((String)TAG, (String)"Unexpected result: ", (ILoggable)((ILoggable)result));
                String string14 = ((SignInChallengeApiResult.UnknownError)result).getError();
                String string15 = ((SignInChallengeApiResult.UnknownError)result).getErrorDescription();
                List list = ((SignInChallengeApiResult.UnknownError)result).getErrorCodes();
                String string16 = result.getCorrelationId();
                mFAChallengeCommandResult = (MFAChallengeCommandResult)new INativeAuthCommandResult.APIError(string14, string15, null, string16, list, null, 36, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return mFAChallengeCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signInChallenge()", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final GetAuthMethodsCommandResult getAuthMethods(@NotNull GetAuthMethodsCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".getAuthMethods()");
        try {
            GetAuthMethodsCommandResult getAuthMethodsCommandResult;
            SignInIntrospectApiResult result;
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            String string3 = parameters.continuationToken;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"parameters.continuationToken");
            String string4 = parameters.getCorrelationId();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"parameters.correlationId");
            SignInIntrospectApiResult signInIntrospectApiResult = result = this.performIntrospectCall(oAuth2Strategy, string3, string4);
            if (signInIntrospectApiResult instanceof SignInIntrospectApiResult.Success) {
                getAuthMethodsCommandResult = (GetAuthMethodsCommandResult)new MFACommandResult.SelectionRequired(result.getCorrelationId(), ((SignInIntrospectApiResult.Success)result).getContinuationToken(), ((SignInIntrospectApiResult.Success)result).getMethods());
            } else if (signInIntrospectApiResult instanceof SignInIntrospectApiResult.Redirect) {
                getAuthMethodsCommandResult = (GetAuthMethodsCommandResult)new INativeAuthCommandResult.Redirect(result.getCorrelationId(), ((SignInIntrospectApiResult.Redirect)result).getRedirectReason());
            } else if (signInIntrospectApiResult instanceof SignInIntrospectApiResult.UnknownError) {
                Logger.warnWithObject((String)TAG, (String)"Unexpected result: ", (ILoggable)((ILoggable)result));
                String string5 = ((SignInIntrospectApiResult.UnknownError)result).getError();
                String string6 = ((SignInIntrospectApiResult.UnknownError)result).getErrorDescription();
                List list = ((SignInIntrospectApiResult.UnknownError)result).getErrorCodes();
                String string7 = result.getCorrelationId();
                getAuthMethodsCommandResult = (GetAuthMethodsCommandResult)new INativeAuthCommandResult.APIError(string5, string6, null, string7, list, null, 36, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return getAuthMethodsCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in getAuthMethods()", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final JITChallengeAuthMethodCommandResult jitChallengeAuthMethod(@NotNull JITChallengeAuthMethodCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".jitChallengeAuthMethod");
        NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
        try {
            JITChallengeAuthMethodCommandResult jITChallengeAuthMethodCommandResult;
            JITChallengeApiResult result;
            JITChallengeApiResult jITChallengeApiResult = result = this.performJITChallengeCall(oAuth2Strategy, parameters);
            if (jITChallengeApiResult instanceof JITChallengeApiResult.InvalidVerificationContact) {
                String string3 = ((JITChallengeApiResult.InvalidVerificationContact)result).getError();
                String string4 = ((JITChallengeApiResult.InvalidVerificationContact)result).getErrorDescription();
                List list = ((JITChallengeApiResult.InvalidVerificationContact)result).getErrorCodes();
                String string5 = result.getCorrelationId();
                jITChallengeAuthMethodCommandResult = (JITChallengeAuthMethodCommandResult)new JITCommandResult.IncorrectVerificationContact(string5, string3, string4, list);
            } else if (jITChallengeApiResult instanceof JITChallengeApiResult.OOBRequired) {
                jITChallengeAuthMethodCommandResult = (JITChallengeAuthMethodCommandResult)new JITCommandResult.VerificationRequired(result.getCorrelationId(), ((JITChallengeApiResult.OOBRequired)result).getContinuationToken(), ((JITChallengeApiResult.OOBRequired)result).getChallengeTargetLabel(), ((JITChallengeApiResult.OOBRequired)result).getChallengeChannel(), ((JITChallengeApiResult.OOBRequired)result).getCodeLength());
            } else if (jITChallengeApiResult instanceof JITChallengeApiResult.UnknownError) {
                Logger.warnWithObject((String)TAG, (String)"Unexpected result: ", (ILoggable)((ILoggable)result));
                String string6 = ((JITChallengeApiResult.UnknownError)result).getError();
                String string7 = ((JITChallengeApiResult.UnknownError)result).getErrorDescription();
                List list = ((JITChallengeApiResult.UnknownError)result).getErrorCodes();
                String string8 = result.getCorrelationId();
                jITChallengeAuthMethodCommandResult = (JITChallengeAuthMethodCommandResult)new INativeAuthCommandResult.APIError(string6, string7, null, string8, list, null, 36, null);
            } else if (jITChallengeApiResult instanceof JITChallengeApiResult.Preverified) {
                JITContinueCommandParameters jitContinueParams = CommandUtil.createJITContinueCommandParameters((BaseSignInTokenCommandParameters)parameters, result.getCorrelationId(), "continuation_token", ((JITChallengeApiResult.Preverified)result).getContinuationToken());
                Intrinsics.checkNotNullExpressionValue((Object)jitContinueParams, (String)"jitContinueParams");
                jITChallengeAuthMethodCommandResult = this.toJITChallengeAuthMethodCommandResult(this.completeJITFlow(jitContinueParams));
            } else if (jITChallengeApiResult instanceof JITChallengeApiResult.Redirect) {
                jITChallengeAuthMethodCommandResult = (JITChallengeAuthMethodCommandResult)new INativeAuthCommandResult.Redirect(result.getCorrelationId(), ((JITChallengeApiResult.Redirect)result).getRedirectReason());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return jITChallengeAuthMethodCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signInSubmitPassword", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final JITSubmitChallengeCommandResult jitSubmitChallenge(@NotNull JITContinueCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".jitSubmitChallenge");
        return this.completeJITFlow(parameters);
    }

    @NotNull
    public final SignUpStartCommandResult signUpStart(@NotNull SignUpStartCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".signUpStart");
        try {
            SignUpStartCommandResult signUpStartCommandResult;
            SignUpStartApiResult signUpStartApiResult;
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            SignUpStartApiResult signUpStartApiResult2 = signUpStartApiResult = this.performSignUpStartUsingPasswordRequest(oAuth2Strategy, parameters);
            if (signUpStartApiResult2 instanceof SignUpStartApiResult.Success) {
                signUpStartCommandResult = this.toSignUpStartCommandResult(this.performSignUpChallengeCall(oAuth2Strategy, ((SignUpStartApiResult.Success)signUpStartApiResult).getContinuationToken(), signUpStartApiResult.getCorrelationId()));
            } else if (signUpStartApiResult2 instanceof SignUpStartApiResult.InvalidPassword) {
                String string3 = ((SignUpStartApiResult.InvalidPassword)signUpStartApiResult).getError();
                String string4 = ((SignUpStartApiResult.InvalidPassword)signUpStartApiResult).getErrorDescription();
                String string5 = ((SignUpStartApiResult.InvalidPassword)signUpStartApiResult).getSubError();
                String string6 = signUpStartApiResult.getCorrelationId();
                signUpStartCommandResult = (SignUpStartCommandResult)new SignUpCommandResult.InvalidPassword(string6, string3, string4, string5);
            } else if (signUpStartApiResult2 instanceof SignUpStartApiResult.InvalidAttributes) {
                String string7 = ((SignUpStartApiResult.InvalidAttributes)signUpStartApiResult).getError();
                String string8 = ((SignUpStartApiResult.InvalidAttributes)signUpStartApiResult).getErrorDescription();
                List list = ((SignUpStartApiResult.InvalidAttributes)signUpStartApiResult).getInvalidAttributes();
                String string9 = signUpStartApiResult.getCorrelationId();
                signUpStartCommandResult = (SignUpStartCommandResult)new SignUpCommandResult.InvalidAttributes(string9, string7, string8, list);
            } else if (signUpStartApiResult2 instanceof SignUpStartApiResult.UsernameAlreadyExists) {
                String string10 = ((SignUpStartApiResult.UsernameAlreadyExists)signUpStartApiResult).getError();
                String string11 = ((SignUpStartApiResult.UsernameAlreadyExists)signUpStartApiResult).getErrorDescription();
                String string12 = signUpStartApiResult.getCorrelationId();
                signUpStartCommandResult = (SignUpStartCommandResult)new SignUpCommandResult.UsernameAlreadyExists(string12, string10, string11);
            } else if (signUpStartApiResult2 instanceof SignUpStartApiResult.InvalidUsername) {
                signUpStartCommandResult = (SignUpStartCommandResult)new INativeAuthCommandResult.InvalidUsername(((SignUpStartApiResult.InvalidUsername)signUpStartApiResult).getError(), ((SignUpStartApiResult.InvalidUsername)signUpStartApiResult).getErrorDescription(), null, signUpStartApiResult.getCorrelationId(), null, null, 52, null);
            } else if (signUpStartApiResult2 instanceof SignUpStartApiResult.AuthNotSupported) {
                String string13 = ((SignUpStartApiResult.AuthNotSupported)signUpStartApiResult).getError();
                String string14 = ((SignUpStartApiResult.AuthNotSupported)signUpStartApiResult).getErrorDescription();
                String string15 = signUpStartApiResult.getCorrelationId();
                signUpStartCommandResult = (SignUpStartCommandResult)new SignUpCommandResult.AuthNotSupported(string15, string13, string14);
            } else if (signUpStartApiResult2 instanceof SignUpStartApiResult.Redirect) {
                signUpStartCommandResult = (SignUpStartCommandResult)new INativeAuthCommandResult.Redirect(signUpStartApiResult.getCorrelationId(), ((SignUpStartApiResult.Redirect)signUpStartApiResult).getRedirectReason());
            } else if (signUpStartApiResult2 instanceof SignUpStartApiResult.UnsupportedChallengeType ? true : signUpStartApiResult2 instanceof SignUpStartApiResult.UnknownError) {
                Intrinsics.checkNotNull((Object)signUpStartApiResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)signUpStartApiResult;
                Logger.warnWithObject((String)TAG, (String)signUpStartApiResult.getCorrelationId(), (String)"Unexpected result: ", (ILoggable)((ILoggable)signUpStartApiResult));
                signUpStartCommandResult = (SignUpStartCommandResult)new INativeAuthCommandResult.APIError(((ApiErrorResult)signUpStartApiResult).getError(), ((ApiErrorResult)signUpStartApiResult).getErrorDescription(), null, signUpStartApiResult.getCorrelationId(), null, null, 52, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return signUpStartCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signUpStart", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final SignUpSubmitCodeCommandResult signUpSubmitCode(@NotNull SignUpSubmitCodeCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".signUpSubmitCode");
        try {
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            SignUpContinueApiResult signUpSubmitCodeResult = this.performSignUpSubmitCode(oAuth2Strategy, parameters);
            return this.toSignUpSubmitCodeCommandResult(signUpSubmitCodeResult, oAuth2Strategy);
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signUpSubmitCode", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final SignUpResendCodeCommandResult signUpResendCode(@NotNull SignUpResendCodeCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".signUpResendCode");
        try {
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            String string3 = parameters.continuationToken;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"parameters.continuationToken");
            String string4 = parameters.getCorrelationId();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"parameters.correlationId");
            SignUpStartCommandResult signUpStartCommandResult = this.toSignUpStartCommandResult(this.performSignUpChallengeCall(oAuth2Strategy, string3, string4));
            Intrinsics.checkNotNull((Object)signUpStartCommandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.controllers.results.SignUpResendCodeCommandResult");
            return (SignUpResendCodeCommandResult)signUpStartCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signUpResendCode", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final SignUpSubmitUserAttributesCommandResult signUpSubmitUserAttributes(@NotNull SignUpSubmitUserAttributesCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".signUpSubmitUserAttributes");
        try {
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            SignUpContinueApiResult signUpContinueApiResult = this.performSignUpSubmitUserAttributes(oAuth2Strategy, parameters);
            return this.toSignUpSubmitUserAttributesCommandResult(signUpContinueApiResult, oAuth2Strategy);
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signUpSubmitUserAttributes", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final SignUpSubmitPasswordCommandResult signUpSubmitPassword(@NotNull SignUpSubmitPasswordCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".signUpSubmitPassword");
        try {
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            return this.toSignUpSubmitPasswordCommandResult(this.performSignUpSubmitPassword(oAuth2Strategy, parameters), oAuth2Strategy);
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signUpSubmitPassword", (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public AcquireTokenResult acquireTokenSilent(@NotNull SilentTokenCommandParameters parameters) throws IOException, ClientException, ArgumentException, ServiceException {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".acquireTokenSilent");
        AcquireTokenResult acquireTokenSilentResult = new AcquireTokenResult();
        parameters.validate();
        Set mergedScopes = this.addDefaultScopes((TokenCommandParameters)parameters);
        SilentTokenCommandParameters parametersWithScopes = ((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)parameters.toBuilder().scopes(mergedScopes)).build();
        AccountRecord accountRecord = this.getCachedAccountRecord(parametersWithScopes);
        Intrinsics.checkNotNullExpressionValue((Object)accountRecord, (String)"getCachedAccountRecord(parametersWithScopes)");
        AccountRecord targetAccount = accountRecord;
        AbstractAuthenticationScheme authScheme = parametersWithScopes.getAuthenticationScheme();
        OAuth2StrategyParameters strategyParameters = OAuth2StrategyParameters.builder().platformComponents(parametersWithScopes.getPlatformComponents()).authenticationScheme(authScheme).build();
        OAuth2Strategy strategy = parametersWithScopes.getAuthority().createOAuth2Strategy(strategyParameters);
        OAuth2TokenCache tokenCache = parametersWithScopes.getOAuth2TokenCache();
        List list = tokenCache.loadWithAggregatedAccountData(parametersWithScopes.getClientId(), parametersWithScopes.getApplicationIdentifier(), null, TextUtils.join((CharSequence)" ", (Iterable)parametersWithScopes.getScopes()), targetAccount, authScheme);
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<com.microsoft.identity.common.java.cache.ICacheRecord>");
        List cacheRecords = list;
        ICacheRecord fullCacheRecord = (ICacheRecord)cacheRecords.get(0);
        if (LibraryConfiguration.getInstance().isRefreshInEnabled() && fullCacheRecord.getAccessToken() != null && fullCacheRecord.getAccessToken().refreshOnIsActive()) {
            Logger.info((String)TAG, (String)parameters.getCorrelationId(), (String)"RefreshOn is active. This will extend your token usage in the rare case servers are not available.");
        }
        if (LibraryConfiguration.getInstance().isRefreshInEnabled() && fullCacheRecord.getAccessToken() != null && fullCacheRecord.getAccessToken().shouldRefresh()) {
            if (!fullCacheRecord.getAccessToken().isExpired()) {
                Intrinsics.checkNotNullExpressionValue((Object)parametersWithScopes, (String)"parametersWithScopes");
                this.setAcquireTokenResult(acquireTokenSilentResult, parametersWithScopes, cacheRecords);
                RefreshOnCommand refreshOnCommand = new RefreshOnCommand((CommandParameters)parametersWithScopes, this.asControllerFactory(), "1201");
                CommandDispatcher.submitAndForget((BaseCommand)refreshOnCommand);
            } else {
                Logger.warn((String)TAG, (String)parameters.getCorrelationId(), (String)"Access token is expired. Removing from cache...");
                tokenCache.removeCredential((Credential)fullCacheRecord.getAccessToken());
                this.renewAccessToken(parametersWithScopes, acquireTokenSilentResult, tokenCache, strategy, fullCacheRecord);
            }
        } else if (this.accessTokenIsNull(fullCacheRecord) || this.refreshTokenIsNull(fullCacheRecord) || parametersWithScopes.isForceRefresh() || !this.isRequestAuthorityRealmSameAsATRealm(parametersWithScopes.getAuthority(), fullCacheRecord.getAccessToken()) || !strategy.validateCachedResult(authScheme, fullCacheRecord)) {
            if (this.refreshTokenIsNull(fullCacheRecord)) {
                ServiceException exception = new ServiceException("no_tokens_found", "No refresh token was found.", null);
                Telemetry.emit((BaseEvent)((BaseEvent)new ApiEndEvent().putException((Exception)exception).putApiId("103")));
                throw exception;
            }
            this.renewAccessToken(parametersWithScopes, acquireTokenSilentResult, tokenCache, strategy, fullCacheRecord);
        } else if (fullCacheRecord.getAccessToken().isExpired()) {
            Logger.warn((String)TAG, (String)parameters.getCorrelationId(), (String)"Access token is expired. Removing from cache...");
            tokenCache.removeCredential((Credential)fullCacheRecord.getAccessToken());
            this.renewAccessToken(parametersWithScopes, acquireTokenSilentResult, tokenCache, strategy, fullCacheRecord);
        } else {
            Logger.verbose((String)TAG, (String)parameters.getCorrelationId(), (String)"Returning silent result");
            Intrinsics.checkNotNullExpressionValue((Object)parametersWithScopes, (String)"parametersWithScopes");
            this.setAcquireTokenResult(acquireTokenSilentResult, parametersWithScopes, cacheRecords);
        }
        Telemetry.emit((BaseEvent)((BaseEvent)new ApiEndEvent().putResult(acquireTokenSilentResult).putApiId("103")));
        return acquireTokenSilentResult;
    }

    private final void setAcquireTokenResult(AcquireTokenResult acquireTokenSilentResult, SilentTokenCommandParameters parametersWithScopes, List<? extends ICacheRecord> cacheRecords) throws ClientException {
        ICacheRecord fullCacheRecord = cacheRecords.get(0);
        acquireTokenSilentResult.setLocalAuthenticationResult((ILocalAuthenticationResult)new LocalAuthenticationResult(this.finalizeCacheRecordForResult(fullCacheRecord, parametersWithScopes.getAuthenticationScheme()), cacheRecords, SdkType.MSAL, true));
    }

    @NotNull
    public final ResetPasswordStartCommandResult resetPasswordStart(@NotNull ResetPasswordStartCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".resetPasswordStart");
        try {
            ResetPasswordStartCommandResult resetPasswordStartCommandResult;
            ResetPasswordStartApiResult resetPasswordStartApiResult;
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            ResetPasswordStartApiResult resetPasswordStartApiResult2 = resetPasswordStartApiResult = this.performResetPasswordStartCall(oAuth2Strategy, parameters);
            if (resetPasswordStartApiResult2 instanceof ResetPasswordStartApiResult.Success) {
                resetPasswordStartCommandResult = this.toResetPasswordStartCommandResult(this.performResetPasswordChallengeCall(oAuth2Strategy, ((ResetPasswordStartApiResult.Success)resetPasswordStartApiResult).getContinuationToken(), resetPasswordStartApiResult.getCorrelationId()));
            } else if (resetPasswordStartApiResult2 instanceof ResetPasswordStartApiResult.Redirect) {
                resetPasswordStartCommandResult = (ResetPasswordStartCommandResult)new INativeAuthCommandResult.Redirect(resetPasswordStartApiResult.getCorrelationId(), ((ResetPasswordStartApiResult.Redirect)resetPasswordStartApiResult).getRedirectReason());
            } else if (resetPasswordStartApiResult2 instanceof ResetPasswordStartApiResult.UserNotFound) {
                String string3 = ((ResetPasswordStartApiResult.UserNotFound)resetPasswordStartApiResult).getError();
                String string4 = ((ResetPasswordStartApiResult.UserNotFound)resetPasswordStartApiResult).getErrorDescription();
                String string5 = resetPasswordStartApiResult.getCorrelationId();
                resetPasswordStartCommandResult = (ResetPasswordStartCommandResult)new ResetPasswordCommandResult.UserNotFound(string5, string3, string4);
            } else if (resetPasswordStartApiResult2 instanceof ResetPasswordStartApiResult.UnsupportedChallengeType ? true : resetPasswordStartApiResult2 instanceof ResetPasswordStartApiResult.UnknownError) {
                Logger.warnWithObject((String)TAG, (String)parameters.getCorrelationId(), (String)"Unexpected result: ", (ILoggable)((ILoggable)resetPasswordStartApiResult));
                Intrinsics.checkNotNull((Object)resetPasswordStartApiResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)resetPasswordStartApiResult;
                resetPasswordStartCommandResult = (ResetPasswordStartCommandResult)new INativeAuthCommandResult.APIError(((ApiErrorResult)resetPasswordStartApiResult).getError(), ((ApiErrorResult)resetPasswordStartApiResult).getErrorDescription(), null, resetPasswordStartApiResult.getCorrelationId(), null, null, 52, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return resetPasswordStartCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in resetPasswordStart", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final ResetPasswordSubmitCodeCommandResult resetPasswordSubmitCode(@NotNull ResetPasswordSubmitCodeCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".resetPasswordSubmitCode");
        try {
            ResetPasswordSubmitCodeCommandResult resetPasswordSubmitCodeCommandResult;
            ResetPasswordContinueApiResult resetPasswordContinueApiResult;
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            ResetPasswordContinueApiResult resetPasswordContinueApiResult2 = resetPasswordContinueApiResult = this.performResetPasswordContinueCall(oAuth2Strategy, parameters);
            if (resetPasswordContinueApiResult2 instanceof ResetPasswordContinueApiResult.PasswordRequired) {
                String string3 = ((ResetPasswordContinueApiResult.PasswordRequired)resetPasswordContinueApiResult).getContinuationToken();
                String string4 = resetPasswordContinueApiResult.getCorrelationId();
                resetPasswordSubmitCodeCommandResult = (ResetPasswordSubmitCodeCommandResult)new ResetPasswordCommandResult.PasswordRequired(string4, string3);
            } else if (resetPasswordContinueApiResult2 instanceof ResetPasswordContinueApiResult.CodeIncorrect) {
                String string5 = ((ResetPasswordContinueApiResult.CodeIncorrect)resetPasswordContinueApiResult).getError();
                String string6 = ((ResetPasswordContinueApiResult.CodeIncorrect)resetPasswordContinueApiResult).getErrorDescription();
                String string7 = ((ResetPasswordContinueApiResult.CodeIncorrect)resetPasswordContinueApiResult).getSubError();
                String string8 = resetPasswordContinueApiResult.getCorrelationId();
                resetPasswordSubmitCodeCommandResult = (ResetPasswordSubmitCodeCommandResult)new ResetPasswordCommandResult.IncorrectCode(string8, string5, string6, string7);
            } else if (resetPasswordContinueApiResult2 instanceof ResetPasswordContinueApiResult.Redirect) {
                resetPasswordSubmitCodeCommandResult = (ResetPasswordSubmitCodeCommandResult)new INativeAuthCommandResult.Redirect(resetPasswordContinueApiResult.getCorrelationId(), ((ResetPasswordContinueApiResult.Redirect)resetPasswordContinueApiResult).getRedirectReason());
            } else if (resetPasswordContinueApiResult2 instanceof ResetPasswordContinueApiResult.ExpiredToken ? true : resetPasswordContinueApiResult2 instanceof ResetPasswordContinueApiResult.UnknownError) {
                Logger.warnWithObject((String)TAG, (String)"Unexpected result: ", (ILoggable)((ILoggable)resetPasswordContinueApiResult));
                Intrinsics.checkNotNull((Object)resetPasswordContinueApiResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)resetPasswordContinueApiResult;
                resetPasswordSubmitCodeCommandResult = (ResetPasswordSubmitCodeCommandResult)new INativeAuthCommandResult.APIError(((ApiErrorResult)resetPasswordContinueApiResult).getError(), ((ApiErrorResult)resetPasswordContinueApiResult).getErrorDescription(), null, resetPasswordContinueApiResult.getCorrelationId(), null, null, 52, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return resetPasswordSubmitCodeCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in resetPasswordSubmitCode", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final ResetPasswordResendCodeCommandResult resetPasswordResendCode(@NotNull ResetPasswordResendCodeCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".resetPasswordResendCode");
        try {
            ResetPasswordResendCodeCommandResult resetPasswordResendCodeCommandResult;
            ResetPasswordChallengeApiResult resetPasswordChallengeApiResult;
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            String string3 = parameters.continuationToken;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"parameters.continuationToken");
            String string4 = parameters.getCorrelationId();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"parameters.correlationId");
            ResetPasswordChallengeApiResult resetPasswordChallengeApiResult2 = resetPasswordChallengeApiResult = this.performResetPasswordChallengeCall(oAuth2Strategy, string3, string4);
            if (resetPasswordChallengeApiResult2 instanceof ResetPasswordChallengeApiResult.CodeRequired) {
                String string5 = ((ResetPasswordChallengeApiResult.CodeRequired)resetPasswordChallengeApiResult).getContinuationToken();
                int n = ((ResetPasswordChallengeApiResult.CodeRequired)resetPasswordChallengeApiResult).getCodeLength();
                String string6 = ((ResetPasswordChallengeApiResult.CodeRequired)resetPasswordChallengeApiResult).getChallengeTargetLabel();
                String string7 = ((ResetPasswordChallengeApiResult.CodeRequired)resetPasswordChallengeApiResult).getChallengeChannel();
                String string8 = resetPasswordChallengeApiResult.getCorrelationId();
                resetPasswordResendCodeCommandResult = (ResetPasswordResendCodeCommandResult)new ResetPasswordCommandResult.CodeRequired(string8, string5, n, string6, string7);
            } else if (resetPasswordChallengeApiResult2 instanceof ResetPasswordChallengeApiResult.Redirect) {
                resetPasswordResendCodeCommandResult = (ResetPasswordResendCodeCommandResult)new INativeAuthCommandResult.Redirect(resetPasswordChallengeApiResult.getCorrelationId(), ((ResetPasswordChallengeApiResult.Redirect)resetPasswordChallengeApiResult).getRedirectReason());
            } else if ((resetPasswordChallengeApiResult2 instanceof ResetPasswordChallengeApiResult.ExpiredToken ? true : resetPasswordChallengeApiResult2 instanceof ResetPasswordChallengeApiResult.UnsupportedChallengeType) ? true : resetPasswordChallengeApiResult2 instanceof ResetPasswordChallengeApiResult.UnknownError) {
                Logger.warnWithObject((String)TAG, (String)resetPasswordChallengeApiResult.getCorrelationId(), (String)"Unexpected result: ", (ILoggable)((ILoggable)resetPasswordChallengeApiResult));
                Intrinsics.checkNotNull((Object)resetPasswordChallengeApiResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)resetPasswordChallengeApiResult;
                resetPasswordResendCodeCommandResult = (ResetPasswordResendCodeCommandResult)new INativeAuthCommandResult.APIError(((ApiErrorResult)resetPasswordChallengeApiResult).getError(), ((ApiErrorResult)resetPasswordChallengeApiResult).getErrorDescription(), null, resetPasswordChallengeApiResult.getCorrelationId(), null, null, 52, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return resetPasswordResendCodeCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in resetPasswordResendCode", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final ResetPasswordSubmitNewPasswordCommandResult resetPasswordSubmitNewPassword(@NotNull ResetPasswordSubmitNewPasswordCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".resetPasswordSubmitNewPassword");
        try {
            ResetPasswordSubmitNewPasswordCommandResult resetPasswordSubmitNewPasswordCommandResult;
            ResetPasswordSubmitApiResult resetPasswordSubmitApiResult;
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            ResetPasswordSubmitApiResult resetPasswordSubmitApiResult2 = resetPasswordSubmitApiResult = this.performResetPasswordSubmitCall(oAuth2Strategy, parameters);
            if (resetPasswordSubmitApiResult2 instanceof ResetPasswordSubmitApiResult.SubmitSuccess) {
                String string3 = ((ResetPasswordSubmitApiResult.SubmitSuccess)resetPasswordSubmitApiResult).getContinuationToken();
                int n = ((ResetPasswordSubmitApiResult.SubmitSuccess)resetPasswordSubmitApiResult).getPollInterval();
                String string4 = resetPasswordSubmitApiResult.getCorrelationId();
                resetPasswordSubmitNewPasswordCommandResult = this.resetPasswordPollCompletion(oAuth2Strategy, string3, string4, n);
            } else if (resetPasswordSubmitApiResult2 instanceof ResetPasswordSubmitApiResult.PasswordInvalid) {
                String string5 = ((ResetPasswordSubmitApiResult.PasswordInvalid)resetPasswordSubmitApiResult).getError();
                String string6 = ((ResetPasswordSubmitApiResult.PasswordInvalid)resetPasswordSubmitApiResult).getErrorDescription();
                String string7 = ((ResetPasswordSubmitApiResult.PasswordInvalid)resetPasswordSubmitApiResult).getSubError();
                String string8 = resetPasswordSubmitApiResult.getCorrelationId();
                resetPasswordSubmitNewPasswordCommandResult = (ResetPasswordSubmitNewPasswordCommandResult)new ResetPasswordCommandResult.PasswordNotAccepted(string8, string5, string6, string7);
            } else if (resetPasswordSubmitApiResult2 instanceof ResetPasswordSubmitApiResult.Redirect) {
                resetPasswordSubmitNewPasswordCommandResult = (ResetPasswordSubmitNewPasswordCommandResult)new INativeAuthCommandResult.Redirect(resetPasswordSubmitApiResult.getCorrelationId(), ((ResetPasswordSubmitApiResult.Redirect)resetPasswordSubmitApiResult).getRedirectReason());
            } else if (resetPasswordSubmitApiResult2 instanceof ResetPasswordSubmitApiResult.ExpiredToken ? true : resetPasswordSubmitApiResult2 instanceof ResetPasswordSubmitApiResult.UnknownError) {
                Logger.warnWithObject((String)TAG, (String)resetPasswordSubmitApiResult.getCorrelationId(), (String)"Unexpected result: ", (ILoggable)((ILoggable)resetPasswordSubmitApiResult));
                Intrinsics.checkNotNull((Object)resetPasswordSubmitApiResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)resetPasswordSubmitApiResult;
                resetPasswordSubmitNewPasswordCommandResult = (ResetPasswordSubmitNewPasswordCommandResult)new INativeAuthCommandResult.APIError(((ApiErrorResult)resetPasswordSubmitApiResult).getError(), ((ApiErrorResult)resetPasswordSubmitApiResult).getErrorDescription(), null, resetPasswordSubmitApiResult.getCorrelationId(), null, null, 52, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return resetPasswordSubmitNewPasswordCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in resetPasswordSubmitNewPassword", (Throwable)e);
            throw e;
        }
    }

    private final ResetPasswordSubmitNewPasswordCommandResult resetPasswordPollCompletion(NativeAuthOAuth2Strategy oAuth2Strategy, String continuationToken, String correlationId, int pollIntervalInSeconds) {
        String methodTag = TAG + ":resetPasswordPollCompletion";
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, correlationId, TAG + ".resetPasswordPollCompletion");
        try {
            ResetPasswordSubmitNewPasswordCommandResult resetPasswordSubmitNewPasswordCommandResult;
            int pollWaitInterval = pollIntervalInSeconds * 1000;
            ResetPasswordPollCompletionApiResult pollCompletionApiResult = this.performResetPasswordPollCompletionCall(oAuth2Strategy, continuationToken, correlationId);
            long startTime = System.currentTimeMillis();
            while (pollCompletionApiResult instanceof ResetPasswordPollCompletionApiResult.InProgress) {
                ThreadUtils.sleepSafely((int)pollWaitInterval, (String)methodTag, (String)"Waiting between reset password polls");
                if (NativeAuthMsalController.resetPasswordPollCompletion$pollCompletionTimedOut(startTime)) {
                    Logger.warn((String)TAG, (String)pollCompletionApiResult.getCorrelationId(), (String)"Reset password completion timed out.");
                    String string3 = pollCompletionApiResult.getCorrelationId();
                    return (ResetPasswordSubmitNewPasswordCommandResult)new ResetPasswordCommandResult.PasswordResetFailed(string3, "timeout", "Command timed out while polling for password reset result.");
                }
                pollCompletionApiResult = this.performResetPasswordPollCompletionCall(oAuth2Strategy, continuationToken, correlationId);
            }
            ResetPasswordPollCompletionApiResult resetPasswordPollCompletionApiResult = pollCompletionApiResult;
            if (resetPasswordPollCompletionApiResult instanceof ResetPasswordPollCompletionApiResult.PollingFailed) {
                String string4 = ((ResetPasswordPollCompletionApiResult.PollingFailed)pollCompletionApiResult).getError();
                String string5 = ((ResetPasswordPollCompletionApiResult.PollingFailed)pollCompletionApiResult).getErrorDescription();
                String string6 = pollCompletionApiResult.getCorrelationId();
                resetPasswordSubmitNewPasswordCommandResult = (ResetPasswordSubmitNewPasswordCommandResult)new ResetPasswordCommandResult.PasswordResetFailed(string6, string4, string5);
            } else if (resetPasswordPollCompletionApiResult instanceof ResetPasswordPollCompletionApiResult.PollingSucceeded) {
                String string7 = ((ResetPasswordPollCompletionApiResult.PollingSucceeded)pollCompletionApiResult).getContinuationToken();
                Integer n = ((ResetPasswordPollCompletionApiResult.PollingSucceeded)pollCompletionApiResult).getExpiresIn();
                String string8 = pollCompletionApiResult.getCorrelationId();
                resetPasswordSubmitNewPasswordCommandResult = (ResetPasswordSubmitNewPasswordCommandResult)new ResetPasswordCommandResult.Complete(string8, string7, n);
            } else if (resetPasswordPollCompletionApiResult instanceof ResetPasswordPollCompletionApiResult.InProgress) {
                Logger.warn((String)TAG, (String)pollCompletionApiResult.getCorrelationId(), (String)"in_progress received after polling, illegal state");
                resetPasswordSubmitNewPasswordCommandResult = (ResetPasswordSubmitNewPasswordCommandResult)new INativeAuthCommandResult.APIError("illegal_state", "in_progress received after polling concluded, illegal state", null, pollCompletionApiResult.getCorrelationId(), null, null, 52, null);
            } else if (resetPasswordPollCompletionApiResult instanceof ResetPasswordPollCompletionApiResult.Redirect) {
                resetPasswordSubmitNewPasswordCommandResult = (ResetPasswordSubmitNewPasswordCommandResult)new INativeAuthCommandResult.Redirect(pollCompletionApiResult.getCorrelationId(), ((ResetPasswordPollCompletionApiResult.Redirect)pollCompletionApiResult).getRedirectReason());
            } else if (((resetPasswordPollCompletionApiResult instanceof ResetPasswordPollCompletionApiResult.ExpiredToken ? true : resetPasswordPollCompletionApiResult instanceof ResetPasswordPollCompletionApiResult.UserNotFound) ? true : resetPasswordPollCompletionApiResult instanceof ResetPasswordPollCompletionApiResult.PasswordInvalid) ? true : resetPasswordPollCompletionApiResult instanceof ResetPasswordPollCompletionApiResult.UnknownError) {
                Logger.warnWithObject((String)TAG, (String)pollCompletionApiResult.getCorrelationId(), (String)"Unexpected result: ", (ILoggable)((ILoggable)pollCompletionApiResult));
                ResetPasswordPollCompletionApiResult resetPasswordPollCompletionApiResult2 = pollCompletionApiResult;
                Intrinsics.checkNotNull((Object)resetPasswordPollCompletionApiResult2, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)resetPasswordPollCompletionApiResult2;
                resetPasswordSubmitNewPasswordCommandResult = (ResetPasswordSubmitNewPasswordCommandResult)new INativeAuthCommandResult.APIError(((ApiErrorResult)pollCompletionApiResult).getError(), ((ApiErrorResult)pollCompletionApiResult).getErrorDescription(), null, pollCompletionApiResult.getCorrelationId(), null, null, 52, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return resetPasswordSubmitNewPasswordCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)correlationId, (String)"Exception thrown in resetPasswordPollCompletion", (Throwable)e);
            throw e;
        }
    }

    @VisibleForTesting
    @NotNull
    public final SignInTokenApiResult performContinuationTokenTokenRequest(@NotNull NativeAuthOAuth2Strategy oAuth2Strategy, @NotNull SignInWithContinuationTokenCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)oAuth2Strategy, (String)"oAuth2Strategy");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".performContinuationTokenTokenRequest");
        return oAuth2Strategy.performContinuationTokenTokenRequest(parameters);
    }

    private final JITIntrospectApiResult performJITIntrospect(NativeAuthOAuth2Strategy oAuth2Strategy, BaseSignInTokenCommandParameters parameters, String continuationToken, String correlationId) {
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, correlationId, TAG + ".performJITIntrospectCall");
        JITIntrospectCommandParameters introspectParams = CommandUtil.createJITIntrospectCommandParameters(parameters, correlationId, continuationToken);
        Intrinsics.checkNotNullExpressionValue((Object)introspectParams, (String)"introspectParams");
        return oAuth2Strategy.performJITIntrospectRequest(introspectParams);
    }

    private final SignInTokenApiResult performOOBTokenRequest(NativeAuthOAuth2Strategy oAuth2Strategy, SignInSubmitCodeCommandParameters parameters) {
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".performOOBTokenRequest");
        return oAuth2Strategy.performOOBTokenRequest(parameters);
    }

    private final SignInTokenApiResult performSubmitChallengeTokenRequest(NativeAuthOAuth2Strategy oAuth2Strategy, MFASubmitChallengeCommandParameters parameters) {
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".performOOBTokenRequest");
        SignInSubmitCodeCommandParameters signInSubmitCodeCommandParameters = CommandUtil.createSignInSubmitCodeCommandParameters(parameters);
        Intrinsics.checkNotNullExpressionValue((Object)signInSubmitCodeCommandParameters, (String)"signInSubmitCodeCommandParameters");
        return oAuth2Strategy.performOOBTokenRequest(signInSubmitCodeCommandParameters);
    }

    @VisibleForTesting
    @NotNull
    public final SignInTokenApiResult performPasswordTokenCall(@NotNull NativeAuthOAuth2Strategy oAuth2Strategy, @NotNull SignInSubmitPasswordCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)oAuth2Strategy, (String)"oAuth2Strategy");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".performPasswordTokenCall");
        return oAuth2Strategy.performPasswordTokenRequest(parameters);
    }

    private final JITSubmitChallengeCommandResult completeJITFlow(JITContinueCommandParameters parameters) {
        NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
        try {
            JITSubmitChallengeCommandResult jITSubmitChallengeCommandResult;
            JITContinueApiResult result;
            JITContinueApiResult jITContinueApiResult = result = this.performJITContinueCall(oAuth2Strategy, parameters);
            if (jITContinueApiResult instanceof JITContinueApiResult.CodeIncorrect) {
                String string2 = ((JITContinueApiResult.CodeIncorrect)result).getError();
                String string3 = ((JITContinueApiResult.CodeIncorrect)result).getErrorDescription();
                List list = ((JITContinueApiResult.CodeIncorrect)result).getErrorCodes();
                String string4 = result.getCorrelationId();
                String string5 = ((JITContinueApiResult.CodeIncorrect)result).getSubError();
                jITSubmitChallengeCommandResult = (JITSubmitChallengeCommandResult)new JITCommandResult.IncorrectChallenge(string4, string2, string3, list, string5);
            } else if (jITContinueApiResult instanceof JITContinueApiResult.Redirect) {
                jITSubmitChallengeCommandResult = (JITSubmitChallengeCommandResult)new INativeAuthCommandResult.Redirect(result.getCorrelationId(), ((JITContinueApiResult.Redirect)result).getRedirectReason());
            } else {
                if (jITContinueApiResult instanceof JITContinueApiResult.Success) {
                    JITSubmitChallengeCommandResult jITSubmitChallengeCommandResult2;
                    SignInWithContinuationTokenCommandParameters signInParams = CommandUtil.createSignInWithContinuationTokenCommandParameters((BaseSignInTokenCommandParameters)parameters, result.getCorrelationId(), ((JITContinueApiResult.Success)result).getContinuationToken());
                    Intrinsics.checkNotNullExpressionValue((Object)signInParams, (String)"signInParams");
                    SignInTokenApiResult tokenApiResult = this.performContinuationTokenTokenRequest(oAuth2Strategy, signInParams);
                    if (tokenApiResult instanceof SignInTokenApiResult.Success) {
                        jITSubmitChallengeCommandResult2 = (JITSubmitChallengeCommandResult)this.saveAndReturnTokens(oAuth2Strategy, (BaseSignInTokenCommandParameters)signInParams, (SignInTokenApiResult.Success)tokenApiResult);
                    } else {
                        Logger.warnWithObject((String)TAG, (String)tokenApiResult.getCorrelationId(), (String)"An error occurred while trying to acquire token using the continuation token: ", (ILoggable)((ILoggable)tokenApiResult));
                        Intrinsics.checkNotNull((Object)tokenApiResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                        ApiErrorResult cfr_ignored_0 = (ApiErrorResult)tokenApiResult;
                        String string6 = ((ApiErrorResult)tokenApiResult).getError();
                        String string7 = ((ApiErrorResult)tokenApiResult).getErrorDescription();
                        List list = ((ApiErrorResult)tokenApiResult).getErrorCodes();
                        String string8 = tokenApiResult.getCorrelationId();
                        jITSubmitChallengeCommandResult2 = (JITSubmitChallengeCommandResult)new INativeAuthCommandResult.APIError(string6, string7, null, string8, list, null, 36, null);
                    }
                    return jITSubmitChallengeCommandResult2;
                }
                if (jITContinueApiResult instanceof JITContinueApiResult.UnknownError) {
                    Logger.warnWithObject((String)TAG, (String)"Unexpected result: ", (ILoggable)((ILoggable)result));
                    String string9 = ((JITContinueApiResult.UnknownError)result).getError();
                    String string10 = ((JITContinueApiResult.UnknownError)result).getErrorDescription();
                    List list = ((JITContinueApiResult.UnknownError)result).getErrorCodes();
                    String string11 = result.getCorrelationId();
                    jITSubmitChallengeCommandResult = (JITSubmitChallengeCommandResult)new INativeAuthCommandResult.APIError(string9, string10, null, string11, list, null, 36, null);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return jITSubmitChallengeCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signInSubmitPassword", (Throwable)e);
            throw e;
        }
    }

    private final SignInInitiateApiResult performSignInInitiateCall(NativeAuthOAuth2Strategy oAuth2Strategy, SignInStartCommandParameters parameters) {
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".performSignInInitiateCall");
        return oAuth2Strategy.performSignInInitiate(parameters);
    }

    private final SignInChallengeApiResult performSignInDefaultChallengeCall(NativeAuthOAuth2Strategy oAuth2Strategy, String continuationToken, String correlationId) {
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, correlationId, TAG + ".performSignInChallengeCall");
        return oAuth2Strategy.performSignInDefaultChallenge(continuationToken, correlationId);
    }

    private final SignInChallengeApiResult performSignInSelectedChallengeCall(NativeAuthOAuth2Strategy oAuth2Strategy, String continuationToken, String correlationId, String challengeId) {
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, correlationId, TAG + ".performSignInSelectedChallengeCall");
        return oAuth2Strategy.performSignInSelectedChallenge(continuationToken, correlationId, challengeId);
    }

    private final SignInIntrospectApiResult performIntrospectCall(NativeAuthOAuth2Strategy oAuth2Strategy, String continuationToken, String correlationId) {
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, correlationId, TAG + ".performIntrospectCall");
        return oAuth2Strategy.performIntrospect(continuationToken, correlationId);
    }

    private final JITChallengeApiResult performJITChallengeCall(NativeAuthOAuth2Strategy oAuth2Strategy, JITChallengeAuthMethodCommandParameters parameters) {
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".performJITChallengeCall");
        return oAuth2Strategy.performJITChallengeRequest(parameters);
    }

    private final JITContinueApiResult performJITContinueCall(NativeAuthOAuth2Strategy oAuth2Strategy, JITContinueCommandParameters parameters) {
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".performJITContinueCall");
        return oAuth2Strategy.performJITContinueRequest(parameters);
    }

    private final ResetPasswordStartApiResult performResetPasswordStartCall(NativeAuthOAuth2Strategy oAuth2Strategy, ResetPasswordStartCommandParameters parameters) {
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".performResetPasswordStartCall");
        return oAuth2Strategy.performResetPasswordStart(parameters);
    }

    private final ResetPasswordChallengeApiResult performResetPasswordChallengeCall(NativeAuthOAuth2Strategy oAuth2Strategy, String continuationToken, String correlationId) {
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, correlationId, TAG + ".performResetPasswordChallengeCall");
        return oAuth2Strategy.performResetPasswordChallenge(continuationToken, correlationId);
    }

    private final ResetPasswordContinueApiResult performResetPasswordContinueCall(NativeAuthOAuth2Strategy oAuth2Strategy, ResetPasswordSubmitCodeCommandParameters parameters) {
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".performResetPasswordContinueCall");
        return oAuth2Strategy.performResetPasswordContinue(parameters);
    }

    private final ResetPasswordSubmitApiResult performResetPasswordSubmitCall(NativeAuthOAuth2Strategy oAuth2Strategy, ResetPasswordSubmitNewPasswordCommandParameters parameters) {
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".performResetPasswordSubmitCall");
        return oAuth2Strategy.performResetPasswordSubmit(parameters);
    }

    private final ResetPasswordPollCompletionApiResult performResetPasswordPollCompletionCall(NativeAuthOAuth2Strategy oAuth2Strategy, String continuationToken, String correlationId) {
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, correlationId, TAG + ".performResetPasswordPollCompletionCall");
        return oAuth2Strategy.performResetPasswordPollCompletion(continuationToken, correlationId);
    }

    private final SignInCommandResult.Complete saveAndReturnTokens(NativeAuthOAuth2Strategy oAuth2Strategy, BaseSignInTokenCommandParameters parametersWithScopes, SignInTokenApiResult.Success tokenApiResult) {
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parametersWithScopes.getCorrelationId(), TAG + ".saveAndReturnTokens");
        Intrinsics.checkNotNull((Object)oAuth2Strategy, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy");
        OAuth2Strategy oAuth2Strategy2 = (OAuth2Strategy)((MicrosoftStsOAuth2Strategy)oAuth2Strategy);
        List list = parametersWithScopes.scopes;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        String string3 = parametersWithScopes.getClientId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"parametersWithScopes.clientId");
        String string4 = parametersWithScopes.getApplicationIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"parametersWithScopes.applicationIdentifier");
        List list2 = this.saveTokens(oAuth2Strategy2, (AuthorizationRequest)this.createAuthorizationRequest(oAuth2Strategy, list, string3, string4), (TokenResponse)tokenApiResult.getTokenResponse(), parametersWithScopes.getOAuth2TokenCache());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"saveTokens(\n            \u2026Auth2TokenCache\n        )");
        List records = list2;
        ICacheRecord newestRecord = (ICacheRecord)records.get(0);
        LocalAuthenticationResult localAuthenticationResult = new LocalAuthenticationResult(this.finalizeCacheRecordForResult(newestRecord, parametersWithScopes.getAuthenticationScheme()), records, SdkType.MSAL, false);
        String string5 = tokenApiResult.getCorrelationId();
        return new SignInCommandResult.Complete(string5, (ILocalAuthenticationResult)localAuthenticationResult);
    }

    private final MicrosoftStsAuthorizationRequest createAuthorizationRequest(NativeAuthOAuth2Strategy strategy, List<String> scopes, String clientId, String applicationIdentifier) {
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, null, TAG + ".createAuthorizationRequest");
        MicrosoftStsAuthorizationRequest.Builder builder = new MicrosoftStsAuthorizationRequest.Builder();
        builder.setAuthority(new URL(strategy.getAuthority()));
        builder.setClientId(clientId);
        builder.setScope(StringUtil.join((CharSequence)" ", (Iterable)scopes));
        builder.setApplicationIdentifier(applicationIdentifier);
        MicrosoftStsAuthorizationRequest microsoftStsAuthorizationRequest = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)microsoftStsAuthorizationRequest, (String)"builder.build()");
        return microsoftStsAuthorizationRequest;
    }

    private final List<String> addDefaultScopes(List<String> scopes) {
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, null, TAG + ".createAuthorizationRequest");
        List list = scopes;
        if (list == null || (list = CollectionsKt.toMutableList((Collection)list)) == null) {
            list = new ArrayList();
        }
        List requestScopes = list;
        Set set = AuthenticationConstants.DEFAULT_SCOPES;
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"DEFAULT_SCOPES");
        requestScopes.addAll(set);
        Collection collection = requestScopes;
        Object object = new String[]{"", null};
        object = CollectionsKt.listOf((Object[])object);
        TypeIntrinsics.asMutableCollection((Object)collection).removeAll((Collection<?>)object);
        return CollectionsKt.toList((Iterable)requestScopes);
    }

    private final ResetPasswordStartCommandResult toResetPasswordStartCommandResult(ResetPasswordChallengeApiResult $this$toResetPasswordStartCommandResult) {
        ResetPasswordStartCommandResult resetPasswordStartCommandResult;
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, $this$toResetPasswordStartCommandResult.getCorrelationId(), TAG + ".createAuthorizationRequest");
        ResetPasswordChallengeApiResult resetPasswordChallengeApiResult = $this$toResetPasswordStartCommandResult;
        if (resetPasswordChallengeApiResult instanceof ResetPasswordChallengeApiResult.CodeRequired) {
            String string3 = ((ResetPasswordChallengeApiResult.CodeRequired)$this$toResetPasswordStartCommandResult).getContinuationToken();
            int n = ((ResetPasswordChallengeApiResult.CodeRequired)$this$toResetPasswordStartCommandResult).getCodeLength();
            String string4 = ((ResetPasswordChallengeApiResult.CodeRequired)$this$toResetPasswordStartCommandResult).getChallengeTargetLabel();
            String string5 = ((ResetPasswordChallengeApiResult.CodeRequired)$this$toResetPasswordStartCommandResult).getChallengeChannel();
            String string6 = $this$toResetPasswordStartCommandResult.getCorrelationId();
            resetPasswordStartCommandResult = (ResetPasswordStartCommandResult)new ResetPasswordCommandResult.CodeRequired(string6, string3, n, string4, string5);
        } else if (resetPasswordChallengeApiResult instanceof ResetPasswordChallengeApiResult.Redirect) {
            resetPasswordStartCommandResult = (ResetPasswordStartCommandResult)new INativeAuthCommandResult.Redirect($this$toResetPasswordStartCommandResult.getCorrelationId(), ((ResetPasswordChallengeApiResult.Redirect)$this$toResetPasswordStartCommandResult).getRedirectReason());
        } else if (resetPasswordChallengeApiResult instanceof ResetPasswordChallengeApiResult.ExpiredToken) {
            Logger.warnWithObject((String)TAG, (String)$this$toResetPasswordStartCommandResult.getCorrelationId(), (String)"Expire token result: ", (ILoggable)((ILoggable)$this$toResetPasswordStartCommandResult));
            resetPasswordStartCommandResult = (ResetPasswordStartCommandResult)new INativeAuthCommandResult.APIError(((ResetPasswordChallengeApiResult.ExpiredToken)$this$toResetPasswordStartCommandResult).getError(), ((ResetPasswordChallengeApiResult.ExpiredToken)$this$toResetPasswordStartCommandResult).getErrorDescription(), null, $this$toResetPasswordStartCommandResult.getCorrelationId(), null, null, 52, null);
        } else if (resetPasswordChallengeApiResult instanceof ResetPasswordChallengeApiResult.UnsupportedChallengeType) {
            Logger.warnWithObject((String)TAG, (String)$this$toResetPasswordStartCommandResult.getCorrelationId(), (String)"Unsupported challenge type: ", (ILoggable)((ILoggable)$this$toResetPasswordStartCommandResult));
            resetPasswordStartCommandResult = (ResetPasswordStartCommandResult)new INativeAuthCommandResult.APIError(((ResetPasswordChallengeApiResult.UnsupportedChallengeType)$this$toResetPasswordStartCommandResult).getError(), ((ResetPasswordChallengeApiResult.UnsupportedChallengeType)$this$toResetPasswordStartCommandResult).getErrorDescription(), null, $this$toResetPasswordStartCommandResult.getCorrelationId(), null, null, 52, null);
        } else if (resetPasswordChallengeApiResult instanceof ResetPasswordChallengeApiResult.UnknownError) {
            Logger.warnWithObject((String)TAG, (String)$this$toResetPasswordStartCommandResult.getCorrelationId(), (String)"Unexpected result: ", (ILoggable)((ILoggable)$this$toResetPasswordStartCommandResult));
            resetPasswordStartCommandResult = (ResetPasswordStartCommandResult)new INativeAuthCommandResult.APIError(((ResetPasswordChallengeApiResult.UnknownError)$this$toResetPasswordStartCommandResult).getError(), ((ResetPasswordChallengeApiResult.UnknownError)$this$toResetPasswordStartCommandResult).getErrorDescription(), null, $this$toResetPasswordStartCommandResult.getCorrelationId(), null, null, 52, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return resetPasswordStartCommandResult;
    }

    @VisibleForTesting
    @NotNull
    public final SignUpStartApiResult performSignUpStartUsingPasswordRequest(@NotNull NativeAuthOAuth2Strategy oAuth2Strategy, @NotNull SignUpStartCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)oAuth2Strategy, (String)"oAuth2Strategy");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".performSignUpStartUsingPasswordRequest");
        return oAuth2Strategy.performSignUpStart(parameters);
    }

    private final SignUpChallengeApiResult performSignUpChallengeCall(NativeAuthOAuth2Strategy oAuth2Strategy, String continuationToken, String correlationId) {
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, correlationId, TAG + ".performSignUpChallengeCall");
        return oAuth2Strategy.performSignUpChallenge(continuationToken, correlationId);
    }

    private final SignUpContinueApiResult performSignUpSubmitCode(NativeAuthOAuth2Strategy oAuth2Strategy, SignUpSubmitCodeCommandParameters parameters) {
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".performSignUpSubmitCode");
        return oAuth2Strategy.performSignUpSubmitCode(parameters);
    }

    private final SignUpContinueApiResult performSignUpSubmitPassword(NativeAuthOAuth2Strategy oAuth2Strategy, SignUpSubmitPasswordCommandParameters parameters) {
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".performSignUpSubmitPassword");
        return oAuth2Strategy.performSignUpSubmitPassword(parameters);
    }

    @VisibleForTesting
    @NotNull
    public final SignUpContinueApiResult performSignUpSubmitUserAttributes(@NotNull NativeAuthOAuth2Strategy oAuth2Strategy, @NotNull SignUpSubmitUserAttributesCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)oAuth2Strategy, (String)"oAuth2Strategy");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, parameters.getCorrelationId(), TAG + ".performSignUpSubmitUserAttributes");
        return oAuth2Strategy.performSignUpSubmitUserAttributes(parameters);
    }

    private final JITChallengeAuthMethodCommandResult toJITChallengeAuthMethodCommandResult(JITSubmitChallengeCommandResult $this$toJITChallengeAuthMethodCommandResult) {
        JITChallengeAuthMethodCommandResult jITChallengeAuthMethodCommandResult;
        JITSubmitChallengeCommandResult jITSubmitChallengeCommandResult = $this$toJITChallengeAuthMethodCommandResult;
        if (jITSubmitChallengeCommandResult instanceof JITCommandResult.IncorrectChallenge) {
            String string2 = ((JITCommandResult.IncorrectChallenge)$this$toJITChallengeAuthMethodCommandResult).getError();
            String string3 = ((JITCommandResult.IncorrectChallenge)$this$toJITChallengeAuthMethodCommandResult).getErrorDescription();
            List list = ((JITCommandResult.IncorrectChallenge)$this$toJITChallengeAuthMethodCommandResult).getErrorCodes();
            String string4 = $this$toJITChallengeAuthMethodCommandResult.getCorrelationId();
            jITChallengeAuthMethodCommandResult = (JITChallengeAuthMethodCommandResult)new INativeAuthCommandResult.APIError(string2, string3, null, string4, list, null, 36, null);
        } else if (jITSubmitChallengeCommandResult instanceof INativeAuthCommandResult.Redirect) {
            jITChallengeAuthMethodCommandResult = (JITChallengeAuthMethodCommandResult)$this$toJITChallengeAuthMethodCommandResult;
        } else if (jITSubmitChallengeCommandResult instanceof INativeAuthCommandResult.APIError) {
            jITChallengeAuthMethodCommandResult = (JITChallengeAuthMethodCommandResult)$this$toJITChallengeAuthMethodCommandResult;
        } else if (jITSubmitChallengeCommandResult instanceof SignInCommandResult.Complete) {
            jITChallengeAuthMethodCommandResult = (JITChallengeAuthMethodCommandResult)$this$toJITChallengeAuthMethodCommandResult;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jITChallengeAuthMethodCommandResult;
    }

    private final SignUpSubmitUserAttributesCommandResult toSignUpSubmitUserAttrsCommandResult(SignUpChallengeApiResult $this$toSignUpSubmitUserAttrsCommandResult) {
        SignUpSubmitUserAttributesCommandResult signUpSubmitUserAttributesCommandResult;
        SignUpChallengeApiResult signUpChallengeApiResult = $this$toSignUpSubmitUserAttrsCommandResult;
        if (signUpChallengeApiResult instanceof SignUpChallengeApiResult.Redirect) {
            signUpSubmitUserAttributesCommandResult = (SignUpSubmitUserAttributesCommandResult)new INativeAuthCommandResult.Redirect($this$toSignUpSubmitUserAttrsCommandResult.getCorrelationId(), ((SignUpChallengeApiResult.Redirect)$this$toSignUpSubmitUserAttrsCommandResult).getRedirectReason());
        } else if ((((signUpChallengeApiResult instanceof SignUpChallengeApiResult.ExpiredToken ? true : signUpChallengeApiResult instanceof SignUpChallengeApiResult.UnsupportedChallengeType) ? true : signUpChallengeApiResult instanceof SignUpChallengeApiResult.OOBRequired) ? true : signUpChallengeApiResult instanceof SignUpChallengeApiResult.PasswordRequired) ? true : signUpChallengeApiResult instanceof SignUpChallengeApiResult.UnknownError) {
            Logger.warnWithObject((String)TAG, (String)$this$toSignUpSubmitUserAttrsCommandResult.getCorrelationId(), (String)"Unexpected result: ", (ILoggable)((ILoggable)$this$toSignUpSubmitUserAttrsCommandResult));
            Intrinsics.checkNotNull((Object)$this$toSignUpSubmitUserAttrsCommandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
            ApiErrorResult cfr_ignored_0 = (ApiErrorResult)$this$toSignUpSubmitUserAttrsCommandResult;
            signUpSubmitUserAttributesCommandResult = (SignUpSubmitUserAttributesCommandResult)new INativeAuthCommandResult.APIError(((ApiErrorResult)$this$toSignUpSubmitUserAttrsCommandResult).getError(), ((ApiErrorResult)$this$toSignUpSubmitUserAttrsCommandResult).getErrorDescription(), null, $this$toSignUpSubmitUserAttrsCommandResult.getCorrelationId(), null, null, 52, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return signUpSubmitUserAttributesCommandResult;
    }

    private final SignUpStartCommandResult toSignUpStartCommandResult(SignUpChallengeApiResult $this$toSignUpStartCommandResult) {
        SignUpStartCommandResult signUpStartCommandResult;
        SignUpChallengeApiResult signUpChallengeApiResult = $this$toSignUpStartCommandResult;
        if (signUpChallengeApiResult instanceof SignUpChallengeApiResult.OOBRequired) {
            String string2 = ((SignUpChallengeApiResult.OOBRequired)$this$toSignUpStartCommandResult).getContinuationToken();
            int n = ((SignUpChallengeApiResult.OOBRequired)$this$toSignUpStartCommandResult).getCodeLength();
            String string3 = ((SignUpChallengeApiResult.OOBRequired)$this$toSignUpStartCommandResult).getChallengeTargetLabel();
            String string4 = ((SignUpChallengeApiResult.OOBRequired)$this$toSignUpStartCommandResult).getChallengeChannel();
            String string5 = $this$toSignUpStartCommandResult.getCorrelationId();
            signUpStartCommandResult = (SignUpStartCommandResult)new SignUpCommandResult.CodeRequired(string5, string2, string3, string4, n);
        } else if (signUpChallengeApiResult instanceof SignUpChallengeApiResult.PasswordRequired) {
            String string6 = ((SignUpChallengeApiResult.PasswordRequired)$this$toSignUpStartCommandResult).getContinuationToken();
            String string7 = $this$toSignUpStartCommandResult.getCorrelationId();
            signUpStartCommandResult = (SignUpStartCommandResult)new SignUpCommandResult.PasswordRequired(string7, string6);
        } else if (signUpChallengeApiResult instanceof SignUpChallengeApiResult.Redirect) {
            signUpStartCommandResult = (SignUpStartCommandResult)new INativeAuthCommandResult.Redirect($this$toSignUpStartCommandResult.getCorrelationId(), ((SignUpChallengeApiResult.Redirect)$this$toSignUpStartCommandResult).getRedirectReason());
        } else if ((signUpChallengeApiResult instanceof SignUpChallengeApiResult.ExpiredToken ? true : signUpChallengeApiResult instanceof SignUpChallengeApiResult.UnsupportedChallengeType) ? true : signUpChallengeApiResult instanceof SignUpChallengeApiResult.UnknownError) {
            Logger.warnWithObject((String)TAG, (String)$this$toSignUpStartCommandResult.getCorrelationId(), (String)"Unexpected result: ", (ILoggable)((ILoggable)$this$toSignUpStartCommandResult));
            Intrinsics.checkNotNull((Object)$this$toSignUpStartCommandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
            ApiErrorResult cfr_ignored_0 = (ApiErrorResult)$this$toSignUpStartCommandResult;
            signUpStartCommandResult = (SignUpStartCommandResult)new INativeAuthCommandResult.APIError(((ApiErrorResult)$this$toSignUpStartCommandResult).getError(), ((ApiErrorResult)$this$toSignUpStartCommandResult).getErrorDescription(), null, $this$toSignUpStartCommandResult.getCorrelationId(), null, null, 52, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return signUpStartCommandResult;
    }

    private final SignUpSubmitCodeCommandResult toSignUpSubmitCodeCommandResult(SignUpContinueApiResult $this$toSignUpSubmitCodeCommandResult, NativeAuthOAuth2Strategy oAuth2Strategy) {
        SignUpSubmitCodeCommandResult signUpSubmitCodeCommandResult;
        SignUpContinueApiResult signUpContinueApiResult = $this$toSignUpSubmitCodeCommandResult;
        if (signUpContinueApiResult instanceof SignUpContinueApiResult.Success) {
            String string2 = ((SignUpContinueApiResult.Success)$this$toSignUpSubmitCodeCommandResult).getContinuationToken();
            Integer n = ((SignUpContinueApiResult.Success)$this$toSignUpSubmitCodeCommandResult).getExpiresIn();
            String string3 = $this$toSignUpSubmitCodeCommandResult.getCorrelationId();
            signUpSubmitCodeCommandResult = (SignUpSubmitCodeCommandResult)new SignUpCommandResult.Complete(string3, string2, n);
        } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.ExpiredToken) {
            Logger.warnWithObject((String)TAG, (String)$this$toSignUpSubmitCodeCommandResult.getCorrelationId(), (String)"Expire token result: ", (ILoggable)((ILoggable)$this$toSignUpSubmitCodeCommandResult));
            signUpSubmitCodeCommandResult = (SignUpSubmitCodeCommandResult)new INativeAuthCommandResult.APIError(((SignUpContinueApiResult.ExpiredToken)$this$toSignUpSubmitCodeCommandResult).getError(), ((SignUpContinueApiResult.ExpiredToken)$this$toSignUpSubmitCodeCommandResult).getErrorDescription(), null, $this$toSignUpSubmitCodeCommandResult.getCorrelationId(), null, null, 52, null);
        } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.UsernameAlreadyExists) {
            String string4 = ((SignUpContinueApiResult.UsernameAlreadyExists)$this$toSignUpSubmitCodeCommandResult).getError();
            String string5 = ((SignUpContinueApiResult.UsernameAlreadyExists)$this$toSignUpSubmitCodeCommandResult).getErrorDescription();
            String string6 = $this$toSignUpSubmitCodeCommandResult.getCorrelationId();
            signUpSubmitCodeCommandResult = (SignUpSubmitCodeCommandResult)new SignUpCommandResult.UsernameAlreadyExists(string6, string4, string5);
        } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.AttributesRequired) {
            String string7 = ((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitCodeCommandResult).getContinuationToken();
            String string8 = ((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitCodeCommandResult).getError();
            String string9 = ((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitCodeCommandResult).getErrorDescription();
            List list = ((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitCodeCommandResult).getRequiredAttributes();
            String string10 = $this$toSignUpSubmitCodeCommandResult.getCorrelationId();
            signUpSubmitCodeCommandResult = (SignUpSubmitCodeCommandResult)new SignUpCommandResult.AttributesRequired(string10, string7, string8, string9, list);
        } else {
            if (signUpContinueApiResult instanceof SignUpContinueApiResult.CredentialRequired) {
                SignUpStartCommandResult signUpStartCommandResult = this.toSignUpStartCommandResult(this.performSignUpChallengeCall(oAuth2Strategy, ((SignUpContinueApiResult.CredentialRequired)$this$toSignUpSubmitCodeCommandResult).getContinuationToken(), $this$toSignUpSubmitCodeCommandResult.getCorrelationId()));
                Intrinsics.checkNotNull((Object)signUpStartCommandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.controllers.results.SignUpSubmitCodeCommandResult");
                return (SignUpSubmitCodeCommandResult)signUpStartCommandResult;
            }
            if (signUpContinueApiResult instanceof SignUpContinueApiResult.InvalidOOBValue) {
                String string11 = ((SignUpContinueApiResult.InvalidOOBValue)$this$toSignUpSubmitCodeCommandResult).getError();
                String string12 = ((SignUpContinueApiResult.InvalidOOBValue)$this$toSignUpSubmitCodeCommandResult).getErrorDescription();
                String string13 = ((SignUpContinueApiResult.InvalidOOBValue)$this$toSignUpSubmitCodeCommandResult).getSubError();
                String string14 = $this$toSignUpSubmitCodeCommandResult.getCorrelationId();
                signUpSubmitCodeCommandResult = (SignUpSubmitCodeCommandResult)new SignUpCommandResult.InvalidCode(string14, string11, string12, string13);
            } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.Redirect) {
                signUpSubmitCodeCommandResult = (SignUpSubmitCodeCommandResult)new INativeAuthCommandResult.Redirect($this$toSignUpSubmitCodeCommandResult.getCorrelationId(), ((SignUpContinueApiResult.Redirect)$this$toSignUpSubmitCodeCommandResult).getRedirectReason());
            } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.UnknownError) {
                Logger.warnWithObject((String)TAG, (String)$this$toSignUpSubmitCodeCommandResult.getCorrelationId(), (String)"Unexpected result: ", (ILoggable)((ILoggable)$this$toSignUpSubmitCodeCommandResult));
                signUpSubmitCodeCommandResult = (SignUpSubmitCodeCommandResult)new INativeAuthCommandResult.APIError(((SignUpContinueApiResult.UnknownError)$this$toSignUpSubmitCodeCommandResult).getError(), ((SignUpContinueApiResult.UnknownError)$this$toSignUpSubmitCodeCommandResult).getErrorDescription(), null, $this$toSignUpSubmitCodeCommandResult.getCorrelationId(), null, null, 52, null);
            } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.InvalidAttributes ? true : signUpContinueApiResult instanceof SignUpContinueApiResult.InvalidPassword) {
                Logger.warnWithObject((String)TAG, (String)$this$toSignUpSubmitCodeCommandResult.getCorrelationId(), (String)"Unexpected result: ", (ILoggable)((ILoggable)$this$toSignUpSubmitCodeCommandResult));
                Intrinsics.checkNotNull((Object)$this$toSignUpSubmitCodeCommandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)$this$toSignUpSubmitCodeCommandResult;
                signUpSubmitCodeCommandResult = (SignUpSubmitCodeCommandResult)new INativeAuthCommandResult.APIError(((ApiErrorResult)$this$toSignUpSubmitCodeCommandResult).getError(), ((ApiErrorResult)$this$toSignUpSubmitCodeCommandResult).getErrorDescription(), null, $this$toSignUpSubmitCodeCommandResult.getCorrelationId(), null, null, 52, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return signUpSubmitCodeCommandResult;
    }

    private final SignUpSubmitUserAttributesCommandResult toSignUpSubmitUserAttributesCommandResult(SignUpContinueApiResult $this$toSignUpSubmitUserAttributesCommandResult, NativeAuthOAuth2Strategy oAuth2Strategy) {
        SignUpSubmitUserAttributesCommandResult signUpSubmitUserAttributesCommandResult;
        SignUpContinueApiResult signUpContinueApiResult = $this$toSignUpSubmitUserAttributesCommandResult;
        if (signUpContinueApiResult instanceof SignUpContinueApiResult.Success) {
            String string2 = ((SignUpContinueApiResult.Success)$this$toSignUpSubmitUserAttributesCommandResult).getContinuationToken();
            Integer n = ((SignUpContinueApiResult.Success)$this$toSignUpSubmitUserAttributesCommandResult).getExpiresIn();
            String string3 = $this$toSignUpSubmitUserAttributesCommandResult.getCorrelationId();
            signUpSubmitUserAttributesCommandResult = (SignUpSubmitUserAttributesCommandResult)new SignUpCommandResult.Complete(string3, string2, n);
        } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.UsernameAlreadyExists) {
            String string4 = ((SignUpContinueApiResult.UsernameAlreadyExists)$this$toSignUpSubmitUserAttributesCommandResult).getError();
            String string5 = ((SignUpContinueApiResult.UsernameAlreadyExists)$this$toSignUpSubmitUserAttributesCommandResult).getErrorDescription();
            String string6 = $this$toSignUpSubmitUserAttributesCommandResult.getCorrelationId();
            signUpSubmitUserAttributesCommandResult = (SignUpSubmitUserAttributesCommandResult)new SignUpCommandResult.UsernameAlreadyExists(string6, string4, string5);
        } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.AttributesRequired) {
            String string7 = ((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitUserAttributesCommandResult).getContinuationToken();
            String string8 = ((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitUserAttributesCommandResult).getError();
            String string9 = ((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitUserAttributesCommandResult).getErrorDescription();
            List list = ((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitUserAttributesCommandResult).getRequiredAttributes();
            String string10 = $this$toSignUpSubmitUserAttributesCommandResult.getCorrelationId();
            signUpSubmitUserAttributesCommandResult = (SignUpSubmitUserAttributesCommandResult)new SignUpCommandResult.AttributesRequired(string10, string7, string8, string9, list);
        } else {
            if (signUpContinueApiResult instanceof SignUpContinueApiResult.CredentialRequired) {
                return this.toSignUpSubmitUserAttrsCommandResult(this.performSignUpChallengeCall(oAuth2Strategy, ((SignUpContinueApiResult.CredentialRequired)$this$toSignUpSubmitUserAttributesCommandResult).getContinuationToken(), $this$toSignUpSubmitUserAttributesCommandResult.getCorrelationId()));
            }
            if (signUpContinueApiResult instanceof SignUpContinueApiResult.Redirect) {
                signUpSubmitUserAttributesCommandResult = (SignUpSubmitUserAttributesCommandResult)new INativeAuthCommandResult.Redirect($this$toSignUpSubmitUserAttributesCommandResult.getCorrelationId(), ((SignUpContinueApiResult.Redirect)$this$toSignUpSubmitUserAttributesCommandResult).getRedirectReason());
            } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.InvalidAttributes) {
                String string11 = ((SignUpContinueApiResult.InvalidAttributes)$this$toSignUpSubmitUserAttributesCommandResult).getError();
                String string12 = ((SignUpContinueApiResult.InvalidAttributes)$this$toSignUpSubmitUserAttributesCommandResult).getErrorDescription();
                List list = ((SignUpContinueApiResult.InvalidAttributes)$this$toSignUpSubmitUserAttributesCommandResult).getInvalidAttributes();
                String string13 = $this$toSignUpSubmitUserAttributesCommandResult.getCorrelationId();
                signUpSubmitUserAttributesCommandResult = (SignUpSubmitUserAttributesCommandResult)new SignUpCommandResult.InvalidAttributes(string13, string11, string12, list);
            } else if (((signUpContinueApiResult instanceof SignUpContinueApiResult.InvalidOOBValue ? true : signUpContinueApiResult instanceof SignUpContinueApiResult.InvalidPassword) ? true : signUpContinueApiResult instanceof SignUpContinueApiResult.ExpiredToken) ? true : signUpContinueApiResult instanceof SignUpContinueApiResult.UnknownError) {
                Logger.warnWithObject((String)TAG, (String)$this$toSignUpSubmitUserAttributesCommandResult.getCorrelationId(), (String)"Expire token result: ", (ILoggable)((ILoggable)$this$toSignUpSubmitUserAttributesCommandResult));
                Intrinsics.checkNotNull((Object)$this$toSignUpSubmitUserAttributesCommandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)$this$toSignUpSubmitUserAttributesCommandResult;
                signUpSubmitUserAttributesCommandResult = (SignUpSubmitUserAttributesCommandResult)new INativeAuthCommandResult.APIError(((ApiErrorResult)$this$toSignUpSubmitUserAttributesCommandResult).getError(), ((ApiErrorResult)$this$toSignUpSubmitUserAttributesCommandResult).getErrorDescription(), null, $this$toSignUpSubmitUserAttributesCommandResult.getCorrelationId(), null, null, 52, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return signUpSubmitUserAttributesCommandResult;
    }

    private final SignUpSubmitPasswordCommandResult toSignUpSubmitPasswordCommandResult(SignUpContinueApiResult $this$toSignUpSubmitPasswordCommandResult, NativeAuthOAuth2Strategy oAuth2Strategy) {
        SignUpSubmitPasswordCommandResult signUpSubmitPasswordCommandResult;
        SignUpContinueApiResult signUpContinueApiResult = $this$toSignUpSubmitPasswordCommandResult;
        if (signUpContinueApiResult instanceof SignUpContinueApiResult.Success) {
            String string2 = ((SignUpContinueApiResult.Success)$this$toSignUpSubmitPasswordCommandResult).getContinuationToken();
            Integer n = ((SignUpContinueApiResult.Success)$this$toSignUpSubmitPasswordCommandResult).getExpiresIn();
            String string3 = $this$toSignUpSubmitPasswordCommandResult.getCorrelationId();
            signUpSubmitPasswordCommandResult = (SignUpSubmitPasswordCommandResult)new SignUpCommandResult.Complete(string3, string2, n);
        } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.UsernameAlreadyExists) {
            String string4 = ((SignUpContinueApiResult.UsernameAlreadyExists)$this$toSignUpSubmitPasswordCommandResult).getError();
            String string5 = ((SignUpContinueApiResult.UsernameAlreadyExists)$this$toSignUpSubmitPasswordCommandResult).getErrorDescription();
            String string6 = $this$toSignUpSubmitPasswordCommandResult.getCorrelationId();
            signUpSubmitPasswordCommandResult = (SignUpSubmitPasswordCommandResult)new SignUpCommandResult.UsernameAlreadyExists(string6, string4, string5);
        } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.AttributesRequired) {
            String string7 = ((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitPasswordCommandResult).getContinuationToken();
            String string8 = ((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitPasswordCommandResult).getError();
            String string9 = ((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitPasswordCommandResult).getErrorDescription();
            List list = ((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitPasswordCommandResult).getRequiredAttributes();
            String string10 = $this$toSignUpSubmitPasswordCommandResult.getCorrelationId();
            signUpSubmitPasswordCommandResult = (SignUpSubmitPasswordCommandResult)new SignUpCommandResult.AttributesRequired(string10, string7, string8, string9, list);
        } else {
            if (signUpContinueApiResult instanceof SignUpContinueApiResult.CredentialRequired) {
                SignUpStartCommandResult signUpStartCommandResult = this.toSignUpStartCommandResult(this.performSignUpChallengeCall(oAuth2Strategy, ((SignUpContinueApiResult.CredentialRequired)$this$toSignUpSubmitPasswordCommandResult).getContinuationToken(), $this$toSignUpSubmitPasswordCommandResult.getCorrelationId()));
                Intrinsics.checkNotNull((Object)signUpStartCommandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.controllers.results.SignUpSubmitPasswordCommandResult");
                return (SignUpSubmitPasswordCommandResult)signUpStartCommandResult;
            }
            if (signUpContinueApiResult instanceof SignUpContinueApiResult.InvalidPassword) {
                String string11 = ((SignUpContinueApiResult.InvalidPassword)$this$toSignUpSubmitPasswordCommandResult).getError();
                String string12 = ((SignUpContinueApiResult.InvalidPassword)$this$toSignUpSubmitPasswordCommandResult).getErrorDescription();
                String string13 = ((SignUpContinueApiResult.InvalidPassword)$this$toSignUpSubmitPasswordCommandResult).getSubError();
                String string14 = $this$toSignUpSubmitPasswordCommandResult.getCorrelationId();
                signUpSubmitPasswordCommandResult = (SignUpSubmitPasswordCommandResult)new SignUpCommandResult.InvalidPassword(string14, string11, string12, string13);
            } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.Redirect) {
                signUpSubmitPasswordCommandResult = (SignUpSubmitPasswordCommandResult)new INativeAuthCommandResult.Redirect($this$toSignUpSubmitPasswordCommandResult.getCorrelationId(), ((SignUpContinueApiResult.Redirect)$this$toSignUpSubmitPasswordCommandResult).getRedirectReason());
            } else if (((signUpContinueApiResult instanceof SignUpContinueApiResult.ExpiredToken ? true : signUpContinueApiResult instanceof SignUpContinueApiResult.InvalidOOBValue) ? true : signUpContinueApiResult instanceof SignUpContinueApiResult.InvalidAttributes) ? true : signUpContinueApiResult instanceof SignUpContinueApiResult.UnknownError) {
                Logger.warnWithObject((String)TAG, (String)$this$toSignUpSubmitPasswordCommandResult.getCorrelationId(), (String)"Error in signup continue result: ", (ILoggable)((ILoggable)$this$toSignUpSubmitPasswordCommandResult));
                Intrinsics.checkNotNull((Object)$this$toSignUpSubmitPasswordCommandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)$this$toSignUpSubmitPasswordCommandResult;
                signUpSubmitPasswordCommandResult = (SignUpSubmitPasswordCommandResult)new INativeAuthCommandResult.APIError(((ApiErrorResult)$this$toSignUpSubmitPasswordCommandResult).getError(), ((ApiErrorResult)$this$toSignUpSubmitPasswordCommandResult).getErrorDescription(), null, $this$toSignUpSubmitPasswordCommandResult.getCorrelationId(), null, null, 52, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return signUpSubmitPasswordCommandResult;
    }

    private final SignInStartCommandResult toSignInStartCommandResult(JITIntrospectApiResult $this$toSignInStartCommandResult) {
        SignInStartCommandResult signInStartCommandResult;
        JITIntrospectApiResult jITIntrospectApiResult = $this$toSignInStartCommandResult;
        if (jITIntrospectApiResult instanceof JITIntrospectApiResult.Success) {
            String string2 = ((JITIntrospectApiResult.Success)$this$toSignInStartCommandResult).getContinuationToken();
            List list = ((JITIntrospectApiResult.Success)$this$toSignInStartCommandResult).getMethods();
            String string3 = $this$toSignInStartCommandResult.getCorrelationId();
            signInStartCommandResult = (SignInStartCommandResult)new SignInCommandResult.StrongAuthMethodRegistrationRequired(string3, string2, list);
        } else if (jITIntrospectApiResult instanceof JITIntrospectApiResult.Redirect) {
            signInStartCommandResult = (SignInStartCommandResult)new INativeAuthCommandResult.Redirect($this$toSignInStartCommandResult.getCorrelationId(), ((JITIntrospectApiResult.Redirect)$this$toSignInStartCommandResult).getRedirectReason());
        } else if (jITIntrospectApiResult instanceof JITIntrospectApiResult.UnknownError) {
            Logger.warnWithObject((String)TAG, (String)$this$toSignInStartCommandResult.getCorrelationId(), (String)"Unexpected result: ", (ILoggable)((ILoggable)$this$toSignInStartCommandResult));
            signInStartCommandResult = (SignInStartCommandResult)new INativeAuthCommandResult.APIError(((JITIntrospectApiResult.UnknownError)$this$toSignInStartCommandResult).getError(), ((JITIntrospectApiResult.UnknownError)$this$toSignInStartCommandResult).getErrorDescription(), null, $this$toSignInStartCommandResult.getCorrelationId(), null, null, 52, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return signInStartCommandResult;
    }

    private final SignInStartCommandResult toSignInStartCommandResult(SignInTokenApiResult $this$toSignInStartCommandResult, NativeAuthOAuth2Strategy oAuth2Strategy, SignInStartCommandParameters parametersWithScopes) {
        SignInStartCommandResult signInStartCommandResult;
        SignInTokenApiResult signInTokenApiResult = $this$toSignInStartCommandResult;
        if (signInTokenApiResult instanceof SignInTokenApiResult.InvalidCredentials) {
            String string2 = ((SignInTokenApiResult.InvalidCredentials)$this$toSignInStartCommandResult).getError();
            String string3 = ((SignInTokenApiResult.InvalidCredentials)$this$toSignInStartCommandResult).getErrorDescription();
            List list = ((SignInTokenApiResult.InvalidCredentials)$this$toSignInStartCommandResult).getErrorCodes();
            String string4 = $this$toSignInStartCommandResult.getCorrelationId();
            signInStartCommandResult = (SignInStartCommandResult)new SignInCommandResult.InvalidCredentials(string4, string2, string3, list);
        } else if (signInTokenApiResult instanceof SignInTokenApiResult.Success) {
            signInStartCommandResult = (SignInStartCommandResult)this.saveAndReturnTokens(oAuth2Strategy, (BaseSignInTokenCommandParameters)parametersWithScopes, (SignInTokenApiResult.Success)$this$toSignInStartCommandResult);
        } else if (signInTokenApiResult instanceof SignInTokenApiResult.MFARequired) {
            String string5 = ((SignInTokenApiResult.MFARequired)$this$toSignInStartCommandResult).getError();
            String string6 = ((SignInTokenApiResult.MFARequired)$this$toSignInStartCommandResult).getErrorDescription();
            String string7 = ((SignInTokenApiResult.MFARequired)$this$toSignInStartCommandResult).getContinuationToken();
            String string8 = ((SignInTokenApiResult.MFARequired)$this$toSignInStartCommandResult).getSubError();
            List list = ((SignInTokenApiResult.MFARequired)$this$toSignInStartCommandResult).getErrorCodes();
            String string9 = $this$toSignInStartCommandResult.getCorrelationId();
            signInStartCommandResult = (SignInStartCommandResult)new SignInCommandResult.MFARequired(string9, string7, string5, string6, list, string8);
        } else if (signInTokenApiResult instanceof SignInTokenApiResult.JITRequired) {
            signInStartCommandResult = this.toSignInStartCommandResult(this.performJITIntrospect(oAuth2Strategy, (BaseSignInTokenCommandParameters)parametersWithScopes, ((SignInTokenApiResult.JITRequired)$this$toSignInStartCommandResult).getContinuationToken(), $this$toSignInStartCommandResult.getCorrelationId()));
        } else if (signInTokenApiResult instanceof SignInTokenApiResult.Redirect) {
            signInStartCommandResult = (SignInStartCommandResult)new INativeAuthCommandResult.Redirect($this$toSignInStartCommandResult.getCorrelationId(), ((SignInTokenApiResult.Redirect)$this$toSignInStartCommandResult).getRedirectReason());
        } else if (((signInTokenApiResult instanceof SignInTokenApiResult.CodeIncorrect ? true : signInTokenApiResult instanceof SignInTokenApiResult.InvalidAuthenticationType) ? true : signInTokenApiResult instanceof SignInTokenApiResult.UserNotFound) ? true : signInTokenApiResult instanceof SignInTokenApiResult.UnknownError) {
            Logger.warnWithObject((String)TAG, (String)$this$toSignInStartCommandResult.getCorrelationId(), (String)"Unexpected result: ", (ILoggable)((ILoggable)$this$toSignInStartCommandResult));
            Intrinsics.checkNotNull((Object)$this$toSignInStartCommandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
            ApiErrorResult cfr_ignored_0 = (ApiErrorResult)$this$toSignInStartCommandResult;
            String string10 = ((ApiErrorResult)$this$toSignInStartCommandResult).getError();
            String string11 = ((ApiErrorResult)$this$toSignInStartCommandResult).getErrorDescription();
            List list = ((ApiErrorResult)$this$toSignInStartCommandResult).getErrorCodes();
            String string12 = $this$toSignInStartCommandResult.getCorrelationId();
            signInStartCommandResult = (SignInStartCommandResult)new INativeAuthCommandResult.APIError(string10, string11, null, string12, list, null, 36, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return signInStartCommandResult;
    }

    private final SignInSubmitPasswordCommandResult toSignInSubmitPasswordCommandResult(SignInTokenApiResult $this$toSignInSubmitPasswordCommandResult, NativeAuthOAuth2Strategy oAuth2Strategy, SignInSubmitPasswordCommandParameters parametersWithScopes) {
        SignInSubmitPasswordCommandResult signInSubmitPasswordCommandResult;
        SignInTokenApiResult signInTokenApiResult = $this$toSignInSubmitPasswordCommandResult;
        if (signInTokenApiResult instanceof SignInTokenApiResult.InvalidCredentials) {
            String string2 = ((SignInTokenApiResult.InvalidCredentials)$this$toSignInSubmitPasswordCommandResult).getError();
            String string3 = ((SignInTokenApiResult.InvalidCredentials)$this$toSignInSubmitPasswordCommandResult).getErrorDescription();
            List list = ((SignInTokenApiResult.InvalidCredentials)$this$toSignInSubmitPasswordCommandResult).getErrorCodes();
            String string4 = $this$toSignInSubmitPasswordCommandResult.getCorrelationId();
            signInSubmitPasswordCommandResult = (SignInSubmitPasswordCommandResult)new SignInCommandResult.InvalidCredentials(string4, string2, string3, list);
        } else if (signInTokenApiResult instanceof SignInTokenApiResult.Success) {
            signInSubmitPasswordCommandResult = (SignInSubmitPasswordCommandResult)this.saveAndReturnTokens(oAuth2Strategy, (BaseSignInTokenCommandParameters)parametersWithScopes, (SignInTokenApiResult.Success)$this$toSignInSubmitPasswordCommandResult);
        } else if (signInTokenApiResult instanceof SignInTokenApiResult.MFARequired) {
            String string5 = ((SignInTokenApiResult.MFARequired)$this$toSignInSubmitPasswordCommandResult).getError();
            String string6 = ((SignInTokenApiResult.MFARequired)$this$toSignInSubmitPasswordCommandResult).getErrorDescription();
            String string7 = ((SignInTokenApiResult.MFARequired)$this$toSignInSubmitPasswordCommandResult).getContinuationToken();
            String string8 = ((SignInTokenApiResult.MFARequired)$this$toSignInSubmitPasswordCommandResult).getSubError();
            List list = ((SignInTokenApiResult.MFARequired)$this$toSignInSubmitPasswordCommandResult).getErrorCodes();
            String string9 = $this$toSignInSubmitPasswordCommandResult.getCorrelationId();
            signInSubmitPasswordCommandResult = (SignInSubmitPasswordCommandResult)new SignInCommandResult.MFARequired(string9, string7, string5, string6, list, string8);
        } else if (signInTokenApiResult instanceof SignInTokenApiResult.JITRequired) {
            SignInStartCommandResult signInStartCommandResult = this.toSignInStartCommandResult(this.performJITIntrospect(oAuth2Strategy, (BaseSignInTokenCommandParameters)parametersWithScopes, ((SignInTokenApiResult.JITRequired)$this$toSignInSubmitPasswordCommandResult).getContinuationToken(), $this$toSignInSubmitPasswordCommandResult.getCorrelationId()));
            Intrinsics.checkNotNull((Object)signInStartCommandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.controllers.results.SignInSubmitPasswordCommandResult");
            signInSubmitPasswordCommandResult = (SignInSubmitPasswordCommandResult)signInStartCommandResult;
        } else if (signInTokenApiResult instanceof SignInTokenApiResult.Redirect) {
            signInSubmitPasswordCommandResult = (SignInSubmitPasswordCommandResult)new INativeAuthCommandResult.Redirect($this$toSignInSubmitPasswordCommandResult.getCorrelationId(), ((SignInTokenApiResult.Redirect)$this$toSignInSubmitPasswordCommandResult).getRedirectReason());
        } else if (((signInTokenApiResult instanceof SignInTokenApiResult.UserNotFound ? true : signInTokenApiResult instanceof SignInTokenApiResult.CodeIncorrect) ? true : signInTokenApiResult instanceof SignInTokenApiResult.InvalidAuthenticationType) ? true : signInTokenApiResult instanceof SignInTokenApiResult.UnknownError) {
            Logger.warnWithObject((String)TAG, (String)$this$toSignInSubmitPasswordCommandResult.getCorrelationId(), (String)"Unexpected result: ", (ILoggable)((ILoggable)$this$toSignInSubmitPasswordCommandResult));
            Intrinsics.checkNotNull((Object)$this$toSignInSubmitPasswordCommandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
            ApiErrorResult cfr_ignored_0 = (ApiErrorResult)$this$toSignInSubmitPasswordCommandResult;
            String string10 = ((ApiErrorResult)$this$toSignInSubmitPasswordCommandResult).getError();
            String string11 = ((ApiErrorResult)$this$toSignInSubmitPasswordCommandResult).getErrorDescription();
            List list = ((ApiErrorResult)$this$toSignInSubmitPasswordCommandResult).getErrorCodes();
            String string12 = $this$toSignInSubmitPasswordCommandResult.getCorrelationId();
            signInSubmitPasswordCommandResult = (SignInSubmitPasswordCommandResult)new INativeAuthCommandResult.APIError(string10, string11, null, string12, list, null, 36, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return signInSubmitPasswordCommandResult;
    }

    private final MFAChallengeCommandResult toMFAChallengeCommandResult(SignInIntrospectApiResult $this$toMFAChallengeCommandResult) {
        MFAChallengeCommandResult mFAChallengeCommandResult;
        SignInIntrospectApiResult signInIntrospectApiResult = $this$toMFAChallengeCommandResult;
        if (signInIntrospectApiResult instanceof SignInIntrospectApiResult.Redirect) {
            mFAChallengeCommandResult = (MFAChallengeCommandResult)new INativeAuthCommandResult.Redirect($this$toMFAChallengeCommandResult.getCorrelationId(), ((SignInIntrospectApiResult.Redirect)$this$toMFAChallengeCommandResult).getRedirectReason());
        } else if (signInIntrospectApiResult instanceof SignInIntrospectApiResult.Success) {
            mFAChallengeCommandResult = (MFAChallengeCommandResult)new MFACommandResult.SelectionRequired($this$toMFAChallengeCommandResult.getCorrelationId(), ((SignInIntrospectApiResult.Success)$this$toMFAChallengeCommandResult).getContinuationToken(), ((SignInIntrospectApiResult.Success)$this$toMFAChallengeCommandResult).getMethods());
        } else if (signInIntrospectApiResult instanceof SignInIntrospectApiResult.UnknownError) {
            Logger.warnWithObject((String)TAG, (String)$this$toMFAChallengeCommandResult.getCorrelationId(), (String)"Unexpected result: ", (ILoggable)((ILoggable)$this$toMFAChallengeCommandResult));
            String string2 = ((SignInIntrospectApiResult.UnknownError)$this$toMFAChallengeCommandResult).getError();
            String string3 = ((SignInIntrospectApiResult.UnknownError)$this$toMFAChallengeCommandResult).getErrorDescription();
            List list = ((SignInIntrospectApiResult.UnknownError)$this$toMFAChallengeCommandResult).getErrorCodes();
            String string4 = $this$toMFAChallengeCommandResult.getCorrelationId();
            mFAChallengeCommandResult = (MFAChallengeCommandResult)new INativeAuthCommandResult.APIError(string2, string3, null, string4, list, null, 36, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return mFAChallengeCommandResult;
    }

    @VisibleForTesting
    @NotNull
    public final SignInStartCommandResult processSignInInitiateApiResult(@NotNull SignInInitiateApiResult initiateApiResult, @Nullable SignInStartCommandParameters parametersWithScopes, @NotNull NativeAuthOAuth2Strategy oAuth2Strategy, boolean usePassword) {
        SignInStartCommandResult signInStartCommandResult;
        Intrinsics.checkNotNullParameter((Object)initiateApiResult, (String)"initiateApiResult");
        Intrinsics.checkNotNullParameter((Object)oAuth2Strategy, (String)"oAuth2Strategy");
        SignInInitiateApiResult signInInitiateApiResult = initiateApiResult;
        if (signInInitiateApiResult instanceof SignInInitiateApiResult.Redirect) {
            signInStartCommandResult = (SignInStartCommandResult)new INativeAuthCommandResult.Redirect(initiateApiResult.getCorrelationId(), ((SignInInitiateApiResult.Redirect)initiateApiResult).getRedirectReason());
        } else {
            if (signInInitiateApiResult instanceof SignInInitiateApiResult.Success) {
                SignInChallengeApiResult signInChallengeResult = this.performSignInDefaultChallengeCall(oAuth2Strategy, ((SignInInitiateApiResult.Success)initiateApiResult).getContinuationToken(), initiateApiResult.getCorrelationId());
                return this.processSignInChallengeCall(oAuth2Strategy, parametersWithScopes, signInChallengeResult, usePassword);
            }
            if (signInInitiateApiResult instanceof SignInInitiateApiResult.UserNotFound) {
                String string2 = ((SignInInitiateApiResult.UserNotFound)initiateApiResult).getError();
                String string3 = ((SignInInitiateApiResult.UserNotFound)initiateApiResult).getErrorDescription();
                List list = ((SignInInitiateApiResult.UserNotFound)initiateApiResult).getErrorCodes();
                String string4 = initiateApiResult.getCorrelationId();
                signInStartCommandResult = (SignInStartCommandResult)new SignInCommandResult.UserNotFound(string4, string2, string3, list);
            } else if (signInInitiateApiResult instanceof SignInInitiateApiResult.UnknownError) {
                Logger.warnWithObject((String)TAG, (String)initiateApiResult.getCorrelationId(), (String)"Unexpected result: ", (ILoggable)((ILoggable)initiateApiResult));
                String string5 = ((SignInInitiateApiResult.UnknownError)initiateApiResult).getError();
                String string6 = ((SignInInitiateApiResult.UnknownError)initiateApiResult).getErrorDescription();
                List list = ((SignInInitiateApiResult.UnknownError)initiateApiResult).getErrorCodes();
                String string7 = initiateApiResult.getCorrelationId();
                signInStartCommandResult = (SignInStartCommandResult)new INativeAuthCommandResult.APIError(string5, string6, null, string7, list, null, 36, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return signInStartCommandResult;
    }

    public static /* synthetic */ SignInStartCommandResult processSignInInitiateApiResult$default(NativeAuthMsalController nativeAuthMsalController, SignInInitiateApiResult signInInitiateApiResult, SignInStartCommandParameters signInStartCommandParameters, NativeAuthOAuth2Strategy nativeAuthOAuth2Strategy, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            signInStartCommandParameters = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return nativeAuthMsalController.processSignInInitiateApiResult(signInInitiateApiResult, signInStartCommandParameters, nativeAuthOAuth2Strategy, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SignInStartCommandResult processSignInChallengeCall(NativeAuthOAuth2Strategy oAuth2Strategy, SignInStartCommandParameters parametersWithScopes, SignInChallengeApiResult result, boolean usePassword) {
        SignInStartCommandResult signInStartCommandResult;
        SignInChallengeApiResult signInChallengeApiResult = result;
        if (signInChallengeApiResult instanceof SignInChallengeApiResult.OOBRequired) {
            String string2 = ((SignInChallengeApiResult.OOBRequired)result).getContinuationToken();
            int n = ((SignInChallengeApiResult.OOBRequired)result).getCodeLength();
            String string3 = ((SignInChallengeApiResult.OOBRequired)result).getChallengeTargetLabel();
            String string4 = ((SignInChallengeApiResult.OOBRequired)result).getChallengeChannel();
            String string5 = result.getCorrelationId();
            signInStartCommandResult = (SignInStartCommandResult)new SignInCommandResult.CodeRequired(string5, string2, string3, string4, n);
        } else if (signInChallengeApiResult instanceof SignInChallengeApiResult.PasswordRequired) {
            if (usePassword) {
                if (parametersWithScopes == null) {
                    throw new IllegalArgumentException("Parameters must be provided in password flow");
                }
                SignInSubmitPasswordCommandParameters signInSubmitPasswordCommandParameters = CommandUtil.createSignInSubmitPasswordCommandParameters(parametersWithScopes, result.getCorrelationId(), ((SignInChallengeApiResult.PasswordRequired)result).getContinuationToken());
                try {
                    Intrinsics.checkNotNullExpressionValue((Object)signInSubmitPasswordCommandParameters, (String)"signInSubmitPasswordCommandParameters");
                    SignInStartCommandResult signInStartCommandResult2 = this.toSignInStartCommandResult(this.performPasswordTokenCall(oAuth2Strategy, signInSubmitPasswordCommandParameters), oAuth2Strategy, parametersWithScopes);
                    return signInStartCommandResult2;
                }
                finally {
                    StringUtil.overwriteWithNull((char[])signInSubmitPasswordCommandParameters.password);
                }
            }
            String string6 = ((SignInChallengeApiResult.PasswordRequired)result).getContinuationToken();
            String string7 = result.getCorrelationId();
            signInStartCommandResult = (SignInStartCommandResult)new SignInCommandResult.PasswordRequired(string7, string6);
        } else if (signInChallengeApiResult instanceof SignInChallengeApiResult.Redirect) {
            signInStartCommandResult = (SignInStartCommandResult)new INativeAuthCommandResult.Redirect(result.getCorrelationId(), ((SignInChallengeApiResult.Redirect)result).getRedirectReason());
        } else if (signInChallengeApiResult instanceof SignInChallengeApiResult.IntrospectRequired) {
            String string8 = ((SignInChallengeApiResult.IntrospectRequired)result).getError();
            String string9 = ((SignInChallengeApiResult.IntrospectRequired)result).getErrorDescription();
            List list = ((SignInChallengeApiResult.IntrospectRequired)result).getErrorCodes();
            String string10 = result.getCorrelationId();
            signInStartCommandResult = (SignInStartCommandResult)new INativeAuthCommandResult.APIError(string8, string9, null, string10, list, null, 36, null);
        } else if (signInChallengeApiResult instanceof SignInChallengeApiResult.UnknownError) {
            Logger.warnWithObject((String)TAG, (String)result.getCorrelationId(), (String)"Unexpected result: ", (ILoggable)((ILoggable)result));
            String string11 = ((SignInChallengeApiResult.UnknownError)result).getError();
            String string12 = ((SignInChallengeApiResult.UnknownError)result).getErrorDescription();
            List list = ((SignInChallengeApiResult.UnknownError)result).getErrorCodes();
            String string13 = result.getCorrelationId();
            signInStartCommandResult = (SignInStartCommandResult)new INativeAuthCommandResult.APIError(string11, string12, null, string13, list, null, 36, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return signInStartCommandResult;
    }

    private final NativeAuthOAuth2Strategy createOAuth2Strategy(BaseNativeAuthCommandParameters parameters) {
        OAuth2StrategyParameters strategyParameters = OAuth2StrategyParameters.builder().platformComponents(parameters.getPlatformComponents()).challengeTypes(parameters.challengeType).capabilities(parameters.capabilities).build();
        NativeAuthCIAMAuthority nativeAuthCIAMAuthority = parameters.authority;
        Intrinsics.checkNotNullExpressionValue((Object)strategyParameters, (String)"strategyParameters");
        return nativeAuthCIAMAuthority.createOAuth2Strategy(strategyParameters);
    }

    private static final boolean resetPasswordPollCompletion$pollCompletionTimedOut(long startTime) {
        long currentTime = System.currentTimeMillis();
        return currentTime - startTime > 300000L;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/microsoft/identity/common/nativeauth/internal/controllers/NativeAuthMsalController$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

