/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.os.Bundle;
import com.microsoft.identity.common.internal.broker.BrokerData;
import com.microsoft.identity.common.internal.broker.IRestrictionsManager;
import com.microsoft.identity.common.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/microsoft/identity/common/internal/broker/SdmQrPinManager;", "", "()V", "TAG", "", "authenticatorPackageName", "restrictionsManager", "Lcom/microsoft/identity/common/internal/broker/IRestrictionsManager;", "getPreferredAuthConfig", "initializeSdmQrPinManager", "", "isCameraConsentSuppressed", "", "common_distRelease"})
public final class SdmQrPinManager {
    @NotNull
    public static final SdmQrPinManager INSTANCE = new SdmQrPinManager();
    @NotNull
    private static final String TAG = "SdmQrPinManager";
    @NotNull
    private static final String authenticatorPackageName = BrokerData.Companion.getProdMicrosoftAuthenticator().getPackageName();
    @Nullable
    private static IRestrictionsManager restrictionsManager;

    private SdmQrPinManager() {
    }

    public final void initializeSdmQrPinManager(@NotNull IRestrictionsManager restrictionsManager) {
        Intrinsics.checkNotNullParameter((Object)restrictionsManager, (String)"restrictionsManager");
        SdmQrPinManager.restrictionsManager = restrictionsManager;
    }

    @Nullable
    public final String getPreferredAuthConfig() {
        String methodTag = "SdmQrPinManager:getPreferredAuthConfig";
        String defaultValue = null;
        IRestrictionsManager iRestrictionsManager = restrictionsManager;
        if (iRestrictionsManager != null) {
            IRestrictionsManager manager = iRestrictionsManager;
            boolean bl = false;
            return manager.getString("preferred_auth_config", authenticatorPackageName, defaultValue);
        }
        SdmQrPinManager $this$getPreferredAuthConfig_u24lambda_u241 = this;
        boolean bl = false;
        Logger.warn(methodTag, "Broker restrictions manager is not initialized.");
        return defaultValue;
    }

    public final boolean isCameraConsentSuppressed() {
        String methodTag = "SdmQrPinManager:isCameraConsentSuppressed";
        boolean defaultValue = false;
        IRestrictionsManager iRestrictionsManager = restrictionsManager;
        if (iRestrictionsManager != null) {
            IRestrictionsManager manager = iRestrictionsManager;
            boolean bl = false;
            Object[] objectArray = new String[]{"suppress_camera_consent", "sdm_suppress_camera_consent"};
            Bundle multiValueRequest = IRestrictionsManager.BrokerRestrictionsManagerKeys.buildMultiValueRequest$default(IRestrictionsManager.BrokerRestrictionsManagerKeys, null, SetsKt.setOf((Object[])objectArray), 1, null);
            Bundle values = manager.getMultiValues(authenticatorPackageName, multiValueRequest);
            return values.getBoolean("suppress_camera_consent", defaultValue) || values.getBoolean("sdm_suppress_camera_consent", defaultValue);
        }
        SdmQrPinManager $this$isCameraConsentSuppressed_u24lambda_u243 = this;
        boolean bl = false;
        Logger.warn(methodTag, "Broker restrictions manager is not initialized.");
        return defaultValue;
    }
}

