/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.migration;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.util.TaskCompletedCallback;
import com.microsoft.identity.common.logging.Logger;
import com.microsoft.identity.common.migration.IMigrationOperationResult;
import com.microsoft.identity.common.migration.IMultiTypeNameValueStorageReencrypter;
import com.microsoft.identity.common.migration.MigrationOperationResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultMultiTypeNameValueStorageReencrypter
implements IMultiTypeNameValueStorageReencrypter {
    private static final String TAG = DefaultMultiTypeNameValueStorageReencrypter.class.getSimpleName();
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();

    @Override
    public IMigrationOperationResult reencrypt(@NonNull INameValueStorage<String> fileManager, final @NonNull IMultiTypeNameValueStorageReencrypter.IStringEncrypter encrypter, final @NonNull IMultiTypeNameValueStorageReencrypter.IStringDecrypter decrypter, @NonNull IMultiTypeNameValueStorageReencrypter.ReencryptionParams params) {
        String methodTag = TAG + ":reencrypt";
        HashMap<String, String> cacheEntries = new HashMap<String, String>(fileManager.getAll());
        Logger.verbose(methodTag, "Attempting to migrate cache entries: " + cacheEntries.size());
        MigrationOperationResult result = new MigrationOperationResult();
        result.setCountOfTotalRecords(cacheEntries.size());
        HashSet<String> keysMarkedForRemoval = new HashSet<String>();
        AtomicBoolean shouldAbort = new AtomicBoolean(false);
        HashSet<String> skipKeys = new HashSet<String>();
        this.applyCacheMutation(cacheEntries, new Callable<Map.Entry<String, String>>(){

            @Override
            public void call(Map.Entry<String, String> entry) throws Exception {
                String decryptedText = decrypter.decrypt(entry.getValue());
                entry.setValue(decryptedText);
            }
        }, result, params, keysMarkedForRemoval, skipKeys, shouldAbort);
        this.clearEntriesMarkedForRemoval(fileManager, cacheEntries, keysMarkedForRemoval);
        if (shouldAbort.get()) {
            Logger.info(methodTag, "Aborting after decrypt.");
            return result;
        }
        this.applyCacheMutation(cacheEntries, new Callable<Map.Entry<String, String>>(){

            @Override
            public void call(Map.Entry<String, String> entry) throws Exception {
                String reencryptedText = encrypter.encrypt(entry.getValue());
                entry.setValue(reencryptedText);
            }
        }, result, params, keysMarkedForRemoval, skipKeys, shouldAbort);
        this.clearEntriesMarkedForRemoval(fileManager, cacheEntries, keysMarkedForRemoval);
        if (shouldAbort.get()) {
            Logger.info(methodTag, "Aborting after reencrypt.");
            return result;
        }
        Logger.info(methodTag, "Writing reencrypted cache entries.");
        for (Map.Entry cacheEntry : cacheEntries.entrySet()) {
            fileManager.put((String)cacheEntry.getKey(), (Object)((String)cacheEntry.getValue()));
        }
        return result;
    }

    private void applyCacheMutation(@NonNull Map<String, String> cacheEntries, @NonNull Callable<Map.Entry<String, String>> callable, @NonNull MigrationOperationResult inputResult, @NonNull IMultiTypeNameValueStorageReencrypter.ReencryptionParams params, @NonNull Set<String> keysMarkedForRemoval, @NonNull Set<String> skipKeys, @NonNull AtomicBoolean shouldAbort) {
        String methodTag = TAG + ":applyCacheMutation";
        for (Map.Entry<String, String> cacheEntry : cacheEntries.entrySet()) {
            try {
                if (skipKeys.contains(cacheEntry.getKey())) {
                    Logger.warn(methodTag, "Skipping entry.");
                    continue;
                }
                callable.call(cacheEntry);
            }
            catch (Exception e) {
                Logger.error(methodTag, "Error during mutation", e);
                Logger.errorPII(methodTag, "Failed key: " + cacheEntry.getKey(), e);
                inputResult.addFailure(e);
                skipKeys.add(cacheEntry.getKey());
                if (params.eraseEntryOnError()) {
                    Logger.warn(methodTag, "Marking key for removal.");
                    keysMarkedForRemoval.add(cacheEntry.getKey());
                }
                if (params.eraseAllOnError()) {
                    Logger.warn(methodTag, "Marking all keys for removal.");
                    keysMarkedForRemoval.addAll(cacheEntries.keySet());
                    shouldAbort.set(true);
                    break;
                }
                if (!params.abortOnError()) continue;
                shouldAbort.set(true);
                break;
            }
        }
    }

    private void clearEntriesMarkedForRemoval(@NonNull INameValueStorage<String> fileManager, @NonNull Map<String, String> cacheEntries, @NonNull Set<String> keysMarkedForRemoval) {
        String methodTag = TAG + ":clearEntriesMarkedForRemoval";
        Logger.warn(methodTag, "Removing entries marked for removal");
        for (String removedKey : keysMarkedForRemoval) {
            cacheEntries.remove(removedKey);
            fileManager.remove(removedKey);
        }
    }

    @Override
    public void reencryptAsync(final @NonNull INameValueStorage<String> fileManager, final @NonNull IMultiTypeNameValueStorageReencrypter.IStringEncrypter encrypter, final @NonNull IMultiTypeNameValueStorageReencrypter.IStringDecrypter decrypter, final @NonNull IMultiTypeNameValueStorageReencrypter.ReencryptionParams params, final @NonNull TaskCompletedCallback<IMigrationOperationResult> callback) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onTaskCompleted((Object)DefaultMultiTypeNameValueStorageReencrypter.this.reencrypt((INameValueStorage<String>)fileManager, encrypter, decrypter, params));
            }
        });
    }

    private static interface Callable<T> {
        public void call(T var1) throws Exception;
    }
}

