/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ICertDetails;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ISmartcardSession;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.YubiKitCertDetails;
import com.microsoft.identity.common.logging.Logger;
import com.yubico.yubikit.core.application.BadResponseException;
import com.yubico.yubikit.core.smartcard.ApduException;
import com.yubico.yubikit.piv.InvalidPinException;
import com.yubico.yubikit.piv.PivSession;
import com.yubico.yubikit.piv.Slot;
import com.yubico.yubikit.piv.jca.PivPrivateKey;
import com.yubico.yubikit.piv.jca.PivProvider;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class YubiKitSmartcardSession
implements ISmartcardSession {
    private static final String TAG = YubiKitSmartcardSession.class.getSimpleName();
    private final PivSession piv;
    private static final String YUBIKEY_PROVIDER = "YKPiv";
    private static final short APDU_EXCEPTION_ERROR_CODE_FILE_NOT_FOUND = 27266;

    public YubiKitSmartcardSession(@NonNull PivSession p) {
        this.piv = p;
    }

    @Override
    @NonNull
    public List<ICertDetails> getCertDetailsList() throws ApduException, BadResponseException, IOException {
        ArrayList<ICertDetails> certList = new ArrayList<ICertDetails>();
        this.getAndPutCertDetailsInList(Slot.AUTHENTICATION, this.piv, certList);
        this.getAndPutCertDetailsInList(Slot.SIGNATURE, this.piv, certList);
        this.getAndPutCertDetailsInList(Slot.KEY_MANAGEMENT, this.piv, certList);
        this.getAndPutCertDetailsInList(Slot.CARD_AUTH, this.piv, certList);
        return certList;
    }

    private void getAndPutCertDetailsInList(@NonNull Slot slot, @NonNull PivSession piv, @NonNull List<ICertDetails> certList) throws IOException, ApduException, BadResponseException {
        String methodTag = TAG + ":getAndPutCertDetailsInList";
        try {
            X509Certificate cert = piv.getCertificate(slot);
            certList.add(new YubiKitCertDetails(cert, slot));
        }
        catch (ApduException e) {
            if (e.getSw() == 27266) {
                Logger.verbose(methodTag, slot + " slot is empty.");
            }
            throw e;
        }
    }

    @Override
    public boolean verifyPin(@NonNull char[] pin) throws ApduException, IOException {
        String methodTag = TAG + ":verifyPin";
        try {
            this.piv.verifyPin(pin);
            return true;
        }
        catch (InvalidPinException e) {
            Logger.info(methodTag, "Incorrect PIN entered.");
            return false;
        }
    }

    @Override
    public int getPinAttemptsRemaining() throws ApduException, IOException {
        return this.piv.getPinAttempts();
    }

    @Override
    @NonNull
    public PrivateKey getKeyForAuth(@NonNull ICertDetails certDetails, @NonNull char[] pin) throws Exception {
        String methodTag = TAG + ":getKeyForAuth";
        if (!(certDetails instanceof YubiKitCertDetails)) {
            throw new Exception("certDetails is not of type YubiKitCertDetails.");
        }
        KeyStore keyStore = KeyStore.getInstance(YUBIKEY_PROVIDER, (Provider)new PivProvider(this.piv));
        keyStore.load(null);
        Key key = keyStore.getKey(((YubiKitCertDetails)certDetails).getSlot().getStringAlias(), pin);
        if (!(key instanceof PivPrivateKey)) {
            Logger.error(methodTag, "Private key retrieved from YKPiv keystore is not of type PivPrivateKey.", null);
            throw new Exception("Private key retrieved from YKPiv keystore is not of type PivPrivateKey.");
        }
        return (PivPrivateKey)key;
    }
}

