/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.content.Context;
import com.microsoft.identity.common.internal.broker.PackageHelper;
import com.microsoft.identity.common.java.logging.Logger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/microsoft/identity/common/internal/broker/BrokerData;", "", "packageName", "", "signingCertificateThumbprint", "(Ljava/lang/String;Ljava/lang/String;)V", "nickName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getPackageName", "()Ljava/lang/String;", "getSigningCertificateThumbprint", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "common_distRelease"})
public final class BrokerData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String packageName;
    @NotNull
    private final String signingCertificateThumbprint;
    @Nullable
    private final String nickName;
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(BrokerData.class).getSimpleName();
    private static boolean sShouldTrustDebugBrokers = false;
    @NotNull
    private static final BrokerData debugMicrosoftAuthenticator = new BrokerData("com.azure.authenticator", "pdAtoxfsEwbpQsIaua5Uobl5AQEjqt40aPXI7UY1lIW0NTmg0G4jHQ5T5mujSjjU06q4mEHs5hb6z/Mr0PNlmQ==", "debugMicrosoftAuthenticator");
    @NotNull
    private static final BrokerData prodMicrosoftAuthenticator = new BrokerData("com.azure.authenticator", "Gu8CuaYmSV5CHWd6dz3tGPXIE+YTalCVIXi5lEBXpvUgsMKoHbU9Rqou3WNRNU1tsz8pvEADTCCJ5f02fbw9qw==", "prodMicrosoftAuthenticator");
    @NotNull
    private static final BrokerData debugCompanyPortal = new BrokerData("com.microsoft.windowsintune.companyportal", "oIuNoUwMsxC10VneTQXnt/GXN+Pjqd6mpOKEMF/cH3i06K93TZMBWq+fHN/zt4zUe/W6zGj6YLymd1/tGuypNQ==", "debugCompanyPortal");
    @NotNull
    private static final BrokerData prodCompanyPortal = new BrokerData("com.microsoft.windowsintune.companyportal", "jPpMoaNvcxSLMX4yG4C3Gf86rtTqh33SqpuRKg4WOP+MnnpA52zZgvKLW76U4Cqqf68iaBk9W7k/jhciiSAtgQ==", "prodCompanyPortal");
    @NotNull
    private static final BrokerData debugBrokerHost = new BrokerData("com.microsoft.identity.testuserapp", "xxAk8S05zu0Nkce+X2J6IKJ2e7YE4F9ZorZj0YnYUQ2vw8vLc8VGGOqJdTnVySbbcy9VY8UDbOfeOETSErYllw==", "debugBrokerHost");
    @NotNull
    private static final BrokerData debugMockCp = new BrokerData("com.microsoft.mockcp", "EZ2RCcsmf869Ec41PgHHnFdI0MgmVsADFFy8AtcfEKsjD1YAPtKxCMZVdT+y+K1IWRnPk4Lf2PUAcL5N49OqAA==", "debugMockCp");
    @NotNull
    private static final BrokerData debugMockAuthApp = new BrokerData("com.microsoft.mockauthapp", "QhjKSYYD31K7+C4q4Mpd08crE0LN/3GgnKVVuej4JWckUTc0Wp/i//LWLQnANaWiAjdESJJrjavu0cE6hkQihQ==", "debugMockAuthApp");
    @NotNull
    private static final BrokerData debugMockLtw = new BrokerData("com.microsoft.mockltw", "felxzv/rpqa69dOADXVVKnawk5x8snBW2k/kDxzQLVkbcdzAvrGm8gcBRItzUGIQTupHCTWksN6WBGbn+b0KIA==", "debugMockLtw");
    @NotNull
    private static final BrokerData prodLTW = new BrokerData("com.microsoft.appmanager", "WhUdh04ZkQLmNb//lKmohyqDdPMWXHcI0O3AvoLMtgF/smnED4r+Vguvgj6d4QG77Jl3avUKt6LeqF2TJPZVzg==", "prodLTW");
    @NotNull
    private static final BrokerData debugLTW = new BrokerData("com.microsoft.appmanager", "5PAhhZNSRRvq7vpTT5vrYJbSLh05AU8USf7oUTS239PEltebX87uGN7GhAe5244lJepwZ5RU4vu8N6ospXVOlg==", "debugLTW");
    @NotNull
    private static final BrokerData debugIntuneCE = new BrokerData("com.microsoft.intune", "F+Tat7A/mlOJCzRYEmj9DgLRHU2Nb0VSQjgZEyAehqW9+cOT0oYjkT/fa33hYcVMwUzaSy0hUOVt9KQtyFRnVQ==", "debugIntuneCE");
    @NotNull
    private static final BrokerData prodIntuneCE = new BrokerData("com.microsoft.intune", "jPpMoaNvcxSLMX4yG4C3Gf86rtTqh33SqpuRKg4WOP+MnnpA52zZgvKLW76U4Cqqf68iaBk9W7k/jhciiSAtgQ==", "prodIntuneCE");
    @NotNull
    private static final Set<String> accountManagerBrokers;
    @NotNull
    private static final Set<BrokerData> debugBrokers;
    @NotNull
    private static final Set<BrokerData> prodBrokers;
    @NotNull
    private static final Set<BrokerData> allBrokers;

    public BrokerData(@NotNull String packageName, @NotNull String signingCertificateThumbprint, @Nullable String nickName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)signingCertificateThumbprint, (String)"signingCertificateThumbprint");
        this.packageName = packageName;
        this.signingCertificateThumbprint = signingCertificateThumbprint;
        this.nickName = nickName;
    }

    @NotNull
    public final String getPackageName() {
        return this.packageName;
    }

    @NotNull
    public final String getSigningCertificateThumbprint() {
        return this.signingCertificateThumbprint;
    }

    public BrokerData(@NotNull String packageName, @NotNull String signingCertificateThumbprint) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)signingCertificateThumbprint, (String)"signingCertificateThumbprint");
        this(packageName, signingCertificateThumbprint, null);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof BrokerData)) {
            return false;
        }
        return StringsKt.equals((String)this.packageName, (String)((BrokerData)other).packageName, (boolean)true) && Intrinsics.areEqual((Object)this.signingCertificateThumbprint, (Object)((BrokerData)other).signingCertificateThumbprint);
    }

    public int hashCode() {
        int result = this.packageName.hashCode();
        result = 31 * result + this.signingCertificateThumbprint.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        CharSequence charSequence = this.nickName;
        if (!(charSequence == null || charSequence.length() == 0)) {
            return this.nickName;
        }
        return this.packageName + "::" + this.signingCertificateThumbprint;
    }

    @NotNull
    public final String component1() {
        return this.packageName;
    }

    @NotNull
    public final String component2() {
        return this.signingCertificateThumbprint;
    }

    private final String component3() {
        return this.nickName;
    }

    @NotNull
    public final BrokerData copy(@NotNull String packageName, @NotNull String signingCertificateThumbprint, @Nullable String nickName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)signingCertificateThumbprint, (String)"signingCertificateThumbprint");
        return new BrokerData(packageName, signingCertificateThumbprint, nickName);
    }

    public static /* synthetic */ BrokerData copy$default(BrokerData brokerData, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = brokerData.packageName;
        }
        if ((n & 2) != 0) {
            string2 = brokerData.signingCertificateThumbprint;
        }
        if ((n & 4) != 0) {
            string3 = brokerData.nickName;
        }
        return brokerData.copy(string, string2, string3);
    }

    @JvmStatic
    public static final void setShouldTrustDebugBrokers(boolean value) {
        Companion.setShouldTrustDebugBrokers(value);
    }

    @JvmStatic
    public static final boolean getShouldTrustDebugBrokers() {
        return Companion.getShouldTrustDebugBrokers();
    }

    @NotNull
    public static final BrokerData getDebugMicrosoftAuthenticator() {
        return Companion.getDebugMicrosoftAuthenticator();
    }

    @NotNull
    public static final BrokerData getProdMicrosoftAuthenticator() {
        return Companion.getProdMicrosoftAuthenticator();
    }

    @NotNull
    public static final BrokerData getDebugCompanyPortal() {
        return Companion.getDebugCompanyPortal();
    }

    @NotNull
    public static final BrokerData getProdCompanyPortal() {
        return Companion.getProdCompanyPortal();
    }

    @NotNull
    public static final BrokerData getDebugBrokerHost() {
        return Companion.getDebugBrokerHost();
    }

    @NotNull
    public static final BrokerData getDebugMockCp() {
        return Companion.getDebugMockCp();
    }

    @NotNull
    public static final BrokerData getDebugMockAuthApp() {
        return Companion.getDebugMockAuthApp();
    }

    @NotNull
    public static final BrokerData getDebugMockLtw() {
        return Companion.getDebugMockLtw();
    }

    @NotNull
    public static final BrokerData getProdLTW() {
        return Companion.getProdLTW();
    }

    @NotNull
    public static final BrokerData getDebugLTW() {
        return Companion.getDebugLTW();
    }

    @NotNull
    public static final BrokerData getDebugIntuneCE() {
        return Companion.getDebugIntuneCE();
    }

    @NotNull
    public static final BrokerData getProdIntuneCE() {
        return Companion.getProdIntuneCE();
    }

    @NotNull
    public static final Set<String> getAccountManagerBrokers() {
        return Companion.getAccountManagerBrokers();
    }

    @NotNull
    public static final Set<BrokerData> getDebugBrokers() {
        return Companion.getDebugBrokers();
    }

    @NotNull
    public static final Set<BrokerData> getProdBrokers() {
        return Companion.getProdBrokers();
    }

    @NotNull
    public static final Set<BrokerData> getAllBrokers() {
        return Companion.getAllBrokers();
    }

    @JvmStatic
    @NotNull
    public static final Set<BrokerData> getKnownBrokerApps() {
        return Companion.getKnownBrokerApps();
    }

    @JvmStatic
    public static final boolean isAccountManagerSupported(@NotNull String packageName) {
        return Companion.isAccountManagerSupported(packageName);
    }

    @JvmStatic
    @Nullable
    public static final BrokerData getFromContext(@NotNull Context context) {
        return Companion.getFromContext(context);
    }

    static {
        Set set = Collections.unmodifiableSet((Set)new HashSet<String>(){
            {
                this.add("com.azure.authenticator");
                this.add("com.microsoft.windowsintune.companyportal");
                this.add("com.microsoft.identity.testuserapp");
                this.add("com.microsoft.mockauthapp");
                this.add("com.microsoft.mockcp");
            }
        });
        Intrinsics.checkNotNullExpressionValue(set, (String)"unmodifiableSet(object :\u2026         }\n            })");
        accountManagerBrokers = set;
        Set set2 = Collections.unmodifiableSet((Set)new HashSet<BrokerData>(){
            {
                this.add(BrokerData.Companion.getDebugMicrosoftAuthenticator());
                this.add(BrokerData.Companion.getDebugLTW());
                this.add(BrokerData.Companion.getDebugCompanyPortal());
                this.add(BrokerData.Companion.getDebugBrokerHost());
                this.add(BrokerData.Companion.getDebugMockCp());
                this.add(BrokerData.Companion.getDebugMockAuthApp());
                this.add(BrokerData.Companion.getDebugMockLtw());
            }
        });
        Intrinsics.checkNotNullExpressionValue(set2, (String)"unmodifiableSet(object :\u2026         }\n            })");
        debugBrokers = set2;
        Set set3 = Collections.unmodifiableSet((Set)new HashSet<BrokerData>(){
            {
                this.add(BrokerData.Companion.getProdMicrosoftAuthenticator());
                this.add(BrokerData.Companion.getProdCompanyPortal());
                this.add(BrokerData.Companion.getProdLTW());
            }
        });
        Intrinsics.checkNotNullExpressionValue(set3, (String)"unmodifiableSet(object :\u2026         }\n            })");
        prodBrokers = set3;
        Set set4 = Collections.unmodifiableSet((Set)new HashSet<BrokerData>(){
            {
                this.addAll((Collection)BrokerData.Companion.getDebugBrokers());
                this.addAll((Collection)BrokerData.Companion.getProdBrokers());
            }
        });
        Intrinsics.checkNotNullExpressionValue(set4, (String)"unmodifiableSet(object :\u2026         }\n            })");
        allBrokers = set4;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b.\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010=\u001a\u0004\u0018\u00010\r2\u0006\u0010>\u001a\u00020?H\u0007J\u000e\u0010@\u001a\b\u0012\u0004\u0012\u00020\r0\bH\u0007J\b\u0010A\u001a\u00020<H\u0007J\u0010\u0010B\u001a\u00020<2\u0006\u0010C\u001a\u00020\u0004H\u0007J\u0010\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020<H\u0007R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u000bR\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u000bR\u001c\u0010\u0010\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0016\u0010\u000bR\u001c\u0010\u0017\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0002\u001a\u0004\b\u0019\u0010\u0013R\u001c\u0010\u001a\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001b\u0010\u0002\u001a\u0004\b\u001c\u0010\u0013R\u001c\u0010\u001d\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001e\u0010\u0002\u001a\u0004\b\u001f\u0010\u0013R\u001c\u0010 \u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b!\u0010\u0002\u001a\u0004\b\"\u0010\u0013R\u001c\u0010#\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b$\u0010\u0002\u001a\u0004\b%\u0010\u0013R\u001c\u0010&\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b'\u0010\u0002\u001a\u0004\b(\u0010\u0013R\u001c\u0010)\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b*\u0010\u0002\u001a\u0004\b+\u0010\u0013R\"\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b-\u0010\u0002\u001a\u0004\b.\u0010\u000bR\u001c\u0010/\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b0\u0010\u0002\u001a\u0004\b1\u0010\u0013R\u001c\u00102\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b3\u0010\u0002\u001a\u0004\b4\u0010\u0013R\u001c\u00105\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b6\u0010\u0002\u001a\u0004\b7\u0010\u0013R\u001c\u00108\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b9\u0010\u0002\u001a\u0004\b:\u0010\u0013R\u000e\u0010;\u001a\u00020<X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/microsoft/identity/common/internal/broker/BrokerData$Companion;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "accountManagerBrokers", "", "getAccountManagerBrokers$annotations", "getAccountManagerBrokers", "()Ljava/util/Set;", "allBrokers", "Lcom/microsoft/identity/common/internal/broker/BrokerData;", "getAllBrokers$annotations", "getAllBrokers", "debugBrokerHost", "getDebugBrokerHost$annotations", "getDebugBrokerHost", "()Lcom/microsoft/identity/common/internal/broker/BrokerData;", "debugBrokers", "getDebugBrokers$annotations", "getDebugBrokers", "debugCompanyPortal", "getDebugCompanyPortal$annotations", "getDebugCompanyPortal", "debugIntuneCE", "getDebugIntuneCE$annotations", "getDebugIntuneCE", "debugLTW", "getDebugLTW$annotations", "getDebugLTW", "debugMicrosoftAuthenticator", "getDebugMicrosoftAuthenticator$annotations", "getDebugMicrosoftAuthenticator", "debugMockAuthApp", "getDebugMockAuthApp$annotations", "getDebugMockAuthApp", "debugMockCp", "getDebugMockCp$annotations", "getDebugMockCp", "debugMockLtw", "getDebugMockLtw$annotations", "getDebugMockLtw", "prodBrokers", "getProdBrokers$annotations", "getProdBrokers", "prodCompanyPortal", "getProdCompanyPortal$annotations", "getProdCompanyPortal", "prodIntuneCE", "getProdIntuneCE$annotations", "getProdIntuneCE", "prodLTW", "getProdLTW$annotations", "getProdLTW", "prodMicrosoftAuthenticator", "getProdMicrosoftAuthenticator$annotations", "getProdMicrosoftAuthenticator", "sShouldTrustDebugBrokers", "", "getFromContext", "context", "Landroid/content/Context;", "getKnownBrokerApps", "getShouldTrustDebugBrokers", "isAccountManagerSupported", "packageName", "setShouldTrustDebugBrokers", "", "value", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getTAG() {
            return TAG;
        }

        @JvmStatic
        public final void setShouldTrustDebugBrokers(boolean value) {
            String methodTag = this.getTAG() + ":setShouldTrustDebugBrokers";
            if (value) {
                Logger.warn((String)methodTag, (String)"You are forcing to trust debug brokers in non-debug builds.");
            }
            sShouldTrustDebugBrokers = value;
        }

        @JvmStatic
        public final boolean getShouldTrustDebugBrokers() {
            return sShouldTrustDebugBrokers;
        }

        @NotNull
        public final BrokerData getDebugMicrosoftAuthenticator() {
            return debugMicrosoftAuthenticator;
        }

        @JvmStatic
        public static /* synthetic */ void getDebugMicrosoftAuthenticator$annotations() {
        }

        @NotNull
        public final BrokerData getProdMicrosoftAuthenticator() {
            return prodMicrosoftAuthenticator;
        }

        @JvmStatic
        public static /* synthetic */ void getProdMicrosoftAuthenticator$annotations() {
        }

        @NotNull
        public final BrokerData getDebugCompanyPortal() {
            return debugCompanyPortal;
        }

        @JvmStatic
        public static /* synthetic */ void getDebugCompanyPortal$annotations() {
        }

        @NotNull
        public final BrokerData getProdCompanyPortal() {
            return prodCompanyPortal;
        }

        @JvmStatic
        public static /* synthetic */ void getProdCompanyPortal$annotations() {
        }

        @NotNull
        public final BrokerData getDebugBrokerHost() {
            return debugBrokerHost;
        }

        @JvmStatic
        public static /* synthetic */ void getDebugBrokerHost$annotations() {
        }

        @NotNull
        public final BrokerData getDebugMockCp() {
            return debugMockCp;
        }

        @JvmStatic
        public static /* synthetic */ void getDebugMockCp$annotations() {
        }

        @NotNull
        public final BrokerData getDebugMockAuthApp() {
            return debugMockAuthApp;
        }

        @JvmStatic
        public static /* synthetic */ void getDebugMockAuthApp$annotations() {
        }

        @NotNull
        public final BrokerData getDebugMockLtw() {
            return debugMockLtw;
        }

        @JvmStatic
        public static /* synthetic */ void getDebugMockLtw$annotations() {
        }

        @NotNull
        public final BrokerData getProdLTW() {
            return prodLTW;
        }

        @JvmStatic
        public static /* synthetic */ void getProdLTW$annotations() {
        }

        @NotNull
        public final BrokerData getDebugLTW() {
            return debugLTW;
        }

        @JvmStatic
        public static /* synthetic */ void getDebugLTW$annotations() {
        }

        @NotNull
        public final BrokerData getDebugIntuneCE() {
            return debugIntuneCE;
        }

        @JvmStatic
        public static /* synthetic */ void getDebugIntuneCE$annotations() {
        }

        @NotNull
        public final BrokerData getProdIntuneCE() {
            return prodIntuneCE;
        }

        @JvmStatic
        public static /* synthetic */ void getProdIntuneCE$annotations() {
        }

        @NotNull
        public final Set<String> getAccountManagerBrokers() {
            return accountManagerBrokers;
        }

        @JvmStatic
        public static /* synthetic */ void getAccountManagerBrokers$annotations() {
        }

        @NotNull
        public final Set<BrokerData> getDebugBrokers() {
            return debugBrokers;
        }

        @JvmStatic
        public static /* synthetic */ void getDebugBrokers$annotations() {
        }

        @NotNull
        public final Set<BrokerData> getProdBrokers() {
            return prodBrokers;
        }

        @JvmStatic
        public static /* synthetic */ void getProdBrokers$annotations() {
        }

        @NotNull
        public final Set<BrokerData> getAllBrokers() {
            return allBrokers;
        }

        @JvmStatic
        public static /* synthetic */ void getAllBrokers$annotations() {
        }

        @JvmStatic
        @NotNull
        public final Set<BrokerData> getKnownBrokerApps() {
            return sShouldTrustDebugBrokers ? this.getAllBrokers() : this.getProdBrokers();
        }

        @JvmStatic
        public final boolean isAccountManagerSupported(@NotNull String packageName) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            return this.getAccountManagerBrokers().contains(packageName);
        }

        @JvmStatic
        @Nullable
        public final BrokerData getFromContext(@NotNull Context context) {
            Object v1;
            block2: {
                CharSequence charSequence;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                String signingCertificateThumbprint = new PackageHelper(context).getSha512SignatureForPackage(context.getPackageName());
                if (Intrinsics.areEqual((Object)context.getPackageName(), (Object)this.getDebugBrokerHost().getPackageName()) && ((charSequence = (CharSequence)signingCertificateThumbprint) == null || charSequence.length() == 0)) {
                    return this.getDebugBrokerHost();
                }
                Iterable $this$firstOrNull$iv = this.getAllBrokers();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    BrokerData it = (BrokerData)element$iv;
                    boolean bl = false;
                    boolean bl2 = Intrinsics.areEqual((Object)it.getPackageName(), (Object)context.getPackageName()) && Intrinsics.areEqual((Object)it.getSigningCertificateThumbprint(), (Object)signingCertificateThumbprint);
                    if (!bl2) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            return v1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

