/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.switchbrowser;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import com.microsoft.identity.common.internal.providers.oauth2.BrokerAuthorizationActivity;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.SwitchBrowserRequestHandler;
import com.microsoft.identity.common.internal.ui.webview.switchbrowser.SwitchBrowserUriHelper;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.ui.AuthorizationAgent;
import com.microsoft.identity.common.logging.Logger;
import java.io.Serializable;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJD\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f24\u0010\u0010\u001a0\u0012\u0004\u0012\u00020\u0012\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013j\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014`\u0015\u0012\u0004\u0012\u00020\r0\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/microsoft/identity/common/internal/ui/webview/switchbrowser/SwitchBrowserProtocolCoordinator;", "", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "switchBrowserRequestHandler", "Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/SwitchBrowserRequestHandler;", "(Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/SwitchBrowserRequestHandler;)V", "getSwitchBrowserRequestHandler", "()Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/SwitchBrowserRequestHandler;", "isExpectingSwitchBrowserResume", "", "processSwitchBrowserResume", "", "extras", "Landroid/os/Bundle;", "onSuccessAction", "Lkotlin/Function2;", "Landroid/net/Uri;", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "Companion", "common_distRelease"})
public final class SwitchBrowserProtocolCoordinator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SwitchBrowserRequestHandler switchBrowserRequestHandler;
    @NotNull
    private static final String TAG = "SwitchBrowserProtocolCoordinator";

    public SwitchBrowserProtocolCoordinator(@NotNull SwitchBrowserRequestHandler switchBrowserRequestHandler) {
        Intrinsics.checkNotNullParameter((Object)switchBrowserRequestHandler, (String)"switchBrowserRequestHandler");
        this.switchBrowserRequestHandler = switchBrowserRequestHandler;
    }

    @NotNull
    public final SwitchBrowserRequestHandler getSwitchBrowserRequestHandler() {
        return this.switchBrowserRequestHandler;
    }

    public SwitchBrowserProtocolCoordinator(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this(new SwitchBrowserRequestHandler(activity));
    }

    public final void processSwitchBrowserResume(@NotNull Bundle extras, @NotNull Function2<? super Uri, ? super HashMap<String, String>, Unit> onSuccessAction) throws ClientException {
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        Intrinsics.checkNotNullParameter(onSuccessAction, (String)"onSuccessAction");
        String methodTag = "SwitchBrowserProtocolCoordinator:processSwitchBrowserResume";
        String actionUri = extras.getString("action_uri");
        String code = extras.getString("code");
        CharSequence charSequence = actionUri;
        if (charSequence == null || charSequence.length() == 0 || (charSequence = (CharSequence)code) == null || charSequence.length() == 0) {
            throw new ClientException("missing_parameter", "Action URI is null/empty: " + (actionUri == null) + ", code is null/empty: " + (code == null));
        }
        Uri resumeUri = SwitchBrowserUriHelper.INSTANCE.buildResumeUri(actionUri);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Authorization", (Object)code)};
        HashMap headers = MapsKt.hashMapOf((Pair[])pairArray);
        onSuccessAction.invoke((Object)resumeUri, (Object)headers);
        this.switchBrowserRequestHandler.resetChallengeState();
        Logger.info(methodTag, "Switch browser resume action processed successfully.");
    }

    public final boolean isExpectingSwitchBrowserResume() {
        String methodTag = "SwitchBrowserProtocolCoordinator:isExpectingSwitchBrowserResume";
        Logger.verbose(methodTag, "ExpectingRequest: " + this.switchBrowserRequestHandler.isChallengeHandled());
        return this.switchBrowserRequestHandler.isChallengeHandled();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u0018\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/microsoft/identity/common/internal/ui/webview/switchbrowser/SwitchBrowserProtocolCoordinator$Companion;", "", "()V", "TAG", "", "getIntentToResumeWebViewAuth", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "intentDataString", "isSwitchBrowserResume", "", "url", "redirectUrl", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSwitchBrowserResume(@Nullable String url, @NotNull String redirectUrl) {
            Intrinsics.checkNotNullParameter((Object)redirectUrl, (String)"redirectUrl");
            return SwitchBrowserUriHelper.INSTANCE.isSwitchBrowserRedirectUrl(url, redirectUrl, "switch_browser_resume");
        }

        @NotNull
        public final Intent getIntentToResumeWebViewAuth(@NotNull Context context, @NotNull String intentDataString) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intentDataString, (String)"intentDataString");
            Uri uri = Uri.parse((String)intentDataString);
            Intent intent = new Intent(context, BrokerAuthorizationActivity.class);
            intent.putExtra("com.microsoft.identity.client.authorization.agent", (Serializable)AuthorizationAgent.WEBVIEW);
            intent.setFlags(0x24000000);
            intent.putExtra("action_uri", uri.getQueryParameter("action_uri"));
            intent.putExtra("code", uri.getQueryParameter("code"));
            return intent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

