/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.challengehandlers;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.microsoft.identity.common.internal.ui.browser.AndroidBrowserSelector;
import com.microsoft.identity.common.internal.ui.browser.CustomTabsManager;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.SwitchBrowserChallenge;
import com.microsoft.identity.common.internal.ui.webview.switchbrowser.SwitchBrowserUriHelper;
import com.microsoft.identity.common.java.browser.Browser;
import com.microsoft.identity.common.java.browser.IBrowserSelector;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.ui.BrowserDescriptor;
import com.microsoft.identity.common.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u00192\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0019B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0006\u0010\u0018\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/SwitchBrowserRequestHandler;", "Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/IChallengeHandler;", "Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/SwitchBrowserChallenge;", "", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "context", "Landroid/content/Context;", "customTabsManager", "Lcom/microsoft/identity/common/internal/ui/browser/CustomTabsManager;", "browserSelector", "Lcom/microsoft/identity/common/java/browser/IBrowserSelector;", "(Landroid/app/Activity;Landroid/content/Context;Lcom/microsoft/identity/common/internal/ui/browser/CustomTabsManager;Lcom/microsoft/identity/common/java/browser/IBrowserSelector;)V", "<set-?>", "", "isChallengeHandled", "()Z", "isSwitchBrowserRequest", "url", "", "redirectUrl", "processChallenge", "switchBrowserChallenge", "resetChallengeState", "Companion", "common_distRelease"})
public final class SwitchBrowserRequestHandler
implements IChallengeHandler<SwitchBrowserChallenge, Unit> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Activity activity;
    @NotNull
    private final Context context;
    @NotNull
    private final CustomTabsManager customTabsManager;
    @NotNull
    private final IBrowserSelector browserSelector;
    private boolean isChallengeHandled;
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(SwitchBrowserRequestHandler.class).getSimpleName();

    public SwitchBrowserRequestHandler(@NotNull Activity activity, @NotNull Context context, @NotNull CustomTabsManager customTabsManager, @NotNull IBrowserSelector browserSelector) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)customTabsManager, (String)"customTabsManager");
        Intrinsics.checkNotNullParameter((Object)browserSelector, (String)"browserSelector");
        this.activity = activity;
        this.context = context;
        this.customTabsManager = customTabsManager;
        this.browserSelector = browserSelector;
    }

    public final boolean isChallengeHandled() {
        return this.isChallengeHandled;
    }

    public SwitchBrowserRequestHandler(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Context context = activity.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"activity.applicationContext");
        this(activity, context, new CustomTabsManager(activity.getApplicationContext()), new AndroidBrowserSelector(activity.getApplicationContext()));
    }

    @Override
    public void processChallenge(@NotNull SwitchBrowserChallenge switchBrowserChallenge) throws ClientException {
        Intrinsics.checkNotNullParameter((Object)switchBrowserChallenge, (String)"switchBrowserChallenge");
        String methodTag = TAG + ":processChallenge";
        Browser browser = this.browserSelector.selectBrowser(BrowserDescriptor.getBrowserSafeListForSwitchBrowser(), null);
        if (browser == null) {
            ClientException exception = new ClientException("no_browsers_available", "No browser found for SwitchBrowserChallenge.");
            Logger.error(methodTag, "No browser found for SwitchBrowserChallenge.", (Throwable)exception);
            throw exception;
        }
        Intent browserIntent = null;
        if (browser.isCustomTabsServiceSupported()) {
            Logger.info(methodTag, "CustomTabsService is supported.");
            if (!this.customTabsManager.bind(this.context, browser.getPackageName())) {
                Logger.warn(methodTag, "Failed to bind CustomTabsService.");
                browserIntent = new Intent("android.intent.action.VIEW");
            } else {
                Intent intent = this.customTabsManager.getCustomTabsIntent().intent;
                Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"customTabsManager.customTabsIntent.intent");
                browserIntent = intent;
            }
        } else {
            Logger.warn(methodTag, "CustomTabsService is NOT supported");
            browserIntent = new Intent("android.intent.action.VIEW");
        }
        Logger.info(methodTag, "Launching switch browser request on browser: " + browser.getPackageName());
        browserIntent.setPackage(browser.getPackageName());
        browserIntent.setData(switchBrowserChallenge.getUri());
        this.activity.startActivity(browserIntent);
        this.isChallengeHandled = true;
    }

    public final boolean isSwitchBrowserRequest(@Nullable String url, @NotNull String redirectUrl) {
        Intrinsics.checkNotNullParameter((Object)redirectUrl, (String)"redirectUrl");
        return SwitchBrowserUriHelper.INSTANCE.isSwitchBrowserRedirectUrl(url, redirectUrl, "switch_browser");
    }

    public final void resetChallengeState() {
        this.customTabsManager.unbind();
        this.isChallengeHandled = false;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/SwitchBrowserRequestHandler$Companion;", "", "()V", "TAG", "", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

