/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.challengehandlers;

import android.webkit.WebView;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IChallengeHandler;
import com.microsoft.identity.common.java.broker.CommonRefreshTokenCredentialProvider;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.logging.Logger;
import io.opentelemetry.api.trace.Span;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B9\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\"\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b`\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J.\u0010\u0011\u001a\u0004\u0018\u00010\b2\"\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b`\tH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0002H\u0016R\u0016\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/NonceRedirectHandler;", "Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/IChallengeHandler;", "Ljava/net/URL;", "Ljava/lang/Void;", "webView", "Landroid/webkit/WebView;", "headers", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "span", "Lio/opentelemetry/api/trace/Span;", "(Landroid/webkit/WebView;Ljava/util/HashMap;Lio/opentelemetry/api/trace/Span;)V", "TAG", "kotlin.jvm.PlatformType", "getNonceFromRedirectUrl", "url", "getPrtHeader", "requestHeaders", "getUserNameFromWebViewUrl", "modifyHeadersWithNewRefreshTokenCredential", "", "nonce", "processChallenge", "input", "common_distRelease"})
public final class NonceRedirectHandler
implements IChallengeHandler<URL, Void> {
    @NotNull
    private final WebView webView;
    @NotNull
    private final HashMap<String, String> headers;
    @NotNull
    private final Span span;
    private final String TAG;

    public NonceRedirectHandler(@NotNull WebView webView, @NotNull HashMap<String, String> headers, @NotNull Span span) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        this.webView = webView;
        this.headers = headers;
        this.span = span;
        this.TAG = NonceRedirectHandler.class.getSimpleName();
    }

    @Override
    @Nullable
    public Void processChallenge(@NotNull URL input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String nonce = this.getNonceFromRedirectUrl(input);
        if (nonce != null) {
            String string2 = input.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"input.toString()");
            this.modifyHeadersWithNewRefreshTokenCredential(nonce, string2);
        }
        this.webView.loadUrl(input.toString(), (Map)this.headers);
        return null;
    }

    private final String getNonceFromRedirectUrl(URL url) {
        HashMap<String, String> parameters = StringExtensions.getUrlParameters(url.toString());
        return parameters.get("sso_nonce");
    }

    private final String getPrtHeader(HashMap<String, String> requestHeaders) {
        return requestHeaders.get("x-ms-RefreshTokenCredential");
    }

    private final void modifyHeadersWithNewRefreshTokenCredential(String nonce, String url) {
        String methodTag = this.TAG + ":getHeadersWithNewRefreshTokenCredential";
        String prtHeader = this.getPrtHeader(this.headers);
        CharSequence charSequence = prtHeader;
        if (!(charSequence == null || charSequence.length() == 0)) {
            String updatedRefreshTokenCredentialHeader;
            Logger.info(methodTag, "PRT credential header found in headers!");
            String username = this.getUserNameFromWebViewUrl(url);
            if (username != null && (updatedRefreshTokenCredentialHeader = CommonRefreshTokenCredentialProvider.INSTANCE.getRefreshTokenCredentialUsingNewNonce(url, username, nonce)) != null) {
                ((Map)this.headers).put("x-ms-RefreshTokenCredential", updatedRefreshTokenCredentialHeader);
                this.span.setAttribute(AttributeName.is_new_refresh_token_cred_header_attached.name(), true);
            }
        }
    }

    private final String getUserNameFromWebViewUrl(String url) {
        HashMap<String, String> hashMap = StringExtensions.getUrlParameters(url);
        Intrinsics.checkNotNullExpressionValue(hashMap, (String)"getUrlParameters(url)");
        Map parameters = hashMap;
        return (String)parameters.get("login_hint");
    }
}

