/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.challengehandlers;

import android.webkit.WebView;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IChallengeHandler;
import com.microsoft.identity.common.java.broker.CommonRefreshTokenCredentialProvider;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.logging.Logger;
import io.opentelemetry.api.trace.Span;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B9\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\"\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002`\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u0016\u0010\f\u001a\n \r*\u0004\u0018\u00010\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/CrossCloudChallengeHandler;", "Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/IChallengeHandler;", "", "Ljava/lang/Void;", "webView", "Landroid/webkit/WebView;", "headers", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "span", "Lio/opentelemetry/api/trace/Span;", "(Landroid/webkit/WebView;Ljava/util/HashMap;Lio/opentelemetry/api/trace/Span;)V", "TAG", "kotlin.jvm.PlatformType", "modifyHeadersWithRefreshTokenCredential", "", "url", "processChallenge", "inputUrl", "common_distRelease"})
public final class CrossCloudChallengeHandler
implements IChallengeHandler<String, Void> {
    @NotNull
    private final WebView webView;
    @NotNull
    private final HashMap<String, String> headers;
    @NotNull
    private final Span span;
    private final String TAG;

    public CrossCloudChallengeHandler(@NotNull WebView webView, @NotNull HashMap<String, String> headers, @NotNull Span span) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        this.webView = webView;
        this.headers = headers;
        this.span = span;
        this.TAG = CrossCloudChallengeHandler.class.getSimpleName();
    }

    @Override
    @Nullable
    public Void processChallenge(@NotNull String inputUrl) {
        Intrinsics.checkNotNullParameter((Object)inputUrl, (String)"inputUrl");
        Logger.info(this.TAG, "Processing challenge of a cross cloud request.");
        this.modifyHeadersWithRefreshTokenCredential(inputUrl);
        this.webView.loadUrl(inputUrl, (Map)this.headers);
        return null;
    }

    public final void modifyHeadersWithRefreshTokenCredential(@NotNull String url) {
        String updatedRefreshTokenCredentialHeader;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String methodTag = this.TAG + ":modifyHeadersWithRefreshTokenCredential";
        HashMap<String, String> hashMap = StringExtensions.getUrlParameters(url);
        Intrinsics.checkNotNullExpressionValue(hashMap, (String)"getUrlParameters(url)");
        Map parameters = hashMap;
        String username = (String)parameters.get("login_hint");
        CharSequence charSequence2 = username;
        if (!(charSequence2 == null || charSequence2.length() == 0) && !((charSequence = (CharSequence)(updatedRefreshTokenCredentialHeader = CommonRefreshTokenCredentialProvider.INSTANCE.getRefreshTokenCredential(url, username))) == null || charSequence.length() == 0)) {
            Logger.info(methodTag, "Attaching refresh token credential in headers.");
            this.span.setAttribute(AttributeName.is_new_refresh_token_cred_header_attached.name(), true);
            ((Map)this.headers).put("x-ms-RefreshTokenCredential", updatedRefreshTokenCredentialHeader);
        }
    }
}

