/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ICancelCbaCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ICertDetails;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IDialogHolder;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IDismissCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardCertPickerDialog;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardDialog;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardErrorDialog;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardNfcLoadingDialog;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardNfcPromptDialog;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardNfcReminderDialog;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardPinDialog;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardPromptDialog;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardRemovalPromptDialog;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.UserChoiceDialog;
import java.util.List;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DialogHolder
implements IDialogHolder {
    private final Activity mActivity;
    private SmartcardDialog mCurrentDialog;

    public DialogHolder(@NonNull Activity activity) {
        this.mActivity = activity;
        this.mCurrentDialog = null;
    }

    @Override
    public synchronized void showCertPickerDialog(@NonNull List<ICertDetails> certList, @NonNull SmartcardCertPickerDialog.PositiveButtonListener positiveButtonListener, @NonNull ICancelCbaCallback cancelCbaCallback) {
        SmartcardCertPickerDialog certPickerDialog = new SmartcardCertPickerDialog(certList, positiveButtonListener, cancelCbaCallback, this.mActivity);
        this.showDialog(certPickerDialog);
    }

    @Override
    public synchronized void showPinDialog(@NonNull SmartcardPinDialog.PositiveButtonListener positiveButtonListener, @NonNull ICancelCbaCallback cancelCbaCallback) {
        SmartcardPinDialog pinDialog = new SmartcardPinDialog(positiveButtonListener, cancelCbaCallback, this.mActivity);
        this.showDialog(pinDialog);
    }

    @Override
    public synchronized void showErrorDialog(int titleStringResourceId, int messageStringResourceId) {
        this.showDialog(new SmartcardErrorDialog(titleStringResourceId, messageStringResourceId, R.string.smartcard_error_dialog_positive_button, new IDismissCallback(){

            @Override
            public void onDismiss() {
                DialogHolder.this.dismissDialog();
            }
        }, this.mActivity));
    }

    @Override
    public synchronized void showErrorDialog(int titleStringResourceId, int messageStringResourceId, int dismissButtonStringResourceId) {
        this.showDialog(new SmartcardErrorDialog(titleStringResourceId, messageStringResourceId, dismissButtonStringResourceId, new IDismissCallback(){

            @Override
            public void onDismiss() {
                DialogHolder.this.dismissDialog();
            }
        }, this.mActivity));
    }

    @Override
    public synchronized void showUserChoiceDialog(@NonNull UserChoiceDialog.PositiveButtonListener positiveButtonListener, @NonNull ICancelCbaCallback cancelCbaCallback) {
        this.showDialog(new UserChoiceDialog(positiveButtonListener, cancelCbaCallback, this.mActivity));
    }

    @Override
    public synchronized void showSmartcardPromptDialog(@NonNull ICancelCbaCallback cancelCbaCallback) {
        this.showDialog(new SmartcardPromptDialog(cancelCbaCallback, this.mActivity));
    }

    @Override
    public synchronized void showSmartcardNfcLoadingDialog() {
        this.showDialog(new SmartcardNfcLoadingDialog(this.mActivity));
    }

    @Override
    public synchronized void showSmartcardNfcPromptDialog(@NonNull ICancelCbaCallback cancelCbaCallback) {
        this.showDialog(new SmartcardNfcPromptDialog(cancelCbaCallback, this.mActivity));
    }

    @Override
    public synchronized void showSmartcardNfcReminderDialog(@NonNull IDismissCallback dismissCallback) {
        this.showDialog(new SmartcardNfcReminderDialog(dismissCallback, this.mActivity));
    }

    @Override
    public synchronized void showSmartcardRemovalPromptDialog(final @Nullable IDismissCallback dismissCallback) {
        this.showDialog(new SmartcardRemovalPromptDialog(new IDismissCallback(){

            @Override
            public void onDismiss() {
                DialogHolder.this.dismissDialog();
                if (dismissCallback != null) {
                    dismissCallback.onDismiss();
                }
            }
        }, this.mActivity));
    }

    @Override
    public synchronized void dismissDialog() {
        this.showDialog(null);
    }

    @Override
    public synchronized void showDialog(@Nullable SmartcardDialog dialog) {
        if (this.mCurrentDialog != null) {
            this.mCurrentDialog.dismiss();
        }
        this.mCurrentDialog = dialog;
        if (this.mCurrentDialog != null) {
            this.mCurrentDialog.show();
        }
    }

    @Override
    public synchronized boolean isDialogShowing() {
        return this.mCurrentDialog != null;
    }

    @Override
    public synchronized boolean isSmartcardRemovalPromptDialogShowing() {
        return this.mCurrentDialog instanceof SmartcardRemovalPromptDialog;
    }

    @Override
    public synchronized void onUnexpectedUnplug() {
        if (this.mCurrentDialog != null) {
            this.mCurrentDialog.onUnexpectedUnplug();
        }
    }

    @Override
    public synchronized void setPinDialogErrorMode() {
        if (this.mCurrentDialog instanceof SmartcardPinDialog) {
            ((SmartcardPinDialog)this.mCurrentDialog).setErrorMode();
        }
    }
}

