/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.webkit.PermissionRequest;
import com.microsoft.identity.common.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/microsoft/identity/common/internal/providers/oauth2/CameraPermissionRequestHandler;", "", "()V", "currentPermissionRequest", "Landroid/webkit/PermissionRequest;", "isGranted", "", "deny", "", "grant", "isForCamera", "request", "isRepeatedRequest", "permissionRequest", "setCurrentPermissionRequest", "setIfValid", "Companion", "common_distRelease"})
public final class CameraPermissionRequestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private PermissionRequest currentPermissionRequest;
    private boolean isGranted;
    @NotNull
    private static final String TAG = "CameraPermissionRequestHandler";
    @NotNull
    private static final String[] cameraResource;

    public final void grant() {
        block0: {
            PermissionRequest permissionRequest = this.currentPermissionRequest;
            if (permissionRequest == null) break block0;
            PermissionRequest it = permissionRequest;
            boolean bl = false;
            it.grant(cameraResource);
            this.isGranted = true;
        }
    }

    public final void deny() {
        block0: {
            PermissionRequest permissionRequest = this.currentPermissionRequest;
            if (permissionRequest == null) break block0;
            PermissionRequest it = permissionRequest;
            boolean bl = false;
            it.deny();
            this.isGranted = false;
        }
    }

    public final boolean setIfValid(@NotNull PermissionRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String methodTag = "CameraPermissionRequestHandler:setIfValid";
        if (!this.isForCamera(request)) {
            Logger.warn(methodTag, "Permission request is not for camera.");
            request.deny();
            return false;
        }
        if (this.isRepeatedRequest(request)) {
            Logger.info(methodTag, "Repeated request, permission is granted: " + this.isGranted);
            if (this.isGranted) {
                request.grant(cameraResource);
            } else {
                request.deny();
            }
            return false;
        }
        Logger.info(methodTag, "Valid new request.");
        this.setCurrentPermissionRequest(request);
        return true;
    }

    private final void setCurrentPermissionRequest(PermissionRequest permissionRequest) {
        this.currentPermissionRequest = permissionRequest;
        this.isGranted = false;
    }

    private final boolean isRepeatedRequest(PermissionRequest permissionRequest) {
        PermissionRequest it = this.currentPermissionRequest;
        boolean bl = false;
        if (it == null) {
            return false;
        }
        if (it.getResources().length != permissionRequest.getResources().length) {
            return false;
        }
        return Intrinsics.areEqual((Object)it.getOrigin(), (Object)permissionRequest.getOrigin());
    }

    private final boolean isForCamera(PermissionRequest request) {
        return request.getResources().length == 1 && Intrinsics.areEqual((Object)"android.webkit.resource.VIDEO_CAPTURE", (Object)request.getResources()[0]);
    }

    static {
        String[] stringArray = new String[]{"android.webkit.resource.VIDEO_CAPTURE"};
        cameraResource = stringArray;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/microsoft/identity/common/internal/providers/oauth2/CameraPermissionRequestHandler$Companion;", "", "()V", "TAG", "", "cameraResource", "", "[Ljava/lang/String;", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

