/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.exception;

import com.microsoft.identity.common.internal.broker.ipc.IIpcStrategy;
import com.microsoft.identity.common.java.exception.BaseException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/microsoft/identity/common/exception/BrokerCommunicationException;", "Lcom/microsoft/identity/common/java/exception/BaseException;", "category", "Lcom/microsoft/identity/common/exception/BrokerCommunicationException$Category;", "strategyType", "Lcom/microsoft/identity/common/internal/broker/ipc/IIpcStrategy$Type;", "errorMessage", "", "throwable", "", "(Lcom/microsoft/identity/common/exception/BrokerCommunicationException$Category;Lcom/microsoft/identity/common/internal/broker/ipc/IIpcStrategy$Type;Ljava/lang/String;Ljava/lang/Throwable;)V", "getCategory", "()Lcom/microsoft/identity/common/exception/BrokerCommunicationException$Category;", "message", "getMessage", "()Ljava/lang/String;", "getStrategyType", "()Lcom/microsoft/identity/common/internal/broker/ipc/IIpcStrategy$Type;", "isCacheable", "", "Category", "Companion", "common_distRelease"})
public final class BrokerCommunicationException
extends BaseException {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Category category;
    @NotNull
    private final IIpcStrategy.Type strategyType;
    private static final long serialVersionUID = 4959278068787428329L;

    public BrokerCommunicationException(@NotNull Category category, @NotNull IIpcStrategy.Type strategyType, @Nullable String errorMessage, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        Intrinsics.checkNotNullParameter((Object)((Object)strategyType), (String)"strategyType");
        super(category.toString(), errorMessage, throwable);
        this.category = category;
        this.strategyType = strategyType;
    }

    @NotNull
    public final Category getCategory() {
        return this.category;
    }

    @NotNull
    public final IIpcStrategy.Type getStrategyType() {
        return this.strategyType;
    }

    @NotNull
    public String getMessage() {
        String string = "[%s] [%s] :%s";
        Object[] objectArray = new Object[3];
        Category category = this.category;
        objectArray[0] = category != null ? category.toString() : null;
        IIpcStrategy.Type type = this.strategyType;
        objectArray[1] = type != null ? type.toString() : null;
        objectArray[2] = super.getMessage();
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    public boolean isCacheable() {
        return this.category != Category.CONNECTION_ERROR;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/microsoft/identity/common/exception/BrokerCommunicationException$Companion;", "", "()V", "serialVersionUID", "", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/microsoft/identity/common/exception/BrokerCommunicationException$Category;", "", "categoryName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "toString", "OPERATION_NOT_SUPPORTED_ON_CLIENT_SIDE", "OPERATION_NOT_SUPPORTED_ON_SERVER_SIDE", "CONNECTION_ERROR", "VALIDATION_ERROR", "NULL_CURSOR", "common_distRelease"})
    public static final class Category
    extends Enum<Category> {
        @NotNull
        private final String categoryName;
        public static final /* enum */ Category OPERATION_NOT_SUPPORTED_ON_CLIENT_SIDE = new Category("ipc_operation_not_supported_on_client_side");
        public static final /* enum */ Category OPERATION_NOT_SUPPORTED_ON_SERVER_SIDE = new Category("ipc_operation_not_supported_on_server_side");
        public static final /* enum */ Category CONNECTION_ERROR = new Category("ipc_connection_error");
        public static final /* enum */ Category VALIDATION_ERROR = new Category("ipc_validation_error");
        public static final /* enum */ Category NULL_CURSOR = new Category("ipc_return_null_cursor");
        private static final /* synthetic */ Category[] $VALUES;

        private Category(String categoryName) {
            this.categoryName = categoryName;
        }

        @NotNull
        public String toString() {
            return this.categoryName;
        }

        public static Category[] values() {
            return (Category[])$VALUES.clone();
        }

        public static Category valueOf(String value) {
            return Enum.valueOf(Category.class, value);
        }

        static {
            $VALUES = categoryArray = new Category[]{Category.OPERATION_NOT_SUPPORTED_ON_CLIENT_SIDE, Category.OPERATION_NOT_SUPPORTED_ON_SERVER_SIDE, Category.CONNECTION_ERROR, Category.VALIDATION_ERROR, Category.NULL_CURSOR};
        }
    }
}

