/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.os.Build;
import android.webkit.PermissionRequest;
import com.microsoft.identity.common.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nR\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/microsoft/identity/common/internal/providers/oauth2/CameraPermissionRequest;", "", "mCameraPermissionRequest", "Landroid/webkit/PermissionRequest;", "(Landroid/webkit/PermissionRequest;)V", "<set-?>", "", "isGranted", "()Z", "deny", "", "grant", "Companion", "common_distRelease"})
public final class CameraPermissionRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PermissionRequest mCameraPermissionRequest;
    private boolean isGranted;
    private static final String TAG = CameraPermissionRequest.class.getSimpleName();

    public CameraPermissionRequest(@NotNull PermissionRequest mCameraPermissionRequest) {
        Intrinsics.checkNotNullParameter((Object)mCameraPermissionRequest, (String)"mCameraPermissionRequest");
        this.mCameraPermissionRequest = mCameraPermissionRequest;
    }

    public final boolean isGranted() {
        return this.isGranted;
    }

    public final void grant() {
        if (Build.VERSION.SDK_INT >= 21) {
            String[] stringArray = new String[]{"android.webkit.resource.VIDEO_CAPTURE"};
            String[] cameraResource = stringArray;
            this.mCameraPermissionRequest.grant(cameraResource);
        }
        this.isGranted = true;
    }

    public final void deny() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.mCameraPermissionRequest.deny();
        }
        this.isGranted = false;
    }

    @JvmStatic
    public static final boolean isValidRequest(@NotNull PermissionRequest request) {
        return Companion.isValidRequest(request);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/microsoft/identity/common/internal/providers/oauth2/CameraPermissionRequest$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "isValidRequest", "", "request", "Landroid/webkit/PermissionRequest;", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isValidRequest(@NotNull PermissionRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            String methodTag = TAG + ":validateRequest";
            if (Build.VERSION.SDK_INT >= 21) {
                return request.getResources().length == 1 && Intrinsics.areEqual((Object)"android.webkit.resource.VIDEO_CAPTURE", (Object)request.getResources()[0]);
            }
            Logger.warn(methodTag, "PermissionRequest.getResources() method is not available on API:" + Build.VERSION.SDK_INT + ". We cannot determine if the request is for camera.");
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

