/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.content.Context;
import android.content.Intent;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.java.util.IBroadcaster;
import com.microsoft.identity.common.java.util.ported.PropertyBag;
import com.microsoft.identity.common.logging.Logger;
import lombok.NonNull;

public class AndroidBroadcaster
implements IBroadcaster {
    private static final String TAG = AndroidBroadcaster.class.getSimpleName();
    @NonNull
    private final Context mContext;

    public void sendBroadcast(@NonNull String broadcastId, @Nullable PropertyBag propertyBag) {
        if (broadcastId == null) {
            throw new NullPointerException("broadcastId is marked non-null but is null");
        }
        String methodTag = TAG + ":sendBroadcast";
        Logger.info(methodTag, "Sending broadcast with broadcastId: " + broadcastId);
        Intent intent = new Intent();
        intent.setAction(broadcastId);
        if (propertyBag != null) {
            for (String key : propertyBag.keySet()) {
                intent.putExtra(key, (String)((Object)propertyBag.get(key)));
            }
        }
        this.mContext.sendBroadcast(intent);
    }

    public AndroidBroadcaster(@NonNull Context mContext) {
        if (mContext == null) {
            throw new NullPointerException("mContext is marked non-null but is null");
        }
        this.mContext = mContext;
    }
}

