/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.fido;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.util.Base64;
import androidx.activity.result.IntentSenderRequest;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.RequiresApi;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorAssertionResponse;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorErrorResponse;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorResponse;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredential;
import com.microsoft.identity.common.internal.fido.LegacyFido2ApiException;
import com.microsoft.identity.common.internal.fido.LegacyFido2ApiObject;
import com.microsoft.identity.common.internal.fido.WebAuthnJsonUtil;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0011H\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0007\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R)\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\f0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/microsoft/identity/common/internal/fido/LegacyFidoActivityResultContract;", "Landroidx/activity/result/contract/ActivityResultContract;", "Lcom/microsoft/identity/common/internal/fido/LegacyFido2ApiObject;", "Ljava/lang/Void;", "()V", "TAG", "", "assertionCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "result", "", "errorCallback", "Lcom/microsoft/identity/common/internal/fido/LegacyFido2ApiException;", "exception", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "input", "parseResult", "resultCode", "", "intent", "common_distRelease"})
public final class LegacyFidoActivityResultContract
extends ActivityResultContract<LegacyFido2ApiObject, Void> {
    @NotNull
    private final String TAG = String.valueOf(Reflection.getOrCreateKotlinClass(LegacyFidoActivityResultContract.class).getSimpleName());
    @NotNull
    private Function1<? super String, Unit> assertionCallback = (Function1)new Function1<String, Unit>(this){
        final /* synthetic */ LegacyFidoActivityResultContract this$0;
        {
            this.this$0 = $receiver;
            super(1);
        }

        public final void invoke(@NotNull String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Logger.info(LegacyFidoActivityResultContract.access$getTAG$p(this.this$0), "Assertion callback not set.");
        }
    };
    @NotNull
    private Function1<? super LegacyFido2ApiException, Unit> errorCallback = (Function1)new Function1<LegacyFido2ApiException, Unit>(this){
        final /* synthetic */ LegacyFidoActivityResultContract this$0;
        {
            this.this$0 = $receiver;
            super(1);
        }

        public final void invoke(@NotNull LegacyFido2ApiException it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            Logger.info(LegacyFidoActivityResultContract.access$getTAG$p(this.this$0), "Error callback not set.");
        }
    };

    @NotNull
    public Intent createIntent(@NotNull Context context, @NotNull LegacyFido2ApiObject input) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.assertionCallback = input.getAssertionCallback();
        this.errorCallback = input.getErrorCallback();
        Intent intent = new Intent("androidx.activity.result.contract.action.INTENT_SENDER_REQUEST").putExtra("androidx.activity.result.contract.extra.INTENT_SENDER_REQUEST", (Parcelable)new IntentSenderRequest.Builder(input.getPendingIntent().getIntentSender()).build());
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(ActivityResultCon\u2026  ).build()\n            )");
        return intent;
    }

    @RequiresApi(api=19)
    @Nullable
    public Void parseResult(int resultCode, @Nullable Intent intent) {
        if (intent == null) {
            this.errorCallback.invoke((Object)new LegacyFido2ApiException("null_object", "Result intent from legacy FIDO2 API was null."));
            return null;
        }
        if (resultCode != -1) {
            this.errorCallback.invoke((Object)new LegacyFido2ApiException("bad_activity_result_code", "Activity closed with result code: " + resultCode));
            return null;
        }
        byte[] bytes = intent.getByteArrayExtra("FIDO2_CREDENTIAL_EXTRA");
        if (bytes == null) {
            this.errorCallback.invoke((Object)new LegacyFido2ApiException("null_object", "Credential result from Intent is null."));
            return null;
        }
        PublicKeyCredential publicKeyCredential = PublicKeyCredential.deserializeFromBytes((byte[])bytes);
        Intrinsics.checkNotNullExpressionValue((Object)publicKeyCredential, (String)"deserializeFromBytes(bytes)");
        PublicKeyCredential credential = publicKeyCredential;
        AuthenticatorResponse authenticatorResponse = credential.getResponse();
        Intrinsics.checkNotNullExpressionValue((Object)authenticatorResponse, (String)"credential.response");
        AuthenticatorResponse response = authenticatorResponse;
        if (response instanceof AuthenticatorErrorResponse) {
            String errorMessage = ((AuthenticatorErrorResponse)response).getErrorMessage();
            String errorCode = ((AuthenticatorErrorResponse)response).getErrorCode().toString();
            this.errorCallback.invoke((Object)new LegacyFido2ApiException(errorCode, StringUtil.isNullOrEmpty((String)errorMessage) ? "AuthenticatorResponse has a null error message." : errorMessage));
            return null;
        }
        if (response instanceof AuthenticatorAssertionResponse) {
            if (((AuthenticatorAssertionResponse)response).getUserHandle() == null) {
                this.errorCallback.invoke((Object)new LegacyFido2ApiException("null_object", "UserHandle value in AuthenticatorAssertionResponse is null."));
                return null;
            }
            String string2 = Base64.encodeToString((byte[])response.getClientDataJSON(), (int)11);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(\n        \u2026ING\n                    )");
            String string3 = Base64.encodeToString((byte[])((AuthenticatorAssertionResponse)response).getAuthenticatorData(), (int)11);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"encodeToString(\n        \u2026ING\n                    )");
            String string4 = string3;
            string3 = Base64.encodeToString((byte[])((AuthenticatorAssertionResponse)response).getSignature(), (int)11);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"encodeToString(\n        \u2026ING\n                    )");
            String string5 = string3;
            string3 = Base64.encodeToString((byte[])((AuthenticatorAssertionResponse)response).getUserHandle(), (int)11);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"encodeToString(\n        \u2026ING\n                    )");
            String string6 = credential.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"credential.id");
            this.assertionCallback.invoke((Object)WebAuthnJsonUtil.Companion.createAssertionString(string2, string4, string5, string3, string6));
            return null;
        }
        this.errorCallback.invoke((Object)new LegacyFido2ApiException("unknown_error", "The legacy FIDO2 API response value is something unexpected which we currently cannot handle."));
        return null;
    }

    public static final /* synthetic */ String access$getTAG$p(LegacyFidoActivityResultContract $this) {
        return $this.TAG;
    }
}

