/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import com.microsoft.identity.common.internal.msafederation.MsaFederationExtensions;
import com.microsoft.identity.common.internal.msafederation.google.SignInWithGoogleApi;
import com.microsoft.identity.common.internal.msafederation.google.SignInWithGoogleCredential;
import com.microsoft.identity.common.internal.msafederation.google.SignInWithGoogleParameters;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationActivity;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationFragment;
import com.microsoft.identity.common.internal.providers.oauth2.BrokerAuthorizationActivity;
import com.microsoft.identity.common.internal.providers.oauth2.BrowserAuthorizationFragment;
import com.microsoft.identity.common.internal.providers.oauth2.CurrentTaskAuthorizationActivity;
import com.microsoft.identity.common.internal.providers.oauth2.CurrentTaskBrowserAuthorizationFragment;
import com.microsoft.identity.common.internal.providers.oauth2.WebViewAuthorizationFragment;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.UiStartEvent;
import com.microsoft.identity.common.internal.util.CommonMoshiJsonAdapter;
import com.microsoft.identity.common.internal.util.ProcessUtil;
import com.microsoft.identity.common.java.configuration.LibraryConfiguration;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.DiagnosticContext;
import com.microsoft.identity.common.java.opentelemetry.SerializableSpanContext;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.telemetry.events.BaseEvent;
import com.microsoft.identity.common.java.ui.AuthorizationAgent;
import com.microsoft.identity.common.java.util.CommonURIBuilder;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class AuthorizationActivityFactory {
    public static Intent getAuthorizationActivityIntent(Context context, Intent authIntent, String requestUrl, String redirectUri, HashMap<String, String> requestHeaders, AuthorizationAgent authorizationAgent, boolean webViewZoomEnabled, boolean webViewZoomControlsEnabled) {
        return AuthorizationActivityFactory.getAuthorizationActivityIntent(context, authIntent, requestUrl, redirectUri, requestHeaders, authorizationAgent, webViewZoomEnabled, webViewZoomControlsEnabled, null, null);
    }

    public static Intent getAuthorizationActivityIntent(Context context, Intent authIntent, String requestUrl, String redirectUri, HashMap<String, String> requestHeaders, AuthorizationAgent authorizationAgent, boolean webViewZoomEnabled, boolean webViewZoomControlsEnabled, String sourceLibraryName, String sourceLibraryVersion) {
        LibraryConfiguration libraryConfig = LibraryConfiguration.getInstance();
        Intent intent = ProcessUtil.isBrokerProcess(context) ? new Intent(context, BrokerAuthorizationActivity.class) : (libraryConfig.isAuthorizationInCurrentTask() && !authorizationAgent.equals((Object)AuthorizationAgent.WEBVIEW) ? new Intent(context, CurrentTaskAuthorizationActivity.class) : new Intent(context, AuthorizationActivity.class));
        intent.putExtra("com.microsoft.identity.auth.intent", (Parcelable)authIntent);
        intent.putExtra("com.microsoft.identity.request.url", requestUrl);
        intent.putExtra("com.microsoft.identity.request.redirect.uri", redirectUri);
        intent.putExtra("com.microsoft.identity.request.headers", requestHeaders);
        intent.putExtra("com.microsoft.identity.client.authorization.agent", (Serializable)authorizationAgent);
        intent.putExtra("com.microsoft.identity.web.view.zoom.controls.enabled", webViewZoomControlsEnabled);
        intent.putExtra("com.microsoft.identity.web.view.zoom.enabled", webViewZoomEnabled);
        intent.putExtra("correlation_id", (String)DiagnosticContext.INSTANCE.getRequestContext().get((Object)"correlation_id"));
        if (sourceLibraryName != null) {
            intent.putExtra("x-client-SKU", sourceLibraryName);
        }
        if (sourceLibraryVersion != null) {
            intent.putExtra("x-client-Ver", sourceLibraryVersion);
        }
        intent.putExtra("serializable_span_context", new CommonMoshiJsonAdapter().toJson(SerializableSpanContext.builder().traceId(SpanExtension.current().getSpanContext().getTraceId()).spanId(SpanExtension.current().getSpanContext().getSpanId()).traceFlags(SpanExtension.current().getSpanContext().getTraceFlags().asByte()).build()));
        return intent;
    }

    public static Fragment getAuthorizationFragmentFromStartIntent(@NonNull Intent intent) {
        AuthorizationAgent authorizationAgent = (AuthorizationAgent)intent.getSerializableExtra("com.microsoft.identity.client.authorization.agent");
        Telemetry.emit((BaseEvent)new UiStartEvent().putUserAgent(authorizationAgent));
        LibraryConfiguration libraryConfig = LibraryConfiguration.getInstance();
        AuthorizationFragment fragment = authorizationAgent == AuthorizationAgent.WEBVIEW ? new WebViewAuthorizationFragment() : (libraryConfig.isAuthorizationInCurrentTask() ? new CurrentTaskBrowserAuthorizationFragment() : new BrowserAuthorizationFragment());
        return fragment;
    }

    public static Fragment getAuthorizationFragmentFromStartIntentWithState(@NonNull Intent intent, @NonNull Bundle bundle) {
        Fragment fragment = AuthorizationActivityFactory.getAuthorizationFragmentFromStartIntent(intent);
        if (fragment instanceof AuthorizationFragment) {
            AuthorizationFragment authFragment = (AuthorizationFragment)fragment;
            authFragment.setInstanceState(bundle);
        }
        return fragment;
    }

    public static Intent signInWithGoogleAndGetAuthorizationActivityIntent(Context context, Intent authIntent, String requestUrl, String redirectUri, HashMap<String, String> requestHeaders, AuthorizationAgent authorizationAgent, boolean webViewZoomEnabled, boolean webViewZoomControlsEnabled, String sourceLibraryName, String sourceLibraryVersion, @NonNull SignInWithGoogleParameters signInWithGoogleParameters) throws ClientException {
        SignInWithGoogleCredential signInWithGoogleCredential = SignInWithGoogleApi.getInstance().signInSync(signInWithGoogleParameters);
        return AuthorizationActivityFactory.getAuthorizationActivityIntent(context, authIntent, requestUrl, redirectUri, requestHeaders, authorizationAgent, webViewZoomEnabled, webViewZoomControlsEnabled, sourceLibraryName, sourceLibraryVersion, signInWithGoogleCredential);
    }

    public static Intent getAuthorizationActivityIntent(Context context, Intent authIntent, String requestUrl, String redirectUri, HashMap<String, String> requestHeaders, AuthorizationAgent authorizationAgent, boolean webViewZoomEnabled, boolean webViewZoomControlsEnabled, String sourceLibraryName, String sourceLibraryVersion, @NonNull SignInWithGoogleCredential signInWithGoogleCredential) throws ClientException {
        String requestUrlWithIdProvider;
        HashMap<String, String> requestHeadersWithGoogleAuthCredential = requestHeaders == null ? new HashMap<String, String>() : new HashMap<String, String>(requestHeaders);
        requestHeadersWithGoogleAuthCredential.putAll(MsaFederationExtensions.getIdProviderHeadersForAuthorization(signInWithGoogleCredential));
        try {
            CommonURIBuilder uriBuilder = new CommonURIBuilder(requestUrl);
            Map.Entry<String, String> extraQueryParamForAuthorization = MsaFederationExtensions.getIdProviderExtraQueryParamForAuthorization(signInWithGoogleCredential);
            uriBuilder.addParameterIfAbsent(extraQueryParamForAuthorization.getKey(), extraQueryParamForAuthorization.getValue());
            requestUrlWithIdProvider = uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new ClientException("malformed_url", "Failed to add id provider query parameter to request URL", (Throwable)e);
        }
        return AuthorizationActivityFactory.getAuthorizationActivityIntent(context, authIntent, requestUrlWithIdProvider, redirectUri, requestHeadersWithGoogleAuthCredential, authorizationAgent, webViewZoomEnabled, webViewZoomControlsEnabled, sourceLibraryName, sourceLibraryVersion);
    }
}

