/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.browser;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.microsoft.identity.common.internal.providers.oauth2.AndroidAuthorizationStrategy;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationActivityFactory;
import com.microsoft.identity.common.internal.ui.browser.CustomTabsManager;
import com.microsoft.identity.common.java.browser.Browser;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.providers.RawAuthorizationResult;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.java.ui.AuthorizationAgent;
import com.microsoft.identity.common.java.util.ResultFuture;
import com.microsoft.identity.common.logging.Logger;
import java.net.URI;
import java.util.concurrent.Future;

public abstract class BrowserAuthorizationStrategy<GenericOAuth2Strategy extends OAuth2Strategy, GenericAuthorizationRequest extends AuthorizationRequest>
extends AndroidAuthorizationStrategy<GenericOAuth2Strategy, GenericAuthorizationRequest> {
    private static final String TAG = BrowserAuthorizationStrategy.class.getSimpleName();
    private CustomTabsManager mCustomTabManager;
    private ResultFuture<AuthorizationResult> mAuthorizationResultFuture;
    private boolean mDisposed;
    private GenericOAuth2Strategy mOAuth2Strategy;
    private GenericAuthorizationRequest mAuthorizationRequest;
    private final Browser mBrowser;

    public BrowserAuthorizationStrategy(@NonNull Context applicationContext, @NonNull Activity activity, @Nullable Fragment fragment, @NonNull Browser browser) {
        super(applicationContext, activity, fragment);
        this.mBrowser = browser;
    }

    public Future<AuthorizationResult> requestAuthorization(GenericAuthorizationRequest authorizationRequest, GenericOAuth2Strategy oAuth2Strategy) throws ClientException {
        Intent authIntent;
        String methodTag = TAG + ":requestAuthorization";
        this.checkNotDisposed();
        Context context = this.getApplicationContext();
        this.mOAuth2Strategy = oAuth2Strategy;
        this.mAuthorizationRequest = authorizationRequest;
        this.mAuthorizationResultFuture = new ResultFuture();
        if (this.mBrowser.isCustomTabsServiceSupported()) {
            Logger.info(methodTag, "CustomTabsService is supported.");
            this.mCustomTabManager = new CustomTabsManager(context);
            authIntent = !this.mCustomTabManager.bind(context, this.mBrowser.getPackageName()) ? new Intent("android.intent.action.VIEW") : this.mCustomTabManager.getCustomTabsIntent().intent;
        } else {
            Logger.warn(methodTag, "CustomTabsService is NOT supported");
            authIntent = new Intent("android.intent.action.VIEW");
        }
        authIntent.setPackage(this.mBrowser.getPackageName());
        URI requestUrl = authorizationRequest.getAuthorizationRequestAsHttpRequest();
        authIntent.setData(Uri.parse((String)requestUrl.toString()));
        Intent intent = this.buildAuthorizationActivityStartIntent(authIntent, requestUrl);
        this.launchIntent(intent);
        return this.mAuthorizationResultFuture;
    }

    private Intent buildAuthorizationActivityStartIntent(Intent authIntent, URI requestUrl) {
        String redirectUri = this.mAuthorizationRequest.getBrkRedirectUri() != null ? this.mAuthorizationRequest.getBrkRedirectUri() : this.mAuthorizationRequest.getRedirectUri();
        Intent intent = AuthorizationActivityFactory.getAuthorizationActivityIntent(this.getApplicationContext(), authIntent, requestUrl.toString(), redirectUri, this.mAuthorizationRequest.getRequestHeaders(), AuthorizationAgent.BROWSER, true, true);
        this.setIntentFlag(intent);
        return intent;
    }

    protected abstract void setIntentFlag(@NonNull Intent var1);

    private void checkNotDisposed() {
        if (this.mDisposed) {
            throw new IllegalStateException("Service has been disposed and rendered inoperable");
        }
    }

    public void completeAuthorization(int requestCode, @NonNull RawAuthorizationResult data) {
        String methodTag = TAG + ":completeAuthorization";
        if (requestCode == 1001) {
            this.dispose();
            AuthorizationResult result = this.mOAuth2Strategy.getAuthorizationResultFactory().createAuthorizationResult(data, this.mAuthorizationRequest);
            this.mAuthorizationResultFuture.setResult((Object)result);
        } else {
            Logger.warnPII(methodTag, "Unknown request code " + requestCode);
        }
    }

    public void dispose() {
        if (this.mDisposed) {
            return;
        }
        if (this.mCustomTabManager != null) {
            this.mCustomTabManager.unbind();
        }
        this.mDisposed = true;
    }
}

