/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.telemetry;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.telemetry.Properties;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class TelemetryContext
extends Properties {
    private static final String TAG = TelemetryContext.class.getSimpleName();

    TelemetryContext(ConcurrentHashMap<String, String> delegate) {
        super(delegate);
    }

    static synchronized TelemetryContext create(Context context) {
        TelemetryContext telemetryContext = new TelemetryContext(new ConcurrentHashMap<String, String>());
        telemetryContext.addApplicationInfo(context);
        telemetryContext.addDeviceInfo(context);
        telemetryContext.addOsInfo();
        telemetryContext.put("Microsoft.MSAL.time_zone", TimeZone.getDefault().getID());
        return telemetryContext;
    }

    void addApplicationInfo(@NonNull Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            this.put("Microsoft.MSAL.application_name", packageInfo.applicationInfo.packageName);
            this.put("Microsoft.MSAL.application_version", packageInfo.versionName);
            this.put("Microsoft.MSAL.application_build", String.valueOf(packageInfo.versionCode));
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.warn(TAG, "Unable to find the app's package name from PackageManager.");
        }
    }

    void addDeviceInfo(@NonNull Context context) {
        this.put("Microsoft.MSAL.device_manufacturer", Build.MANUFACTURER);
        this.put("Microsoft.MSAL.device_model", Build.MODEL);
        this.put("Microsoft.MSAL.device_name", Build.DEVICE);
        try {
            this.put("Microsoft.MSAL.device_id", StringExtensions.createHash(Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id")));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException exception) {
            Logger.warn(TAG, "Unable to get the device id.");
        }
    }

    void addOsInfo() {
        this.put("Microsoft.MSAL.os_name", "android");
        this.put("Microsoft.MSAL.os_version", Build.VERSION.RELEASE);
        if (Build.VERSION.SDK_INT >= 23) {
            this.put("Microsoft.MSAL.security_patch", Build.VERSION.SECURITY_PATCH);
        }
    }

    public void isNetworkDisabledFromOptimizations(boolean isDozed) {
        this.put("Microsoft.MSAL.power_optimization", String.valueOf(isDozed));
    }

    public void isNetworkConnected(boolean isConnected) {
        this.put("Microsoft.MSAL.network_connection", String.valueOf(isConnected));
    }
}

