/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.microsoft.identity.common.adal.internal.net.HttpWebRequest;
import com.microsoft.identity.common.exception.ArgumentException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.authorities.Authority;
import com.microsoft.identity.common.internal.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.commands.parameters.CommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.DeviceCodeFlowCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.TokenCommandParameters;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResponse;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsTokenRequest;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResponse;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStatus;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStrategy;
import com.microsoft.identity.common.internal.providers.oauth2.IResult;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2StrategyParameters;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResult;
import com.microsoft.identity.common.internal.request.SdkType;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.LocalAuthenticationResult;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.ApiEndEvent;
import com.microsoft.identity.common.internal.telemetry.events.ApiStartEvent;
import com.microsoft.identity.common.internal.ui.AuthorizationStrategyFactory;
import com.microsoft.identity.common.internal.util.ThreadUtils;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class LocalMSALController
extends BaseController {
    private static final String TAG = LocalMSALController.class.getSimpleName();
    private AuthorizationStrategy mAuthorizationStrategy = null;
    private AuthorizationRequest mAuthorizationRequest = null;

    @Override
    public AcquireTokenResult acquireToken(@NonNull InteractiveTokenCommandParameters parameters) throws ExecutionException, InterruptedException, ClientException, IOException, ArgumentException {
        String methodName = ":acquireToken";
        Logger.verbose(TAG + ":acquireToken", "Acquiring token...");
        Telemetry.emit(new ApiStartEvent().putProperties(parameters).putApiId("101"));
        AcquireTokenResult acquireTokenResult = new AcquireTokenResult();
        parameters.validate();
        Set<String> mergedScopes = this.addDefaultScopes(parameters);
        TokenCommandParameters parametersWithScopes = ((InteractiveTokenCommandParameters.InteractiveTokenCommandParametersBuilder)parameters.toBuilder().scopes(mergedScopes)).build();
        this.logParameters(TAG, parametersWithScopes);
        HttpWebRequest.throwIfNetworkNotAvailable(parametersWithScopes.getAndroidApplicationContext(), parametersWithScopes.isPowerOptCheckEnabled());
        Authority.KnownAuthorityResult authorityResult = Authority.getKnownAuthorityResult(parametersWithScopes.getAuthority());
        if (!authorityResult.getKnown()) {
            Telemetry.emit(new ApiEndEvent().putException(authorityResult.getClientException()).putApiId("101"));
            throw authorityResult.getClientException();
        }
        OAuth2StrategyParameters strategyParameters = new OAuth2StrategyParameters();
        strategyParameters.setContext(parametersWithScopes.getAndroidApplicationContext());
        OAuth2Strategy oAuth2Strategy = parametersWithScopes.getAuthority().createOAuth2Strategy(strategyParameters);
        AuthorizationResult result = this.performAuthorizationRequest(oAuth2Strategy, parametersWithScopes.getAndroidApplicationContext(), (InteractiveTokenCommandParameters)parametersWithScopes);
        acquireTokenResult.setAuthorizationResult(result);
        LocalMSALController.logResult(TAG, result);
        if (result.getAuthorizationStatus().equals((Object)AuthorizationStatus.SUCCESS)) {
            TokenResult tokenResult = this.performTokenRequest(oAuth2Strategy, this.mAuthorizationRequest, (AuthorizationResponse)result.getAuthorizationResponse(), (InteractiveTokenCommandParameters)parametersWithScopes);
            acquireTokenResult.setTokenResult(tokenResult);
            if (tokenResult != null && tokenResult.getSuccess()) {
                List<ICacheRecord> records = this.saveTokens(oAuth2Strategy, this.mAuthorizationRequest, tokenResult.getTokenResponse(), parametersWithScopes.getOAuth2TokenCache());
                ICacheRecord newestRecord = records.get(0);
                acquireTokenResult.setLocalAuthenticationResult(new LocalAuthenticationResult(this.finalizeCacheRecordForResult(newestRecord, parametersWithScopes.getAuthenticationScheme()), records, SdkType.MSAL, false));
            }
        }
        Telemetry.emit(new ApiEndEvent().putResult(acquireTokenResult).putApiId("101"));
        return acquireTokenResult;
    }

    private AuthorizationResult performAuthorizationRequest(@NonNull OAuth2Strategy strategy, @NonNull Context context, @NonNull InteractiveTokenCommandParameters parameters) throws ExecutionException, InterruptedException, ClientException {
        HttpWebRequest.throwIfNetworkNotAvailable(context, parameters.isPowerOptCheckEnabled());
        this.mAuthorizationStrategy = AuthorizationStrategyFactory.getInstance().getAuthorizationStrategy(parameters);
        this.mAuthorizationRequest = this.getAuthorizationRequest(strategy, parameters);
        Future<AuthorizationResult> future = strategy.requestAuthorization(this.mAuthorizationRequest, this.mAuthorizationStrategy);
        AuthorizationResult result = future.get();
        return result;
    }

    @Override
    public void completeAcquireToken(int requestCode, int resultCode, Intent data) {
        String methodName = ":completeAcquireToken";
        Logger.verbose(TAG + ":completeAcquireToken", "Completing acquire token...");
        Telemetry.emit(new ApiStartEvent().putApiId("1032").put("Microsoft.MSAL.result_code", String.valueOf(resultCode)).put("Microsoft.MSAL.request_code", String.valueOf(requestCode)));
        this.mAuthorizationStrategy.completeAuthorization(requestCode, resultCode, data);
        Telemetry.emit(new ApiEndEvent().putApiId("1032"));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public AcquireTokenResult acquireTokenSilent(@NonNull SilentTokenCommandParameters parameters) throws IOException, ClientException, ArgumentException, ServiceException {
        String methodName = ":acquireTokenSilent";
        Logger.verbose(TAG + ":acquireTokenSilent", "Acquiring token silently...");
        Telemetry.emit(new ApiStartEvent().putProperties(parameters).putApiId("103"));
        AcquireTokenResult acquireTokenSilentResult = new AcquireTokenResult();
        parameters.validate();
        Set<String> mergedScopes = this.addDefaultScopes(parameters);
        TokenCommandParameters parametersWithScopes = ((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)parameters.toBuilder().scopes(mergedScopes)).build();
        OAuth2TokenCache tokenCache = parametersWithScopes.getOAuth2TokenCache();
        AccountRecord targetAccount = this.getCachedAccountRecord((SilentTokenCommandParameters)parametersWithScopes);
        AbstractAuthenticationScheme authScheme = parametersWithScopes.getAuthenticationScheme();
        OAuth2StrategyParameters strategyParameters = new OAuth2StrategyParameters();
        strategyParameters.setContext(parametersWithScopes.getAndroidApplicationContext());
        OAuth2Strategy strategy = parametersWithScopes.getAuthority().createOAuth2Strategy(strategyParameters);
        List<ICacheRecord> cacheRecords = tokenCache.loadWithAggregatedAccountData(parametersWithScopes.getClientId(), TextUtils.join((CharSequence)" ", parametersWithScopes.getScopes()), targetAccount, authScheme);
        ICacheRecord fullCacheRecord = cacheRecords.get(0);
        if (this.accessTokenIsNull(fullCacheRecord) || this.refreshTokenIsNull(fullCacheRecord) || parametersWithScopes.isForceRefresh() || !this.isRequestAuthorityRealmSameAsATRealm(parametersWithScopes.getAuthority(), fullCacheRecord.getAccessToken()) || !strategy.validateCachedResult(authScheme, fullCacheRecord)) {
            if (this.refreshTokenIsNull(fullCacheRecord)) {
                ClientException exception = new ClientException("no_tokens_found", "No refresh token was found. ");
                Telemetry.emit(new ApiEndEvent().putException(exception).putApiId("103"));
                throw exception;
            }
            Logger.verbose(TAG + ":acquireTokenSilent", "No access token found, but RT is available.");
            this.renewAccessToken((SilentTokenCommandParameters)parametersWithScopes, acquireTokenSilentResult, tokenCache, strategy, fullCacheRecord);
        } else if (fullCacheRecord.getAccessToken().isExpired()) {
            Logger.warn(TAG + ":acquireTokenSilent", "Access token is expired. Removing from cache...");
            tokenCache.removeCredential(fullCacheRecord.getAccessToken());
            Logger.verbose(TAG + ":acquireTokenSilent", "Renewing access token...");
            this.renewAccessToken((SilentTokenCommandParameters)parametersWithScopes, acquireTokenSilentResult, tokenCache, strategy, fullCacheRecord);
        } else {
            Logger.verbose(TAG + ":acquireTokenSilent", "Returning silent result");
            acquireTokenSilentResult.setLocalAuthenticationResult(new LocalAuthenticationResult(this.finalizeCacheRecordForResult(fullCacheRecord, parametersWithScopes.getAuthenticationScheme()), cacheRecords, SdkType.MSAL, true));
        }
        Telemetry.emit(new ApiEndEvent().putResult(acquireTokenSilentResult).putApiId("103"));
        return acquireTokenSilentResult;
    }

    @Override
    @WorkerThread
    public List<ICacheRecord> getAccounts(@NonNull CommandParameters parameters) {
        Telemetry.emit(new ApiStartEvent().putProperties(parameters).putApiId("106"));
        List<ICacheRecord> accountsInCache = parameters.getOAuth2TokenCache().getAccountsWithAggregatedAccountData(null, parameters.getClientId());
        Telemetry.emit(new ApiEndEvent().putApiId("106").put("Microsoft.MSAL.accounts_number", Integer.toString(accountsInCache.size())).put("_is_successful", "true"));
        return accountsInCache;
    }

    @Override
    @WorkerThread
    public boolean removeAccount(@NonNull RemoveAccountCommandParameters parameters) {
        Telemetry.emit(new ApiStartEvent().putProperties(parameters).putApiId("107"));
        String realm = null;
        if (parameters.getAccount() != null) {
            realm = parameters.getAccount().getRealm();
        }
        boolean localRemoveAccountSuccess = !parameters.getOAuth2TokenCache().removeAccount(parameters.getAccount() == null ? null : parameters.getAccount().getEnvironment(), parameters.getClientId(), parameters.getAccount() == null ? null : parameters.getAccount().getHomeAccountId(), realm).isEmpty();
        Telemetry.emit(new ApiEndEvent().put("_is_successful", String.valueOf(localRemoveAccountSuccess)).putApiId("107"));
        return localRemoveAccountSuccess;
    }

    @Override
    public boolean getDeviceMode(CommandParameters parameters) throws Exception {
        String methodName = ":getDeviceMode";
        String errorMessage = "LocalMSALController is not eligible to use the broker. Do not check sharedDevice mode and return false immediately.";
        Logger.warn(TAG + ":getDeviceMode", "LocalMSALController is not eligible to use the broker. Do not check sharedDevice mode and return false immediately.");
        return false;
    }

    @Override
    public List<ICacheRecord> getCurrentAccount(CommandParameters parameters) throws Exception {
        return this.getAccounts(parameters);
    }

    @Override
    public boolean removeCurrentAccount(RemoveAccountCommandParameters parameters) throws Exception {
        return this.removeAccount(parameters);
    }

    @Override
    public AuthorizationResult deviceCodeFlowAuthRequest(DeviceCodeFlowCommandParameters parameters) throws ServiceException, ClientException, IOException {
        AuthorizationResult authorizationResult;
        String methodName = ":deviceCodeFlowAuthRequest";
        Logger.verbose(TAG + ":deviceCodeFlowAuthRequest", "Device Code Flow: Authorizing user code...");
        Set<String> mergedScopes = this.addDefaultScopes(parameters);
        TokenCommandParameters parametersWithScopes = ((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)parameters.toBuilder().scopes(mergedScopes)).build();
        this.logParameters(TAG, parametersWithScopes);
        Telemetry.emit(new ApiStartEvent().putProperties(parametersWithScopes).putApiId("108"));
        Authority.KnownAuthorityResult authorityResult = Authority.getKnownAuthorityResult(parametersWithScopes.getAuthority());
        if (!authorityResult.getKnown()) {
            Telemetry.emit(new ApiEndEvent().putException(authorityResult.getClientException()).putApiId("108"));
            throw authorityResult.getClientException();
        }
        try {
            OAuth2StrategyParameters strategyParameters = new OAuth2StrategyParameters();
            strategyParameters.setContext(parametersWithScopes.getAndroidApplicationContext());
            OAuth2Strategy oAuth2Strategy = parametersWithScopes.getAuthority().createOAuth2Strategy(strategyParameters);
            this.mAuthorizationRequest = this.getAuthorizationRequest(oAuth2Strategy, parametersWithScopes);
            authorizationResult = oAuth2Strategy.getDeviceCode((MicrosoftStsAuthorizationRequest)this.mAuthorizationRequest);
            this.validateServiceResult(authorizationResult);
        }
        catch (Exception error) {
            Telemetry.emit(new ApiEndEvent().putException(error).putApiId("108"));
            throw error;
        }
        Logger.verbose(TAG + ":deviceCodeFlowAuthRequest", "Device Code Flow authorization step finished...");
        LocalMSALController.logResult(TAG, authorizationResult);
        Telemetry.emit(new ApiEndEvent().putApiId("108"));
        return authorizationResult;
    }

    @Override
    public AcquireTokenResult acquireDeviceCodeFlowToken(AuthorizationResult authorizationResult, DeviceCodeFlowCommandParameters parameters) throws ServiceException, ClientException, IOException {
        String methodName = ":acquireDeviceCodeFlowToken";
        Logger.verbose(TAG + ":acquireDeviceCodeFlowToken", "Device Code Flow: Polling for token...");
        Telemetry.emit(new ApiStartEvent().putApiId("109"));
        AcquireTokenResult acquireTokenResult = new AcquireTokenResult();
        acquireTokenResult.setAuthorizationResult(authorizationResult);
        MicrosoftStsAuthorizationResponse authorizationResponse = (MicrosoftStsAuthorizationResponse)authorizationResult.getAuthorizationResponse();
        TokenResult tokenResult = null;
        try {
            OAuth2StrategyParameters strategyParameters = new OAuth2StrategyParameters();
            strategyParameters.setContext(parameters.getAndroidApplicationContext());
            OAuth2Strategy oAuth2Strategy = parameters.getAuthority().createOAuth2Strategy(strategyParameters);
            MicrosoftStsTokenRequest tokenRequest = (MicrosoftStsTokenRequest)oAuth2Strategy.createTokenRequest(this.mAuthorizationRequest, authorizationResponse, parameters.getAuthenticationScheme());
            int intervalInMilliseconds = Integer.parseInt(authorizationResponse.getInterval()) * 1000;
            String errorCode = "authorization_pending";
            while (this.authorizationPending(errorCode)) {
                ThreadUtils.sleepSafely(intervalInMilliseconds, TAG, "Attempting to sleep thread during Device Code Flow token polling...");
                errorCode = "";
                tokenResult = (TokenResult)oAuth2Strategy.requestToken(tokenRequest);
                if (tokenResult.getErrorResponse() == null) continue;
                errorCode = tokenResult.getErrorResponse().getError();
            }
            this.validateServiceResult(tokenResult);
            acquireTokenResult.setTokenResult(tokenResult);
            List<ICacheRecord> records = this.saveTokens(oAuth2Strategy, this.mAuthorizationRequest, acquireTokenResult.getTokenResult().getTokenResponse(), parameters.getOAuth2TokenCache());
            ICacheRecord newestRecord = records.get(0);
            acquireTokenResult.setLocalAuthenticationResult(new LocalAuthenticationResult(this.finalizeCacheRecordForResult(newestRecord, parameters.getAuthenticationScheme()), records, SdkType.MSAL, false));
        }
        catch (Exception error) {
            Telemetry.emit(new ApiEndEvent().putException(error).putApiId("109"));
            throw error;
        }
        LocalMSALController.logResult(TAG, tokenResult);
        Telemetry.emit(new ApiEndEvent().putResult(acquireTokenResult).putApiId("109"));
        return acquireTokenResult;
    }

    private boolean authorizationPending(@NonNull String errorCode) {
        return errorCode.equals("authorization_pending");
    }

    private void validateServiceResult(@NonNull IResult result) throws ServiceException {
        if (!result.getSuccess()) {
            String errorMessage;
            String errorCode;
            switch (errorCode = result.getErrorResponse().getError()) {
                case "authorization_declined": {
                    errorMessage = "The end user has denied the authorization request. Re-run the Device Code Flow Protocol with another user.";
                    break;
                }
                case "expired_token": {
                    errorMessage = "The token has expired, therefore authentication is no longer possible with this flow attempt. Re-run the Device Code Flow Protocol to try again.";
                    break;
                }
                case "bad_verification_code": {
                    errorMessage = "The token request contains a device code that was not recognized. Verify that the client is sending the right device code.";
                    break;
                }
                case "invalid_grant": {
                    errorMessage = "The token for this device code has already been redeemed. To receive another access token, please re-run the Device Code Flow protocol.";
                    break;
                }
                case "invalid_scope": {
                    errorMessage = "The scope attached to the device code flow request is invalid. Please re-try with a valid scope.";
                    break;
                }
                default: {
                    errorMessage = "Device Code Flow has failed with an unexpected error. The error code shown was received from the result object.";
                }
            }
            throw new ServiceException(errorCode, errorMessage, 0, null);
        }
    }
}

