/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.migration;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.authscheme.BearerAuthenticationSchemeInternal;
import com.microsoft.identity.common.internal.cache.ADALTokenCacheItem;
import com.microsoft.identity.common.internal.cache.BrokerOAuth2TokenCache;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.cache.ITokenCacheItem;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.migration.AdalMigrationAdapter;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftTokenResponse;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAccount;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Configuration;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsTokenRequest;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsTokenResponse;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2StrategyParameters;
import com.microsoft.identity.common.internal.providers.oauth2.TokenErrorResponse;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResult;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TokenCacheItemMigrationAdapter {
    private static final String TAG = TokenCacheItemMigrationAdapter.class.getSimpleName();
    private static final String COMMON = "/common";
    public static final ExecutorService sBackgroundExecutor = Executors.newCachedThreadPool();
    private static final String RESOURCE_DEFAULT_SCOPE = "/.default";

    public static List<Pair<MicrosoftAccount, MicrosoftRefreshToken>> migrateTokens(@NonNull Map<String, String> redirects, @NonNull Collection<ADALTokenCacheItem> cacheItems) {
        ArrayList<Pair<MicrosoftAccount, MicrosoftRefreshToken>> result = new ArrayList<Pair<MicrosoftAccount, MicrosoftRefreshToken>>();
        boolean cloudMetadataLoaded = AdalMigrationAdapter.loadCloudDiscoveryMetadata();
        if (cloudMetadataLoaded) {
            List<ADALTokenCacheItem> cacheItemsWithoutDuplicates = TokenCacheItemMigrationAdapter.filterDuplicateTokens(cacheItems);
            Map<String, List<ADALTokenCacheItem>> tokensByClientId = TokenCacheItemMigrationAdapter.splitTokensByClientId(cacheItemsWithoutDuplicates);
            Map<String, List<ADALTokenCacheItem>> filteredTokens = TokenCacheItemMigrationAdapter.preferentiallySelectTokens(tokensByClientId);
            ArrayList<ADALTokenCacheItem> cacheItemsToRenew = new ArrayList<ADALTokenCacheItem>();
            for (List<ADALTokenCacheItem> cacheItemList : filteredTokens.values()) {
                cacheItemsToRenew.addAll(cacheItemList);
            }
            result.addAll(TokenCacheItemMigrationAdapter.renewTokens(redirects, cacheItemsToRenew));
        }
        return result;
    }

    public static boolean tryFociTokenWithGivenClientId(@NonNull BrokerOAuth2TokenCache brokerOAuth2TokenCache, @NonNull String clientId, @NonNull String redirectUri, @NonNull ICacheRecord cacheRecord) throws ClientException, IOException {
        String methodName = ":tryFociTokenWithGivenClientId";
        MicrosoftStsOAuth2Configuration config = new MicrosoftStsOAuth2Configuration();
        Uri.Builder requestUrlBuilder = new Uri.Builder();
        String tenantId = cacheRecord.getAccount().getRealm();
        requestUrlBuilder.scheme("https").authority(cacheRecord.getRefreshToken().getEnvironment()).appendPath(StringUtil.isEmpty(tenantId) ? "common" : tenantId);
        URL authorityUrl = new URL(requestUrlBuilder.build().toString());
        config.setAuthorityUrl(authorityUrl);
        OAuth2StrategyParameters strategyParameters = new OAuth2StrategyParameters();
        MicrosoftStsOAuth2Strategy strategy = new MicrosoftStsOAuth2Strategy(config, strategyParameters);
        String refreshToken = cacheRecord.getRefreshToken().getSecret();
        String scopes = BaseController.getDelimitedDefaultScopeString();
        UUID correlationId = UUID.randomUUID();
        Logger.verbose(TAG + ":tryFociTokenWithGivenClientId", "Create the token request with correlationId [" + correlationId + "]");
        MicrosoftStsTokenRequest tokenRequest = TokenCacheItemMigrationAdapter.createTokenRequest(clientId, scopes, refreshToken, redirectUri, strategy, correlationId, "2");
        Logger.verbose(TAG + ":tryFociTokenWithGivenClientId", "Start refreshing token with correlationId [" + correlationId + "]");
        Object tokenResult = strategy.requestToken(tokenRequest);
        Logger.verbose(TAG + ":tryFociTokenWithGivenClientId", "Is the client ID able to use the foci? [" + ((TokenResult)tokenResult).getSuccess() + "] with correlationId [" + correlationId + "]");
        if (((TokenResult)tokenResult).getSuccess()) {
            MicrosoftStsAuthorizationRequest authorizationRequest = TokenCacheItemMigrationAdapter.createAuthRequest(strategy, cacheRecord, clientId, redirectUri, scopes, correlationId);
            Logger.verbose(TAG + ":tryFociTokenWithGivenClientId", "Saving records to cache with client id" + clientId);
            brokerOAuth2TokenCache.save(strategy, authorizationRequest, (MicrosoftTokenResponse)((TokenResult)tokenResult).getTokenResponse());
        }
        return ((TokenResult)tokenResult).getSuccess();
    }

    private static List<Pair<MicrosoftAccount, MicrosoftRefreshToken>> renewTokens(final @NonNull Map<String, String> redirects, final @NonNull List<ADALTokenCacheItem> filteredTokens) {
        final ArrayList<Pair<MicrosoftAccount, MicrosoftRefreshToken>> result = new ArrayList<Pair<MicrosoftAccount, MicrosoftRefreshToken>>();
        int tokenCount = filteredTokens.size();
        final CountDownLatch latch = new CountDownLatch(tokenCount);
        int ii = 0;
        while (ii < tokenCount) {
            final int subIndex = ii++;
            sBackgroundExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    ADALTokenCacheItem targetCacheItemToRenew = (ADALTokenCacheItem)filteredTokens.get(subIndex);
                    Pair<MicrosoftAccount, MicrosoftRefreshToken> renewedPair = TokenCacheItemMigrationAdapter.renewToken((String)redirects.get(targetCacheItemToRenew.getClientId()), targetCacheItemToRenew);
                    if (null != renewedPair) {
                        result.add(renewedPair);
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Logger.error(TAG, "Interrupted while requesting tokens...", e);
            Thread.currentThread().interrupt();
        }
        return result;
    }

    @Nullable
    public static Pair<MicrosoftAccount, MicrosoftRefreshToken> renewToken(@Nullable String redirectUri, @NonNull ITokenCacheItem targetCacheItemToRenew) {
        Pair resultPair = null;
        if (!StringExtensions.isNullOrBlank(redirectUri)) {
            try {
                String authority = targetCacheItemToRenew.getAuthority();
                String clientId = targetCacheItemToRenew.getClientId();
                String refreshToken = targetCacheItemToRenew.getRefreshToken();
                MicrosoftStsOAuth2Configuration config = new MicrosoftStsOAuth2Configuration();
                config.setAuthorityUrl(new URL(authority));
                UUID correlationId = UUID.randomUUID();
                String scopes = TextUtils.isEmpty((CharSequence)targetCacheItemToRenew.getResource()) ? BaseController.getDelimitedDefaultScopeString() : TokenCacheItemMigrationAdapter.getScopesForTokenRequest(targetCacheItemToRenew.getResource());
                OAuth2StrategyParameters strategyParameters = new OAuth2StrategyParameters();
                MicrosoftStsOAuth2Strategy strategy = new MicrosoftStsOAuth2Strategy(config, strategyParameters);
                MicrosoftStsTokenRequest tokenRequest = TokenCacheItemMigrationAdapter.createTokenRequest(clientId, scopes, refreshToken, redirectUri, strategy, correlationId, "2");
                Object tokenResult = strategy.requestToken(tokenRequest);
                if (((TokenResult)tokenResult).getSuccess()) {
                    MicrosoftStsTokenResponse tokenResponse = (MicrosoftStsTokenResponse)((TokenResult)tokenResult).getTokenResponse();
                    tokenResponse.setClientId(clientId);
                    MicrosoftStsAccount account = strategy.createAccount(tokenResponse);
                    MicrosoftStsRefreshToken msStsRt = new MicrosoftStsRefreshToken(tokenResponse);
                    msStsRt.setEnvironment(AzureActiveDirectory.getAzureActiveDirectoryCloud(new URL(authority)).getPreferredCacheHostName());
                    resultPair = new Pair((Object)account, (Object)msStsRt);
                } else {
                    Logger.warn(TAG, correlationId.toString(), "TokenRequest was unsuccessful.");
                    if (null != ((TokenResult)tokenResult).getErrorResponse()) {
                        TokenCacheItemMigrationAdapter.logTokenResultError(correlationId, tokenResult);
                    }
                }
            }
            catch (Exception e) {
                Logger.errorPII(TAG, "Failed to request new refresh token...", e);
            }
        }
        return resultPair;
    }

    @NonNull
    public static List<ADALTokenCacheItem> filterDuplicateTokens(@NonNull Collection<ADALTokenCacheItem> cacheItems) {
        ArrayList<ADALTokenCacheItem> cacheItemsFiltered = new ArrayList<ADALTokenCacheItem>();
        HashMap<String, ADALTokenCacheItem> cacheItemMap = new HashMap<String, ADALTokenCacheItem>();
        for (ADALTokenCacheItem cacheItem : cacheItems) {
            if (null == cacheItem.getResource()) {
                Logger.warn(TAG, "Skipping resourceless token.");
                continue;
            }
            if (null == cacheItemMap.get(cacheItem.getRefreshToken())) {
                cacheItemMap.put(cacheItem.getRefreshToken(), cacheItem);
            }
            if (null == cacheItemMap.get(cacheItem.getRefreshToken()) || !cacheItem.getAuthority().contains(COMMON)) continue;
            cacheItemMap.put(cacheItem.getRefreshToken(), cacheItem);
        }
        cacheItemsFiltered.addAll(cacheItemMap.values());
        return cacheItemsFiltered;
    }

    @NonNull
    public static Map<String, List<ADALTokenCacheItem>> splitTokensByClientId(@NonNull List<ADALTokenCacheItem> cacheItemsIn) {
        String methodName = ":splitTokensByClientId";
        Logger.verbose(TAG + ":splitTokensByClientId", "Splitting [" + cacheItemsIn.size() + "] cache items.");
        HashMap<String, List<ADALTokenCacheItem>> cacheItemsOut = new HashMap<String, List<ADALTokenCacheItem>>();
        for (ADALTokenCacheItem cacheItem : cacheItemsIn) {
            if (null == cacheItemsOut.get(cacheItem.getClientId())) {
                cacheItemsOut.put(cacheItem.getClientId(), new ArrayList());
            }
            ((List)cacheItemsOut.get(cacheItem.getClientId())).add(cacheItem);
        }
        return cacheItemsOut;
    }

    public static Map<String, List<ADALTokenCacheItem>> preferentiallySelectTokens(@NonNull Map<String, List<ADALTokenCacheItem>> tokensByClientId) {
        String methodName = ":preferentiallySelectTokens";
        HashMap<String, List<ADALTokenCacheItem>> result = new HashMap<String, List<ADALTokenCacheItem>>();
        for (Map.Entry<String, List<ADALTokenCacheItem>> entry : tokensByClientId.entrySet()) {
            String clientId = entry.getKey();
            List<ADALTokenCacheItem> tokens = entry.getValue();
            ADALTokenCacheItem refreshToken = TokenCacheItemMigrationAdapter.findFrt(tokens);
            if (null == refreshToken) {
                Logger.verbose(TAG + ":preferentiallySelectTokens", "FRT was null. Try MRRT.");
                refreshToken = TokenCacheItemMigrationAdapter.findMrrt(tokens);
            }
            if (null == refreshToken) {
                Logger.verbose(TAG + ":preferentiallySelectTokens", "MRRT was null. Try RT.");
                refreshToken = TokenCacheItemMigrationAdapter.findRt(tokens);
            }
            if (null != refreshToken) {
                if (null == result.get(clientId)) {
                    result.put(clientId, new ArrayList());
                }
                ((List)result.get(clientId)).add(refreshToken);
                continue;
            }
            Logger.warn(TAG + ":preferentiallySelectTokens", "Refresh token could not be located.");
        }
        return result;
    }

    @Nullable
    public static ADALTokenCacheItem findRt(@NonNull List<ADALTokenCacheItem> cacheItems) {
        String methodName = ":findRt";
        ADALTokenCacheItem result = null;
        for (ADALTokenCacheItem cacheItem : cacheItems) {
            if (StringExtensions.isNullOrBlank(cacheItem.getRefreshToken())) continue;
            result = cacheItem;
            Logger.verbose(TAG + ":findRt", "RT found.");
            break;
        }
        return result;
    }

    @Nullable
    public static ADALTokenCacheItem findMrrt(@NonNull List<ADALTokenCacheItem> cacheItems) {
        String methodName = ":findMrrt";
        ADALTokenCacheItem result = null;
        for (ADALTokenCacheItem cacheItem : cacheItems) {
            if (StringExtensions.isNullOrBlank(cacheItem.getRefreshToken()) || !cacheItem.getIsMultiResourceRefreshToken()) continue;
            result = cacheItem;
            Logger.verbose(TAG + ":findMrrt", "Mrrt found.");
            break;
        }
        return result;
    }

    @Nullable
    public static ADALTokenCacheItem findFrt(@NonNull List<ADALTokenCacheItem> cacheItems) {
        String methodName = ":findFrt";
        ADALTokenCacheItem result = null;
        for (ADALTokenCacheItem cacheItem : cacheItems) {
            if (StringExtensions.isNullOrBlank(cacheItem.getRefreshToken()) || StringExtensions.isNullOrBlank(cacheItem.getFamilyClientId())) continue;
            result = cacheItem;
            Logger.verbose(TAG + ":findFrt", "Frt found.");
            break;
        }
        return result;
    }

    @NonNull
    public static String getScopesForTokenRequest(@NonNull String v1Resource) {
        String scopes = TokenCacheItemMigrationAdapter.getScopeFromResource(v1Resource);
        scopes = scopes + " " + BaseController.getDelimitedDefaultScopeString();
        return scopes;
    }

    @NonNull
    public static String getScopeFromResource(@NonNull String resource) {
        return resource + RESOURCE_DEFAULT_SCOPE;
    }

    @NonNull
    public static MicrosoftStsTokenRequest createTokenRequest(@NonNull String clientId, @NonNull String scopes, @NonNull String refreshToken, @NonNull String redirectUri, @NonNull MicrosoftStsOAuth2Strategy strategy, @Nullable UUID correlationId, @NonNull String idTokenVersion) throws ClientException {
        MicrosoftStsTokenRequest tokenRequest = strategy.createRefreshTokenRequest(new BearerAuthenticationSchemeInternal());
        tokenRequest.setClientId(clientId);
        tokenRequest.setScope(scopes);
        tokenRequest.setCorrelationId(correlationId);
        tokenRequest.setRefreshToken(refreshToken);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setIdTokenVersion(idTokenVersion);
        return tokenRequest;
    }

    public static MicrosoftStsAuthorizationRequest createAuthRequest(@NonNull MicrosoftStsOAuth2Strategy strategy, @NonNull ICacheRecord cacheRecord, @NonNull String clientId, @NonNull String redirectUri, @NonNull String scope, @Nullable UUID correlationId) {
        MicrosoftStsAuthorizationRequest.Builder builder = strategy.createAuthorizationRequestBuilder(cacheRecord.getAccount());
        return ((MicrosoftStsAuthorizationRequest.Builder)((MicrosoftStsAuthorizationRequest.Builder)((MicrosoftStsAuthorizationRequest.Builder)((MicrosoftStsAuthorizationRequest.Builder)builder.setClientId(clientId)).setRedirectUri(redirectUri)).setCorrelationId(correlationId)).setScope(scope)).build();
    }

    public static void logTokenResultError(@NonNull UUID correlationId, @NonNull TokenResult tokenResult) {
        TokenErrorResponse tokenErrorResponse = tokenResult.getErrorResponse();
        Logger.warn(TAG, correlationId.toString(), "Status code: [" + tokenErrorResponse.getStatusCode() + "]");
        Logger.warn(TAG, correlationId.toString(), "Error description: [" + tokenErrorResponse.getErrorDescription() + "]");
    }
}

