/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.accounts.AccountManager;
import android.accounts.AuthenticatorDescription;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.broker.MicrosoftAuthServiceConnection;
import com.microsoft.identity.common.internal.broker.MicrosoftAuthServiceFuture;
import com.microsoft.identity.common.internal.logging.Logger;
import java.util.List;

public class MicrosoftAuthClient {
    private static final String TAG = MicrosoftAuthClient.class.getSimpleName();
    private static final String MICROSOFT_AUTH_SERVICE_INTENT_FILTER = "com.microsoft.identity.client.MicrosoftAuth";
    private static final String MICROSOFT_AUTH_SERVICE_CLASS_NAME = "com.microsoft.identity.client.MicrosoftAuthService";
    private Context mContext;
    private MicrosoftAuthServiceConnection mMicrosoftAuthServiceConnection;
    private Intent mMicrosoftAuthServiceIntent;
    private Boolean mBound = false;

    public MicrosoftAuthClient(Context context) {
        this.mContext = context;
        this.mMicrosoftAuthServiceIntent = this.getIntentForAuthService(this.mContext);
    }

    public MicrosoftAuthServiceFuture connect() throws ClientException {
        MicrosoftAuthServiceFuture future = new MicrosoftAuthServiceFuture();
        this.mMicrosoftAuthServiceConnection = new MicrosoftAuthServiceConnection(future);
        this.mBound = this.mContext.bindService(this.mMicrosoftAuthServiceIntent, (ServiceConnection)this.mMicrosoftAuthServiceConnection, 1);
        Logger.info(TAG + "connect", "The status for MicrosoftAuthService bindService call is: " + Boolean.valueOf(this.mBound));
        if (!this.mBound.booleanValue()) {
            throw new ClientException("Service is unavailable or does not support binding.  Microsoft Auth Service.");
        }
        return future;
    }

    public void disconnect() {
        if (this.mBound.booleanValue()) {
            this.mContext.unbindService((ServiceConnection)this.mMicrosoftAuthServiceConnection);
            this.mBound = false;
        }
    }

    public Intent getIntentForAuthService(Context context) {
        String currentActiveBrokerPackageName = this.getCurrentActiveBrokerPackageName(context);
        if (currentActiveBrokerPackageName == null || currentActiveBrokerPackageName.length() == 0) {
            return null;
        }
        Intent authServiceToBind = new Intent(MICROSOFT_AUTH_SERVICE_INTENT_FILTER);
        authServiceToBind.setPackage(currentActiveBrokerPackageName);
        authServiceToBind.setClassName(currentActiveBrokerPackageName, MICROSOFT_AUTH_SERVICE_CLASS_NAME);
        return authServiceToBind;
    }

    private boolean isMicrosoftAuthServiceSupported(@NonNull PackageManager packageManager, @NonNull String packageName) {
        Intent microsoftAuthServiceIntent = new Intent(MICROSOFT_AUTH_SERVICE_INTENT_FILTER);
        microsoftAuthServiceIntent.setPackage(packageName);
        microsoftAuthServiceIntent.setClassName(packageName, MICROSOFT_AUTH_SERVICE_CLASS_NAME);
        List infos = packageManager.queryIntentServices(microsoftAuthServiceIntent, 0);
        return infos != null && infos.size() > 0;
    }

    private String getCurrentActiveBrokerPackageName(@NonNull Context context) {
        AuthenticatorDescription[] authenticators;
        for (AuthenticatorDescription authenticator : authenticators = AccountManager.get((Context)context).getAuthenticatorTypes()) {
            if (!authenticator.type.equals("com.microsoft.workaccount") || !this.isMicrosoftAuthServiceSupported(context.getPackageManager(), authenticator.packageName)) continue;
            return authenticator.packageName;
        }
        return null;
    }
}

