/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.telemetry.adapter;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.telemetry.adapter.ITelemetryAdapter;
import com.microsoft.identity.common.internal.telemetry.observers.ITelemetryAggregatedObserver;
import com.microsoft.identity.common.internal.telemetry.rules.TelemetryAggregationRules;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TelemetryAggregationAdapter
implements ITelemetryAdapter<List<Map<String, String>>> {
    private ITelemetryAggregatedObserver mObserver;
    private final String START = "start";
    private final String END = "end";

    public TelemetryAggregationAdapter(@NonNull ITelemetryAggregatedObserver observer) {
        this.mObserver = observer;
    }

    public ITelemetryAggregatedObserver getObserver() {
        return this.mObserver;
    }

    @Override
    public void process(@NonNull List<Map<String, String>> rawData) {
        HashMap<String, String> aggregatedData = new HashMap<String, String>();
        HashMap<String, String> responseTimeMap = new HashMap<String, String>();
        for (Map<String, String> event : rawData) {
            String eventName = event.get("Microsoft.MSAL.event_name");
            String eventType = event.get("Microsoft.MSAL.event_type");
            if (StringUtil.isEmpty(eventName)) {
                aggregatedData.putAll(this.applyAggregationRule(event));
                continue;
            }
            if (eventName.contains("start")) {
                String eventTypeCountKey = eventType + "_count";
                String currentEventTypeCount = (String)aggregatedData.get(eventTypeCountKey);
                int currentEventTypeCountValue = Integer.parseInt(currentEventTypeCount == null ? "0" : currentEventTypeCount);
                int newEventTypeCountValue = currentEventTypeCountValue + 1;
                aggregatedData.put(eventTypeCountKey, String.valueOf(newEventTypeCountValue));
            }
            if (!StringUtil.isEmpty(event.get("_is_successful"))) {
                aggregatedData.put(eventType + "_is_successful", event.get("_is_successful"));
            }
            this.trackEventResponseTime(responseTimeMap, event);
            aggregatedData.putAll(this.applyAggregationRule(event));
        }
        this.calculateEventResponseTime(responseTimeMap, aggregatedData);
        this.mObserver.onReceived((Map<String, String>)aggregatedData);
    }

    private Map<String, String> applyAggregationRule(@NonNull Map<String, String> properties) {
        HashMap<String, String> nonPiiProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (StringUtil.isEmpty(entry.getValue()) || TelemetryAggregationRules.getInstance().isRedundant(entry.getKey())) continue;
            nonPiiProperties.put(entry.getKey(), entry.getValue());
        }
        return nonPiiProperties;
    }

    private void trackEventResponseTime(@NonNull Map<String, String> responseTimeMap, @NonNull Map<String, String> event) {
        String eventName = event.get("Microsoft.MSAL.event_name");
        String eventType = event.get("Microsoft.MSAL.event_type");
        if (eventName != null && eventName.contains("start")) {
            String eventStartTime = eventType + "_start_time";
            responseTimeMap.put(eventStartTime, event.get("Microsoft.MSAL.occur_time"));
        }
        if (eventName != null && eventName.contains("end")) {
            String eventEndTime = eventType + "_end_time";
            responseTimeMap.put(eventEndTime, event.get("Microsoft.MSAL.occur_time"));
        }
    }

    private void calculateEventResponseTime(@NonNull Map<String, String> responseTimeMap, @NonNull Map<String, String> aggregatedData) {
        for (Map.Entry<String, String> entry : responseTimeMap.entrySet()) {
            String eventEndTimeKey;
            String eventEndTimeValue;
            String entryKey = entry.getKey();
            if (!entryKey.contains("start") || (eventEndTimeValue = responseTimeMap.get(eventEndTimeKey = entryKey.replace("start", "end"))) == null) continue;
            String eventResponseTimeKey = entryKey.replace("start", "response");
            long startTime = Long.parseLong(entry.getValue());
            long endTime = Long.parseLong(eventEndTimeValue);
            aggregatedData.put(eventResponseTimeKey, String.valueOf(endTime - startTime));
        }
    }
}

