/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.request;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.internal.authorities.Authority;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.internal.authscheme.BearerAuthenticationSchemeInternal;
import com.microsoft.identity.common.internal.broker.BrokerRequest;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.commands.parameters.BrokerInteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.BrokerSilentTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.CommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.TokenCommandParameters;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.migration.TokenCacheItemMigrationAdapter;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectorySlice;
import com.microsoft.identity.common.internal.providers.oauth2.OpenIdConnectPromptParameter;
import com.microsoft.identity.common.internal.request.IBrokerRequestAdapter;
import com.microsoft.identity.common.internal.request.SdkType;
import com.microsoft.identity.common.internal.result.AdalBrokerResultAdapter;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;

public class AdalBrokerRequestAdapter
implements IBrokerRequestAdapter {
    private static final String TAG = AdalBrokerResultAdapter.class.getName();

    @Override
    public BrokerRequest brokerRequestFromAcquireTokenParameters(InteractiveTokenCommandParameters parameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BrokerRequest brokerRequestFromSilentOperationParameters(SilentTokenCommandParameters parameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BrokerInteractiveTokenCommandParameters brokerInteractiveParametersFromActivity(@NonNull Activity callingActivity) {
        String methodName = "brokerInteractiveParametersFromActivity";
        Logger.verbose(TAG + "brokerInteractiveParametersFromActivity", "Constructing BrokerAcquireTokenOperationParameters from activity ");
        Intent intent = callingActivity.getIntent();
        int callingAppUid = intent.getIntExtra("caller.info.uid", 0);
        boolean callerPackageNameProvided = this.packageNameWasProvidedInBundle(intent.getExtras());
        String redirectUri = callerPackageNameProvided ? BrokerValidator.getBrokerRedirectUri((Context)callingActivity, this.getPackageNameFromBundle(intent.getExtras(), callingActivity.getApplicationContext())) : intent.getStringExtra("account.redirect");
        List<Pair<String, String>> extraQP = this.getExtraQueryParamAsList(intent.getStringExtra("account.extra.query.param"));
        AzureActiveDirectoryAuthority authority = AdalBrokerRequestAdapter.getRequestAuthorityWithExtraQP(intent.getStringExtra("account.authority"), extraQP);
        if (authority.getAudience().getTenantId().equalsIgnoreCase("common")) {
            authority.getAudience().setTenantId("organizations");
        }
        String resource = intent.getStringExtra("account.resource");
        HashSet<String> scopes = new HashSet<String>();
        scopes.add(TokenCacheItemMigrationAdapter.getScopeFromResource(resource));
        String correlationIdString = intent.getStringExtra("account.correlationid");
        if (TextUtils.isEmpty((CharSequence)correlationIdString)) {
            Logger.info(TAG, "Correlation id not set by Adal, creating a new one");
            UUID correlationId = UUID.randomUUID();
            correlationIdString = correlationId.toString();
        }
        InteractiveTokenCommandParameters commandParameters = ((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((InteractiveTokenCommandParameters.InteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)((BrokerInteractiveTokenCommandParameters.BrokerInteractiveTokenCommandParametersBuilder)BrokerInteractiveTokenCommandParameters.builder().authenticationScheme(new BearerAuthenticationSchemeInternal())).activity(callingActivity)).androidApplicationContext(callingActivity.getApplicationContext())).sdkType(SdkType.ADAL)).callerUid(callingAppUid)).callerPackageName(this.getPackageNameFromBundle(intent.getExtras(), callingActivity.getApplicationContext()))).callerAppVersion(intent.getStringExtra("x-app-ver"))).extraQueryStringParameters(extraQP)).authority(authority)).scopes(scopes)).clientId("account.clientid.key")).redirectUri(redirectUri)).loginHint(intent.getStringExtra("account.name"))).correlationId(correlationIdString)).claimsRequestJson(intent.getStringExtra("account.claims"))).prompt(OpenIdConnectPromptParameter._fromPromptBehavior(intent.getStringExtra("account.prompt")))).authorizationAgent(AuthorizationAgent.WEBVIEW)).build();
        return commandParameters;
    }

    @Override
    public BrokerSilentTokenCommandParameters brokerSilentParametersFromBundle(Bundle bundle, Context context, Account account) {
        String methodName = ":brokerSilentParametersFromBundle";
        Logger.verbose(TAG + ":brokerSilentParametersFromBundle", "Constructing BrokerAcquireTokenOperationParameters from activity ");
        int callingAppUid = bundle.getInt("caller.info.uid");
        Authority authority = Authority.getAuthorityFromAuthorityUrl(bundle.getString("account.authority"));
        String correlationIdString = bundle.getString("account.correlationid");
        if (TextUtils.isEmpty((CharSequence)correlationIdString)) {
            Logger.info(TAG, "Correlation id not set by Adal, creating a new one");
            UUID correlationId = UUID.randomUUID();
            correlationIdString = correlationId.toString();
        }
        String resource = bundle.getString("account.resource");
        HashSet<String> scopes = new HashSet<String>();
        scopes.add(TokenCacheItemMigrationAdapter.getScopeFromResource(resource));
        boolean callerPackageNameProvided = this.packageNameWasProvidedInBundle(bundle);
        String packageName = this.getPackageNameFromBundle(bundle, context);
        String redirectUri = bundle.getString("account.redirect");
        if (callerPackageNameProvided || TextUtils.isEmpty((CharSequence)redirectUri)) {
            redirectUri = BrokerValidator.getBrokerRedirectUri(context, packageName);
        }
        SilentTokenCommandParameters commandParameters = ((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((CommandParameters.CommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((TokenCommandParameters.TokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((CommandParameters.CommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)((BrokerSilentTokenCommandParameters.BrokerSilentTokenCommandParametersBuilder)BrokerSilentTokenCommandParameters.builder().authenticationScheme(new BearerAuthenticationSchemeInternal())).androidApplicationContext(context)).accountManagerAccount(account)).sdkType(SdkType.ADAL)).callerUid(callingAppUid)).callerPackageName(packageName)).callerAppVersion(bundle.getString("x-app-ver"))).authority(authority)).correlationId(correlationIdString)).scopes(scopes)).clientId(bundle.getString("account.clientid.key"))).localAccountId(bundle.getString("account.userinfo.userid"))).redirectUri(redirectUri)).forceRefresh(Boolean.parseBoolean(bundle.getString("force.refresh")))).claimsRequestJson(bundle.getString("account.claims"))).loginHint(bundle.getString("account.name"))).build();
        return commandParameters;
    }

    private boolean packageNameWasProvidedInBundle(@Nullable Bundle bundle) {
        if (null == bundle) {
            return false;
        }
        String callerInfoPkg = bundle.getString("caller.info.package");
        String appPkgName = bundle.getString("x-app-name");
        return !TextUtils.isEmpty((CharSequence)callerInfoPkg) || !TextUtils.isEmpty((CharSequence)appPkgName);
    }

    private String getPackageNameFromBundle(Bundle bundle, Context context) {
        String packageName = bundle.getString("caller.info.package");
        if (TextUtils.isEmpty((CharSequence)packageName) && TextUtils.isEmpty((CharSequence)(packageName = bundle.getString("x-app-name")))) {
            Logger.warn(TAG, "Caller package name not set by app, getting from context");
            packageName = context.getPackageName();
        }
        return packageName;
    }

    private List<Pair<String, String>> getExtraQueryParamAsList(@Nullable String extraQueryParamString) {
        ArrayList<Pair<String, String>> extraQPList = new ArrayList<Pair<String, String>>();
        if (!StringUtil.isEmpty(extraQueryParamString)) {
            String[] extraQueryParams;
            for (String param : extraQueryParams = extraQueryParamString.split("&")) {
                if (StringUtil.isEmpty(param)) continue;
                String[] split = param.split("=");
                String name = split[0];
                String value = split.length > 1 ? split[1] : null;
                Pair extraQPPair = new Pair((Object)name, (Object)value);
                extraQPList.add((Pair<String, String>)extraQPPair);
            }
        }
        return extraQPList;
    }

    public static AzureActiveDirectoryAuthority getRequestAuthorityWithExtraQP(String authority, List<Pair<String, String>> extraQP) {
        AzureActiveDirectoryAuthority requestAuthority = (AzureActiveDirectoryAuthority)Authority.getAuthorityFromAuthorityUrl(authority);
        if (extraQP != null) {
            AzureActiveDirectorySlice slice = new AzureActiveDirectorySlice();
            ArrayList<Pair<String, String>> extraQPListCopy = new ArrayList<Pair<String, String>>(extraQP);
            for (Pair pair : extraQPListCopy) {
                if (StringUtil.isEmpty((String)pair.first)) {
                    Logger.warn(TAG, "The extra query parameter.first is empty.");
                    continue;
                }
                if (((String)pair.first).equalsIgnoreCase("instance_aware")) {
                    Logger.info(TAG, "Set the extra query parameter mMultipleCloudAware for MicrosoftStsAuthorizationRequest.");
                    Logger.infoPII(TAG, "Set the mMultipleCloudAware to " + (pair.second == null ? "null" : (String)pair.second));
                    requestAuthority.mMultipleCloudsSupported = null != pair.second && ((String)pair.second).equalsIgnoreCase(Boolean.TRUE.toString());
                    extraQP.remove(pair);
                    continue;
                }
                if (((String)pair.first).equalsIgnoreCase("slice")) {
                    slice.setSlice((String)pair.second);
                    extraQP.remove(pair);
                    continue;
                }
                if (!((String)pair.first).equalsIgnoreCase("dc")) continue;
                slice.setDataCenter((String)pair.second);
                extraQP.remove(pair);
            }
            Logger.verbose(TAG, "Set the extra query parameter mSlice for MicrosoftStsAuthorizationRequest.");
            Logger.verbosePII(TAG, "Set the mSlice to " + slice.toString());
            requestAuthority.mSlice = slice;
        }
        return requestAuthority;
    }
}

