/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory;

import android.content.Intent;
import android.os.Bundle;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAuthorizationErrorResponse;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAuthorizationResponse;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResultFactory;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStatus;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.Serializable;
import java.util.HashMap;

public class AzureActiveDirectoryAuthorizationResultFactory
extends AuthorizationResultFactory<AzureActiveDirectoryAuthorizationResult, AzureActiveDirectoryAuthorizationRequest> {
    private static final String TAG = AzureActiveDirectoryAuthorizationResultFactory.class.getSimpleName();
    private static final String ERROR_CODES = "error_codes";

    @Override
    public AzureActiveDirectoryAuthorizationResult createAuthorizationResult(int resultCode, Intent data, AzureActiveDirectoryAuthorizationRequest request) {
        if (data == null || data.getExtras() == null) {
            return this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "authorization_failed", "Received null intent");
        }
        Bundle extras = data.getExtras();
        int requestId = extras.getInt("com.microsoft.aad.adal:RequestId");
        AzureActiveDirectoryAuthorizationResult result = null;
        switch (resultCode) {
            case 2001: {
                Logger.verbose(TAG, "User cancel the request in webview: " + requestId);
                result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.USER_CANCEL, "user_cancelled", "User pressed device back button to cancel the flow.");
                break;
            }
            case 2003: {
                String url = extras.getString("com.microsoft.aad.adal:BrowserFinalUrl", "");
                result = this.parseUrlAndCreateAuthorizationResult(url, data.getStringExtra("request_state_parameter"));
                break;
            }
            case 2002: {
                String error = extras.getString("com.microsoft.aad.adal:BrowserErrorCode");
                String errorDescription = extras.getString("com.microsoft.aad.adal:BrowserErrorMessage");
                result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, error, errorDescription);
                break;
            }
            case 2005: {
                Serializable responseAuthenticationException = extras.getSerializable("com.microsoft.aad.adal:AuthenticationException");
                if (responseAuthenticationException == null || !(responseAuthenticationException instanceof ClientException)) break;
                ClientException exception = (ClientException)responseAuthenticationException;
                result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, exception.getErrorCode(), exception.getMessage());
                break;
            }
            case 2006: {
                Logger.verbose(TAG, "Device needs to have broker installed, we expect the apps to call usback when the broker is installed");
                result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "broker_needs_to_be_installed", "Device needs to have broker installed");
                break;
            }
            case 2007: {
                Logger.info(TAG, "Device Registration needed, need to start WPJ");
                result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "device_registration_needed", "Device needs to be registered to access the resource");
                ((AzureActiveDirectoryAuthorizationErrorResponse)result.getAuthorizationErrorResponse()).setUserName(data.getStringExtra("username"));
                break;
            }
            case 2009: {
                Logger.info(TAG, "MDM required. Launching Intune MDM link on browser.");
                result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "device_needs_to_be_managed", "Device needs to be managed to access the resource");
                break;
            }
            default: {
                result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "Unknown error", "Unknown result code returned [" + resultCode + "]");
            }
        }
        if (result == null) {
            result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "Unknown error", "Unknown result code returned [" + resultCode + "]");
        }
        return result;
    }

    private AzureActiveDirectoryAuthorizationResult createAuthorizationResultWithErrorResponse(AuthorizationStatus authStatus, String error, String errorDescription) {
        AzureActiveDirectoryAuthorizationErrorResponse errorResponse = new AzureActiveDirectoryAuthorizationErrorResponse(error, errorDescription);
        return new AzureActiveDirectoryAuthorizationResult(authStatus, errorResponse);
    }

    private AzureActiveDirectoryAuthorizationResult createAuthorizationResultWithErrorResponse(AuthorizationStatus authStatus, String error, String errorDescription, String errorCodes, String correlationId) {
        Logger.info(TAG, correlationId, "Error is returned from webview redirect");
        Logger.infoPII(TAG, correlationId, "error: " + error + " errorDescription: " + errorDescription);
        AzureActiveDirectoryAuthorizationErrorResponse errorResponse = new AzureActiveDirectoryAuthorizationErrorResponse(error, errorDescription);
        errorResponse.setErrorCodes(errorCodes);
        return new AzureActiveDirectoryAuthorizationResult(authStatus, errorResponse);
    }

    private AzureActiveDirectoryAuthorizationResult parseUrlAndCreateAuthorizationResult(String url, String requestStateParameter) {
        HashMap<String, String> urlParameters = StringExtensions.getUrlParameters(url);
        if (urlParameters == null || urlParameters.isEmpty()) {
            Logger.warn(TAG, "Invalid server response, empty query string from the webview redirect.");
            return this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "authorization_failed", "The authorization server returned an invalid response.");
        }
        String correlationInResponse = urlParameters.get("correlation_id");
        AzureActiveDirectoryAuthorizationResult result = urlParameters.containsKey("code") ? this.validateAndCreateAuthorizationResult(urlParameters.get("code"), urlParameters.get("state"), requestStateParameter, correlationInResponse) : (urlParameters.containsKey("error") ? this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, urlParameters.get("error"), urlParameters.get("error_description"), urlParameters.get(ERROR_CODES), correlationInResponse) : this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "authorization_failed", "The authorization server returned an invalid response."));
        return result;
    }

    private AzureActiveDirectoryAuthorizationResult validateAndCreateAuthorizationResult(String code, String state, String requestStateParameter, String correlationId) {
        AzureActiveDirectoryAuthorizationResult result;
        if (StringUtil.isEmpty(state)) {
            Logger.warn(TAG, correlationId, "State parameter is not returned from the webview redirect.");
            result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "state_mismatch", "State is not returned");
        } else if (StringUtil.isEmpty(requestStateParameter) || !requestStateParameter.equals(state)) {
            Logger.warn(TAG, correlationId, "State parameter returned from the redirect is not same as the one sent in request.");
            result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "state_mismatch", "Returned state from authorize endpoint is not the same as the one sent");
        } else {
            Logger.info(TAG, correlationId, "Auth code is successfully returned from webview redirect.");
            AzureActiveDirectoryAuthorizationResponse response = new AzureActiveDirectoryAuthorizationResponse(code, state);
            response.setCorrelationId(correlationId);
            result = new AzureActiveDirectoryAuthorizationResult(AuthorizationStatus.SUCCESS, response);
        }
        return result;
    }
}

