/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.commands.parameters;

import com.microsoft.identity.common.exception.ArgumentException;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryB2CAuthority;
import com.microsoft.identity.common.internal.commands.parameters.TokenCommandParameters;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryCloud;
import java.io.IOException;

public class SilentTokenCommandParameters
extends TokenCommandParameters {
    private static final String TAG = SilentTokenCommandParameters.class.getSimpleName();
    private static final Object sLock = new Object();

    @Override
    public void validate() throws ArgumentException {
        super.validate();
        if (this.getAccount() == null) {
            Logger.warn(TAG, "The account set on silent operation parameters is NULL.");
        } else if (!this.isAuthorityB2C() && !this.authorityMatchesAccountEnvironment()) {
            throw new ArgumentException("acquireTokenSilent", "authority", "Authority passed to silent parameters does not match with the cloud associated to the account.");
        }
    }

    private boolean isAuthorityB2C() {
        return this.getAuthority() instanceof AzureActiveDirectoryB2CAuthority;
    }

    private boolean authorityMatchesAccountEnvironment() {
        String methodName = ":authorityMatchesAccountEnvironment";
        try {
            AzureActiveDirectoryCloud cloud;
            if (!AzureActiveDirectory.isInitialized()) {
                SilentTokenCommandParameters.performCloudDiscovery();
            }
            return (cloud = AzureActiveDirectory.getAzureActiveDirectoryCloudFromHostName(this.getAccount().getEnvironment())) != null && cloud.getPreferredNetworkHostName().equals(this.getAuthority().getAuthorityURL().getAuthority());
        }
        catch (IOException e) {
            Logger.error(TAG + ":authorityMatchesAccountEnvironment", "Unable to perform cloud discovery", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performCloudDiscovery() throws IOException {
        String methodName = ":performCloudDiscovery";
        Logger.verbose(TAG + ":performCloudDiscovery", "Performing cloud discovery...");
        Object object = sLock;
        synchronized (object) {
            AzureActiveDirectory.performCloudDiscovery();
        }
    }

    protected SilentTokenCommandParameters(SilentTokenCommandParametersBuilder<?, ?> b) {
        super((TokenCommandParameters.TokenCommandParametersBuilder<?, ?>)b);
    }

    public static SilentTokenCommandParametersBuilder<?, ?> builder() {
        return new SilentTokenCommandParametersBuilderImpl();
    }

    @Override
    public SilentTokenCommandParametersBuilder<?, ?> toBuilder() {
        return new SilentTokenCommandParametersBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SilentTokenCommandParameters)) {
            return false;
        }
        SilentTokenCommandParameters other = (SilentTokenCommandParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SilentTokenCommandParameters;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    private static final class SilentTokenCommandParametersBuilderImpl
    extends SilentTokenCommandParametersBuilder<SilentTokenCommandParameters, SilentTokenCommandParametersBuilderImpl> {
        private SilentTokenCommandParametersBuilderImpl() {
        }

        @Override
        protected SilentTokenCommandParametersBuilderImpl self() {
            return this;
        }

        @Override
        public SilentTokenCommandParameters build() {
            return new SilentTokenCommandParameters(this);
        }
    }

    public static abstract class SilentTokenCommandParametersBuilder<C extends SilentTokenCommandParameters, B extends SilentTokenCommandParametersBuilder<C, B>>
    extends TokenCommandParameters.TokenCommandParametersBuilder<C, B> {
        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SilentTokenCommandParametersBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(SilentTokenCommandParameters instance, SilentTokenCommandParametersBuilder<?, ?> b) {
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "SilentTokenCommandParameters.SilentTokenCommandParametersBuilder(super=" + super.toString() + ")";
        }
    }
}

