/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.request;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.authorities.Authority;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.internal.authorities.Environment;
import com.microsoft.identity.common.internal.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.internal.authscheme.BearerAuthenticationSchemeInternal;
import com.microsoft.identity.common.internal.authscheme.PopAuthenticationSchemeInternal;
import com.microsoft.identity.common.internal.broker.BrokerRequest;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.internal.providers.oauth2.OpenIdConnectPromptParameter;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.AdalBrokerRequestAdapter;
import com.microsoft.identity.common.internal.request.AuthenticationSchemeTypeAdapter;
import com.microsoft.identity.common.internal.request.BrokerAcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.BrokerAcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.IBrokerRequestAdapter;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.request.SdkType;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import com.microsoft.identity.common.internal.ui.browser.Browser;
import com.microsoft.identity.common.internal.ui.browser.BrowserDescriptor;
import com.microsoft.identity.common.internal.ui.browser.BrowserSelector;
import com.microsoft.identity.common.internal.util.ClockSkewManager;
import com.microsoft.identity.common.internal.util.QueryParamsAdapter;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class MsalBrokerRequestAdapter
implements IBrokerRequestAdapter {
    private static final String TAG = MsalBrokerRequestAdapter.class.getName();
    public static Gson sRequestAdapterGsonInstance = new GsonBuilder().registerTypeAdapter(AbstractAuthenticationScheme.class, (Object)new AuthenticationSchemeTypeAdapter()).create();

    @Override
    public BrokerRequest brokerRequestFromAcquireTokenParameters(@NonNull AcquireTokenOperationParameters parameters) {
        Logger.info(TAG, "Constructing result bundle from AcquireTokenOperationParameters.");
        BrokerRequest brokerRequest = new BrokerRequest.Builder().authority(parameters.getAuthority().getAuthorityURL().toString()).scope(TextUtils.join((CharSequence)" ", parameters.getScopes())).redirect(this.getRedirectUri(parameters)).clientId(parameters.getClientId()).username(parameters.getLoginHint()).extraQueryStringParameter(parameters.getExtraQueryStringParameters() != null ? QueryParamsAdapter._toJson(parameters.getExtraQueryStringParameters()) : null).prompt(parameters.getOpenIdConnectPromptParameter().name()).claims(parameters.getClaimsRequestJson()).forceRefresh(parameters.getForceRefresh()).correlationId((String)DiagnosticContext.getRequestContext().get("correlation_id")).applicationName(parameters.getApplicationName()).applicationVersion(parameters.getApplicationVersion()).msalVersion(parameters.getSdkVersion()).environment(AzureActiveDirectory.getEnvironment().name()).multipleCloudsSupported(this.getMultipleCloudsSupported(parameters)).authorizationAgent(parameters.isBrokerBrowserSupportEnabled() ? AuthorizationAgent.BROWSER.name() : AuthorizationAgent.WEBVIEW.name()).authenticationScheme(parameters.getAuthenticationScheme()).build();
        return brokerRequest;
    }

    @Override
    public BrokerRequest brokerRequestFromSilentOperationParameters(@NonNull AcquireTokenSilentOperationParameters parameters) {
        Logger.info(TAG, "Constructing result bundle from AcquireTokenSilentOperationParameters.");
        BrokerRequest brokerRequest = new BrokerRequest.Builder().authority(parameters.getAuthority().getAuthorityURL().toString()).scope(TextUtils.join((CharSequence)" ", parameters.getScopes())).redirect(this.getRedirectUri(parameters)).clientId(parameters.getClientId()).homeAccountId(parameters.getAccount().getHomeAccountId()).localAccountId(parameters.getAccount().getLocalAccountId()).username(parameters.getAccount().getUsername()).claims(parameters.getClaimsRequestJson()).forceRefresh(parameters.getForceRefresh()).correlationId((String)DiagnosticContext.getRequestContext().get("correlation_id")).applicationName(parameters.getApplicationName()).applicationVersion(parameters.getApplicationVersion()).msalVersion(parameters.getSdkVersion()).environment(AzureActiveDirectory.getEnvironment().name()).multipleCloudsSupported(this.getMultipleCloudsSupported(parameters)).authenticationScheme(parameters.getAuthenticationScheme()).build();
        return brokerRequest;
    }

    @NonNull
    private static AbstractAuthenticationScheme getAuthenticationScheme(@NonNull Context context, @NonNull BrokerRequest request) {
        AbstractAuthenticationScheme requestScheme = request.getAuthenticationScheme();
        if (null == requestScheme) {
            return new BearerAuthenticationSchemeInternal();
        }
        if (requestScheme instanceof PopAuthenticationSchemeInternal) {
            ClockSkewManager clockSkewManager = new ClockSkewManager(context);
            ((PopAuthenticationSchemeInternal)requestScheme).setClockSkewManager(clockSkewManager);
        }
        return requestScheme;
    }

    @Override
    public BrokerAcquireTokenOperationParameters brokerInteractiveParametersFromActivity(@NonNull Activity callingActivity) {
        AzureActiveDirectoryAuthority authority;
        Logger.info(TAG, "Constructing BrokerAcquireTokenOperationParameters from calling activity");
        BrokerAcquireTokenOperationParameters parameters = new BrokerAcquireTokenOperationParameters();
        Intent intent = callingActivity.getIntent();
        BrokerRequest brokerRequest = (BrokerRequest)sRequestAdapterGsonInstance.fromJson(intent.getStringExtra("broker_request_v2"), BrokerRequest.class);
        parameters.setAuthenticationScheme(MsalBrokerRequestAdapter.getAuthenticationScheme((Context)callingActivity, brokerRequest));
        parameters.setActivity(callingActivity);
        parameters.setAppContext(callingActivity.getApplicationContext());
        parameters.setSdkType(SdkType.MSAL);
        int callingAppUid = intent.getIntExtra("caller.info.uid", 0);
        parameters.setCallerUId(callingAppUid);
        parameters.setCallerPackageName(brokerRequest.getApplicationName());
        parameters.setCallerAppVersion(brokerRequest.getApplicationVersion());
        List<Pair<String, String>> extraQP = new ArrayList<Pair<String, String>>();
        if (!TextUtils.isEmpty((CharSequence)brokerRequest.getExtraQueryStringParameter())) {
            extraQP = QueryParamsAdapter._fromJson(brokerRequest.getExtraQueryStringParameter());
            parameters.setExtraQueryStringParameters(extraQP);
        }
        if ((authority = AdalBrokerRequestAdapter.getRequestAuthorityWithExtraQP(brokerRequest.getAuthority(), extraQP)) != null) {
            authority.setMultipleCloudsSupported(brokerRequest.getMultipleCloudsSupported());
            parameters.setAuthority(authority);
        }
        parameters.setScopes(this.getScopesAsSet(brokerRequest.getScope()));
        parameters.setClientId(brokerRequest.getClientId());
        parameters.setRedirectUri(brokerRequest.getRedirect());
        parameters.setLoginHint(brokerRequest.getUserName());
        String correlationIdString = brokerRequest.getCorrelationId();
        if (TextUtils.isEmpty((CharSequence)correlationIdString)) {
            UUID correlationId = UUID.randomUUID();
            correlationIdString = correlationId.toString();
        }
        parameters.setCorrelationId(correlationIdString);
        parameters.setClaimsRequest(brokerRequest.getClaims());
        parameters.setOpenIdConnectPromptParameter(brokerRequest.getPrompt() != null ? OpenIdConnectPromptParameter.valueOf(brokerRequest.getPrompt()) : OpenIdConnectPromptParameter.NONE);
        Logger.info(TAG, "Authorization agent passed in by MSAL: " + brokerRequest.getAuthorizationAgent());
        if (brokerRequest.getAuthorizationAgent() != null && brokerRequest.getAuthorizationAgent().equalsIgnoreCase(AuthorizationAgent.BROWSER.name()) && this.isCallingPackageIntune(parameters.getCallerPackageName())) {
            Logger.info(TAG, "Setting Authorization Agent to Browser for Intune app");
            parameters.setAuthorizationAgent(AuthorizationAgent.BROWSER);
            parameters.setBrokerBrowserSupportEnabled(true);
            parameters.setBrowserSafeList(MsalBrokerRequestAdapter.getBrowserSafeListForBroker());
        } else {
            parameters.setAuthorizationAgent(AuthorizationAgent.WEBVIEW);
        }
        if (!TextUtils.isEmpty((CharSequence)brokerRequest.getEnvironment())) {
            AzureActiveDirectory.setEnvironment(Environment.valueOf(brokerRequest.getEnvironment()));
        }
        return parameters;
    }

    @Override
    public BrokerAcquireTokenSilentOperationParameters brokerSilentParametersFromBundle(@NonNull Bundle bundle, @NonNull Context context, @NonNull Account account) {
        Logger.info(TAG, "Constructing BrokerAcquireTokenSilentOperationParameters from result bundle");
        BrokerRequest brokerRequest = (BrokerRequest)sRequestAdapterGsonInstance.fromJson(bundle.getString("broker_request_v2"), BrokerRequest.class);
        BrokerAcquireTokenSilentOperationParameters parameters = new BrokerAcquireTokenSilentOperationParameters();
        parameters.setAuthenticationScheme(MsalBrokerRequestAdapter.getAuthenticationScheme(context, brokerRequest));
        parameters.setAppContext(context);
        parameters.setAccountManagerAccount(account);
        parameters.setSdkType(SdkType.MSAL);
        int callingAppUid = bundle.getInt("caller.info.uid");
        parameters.setCallerUId(callingAppUid);
        parameters.setCallerPackageName(brokerRequest.getApplicationName());
        parameters.setCallerAppVersion(brokerRequest.getApplicationVersion());
        Authority authority = Authority.getAuthorityFromAuthorityUrl(brokerRequest.getAuthority());
        if (authority instanceof AzureActiveDirectoryAuthority) {
            ((AzureActiveDirectoryAuthority)authority).setMultipleCloudsSupported(brokerRequest.getMultipleCloudsSupported());
        }
        parameters.setAuthority(authority);
        String correlationIdString = bundle.getString(brokerRequest.getCorrelationId());
        if (TextUtils.isEmpty((CharSequence)correlationIdString)) {
            UUID correlationId = UUID.randomUUID();
            correlationIdString = correlationId.toString();
        }
        parameters.setCorrelationId(correlationIdString);
        parameters.setScopes(this.getScopesAsSet(brokerRequest.getScope()));
        parameters.setRedirectUri(brokerRequest.getRedirect());
        parameters.setClientId(brokerRequest.getClientId());
        parameters.setForceRefresh(brokerRequest.getForceRefresh());
        parameters.setClaimsRequest(brokerRequest.getClaims());
        parameters.setLoginHint(brokerRequest.getUserName());
        parameters.setHomeAccountId(brokerRequest.getHomeAccountId());
        parameters.setLocalAccountId(brokerRequest.getLocalAccountId());
        if (!TextUtils.isEmpty((CharSequence)brokerRequest.getExtraQueryStringParameter())) {
            parameters.setExtraQueryStringParameters(QueryParamsAdapter._fromJson(brokerRequest.getExtraQueryStringParameter()));
        }
        if (!TextUtils.isEmpty((CharSequence)brokerRequest.getEnvironment())) {
            AzureActiveDirectory.setEnvironment(Environment.valueOf(brokerRequest.getEnvironment()));
        }
        return parameters;
    }

    private Set<String> getScopesAsSet(@Nullable String scopeString) {
        if (TextUtils.isEmpty((CharSequence)scopeString)) {
            return new HashSet<String>();
        }
        String[] scopes = scopeString.split(" ");
        return new HashSet<String>(Arrays.asList(scopes));
    }

    private String getRedirectUri(@NonNull OperationParameters parameters) {
        if (TextUtils.isEmpty((CharSequence)parameters.getRedirectUri())) {
            return BrokerValidator.getBrokerRedirectUri(parameters.getAppContext(), parameters.getApplicationName());
        }
        return parameters.getRedirectUri();
    }

    public Bundle getRequestBundleForHello(@NonNull OperationParameters parameters) {
        Bundle requestBundle = new Bundle();
        requestBundle.putString("broker.protocol.version.name", "4.0");
        if (!StringUtil.isEmpty(parameters.getRequiredBrokerProtocolVersion())) {
            requestBundle.putString("required.broker.protocol.version.name", parameters.getRequiredBrokerProtocolVersion());
        }
        return requestBundle;
    }

    public Bundle getRequestBundleForAcquireTokenSilent(AcquireTokenSilentOperationParameters parameters) {
        MsalBrokerRequestAdapter msalBrokerRequestAdapter = new MsalBrokerRequestAdapter();
        Bundle requestBundle = new Bundle();
        BrokerRequest brokerRequest = msalBrokerRequestAdapter.brokerRequestFromSilentOperationParameters(parameters);
        requestBundle.putString("broker_request_v2", sRequestAdapterGsonInstance.toJson((Object)brokerRequest, BrokerRequest.class));
        requestBundle.putInt("caller.info.uid", parameters.getAppContext().getApplicationInfo().uid);
        return requestBundle;
    }

    public Bundle getRequestBundleForGetAccounts(@NonNull OperationParameters parameters) {
        Bundle requestBundle = new Bundle();
        requestBundle.putString("account.clientid.key", parameters.getClientId());
        requestBundle.putString("account.redirect", parameters.getRedirectUri());
        return requestBundle;
    }

    public Bundle getRequestBundleForRemoveAccount(@NonNull OperationParameters parameters) {
        Bundle requestBundle = new Bundle();
        if (null != parameters.getAccount()) {
            requestBundle.putString("account.clientid.key", parameters.getClientId());
            requestBundle.putString("environment", parameters.getAccount().getEnvironment());
            requestBundle.putString("account.home.account.id", parameters.getAccount().getHomeAccountId());
        }
        return requestBundle;
    }

    public Bundle getRequestBundleForRemoveAccountFromSharedDevice(@NonNull OperationParameters parameters) {
        Bundle requestBundle = new Bundle();
        try {
            Browser browser = BrowserSelector.select(parameters.getAppContext(), parameters.getBrowserSafeList());
            requestBundle.putString("default.browser.package.name", browser.getPackageName());
        }
        catch (ClientException e) {
            Logger.error(TAG, e.getErrorCode(), e);
        }
        return requestBundle;
    }

    private boolean getMultipleCloudsSupported(@NonNull OperationParameters parameters) {
        if (parameters.getAuthority() instanceof AzureActiveDirectoryAuthority) {
            AzureActiveDirectoryAuthority authority = (AzureActiveDirectoryAuthority)parameters.getAuthority();
            return authority.getMultipleCloudsSupported();
        }
        return false;
    }

    public static List<BrowserDescriptor> getBrowserSafeListForBroker() {
        ArrayList<BrowserDescriptor> browserDescriptors = new ArrayList<BrowserDescriptor>();
        HashSet<String> signatureHashes = new HashSet<String>();
        signatureHashes.add("7fmduHKTdHHrlMvldlEqAIlSfii1tl35bxj1OXN5Ve8c4lU6URVu4xtSHc3BVZxS6WWJnxMDhIfQN0N0K2NDJg==");
        BrowserDescriptor chrome = new BrowserDescriptor("com.android.chrome", signatureHashes, null, null);
        browserDescriptors.add(chrome);
        return browserDescriptors;
    }

    private boolean isCallingPackageIntune(@NonNull String packageName) {
        String methodName = ":isCallingPackageIntune";
        String intunePackageName = "com.microsoft.intune";
        Logger.info(TAG + ":isCallingPackageIntune", "Calling package name : " + packageName);
        return "com.microsoft.intune".equalsIgnoreCase(packageName);
    }
}

