/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.request;

import androidx.annotation.NonNull;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.microsoft.identity.common.internal.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.internal.authscheme.BearerAuthenticationSchemeInternal;
import com.microsoft.identity.common.internal.authscheme.PopAuthenticationSchemeInternal;
import com.microsoft.identity.common.internal.logging.Logger;
import java.lang.reflect.Type;

class AuthenticationSchemeTypeAdapter
implements JsonDeserializer<AbstractAuthenticationScheme>,
JsonSerializer<AbstractAuthenticationScheme> {
    private static final String TAG = AuthenticationSchemeTypeAdapter.class.getSimpleName();

    AuthenticationSchemeTypeAdapter() {
    }

    public AbstractAuthenticationScheme deserialize(@NonNull JsonElement json, @NonNull Type typeOfT, @NonNull JsonDeserializationContext context) throws JsonParseException {
        String schemeNameStr;
        JsonObject authScheme = json.getAsJsonObject();
        JsonElement schemeName = authScheme.get("name");
        switch (schemeNameStr = schemeName.getAsString()) {
            case "Bearer": {
                return (AbstractAuthenticationScheme)context.deserialize(json, BearerAuthenticationSchemeInternal.class);
            }
            case "PoP": {
                return (AbstractAuthenticationScheme)context.deserialize(json, PopAuthenticationSchemeInternal.class);
            }
        }
        Logger.warn(TAG, "Unrecognized auth scheme. Deserializing as null.");
        return null;
    }

    public JsonElement serialize(@NonNull AbstractAuthenticationScheme src, @NonNull Type typeOfSrc, @NonNull JsonSerializationContext context) {
        switch (src.getName()) {
            case "Bearer": {
                return context.serialize((Object)src, BearerAuthenticationSchemeInternal.class);
            }
            case "PoP": {
                return context.serialize((Object)src, PopAuthenticationSchemeInternal.class);
            }
        }
        Logger.warn(TAG, "Unrecognized auth scheme. Serializing as null.");
        return null;
    }
}

