/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationFragment;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.UiEndEvent;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;

public class BrowserAuthorizationFragment
extends AuthorizationFragment {
    private static final String TAG = BrowserAuthorizationFragment.class.getSimpleName();
    @VisibleForTesting
    private static final String BROWSER_FLOW_STARTED = "browserFlowStarted";
    private static Class<?> sCallingActivityClass;
    private static String sCustomTabResponseUri;
    private boolean mBrowserFlowStarted = false;
    private Intent mAuthIntent;

    @Nullable
    public static Intent createCustomTabResponseIntent(Context context, String responseUri) {
        if (sCallingActivityClass == null) {
            Logger.warn(TAG, "Calling activity class is NULL. Unable to create intent for response.");
            return null;
        }
        sCustomTabResponseUri = responseUri;
        Intent intent = new Intent(context, sCallingActivityClass);
        intent.addFlags(0x24000000);
        return intent;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        sCallingActivityClass = this.getActivity().getClass();
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable("com.microsoft.identity.auth.intent", (Parcelable)this.mAuthIntent);
        outState.putBoolean(BROWSER_FLOW_STARTED, this.mBrowserFlowStarted);
    }

    @Override
    void extractState(@NonNull Bundle state) {
        super.extractState(state);
        this.mAuthIntent = (Intent)state.getParcelable("com.microsoft.identity.auth.intent");
        this.mBrowserFlowStarted = state.getBoolean(BROWSER_FLOW_STARTED, false);
    }

    public void onResume() {
        super.onResume();
        if (!this.mBrowserFlowStarted) {
            this.mBrowserFlowStarted = true;
            if (this.mAuthIntent != null) {
                this.startActivity(this.mAuthIntent);
            } else {
                Intent resultIntent = new Intent();
                resultIntent.putExtra("com.microsoft.aad.adal:AuthenticationException", (Serializable)new ClientException("Authorization intent is null."));
                this.sendResult(2005, resultIntent);
                this.finish();
            }
        } else {
            if (!StringUtil.isEmpty(sCustomTabResponseUri)) {
                this.completeAuthorizationInBrowserFlow(sCustomTabResponseUri);
            } else {
                this.cancelAuthorization(true);
            }
            sCustomTabResponseUri = null;
        }
    }

    private void completeAuthorizationInBrowserFlow(@NonNull String customTabResponseUri) {
        Logger.info(TAG, null, "Received redirect from customTab/browser.");
        Intent resultIntent = this.createResultIntent(customTabResponseUri);
        HashMap<String, String> urlQueryParameters = StringExtensions.getUrlParameters(customTabResponseUri);
        String userName = (String)urlQueryParameters.get("username");
        if (this.isDeviceRegisterRedirect(customTabResponseUri) && !TextUtils.isEmpty((CharSequence)userName)) {
            Logger.info(TAG, " Device needs to be registered, sending BROWSER_CODE_DEVICE_REGISTER");
            Logger.infoPII(TAG, "Device Registration triggered for user: " + userName);
            resultIntent.putExtra("username", userName);
            this.sendResult(2007, resultIntent);
            return;
        }
        if (urlQueryParameters.containsKey("app_link")) {
            String appLink = (String)urlQueryParameters.get("app_link");
            Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)appLink));
            this.startActivity(browserIntent);
            Logger.info(TAG, "Return to caller with BROKER_REQUEST_RESUME, and waiting for result.");
            this.sendResult(2006, resultIntent);
        } else if (!StringUtil.isEmpty(resultIntent.getStringExtra("com.microsoft.identity.client.final.url"))) {
            this.sendResult(2003, resultIntent);
            Telemetry.emit(new UiEndEvent().isUiComplete());
        } else if (!StringUtil.isEmpty(resultIntent.getStringExtra("com.microsoft.aad.adal:BrowserErrorSubCode")) && resultIntent.getStringExtra("com.microsoft.aad.adal:BrowserErrorSubCode").equalsIgnoreCase("cancel")) {
            Telemetry.emit(new UiEndEvent().isUserCancelled());
            this.sendResult(2008, resultIntent);
        } else {
            Telemetry.emit(new UiEndEvent().isUiCancelled());
            this.sendResult(2002, resultIntent);
        }
        this.finish();
    }

    private Intent createResultIntent(@NonNull String url) {
        Intent resultIntent = new Intent();
        HashMap<String, String> parameters = StringExtensions.getUrlParameters(url);
        if (!StringExtensions.isNullOrBlank((String)parameters.get("error"))) {
            Logger.info(TAG, "Sending intent to cancel authentication activity");
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", (String)parameters.get("error"));
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorSubCode", (String)parameters.get("error_subcode"));
            if (!StringUtil.isEmpty((String)parameters.get("error_description"))) {
                resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", (String)parameters.get("error_description"));
            } else {
                resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", (String)parameters.get("error_subcode"));
            }
        } else {
            Logger.info(TAG, "It is pointing to redirect. Final url can be processed to get the code or error.");
            resultIntent.putExtra("com.microsoft.identity.client.final.url", url);
        }
        return resultIntent;
    }

    private boolean isDeviceRegisterRedirect(@NonNull String redirectUrl) {
        try {
            URI uri = new URI(redirectUrl);
            return uri.getScheme().equalsIgnoreCase("msauth") && uri.getHost().equalsIgnoreCase("wpj");
        }
        catch (URISyntaxException e) {
            Logger.error(TAG, "Uri construction failed", e);
            return false;
        }
    }
}

