/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.eststelemetry;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.cache.SharedPreferencesFileManager;
import com.microsoft.identity.common.internal.controllers.BaseCommand;
import com.microsoft.identity.common.internal.controllers.CommandResult;
import com.microsoft.identity.common.internal.controllers.TokenCommand;
import com.microsoft.identity.common.internal.eststelemetry.CurrentRequestTelemetry;
import com.microsoft.identity.common.internal.eststelemetry.FailedRequest;
import com.microsoft.identity.common.internal.eststelemetry.IRequestTelemetryCache;
import com.microsoft.identity.common.internal.eststelemetry.LastRequestTelemetry;
import com.microsoft.identity.common.internal.eststelemetry.RequestTelemetry;
import com.microsoft.identity.common.internal.eststelemetry.SharedPreferencesLastRequestTelemetryCache;
import com.microsoft.identity.common.internal.eststelemetry.TelemetryUtils;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class EstsTelemetry {
    private static final String TAG = EstsTelemetry.class.getSimpleName();
    private static final String LAST_REQUEST_TELEMETRY_SHARED_PREFERENCES = "com.microsoft.identity.client.last_request_telemetry";
    private static volatile EstsTelemetry sEstsTelemetryInstance = null;
    private IRequestTelemetryCache mLastRequestTelemetryCache;
    private Map<String, CurrentRequestTelemetry> mTelemetryMap = new ConcurrentHashMap<String, CurrentRequestTelemetry>();
    private Map<String, Set<FailedRequest>> mSentFailedRequests = new ConcurrentHashMap<String, Set<FailedRequest>>();

    private EstsTelemetry() {
    }

    public static synchronized EstsTelemetry getInstance() {
        if (sEstsTelemetryInstance == null) {
            sEstsTelemetryInstance = new EstsTelemetry();
        }
        return sEstsTelemetryInstance;
    }

    private void setupLastRequestTelemetryCache(@NonNull Context context) {
        this.mLastRequestTelemetryCache = this.createLastRequestTelemetryCache(context);
        if (this.mLastRequestTelemetryCache != null) {
            Logger.verbose(TAG, "Ests Telemetry cache has been initialized properly.");
        }
    }

    public void initTelemetryForCommand(@NonNull BaseCommand command) {
        this.setupLastRequestTelemetryCache(command.getParameters().getAppContext());
        String correlationId = command.getParameters().getCorrelationId();
        if (command.isEligibleForEstsTelemetry()) {
            CurrentRequestTelemetry currentRequestTelemetry = new CurrentRequestTelemetry();
            this.mTelemetryMap.put(correlationId, currentRequestTelemetry);
            this.mSentFailedRequests.put(correlationId, new HashSet());
        }
    }

    private boolean isCurrentTelemetryAvailable() {
        String correlationId = (String)DiagnosticContext.getRequestContext().get("correlation_id");
        CurrentRequestTelemetry currentRequestTelemetry = this.getCurrentTelemetryInstance(correlationId);
        return currentRequestTelemetry != null;
    }

    public void emit(@Nullable Map<String, String> telemetry) {
        if (telemetry == null) {
            return;
        }
        for (Map.Entry<String, String> entry : telemetry.entrySet()) {
            this.emit(entry.getKey(), entry.getValue());
        }
    }

    public void emit(String key, String value) {
        if (StringUtil.isEmpty(key)) {
            return;
        }
        String correlationId = (String)DiagnosticContext.getRequestContext().get("correlation_id");
        String compliantValueString = TelemetryUtils.getSchemaCompliantString(value);
        CurrentRequestTelemetry currentTelemetryInstance = this.getCurrentTelemetryInstance(correlationId);
        if (currentTelemetryInstance != null) {
            currentTelemetryInstance.put(key, compliantValueString);
        }
    }

    @Nullable
    private CurrentRequestTelemetry getCurrentTelemetryInstance(@Nullable String correlationId) {
        if (this.mTelemetryMap == null || correlationId == null || correlationId.equals("UNSET")) {
            return null;
        }
        return this.mTelemetryMap.get(correlationId);
    }

    @Nullable
    private LastRequestTelemetry loadLastRequestTelemetryFromCache() {
        String methodName = ":loadLastRequestTelemetry";
        if (this.mLastRequestTelemetryCache == null) {
            Logger.verbose(TAG + ":loadLastRequestTelemetry", "Last Request Telemetry Cache has not been initialized. Cannot load Last Request Telemetry data from cache.");
            return null;
        }
        return (LastRequestTelemetry)this.mLastRequestTelemetryCache.getRequestTelemetryFromCache();
    }

    public void emitApiId(String apiId) {
        this.emit("Microsoft.MSAL.api_id", apiId);
    }

    public void emitForceRefresh(boolean forceRefresh) {
        String val = TelemetryUtils.getSchemaCompliantStringFromBoolean(forceRefresh);
        this.emit("Microsoft.MSAL.force_refresh", val);
    }

    private IRequestTelemetryCache createLastRequestTelemetryCache(@NonNull Context context) {
        String methodName = ":createLastRequestTelemetryCache";
        if (context == null) {
            Logger.verbose(TAG + ":createLastRequestTelemetryCache", "Context is NULL. Unable to create last request telemetry cache.");
            return null;
        }
        Logger.verbose(TAG + ":createLastRequestTelemetryCache", "Creating Last Request Telemetry Cache");
        SharedPreferencesFileManager sharedPreferencesFileManager = new SharedPreferencesFileManager(context, LAST_REQUEST_TELEMETRY_SHARED_PREFERENCES);
        return new SharedPreferencesLastRequestTelemetryCache(sharedPreferencesFileManager);
    }

    public synchronized void flush(@NonNull BaseCommand command, @NonNull CommandResult commandResult) {
        ILocalAuthenticationResult localAuthenticationResult;
        String errorCode;
        String methodName = ":flush";
        String correlationId = command.getParameters().getCorrelationId();
        if (this.mTelemetryMap == null || correlationId == null) {
            return;
        }
        CurrentRequestTelemetry currentTelemetry = this.mTelemetryMap.get(correlationId);
        if (currentTelemetry == null) {
            return;
        }
        LastRequestTelemetry lastRequestTelemetry = this.loadLastRequestTelemetryFromCache();
        if (lastRequestTelemetry == null) {
            lastRequestTelemetry = new LastRequestTelemetry(currentTelemetry.getSchemaVersion());
            lastRequestTelemetry = (LastRequestTelemetry)lastRequestTelemetry.copySharedValues(currentTelemetry);
        }
        if (this.isTelemetryLoggedByServer(command, commandResult)) {
            lastRequestTelemetry.resetSilentSuccessCount();
            Set<FailedRequest> failedRequestSentSet = this.mSentFailedRequests.get(correlationId);
            lastRequestTelemetry.wipeFailedRequestAndErrorForSubList(failedRequestSentSet);
        }
        if ((errorCode = this.getErrorFromCommandResult(commandResult)) != null) {
            lastRequestTelemetry.appendFailedRequest(currentTelemetry.getApiId(), correlationId, errorCode);
        } else if (command instanceof TokenCommand && (localAuthenticationResult = (ILocalAuthenticationResult)commandResult.getResult()).isServicedFromCache()) {
            lastRequestTelemetry.incrementSilentSuccessCount();
        }
        this.mTelemetryMap.remove(correlationId);
        this.mSentFailedRequests.remove(correlationId);
        if (this.mLastRequestTelemetryCache != null) {
            this.mLastRequestTelemetryCache.saveRequestTelemetryToCache(lastRequestTelemetry);
        } else {
            Logger.warn(TAG + ":flush", "Last Request Telemetry Cache object was null. Unable to save request telemetry to cache.");
        }
    }

    @Nullable
    private String getErrorFromCommandResult(CommandResult commandResult) {
        if (commandResult.getStatus() == CommandResult.ResultStatus.ERROR) {
            BaseException baseException = (BaseException)commandResult.getResult();
            return baseException.getErrorCode();
        }
        if (commandResult.getStatus() == CommandResult.ResultStatus.CANCEL) {
            return "user_cancel";
        }
        return null;
    }

    private boolean isTelemetryLoggedByServer(@NonNull BaseCommand command, @NonNull CommandResult commandResult) {
        if (!(command instanceof TokenCommand)) {
            return false;
        }
        if (commandResult.getStatus() == CommandResult.ResultStatus.ERROR) {
            BaseException baseException = (BaseException)commandResult.getResult();
            if (!(baseException instanceof ServiceException)) {
                return false;
            }
            ServiceException serviceException = (ServiceException)baseException;
            int statusCode = serviceException.getHttpStatusCode();
            return statusCode != 0 && statusCode != 429 && statusCode < 500;
        }
        if (commandResult.getStatus() == CommandResult.ResultStatus.CANCEL) {
            return false;
        }
        if (commandResult.getStatus() == CommandResult.ResultStatus.COMPLETED) {
            if (commandResult.getResult() instanceof ILocalAuthenticationResult) {
                ILocalAuthenticationResult localAuthenticationResult = (ILocalAuthenticationResult)commandResult.getResult();
                if (localAuthenticationResult.isServicedFromCache()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private String getCurrentTelemetryHeaderString() {
        String correlationId = (String)DiagnosticContext.getRequestContext().get("correlation_id");
        if (this.mTelemetryMap == null || correlationId == null) {
            return null;
        }
        RequestTelemetry currentTelemetry = this.mTelemetryMap.get(correlationId);
        if (currentTelemetry == null) {
            return null;
        }
        return currentTelemetry.getCompleteHeaderString();
    }

    private synchronized String getLastTelemetryHeaderString() {
        if (this.mLastRequestTelemetryCache == null) {
            return null;
        }
        LastRequestTelemetry lastRequestTelemetryFromCache = (LastRequestTelemetry)this.mLastRequestTelemetryCache.getRequestTelemetryFromCache();
        String correlationId = (String)DiagnosticContext.getRequestContext().get("correlation_id");
        if (lastRequestTelemetryFromCache == null) {
            CurrentRequestTelemetry currentRequestTelemetry = this.mTelemetryMap.get(correlationId);
            LastRequestTelemetry lastRequestTelemetry = new LastRequestTelemetry(currentRequestTelemetry.getSchemaVersion());
            lastRequestTelemetry.copySharedValues(currentRequestTelemetry);
            lastRequestTelemetry.putInPlatformTelemetry("is_all_telemetry_data_sent", "1");
            return lastRequestTelemetry.getCompleteHeaderString();
        }
        LastRequestTelemetry lastRequestTelemetryCopy = new LastRequestTelemetry(lastRequestTelemetryFromCache.getSchemaVersion());
        lastRequestTelemetryCopy.copySharedValues(lastRequestTelemetryFromCache);
        List<FailedRequest> originalFailedRequests = lastRequestTelemetryFromCache.getFailedRequests();
        Set<FailedRequest> failedRequestSentSet = this.mSentFailedRequests.get(correlationId);
        boolean isAllDataSentInHeader = true;
        for (int i = 0; i < originalFailedRequests.size(); ++i) {
            if (lastRequestTelemetryCopy.getCompleteHeaderString().length() < 3800) {
                FailedRequest failedRequest = originalFailedRequests.get(i);
                lastRequestTelemetryCopy.appendFailedRequest(failedRequest);
                if (failedRequestSentSet == null) continue;
                failedRequestSentSet.add(failedRequest);
                continue;
            }
            isAllDataSentInHeader = false;
            break;
        }
        String isAllDataSentString = TelemetryUtils.getSchemaCompliantStringFromBoolean(isAllDataSentInHeader);
        lastRequestTelemetryCopy.putInPlatformTelemetry("is_all_telemetry_data_sent", isAllDataSentString);
        return lastRequestTelemetryCopy.getCompleteHeaderString();
    }

    public Map<String, String> getTelemetryHeaders() {
        String methodName = ":getTelemetryHeaders";
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (!this.isCurrentTelemetryAvailable()) {
            return headerMap;
        }
        String currentHeader = this.getCurrentTelemetryHeaderString();
        String lastHeader = this.getLastTelemetryHeaderString();
        if (currentHeader != null) {
            headerMap.put("x-client-current-telemetry", currentHeader);
        } else {
            Logger.verbose(TAG + ":getTelemetryHeaders", "Current Request Telemetry Header is null");
        }
        if (lastHeader != null) {
            headerMap.put("x-client-last-telemetry", lastHeader);
        } else {
            Logger.verbose(TAG + ":getTelemetryHeaders", "Last Request Telemetry Header is null");
        }
        return Collections.unmodifiableMap(headerMap);
    }
}

