/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.request;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.Expose;
import com.microsoft.identity.common.exception.ArgumentException;
import com.microsoft.identity.common.internal.authorities.Authority;
import com.microsoft.identity.common.internal.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.internal.dto.IAccountRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.SdkType;
import com.microsoft.identity.common.internal.ui.browser.BrowserDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class OperationParameters {
    private static final String TAG = OperationParameters.class.getSimpleName();
    private transient Context mAppContext;
    private transient OAuth2TokenCache mTokenCache;
    private transient boolean mIsSharedDevice;
    protected transient List<BrowserDescriptor> mBrowserSafeList;
    @Expose
    private Set<String> mScopes;
    protected IAccountRecord mAccount;
    @Expose
    private String clientId;
    @Expose
    private String redirectUri;
    @Expose
    private Authority mAuthority;
    @Expose
    private String mClaimsRequestJson;
    @Expose
    private SdkType mSdkType = SdkType.MSAL;
    @Expose
    private String mSdkVersion;
    @Expose
    private String mApplicationName;
    @Expose
    private String mApplicationVersion;
    @Expose
    private String mRequiredBrokerProtocolVersion;
    @Expose
    private boolean mForceRefresh;
    @Expose
    private String mCorrelationId;
    @Expose
    private AbstractAuthenticationScheme mAuthenticationScheme;

    public String getRequiredBrokerProtocolVersion() {
        return this.mRequiredBrokerProtocolVersion;
    }

    public void setRequiredBrokerProtocolVersion(@NonNull String requiredBrokerProtocolVersion) {
        this.mRequiredBrokerProtocolVersion = requiredBrokerProtocolVersion;
    }

    public SdkType getSdkType() {
        return this.mSdkType;
    }

    public void setSdkType(@Nullable SdkType sdkType) {
        this.mSdkType = sdkType;
    }

    public Context getAppContext() {
        return this.mAppContext;
    }

    public void setAppContext(@NonNull Context mAppContext) {
        this.mAppContext = mAppContext;
    }

    public boolean getIsSharedDevice() {
        return this.mIsSharedDevice;
    }

    public void setIsSharedDevice(@NonNull boolean isSharedDevice) {
        this.mIsSharedDevice = isSharedDevice;
    }

    public Set<String> getScopes() {
        return this.mScopes;
    }

    public void setScopes(@NonNull Set<String> mScopes) {
        this.mScopes = mScopes;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(@NonNull String clientId) {
        this.clientId = clientId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(@NonNull String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void setTokenCache(@NonNull OAuth2TokenCache cache) {
        this.mTokenCache = cache;
    }

    public OAuth2TokenCache getTokenCache() {
        return this.mTokenCache;
    }

    public Authority getAuthority() {
        return this.mAuthority;
    }

    public void setAuthority(@NonNull Authority authority) {
        this.mAuthority = authority;
    }

    public void setAccount(@Nullable IAccountRecord account) {
        this.mAccount = account;
    }

    public IAccountRecord getAccount() {
        return this.mAccount;
    }

    public String getClaimsRequestJson() {
        return this.mClaimsRequestJson;
    }

    public void setClaimsRequest(@Nullable String claimsRequestJson) {
        this.mClaimsRequestJson = claimsRequestJson;
    }

    public String getSdkVersion() {
        return this.mSdkVersion;
    }

    public void setSdkVersion(@Nullable String sdkVersion) {
        this.mSdkVersion = sdkVersion;
    }

    public String getApplicationName() {
        return this.mApplicationName;
    }

    public void setApplicationName(@Nullable String applicationName) {
        this.mApplicationName = applicationName;
    }

    public String getApplicationVersion() {
        return this.mApplicationVersion;
    }

    public void setApplicationVersion(@Nullable String applicationVersion) {
        this.mApplicationVersion = applicationVersion;
    }

    public void setForceRefresh(boolean forceRefresh) {
        this.mForceRefresh = forceRefresh;
    }

    public boolean getForceRefresh() {
        return this.mForceRefresh;
    }

    public String getCorrelationId() {
        return this.mCorrelationId;
    }

    public void setCorrelationId(String correlationId) {
        this.mCorrelationId = correlationId;
    }

    public AbstractAuthenticationScheme getAuthenticationScheme() {
        return this.mAuthenticationScheme;
    }

    public void setAuthenticationScheme(@NonNull AbstractAuthenticationScheme scheme) {
        this.mAuthenticationScheme = scheme;
    }

    public void setBrowserSafeList(List<BrowserDescriptor> browserSafeList) {
        this.mBrowserSafeList = browserSafeList;
    }

    public List<BrowserDescriptor> getBrowserSafeList() {
        return this.mBrowserSafeList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationParameters that = (OperationParameters)o;
        if (this.mForceRefresh != that.mForceRefresh) {
            return false;
        }
        if (this.mScopes != null ? !this.mScopes.equals(that.mScopes) : that.mScopes != null) {
            return false;
        }
        if (this.mAccount != null ? !this.mAccount.equals(that.mAccount) : that.mAccount != null) {
            return false;
        }
        if (!this.clientId.equals(that.clientId)) {
            return false;
        }
        if (this.redirectUri != null ? !this.redirectUri.equals(that.redirectUri) : that.redirectUri != null) {
            return false;
        }
        if (this.mAuthority != null ? !this.mAuthority.equals(that.mAuthority) : that.mAuthority != null) {
            return false;
        }
        if (this.mClaimsRequestJson != null ? !this.mClaimsRequestJson.equals(that.mClaimsRequestJson) : that.mClaimsRequestJson != null) {
            return false;
        }
        return this.mAuthenticationScheme != null ? this.mAuthenticationScheme.equals(that.mAuthenticationScheme) : that.mAuthenticationScheme == null;
    }

    public int hashCode() {
        int result = this.mScopes != null ? this.mScopes.hashCode() : 0;
        result = 31 * result + (this.mAccount != null ? this.mAccount.hashCode() : 0);
        result = 31 * result + this.clientId.hashCode();
        result = 31 * result + (this.redirectUri != null ? this.redirectUri.hashCode() : 0);
        result = 31 * result + (this.mAuthority != null ? this.mAuthority.hashCode() : 0);
        result = 31 * result + (this.mClaimsRequestJson != null ? this.mClaimsRequestJson.hashCode() : 0);
        result = 31 * result + (this.mForceRefresh ? 1 : 0);
        result = 31 * result + (this.mAuthenticationScheme != null ? this.mAuthenticationScheme.hashCode() : 0);
        return result;
    }

    public void validate() throws ArgumentException {
        String methodName = ":validate";
        Logger.verbose(TAG + ":validate", "Validating operation params...");
        boolean validScopeArgument = false;
        if (this.mScopes != null) {
            this.mScopes.removeAll(Arrays.asList("", null));
            if (this.mScopes.size() > 0) {
                validScopeArgument = true;
            }
        }
        if (!validScopeArgument) {
            if (this instanceof AcquireTokenSilentOperationParameters) {
                throw new ArgumentException("acquireTokenSilent", "scopes", "scope is empty or null");
            }
            if (this instanceof AcquireTokenOperationParameters) {
                throw new ArgumentException("acquireToken", "scopes", "scope is empty or null");
            }
        }
        if (null == this.mAuthenticationScheme) {
            if (this instanceof AcquireTokenSilentOperationParameters) {
                throw new ArgumentException("acquireTokenSilent", "authentication_scheme", "authentication scheme is undefined");
            }
            if (this instanceof AcquireTokenOperationParameters) {
                throw new ArgumentException("acquireToken", "authentication_scheme", "authentication scheme is undefined");
            }
        }
    }
}

