/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationFragment;
import com.microsoft.identity.common.internal.ui.webview.AzureActiveDirectoryWebViewClient;
import com.microsoft.identity.common.internal.ui.webview.OnPageLoadedCallback;
import com.microsoft.identity.common.internal.ui.webview.WebViewUtil;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IAuthorizationCompletionCallback;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class WebViewAuthorizationFragment
extends AuthorizationFragment {
    private static final String TAG = WebViewAuthorizationFragment.class.getSimpleName();
    @VisibleForTesting
    private static final String PKEYAUTH_STATUS = "pkeyAuthStatus";
    private WebView mWebView;
    private ProgressBar mProgressBar;
    private Intent mAuthIntent;
    private boolean mPkeyAuthStatus = false;
    private String mAuthorizationRequestUrl;
    private String mRedirectUri;
    private HashMap<String, String> mRequestHeaders;
    private String mPostPageLoadedUrl;
    private boolean webViewZoomControlsEnabled;
    private boolean webViewZoomEnabled;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        WebViewUtil.setDataDirectorySuffix(this.getActivity().getApplicationContext());
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable("com.microsoft.identity.auth.intent", (Parcelable)this.mAuthIntent);
        outState.putBoolean(PKEYAUTH_STATUS, this.mPkeyAuthStatus);
        outState.putString("com.microsoft.identity.request.redirect.uri", this.mRedirectUri);
        outState.putString("com.microsoft.identity.request.url", this.mAuthorizationRequestUrl);
        outState.putSerializable("com.microsoft.identity.request.headers", this.mRequestHeaders);
        outState.putSerializable("com.microsoft.identity.post.page.loaded.url", (Serializable)((Object)this.mPostPageLoadedUrl));
        outState.putSerializable("com.microsoft.identity.post.page.loaded.url", (Serializable)((Object)this.mPostPageLoadedUrl));
        outState.putBoolean("com.microsoft.identity.web.view.zoom.controls.enabled", this.webViewZoomControlsEnabled);
        outState.putBoolean("com.microsoft.identity.web.view.zoom.enabled", this.webViewZoomEnabled);
    }

    @Override
    void extractState(@NonNull Bundle state) {
        super.extractState(state);
        this.mAuthIntent = (Intent)state.getParcelable("com.microsoft.identity.auth.intent");
        this.mPkeyAuthStatus = state.getBoolean(PKEYAUTH_STATUS, false);
        this.mAuthorizationRequestUrl = state.getString("com.microsoft.identity.request.url");
        this.mRedirectUri = state.getString("com.microsoft.identity.request.redirect.uri");
        this.mRequestHeaders = this.getRequestHeaders(state);
        this.mPostPageLoadedUrl = state.getString("com.microsoft.identity.post.page.loaded.url");
        this.webViewZoomEnabled = state.getBoolean("com.microsoft.identity.web.view.zoom.enabled", true);
        this.webViewZoomControlsEnabled = state.getBoolean("com.microsoft.identity.web.view.zoom.controls.enabled", true);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        String methodName = "#onCreateView";
        View view = inflater.inflate(R.layout.common_activity_authentication, container, false);
        this.mProgressBar = (ProgressBar)view.findViewById(R.id.common_auth_webview_progressbar);
        AzureActiveDirectoryWebViewClient webViewClient = new AzureActiveDirectoryWebViewClient((Activity)this.getActivity(), new AuthorizationCompletionCallback(), new OnPageLoadedCallback(){

            @Override
            public void onPageLoaded() {
                WebViewAuthorizationFragment.this.mProgressBar.setVisibility(4);
                if (!StringExtensions.isNullOrBlank(WebViewAuthorizationFragment.this.mPostPageLoadedUrl)) {
                    WebViewAuthorizationFragment.this.mWebView.loadUrl(WebViewAuthorizationFragment.this.mPostPageLoadedUrl);
                }
            }
        }, this.mRedirectUri);
        this.setUpWebView(view, webViewClient);
        this.mWebView.post(new Runnable(){

            @Override
            public void run() {
                WebViewAuthorizationFragment.this.mWebView.loadUrl("about:blank");
                Logger.info(TAG + "#onCreateView", "Launching embedded WebView for acquiring auth code.");
                Logger.infoPII(TAG + "#onCreateView", "The start url is " + WebViewAuthorizationFragment.this.mAuthorizationRequestUrl);
                WebViewAuthorizationFragment.this.mWebView.loadUrl(WebViewAuthorizationFragment.this.mAuthorizationRequestUrl, (Map)WebViewAuthorizationFragment.this.mRequestHeaders);
                WebViewAuthorizationFragment.this.mProgressBar.setVisibility(0);
            }
        });
        return view;
    }

    @Override
    public boolean onBackPressed() {
        Logger.info(TAG, "Back button is pressed");
        if (null != this.mWebView && this.mWebView.canGoBack()) {
            int BACK_PRESSED_STEPS = -2;
            if (!this.mWebView.canGoBackOrForward(-2)) {
                this.cancelAuthorization(true);
            } else {
                this.mWebView.goBack();
            }
            return true;
        }
        return false;
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "ClickableViewAccessibility"})
    private void setUpWebView(@NonNull View view, @NonNull AzureActiveDirectoryWebViewClient webViewClient) {
        this.mWebView = (WebView)view.findViewById(R.id.common_auth_webview);
        WebSettings userAgentSetting = this.mWebView.getSettings();
        String userAgent = userAgentSetting.getUserAgentString();
        this.mWebView.getSettings().setUserAgentString(userAgent + " PKeyAuth/1.0");
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.requestFocus(130);
        this.mWebView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                int action = event.getAction();
                if (!(action != 0 && action != 1 || view.hasFocus())) {
                    view.requestFocus();
                }
                return false;
            }
        });
        this.mWebView.getSettings().setLoadWithOverviewMode(true);
        this.mWebView.getSettings().setDomStorageEnabled(true);
        this.mWebView.getSettings().setUseWideViewPort(true);
        this.mWebView.getSettings().setBuiltInZoomControls(this.webViewZoomControlsEnabled);
        this.mWebView.getSettings().setSupportZoom(this.webViewZoomEnabled);
        this.mWebView.setVisibility(4);
        this.mWebView.setWebViewClient((WebViewClient)webViewClient);
    }

    private HashMap<String, String> getRequestHeaders(Bundle state) {
        try {
            return (HashMap)state.getSerializable("com.microsoft.identity.request.headers");
        }
        catch (Exception e) {
            return null;
        }
    }

    class AuthorizationCompletionCallback
    implements IAuthorizationCompletionCallback {
        AuthorizationCompletionCallback() {
        }

        @Override
        public void onChallengeResponseReceived(int returnCode, Intent responseIntent) {
            Logger.info(TAG, null, "onChallengeResponseReceived:" + returnCode);
            WebViewAuthorizationFragment.this.sendResult(returnCode, responseIntent);
            WebViewAuthorizationFragment.this.finish();
        }

        @Override
        public void setPKeyAuthStatus(boolean status) {
            WebViewAuthorizationFragment.this.mPkeyAuthStatus = status;
            Logger.info(TAG, null, "setPKeyAuthStatus:" + status);
        }
    }
}

