/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.eststelemetry;

import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResult;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;

public class TelemetryUtils {
    static String errorFromAcquireTokenResult(AcquireTokenResult acquireTokenResult) {
        if (acquireTokenResult == null) {
            return "unknown_error";
        }
        String errorFromAuthorization = TelemetryUtils.getErrorFromAuthorizationResult(acquireTokenResult.getAuthorizationResult());
        if (errorFromAuthorization != null) {
            return errorFromAuthorization;
        }
        return TelemetryUtils.getErrorFromTokenResult(acquireTokenResult.getTokenResult());
    }

    private static String getErrorFromAuthorizationResult(AuthorizationResult authorizationResult) {
        if (authorizationResult != null && authorizationResult.getErrorResponse() != null) {
            return authorizationResult.getErrorResponse().getError();
        }
        return null;
    }

    private static String getErrorFromTokenResult(TokenResult tokenResult) {
        if (tokenResult != null && tokenResult.getErrorResponse() != null) {
            return tokenResult.getErrorResponse().getError();
        }
        return null;
    }
}

