/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.eststelemetry;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.internal.cache.SharedPreferencesFileManager;
import com.microsoft.identity.common.internal.eststelemetry.IRequestTelemetryCache;
import com.microsoft.identity.common.internal.eststelemetry.RequestTelemetry;
import com.microsoft.identity.common.internal.eststelemetry.Schema;
import com.microsoft.identity.common.internal.eststelemetry.SharedPreferencesLastRequestTelemetryCache;
import com.microsoft.identity.common.internal.eststelemetry.TelemetryUtils;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EstsTelemetry {
    private static final String TAG = EstsTelemetry.class.getSimpleName();
    private static final String LAST_REQUEST_TELEMETRY_SHARED_PREFERENCES = "com.microsoft.identity.client.last_request_telemetry";
    private static volatile EstsTelemetry sEstsTelemetryInstance = null;
    private IRequestTelemetryCache mLastRequestTelemetryCache;
    private Map<String, RequestTelemetry> mTelemetryMap = new ConcurrentHashMap<String, RequestTelemetry>();

    private EstsTelemetry() {
    }

    public static synchronized EstsTelemetry getInstance() {
        if (sEstsTelemetryInstance == null) {
            sEstsTelemetryInstance = new EstsTelemetry();
        }
        return sEstsTelemetryInstance;
    }

    public void setupLastRequestTelemetryCache(@NonNull Context context) {
        this.mLastRequestTelemetryCache = this.createLastRequestTelemetryCache(context);
        if (this.mLastRequestTelemetryCache != null) {
            Logger.verbose(TAG, "Ests Telemetry cache has been initialized properly.");
        }
    }

    public void emit(@Nullable Map<String, String> telemetry) {
        if (telemetry == null) {
            return;
        }
        for (Map.Entry<String, String> entry : telemetry.entrySet()) {
            this.emit(entry.getKey(), entry.getValue());
        }
    }

    public void emit(String key, String value) {
        String correlationId = (String)DiagnosticContext.getRequestContext().get("correlation_id");
        this.emit(correlationId, key, value);
    }

    private void emit(String correlationId, String key, String value) {
        RequestTelemetry currentTelemetryInstance = this.getCurrentTelemetryInstance(correlationId);
        if (currentTelemetryInstance != null) {
            currentTelemetryInstance.putTelemetry(key, value);
        }
    }

    private RequestTelemetry getCurrentTelemetryInstance(@Nullable String correlationId) {
        if (this.mTelemetryMap == null || correlationId == null || correlationId.equals("UNSET")) {
            return null;
        }
        RequestTelemetry currentTelemetry = this.mTelemetryMap.get(correlationId);
        if (currentTelemetry != null) {
            return currentTelemetry;
        }
        RequestTelemetry telemetry = new RequestTelemetry(true);
        this.mTelemetryMap.put(correlationId, telemetry);
        return telemetry;
    }

    @Nullable
    private RequestTelemetry loadLastRequestTelemetryFromCache() {
        String methodName = ":loadLastRequestTelemetry";
        if (this.mLastRequestTelemetryCache == null) {
            Logger.verbose(TAG + ":loadLastRequestTelemetry", "Last Request Telemetry Cache has not been initialized. Cannot load Last Request Telemetry data from cache.");
            return null;
        }
        return this.mLastRequestTelemetryCache.getRequestTelemetryFromCache();
    }

    public void emitApiId(String apiId) {
        this.emit("Microsoft.MSAL.api_id", apiId);
    }

    public void emitForceRefresh(boolean forceRefresh) {
        String val = Schema.getSchemaCompliantStringFromBoolean(forceRefresh);
        this.emit("Microsoft.MSAL.force_refresh", val);
    }

    private IRequestTelemetryCache createLastRequestTelemetryCache(@NonNull Context context) {
        String methodName = ":createLastRequestTelemetryCache";
        if (context == null) {
            Logger.verbose(TAG + ":createLastRequestTelemetryCache", "Context is NULL. Unable to create last request telemetry cache.");
            return null;
        }
        Logger.verbose(TAG + ":createLastRequestTelemetryCache", "Creating Last Request Telemetry Cache");
        SharedPreferencesFileManager sharedPreferencesFileManager = new SharedPreferencesFileManager(context, LAST_REQUEST_TELEMETRY_SHARED_PREFERENCES);
        return new SharedPreferencesLastRequestTelemetryCache(sharedPreferencesFileManager);
    }

    private RequestTelemetry setupLastFromCurrent(@Nullable RequestTelemetry currentTelemetry) {
        if (currentTelemetry == null) {
            return new RequestTelemetry("1", false);
        }
        RequestTelemetry lastTelemetry = new RequestTelemetry(currentTelemetry.getSchemaVersion(), false);
        for (Map.Entry<String, String> entry : currentTelemetry.getCommonTelemetry().entrySet()) {
            lastTelemetry.putTelemetry(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : currentTelemetry.getPlatformTelemetry().entrySet()) {
            lastTelemetry.putTelemetry(entry.getKey(), entry.getValue());
        }
        return lastTelemetry;
    }

    void flush() {
        String correlationId = (String)DiagnosticContext.getRequestContext().get("correlation_id");
        this.flush(correlationId);
    }

    public void flush(String correlationId) {
        String errorCode = null;
        this.flush(correlationId, errorCode);
    }

    public void flush(String correlationId, BaseException baseException) {
        this.flush(correlationId, baseException == null ? null : baseException.getErrorCode());
    }

    public void flush(String correlationId, AcquireTokenResult acquireTokenResult) {
        String errorCode = TelemetryUtils.errorFromAcquireTokenResult(acquireTokenResult);
        this.flush(correlationId, errorCode);
    }

    public void flush(String correlationId, String errorCode) {
        String methodName = ":flush";
        if (this.mTelemetryMap == null || correlationId == null) {
            return;
        }
        RequestTelemetry currentTelemetry = this.mTelemetryMap.get(correlationId);
        if (currentTelemetry == null) {
            return;
        }
        RequestTelemetry lastTelemetry = this.setupLastFromCurrent(currentTelemetry);
        lastTelemetry.putTelemetry("Microsoft.MSAL.correlation_id", correlationId);
        lastTelemetry.putTelemetry("Microsoft.MSAL.api_error_code", errorCode);
        currentTelemetry.clearTelemetry();
        this.mTelemetryMap.remove(correlationId);
        if (this.mLastRequestTelemetryCache == null) {
            Logger.warn(TAG + ":flush", "Last Request Telemetry Cache object was null. Unable to save request telemetry to cache.");
        } else if (this.eligibleToCache(lastTelemetry)) {
            this.mLastRequestTelemetryCache.clearAll();
            this.mLastRequestTelemetryCache.saveRequestTelemetryToCache(lastTelemetry);
        }
    }

    private boolean eligibleToCache(RequestTelemetry lastTelemetry) {
        return !TextUtils.isEmpty((CharSequence)lastTelemetry.getSchemaVersion()) && !TextUtils.isEmpty((CharSequence)lastTelemetry.getCommonTelemetry().get("Microsoft.MSAL.api_id"));
    }

    String getCurrentTelemetryHeaderString() {
        String correlationId = (String)DiagnosticContext.getRequestContext().get("correlation_id");
        if (this.mTelemetryMap == null || correlationId == null) {
            return null;
        }
        RequestTelemetry currentTelemetry = this.mTelemetryMap.get(correlationId);
        if (currentTelemetry == null) {
            return null;
        }
        return currentTelemetry.getCompleteTelemetryHeaderString();
    }

    String getLastTelemetryHeaderString() {
        RequestTelemetry lastTelemetry = this.loadLastRequestTelemetryFromCache();
        if (lastTelemetry == null) {
            return null;
        }
        return lastTelemetry.getCompleteTelemetryHeaderString();
    }

    public Map<String, String> getTelemetryHeaders() {
        String methodName = ":getTelemetryHeaders";
        HashMap<String, String> headerMap = new HashMap<String, String>();
        String currentHeader = this.getCurrentTelemetryHeaderString();
        String lastHeader = this.getLastTelemetryHeaderString();
        if (currentHeader != null) {
            headerMap.put("x-client-current-telemetry", currentHeader);
        } else {
            Logger.verbose(TAG + ":getTelemetryHeaders", "Current Request Telemetry Header is null");
        }
        if (lastHeader != null) {
            headerMap.put("x-client-last-telemetry", lastHeader);
        } else {
            Logger.verbose(TAG + ":getTelemetryHeaders", "Last Request Telemetry Header is null");
        }
        return headerMap;
    }
}

