/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.dto;

import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.internal.dto.Credential;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class AccessTokenRecord
extends Credential {
    @SerializedName(value="kid")
    private String mKid;
    @SerializedName(value="access_token_type")
    private String mAccessTokenType;
    @SerializedName(value="authority")
    private String mAuthority;
    @SerializedName(value="extended_expires_on")
    private String mExtendedExpiresOn;
    @SerializedName(value="realm")
    private String mRealm;
    @SerializedName(value="target")
    private String mTarget;
    @SerializedName(value="expires_on")
    private String mExpiresOn;

    @Nullable
    public String getKid() {
        return this.mKid;
    }

    public void setKid(@Nullable String kid) {
        this.mKid = kid;
    }

    public String getRealm() {
        return this.mRealm;
    }

    public void setRealm(String realm) {
        this.mRealm = realm;
    }

    public String getTarget() {
        return this.mTarget;
    }

    public void setTarget(String target) {
        this.mTarget = target;
    }

    public String getAccessTokenType() {
        return this.mAccessTokenType;
    }

    public void setAccessTokenType(String accessTokenType) {
        this.mAccessTokenType = accessTokenType;
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    public void setAuthority(String authority) {
        this.mAuthority = authority;
    }

    public String getExtendedExpiresOn() {
        return this.mExtendedExpiresOn;
    }

    public void setExtendedExpiresOn(String extendedExpiresOn) {
        this.mExtendedExpiresOn = extendedExpiresOn;
    }

    public String getExpiresOn() {
        return this.mExpiresOn;
    }

    public void setExpiresOn(String expiresOn) {
        this.mExpiresOn = expiresOn;
    }

    private boolean isExpired(String expires) {
        Calendar calendar = Calendar.getInstance();
        Date validity = calendar.getTime();
        long epoch = Long.valueOf(expires);
        Date expiresOn = new Date(TimeUnit.SECONDS.toMillis(epoch));
        return expiresOn.before(validity);
    }

    @Override
    public boolean isExpired() {
        return this.isExpired(this.getExpiresOn());
    }

    public static class SerializedNames
    extends Credential.SerializedNames {
        public static final String ACCESS_TOKEN_TYPE = "access_token_type";
        public static final String AUTHORITY = "authority";
        public static final String EXTENDED_EXPIRES_ON = "extended_expires_on";
        public static final String REALM = "realm";
        public static final String TARGET = "target";
        public static final String KID = "kid";
    }
}

