/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.IntuneAppProtectionPolicyRequiredException;
import com.microsoft.identity.common.exception.UserCancelException;
import com.microsoft.identity.common.internal.controllers.BaseCommand;
import com.microsoft.identity.common.internal.controllers.CommandResult;
import com.microsoft.identity.common.internal.controllers.CommandResultCache;
import com.microsoft.identity.common.internal.controllers.ExceptionAdapter;
import com.microsoft.identity.common.internal.controllers.InteractiveTokenCommand;
import com.microsoft.identity.common.internal.eststelemetry.EstsTelemetry;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.logging.RequestContext;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.BrokerAcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CommandDispatcher {
    private static final String TAG = CommandDispatcher.class.getSimpleName();
    private static final ExecutorService sInteractiveExecutor = Executors.newSingleThreadExecutor();
    private static final ExecutorService sSilentExecutor = Executors.newCachedThreadPool();
    private static final Object sLock = new Object();
    private static InteractiveTokenCommand sCommand = null;
    private static final CommandResultCache sCommandResultCache = new CommandResultCache();

    public static void submitSilent(final @NonNull BaseCommand command) {
        String methodName = ":submitSilent";
        Logger.verbose(TAG + ":submitSilent", "Beginning execution of silent command.");
        sSilentExecutor.execute(new Runnable(){

            @Override
            public void run() {
                String correlationId = CommandDispatcher.initializeDiagnosticContext(command.getParameters().getCorrelationId());
                command.getParameters().setCorrelationId(correlationId);
                EstsTelemetry.getInstance().emitApiId(command.getPublicApiId());
                CommandResult commandResult = null;
                Handler handler = new Handler(Looper.getMainLooper());
                if (command.getParameters() instanceof AcquireTokenSilentOperationParameters) {
                    CommandDispatcher.logSilentRequestParams(":submitSilent", (AcquireTokenSilentOperationParameters)command.getParameters());
                    EstsTelemetry.getInstance().emitForceRefresh(command.getParameters().getForceRefresh());
                }
                if ((commandResult = sCommandResultCache.get(command)) == null) {
                    commandResult = CommandDispatcher.executeCommand(command);
                    CommandDispatcher.cacheCommandResult(command, commandResult);
                } else {
                    Logger.info(TAG + ":submitSilent", "Silent command result returned from cache.");
                }
                CommandDispatcher.returnCommandResult(command, commandResult, handler);
                Telemetry.getInstance().flush(correlationId);
                if (commandResult.getResult() instanceof BaseException) {
                    EstsTelemetry.getInstance().flush(correlationId, (BaseException)commandResult.getResult());
                } else {
                    EstsTelemetry.getInstance().flush(correlationId);
                }
            }
        });
    }

    static void clearCommandCache() {
        sCommandResultCache.clear();
    }

    private static CommandResult executeCommand(BaseCommand command) {
        Object result = null;
        BaseException baseException = null;
        try {
            result = command.execute();
        }
        catch (Exception e) {
            baseException = e instanceof BaseException ? (BaseException)e : ExceptionAdapter.baseExceptionFromException(e);
        }
        CommandResult commandResult = baseException != null ? new CommandResult(CommandResult.ResultStatus.ERROR, baseException) : (result != null && result instanceof AcquireTokenResult ? CommandDispatcher.getCommandResultFromTokenResult(baseException, result) : new CommandResult(CommandResult.ResultStatus.COMPLETED, result));
        return commandResult;
    }

    private static void returnCommandResult(final BaseCommand command, final CommandResult result, Handler handler) {
        handler.post(new Runnable(){

            @Override
            public void run() {
                switch (result.getStatus()) {
                    case ERROR: {
                        command.getCallback().onError(result.getResult());
                        break;
                    }
                    case COMPLETED: {
                        command.getCallback().onTaskCompleted(result.getResult());
                        break;
                    }
                    case CANCEL: {
                        command.getCallback().onCancel();
                    }
                }
            }
        });
    }

    private static void cacheCommandResult(BaseCommand command, CommandResult commandResult) {
        if (command.isEligibleForCaching() && CommandDispatcher.eligibleToCache(commandResult)) {
            sCommandResultCache.put(command, commandResult);
        }
    }

    private static boolean eligibleToCache(CommandResult commandResult) {
        switch (commandResult.getStatus()) {
            case ERROR: {
                return CommandDispatcher.eligibleToCacheException((BaseException)commandResult.getResult());
            }
            case COMPLETED: {
                return true;
            }
        }
        return false;
    }

    private static boolean eligibleToCacheException(BaseException exception) {
        return !(exception instanceof IntuneAppProtectionPolicyRequiredException);
    }

    private static CommandResult getCommandResultFromTokenResult(BaseException baseException, AcquireTokenResult result) {
        if (result.getSucceeded().booleanValue()) {
            return new CommandResult(CommandResult.ResultStatus.COMPLETED, result.getLocalAuthenticationResult());
        }
        baseException = ExceptionAdapter.exceptionFromAcquireTokenResult(result);
        if (baseException instanceof UserCancelException) {
            return new CommandResult(CommandResult.ResultStatus.CANCEL, null);
        }
        return new CommandResult(CommandResult.ResultStatus.ERROR, baseException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void beginInteractive(final InteractiveTokenCommand command) {
        String methodName = ":beginInteractive";
        Logger.info(TAG + ":beginInteractive", "Beginning interactive request");
        Object object = sLock;
        synchronized (object) {
            final LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)command.getParameters().getAppContext());
            if (command.getParameters() instanceof BrokerAcquireTokenOperationParameters) {
                localBroadcastManager.sendBroadcast(new Intent("cancel_interactive_request"));
            }
            sInteractiveExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String correlationId = CommandDispatcher.initializeDiagnosticContext(command.getParameters().getCorrelationId());
                    command.getParameters().setCorrelationId(correlationId);
                    EstsTelemetry.getInstance().emitApiId(command.getPublicApiId());
                    if (command.getParameters() instanceof AcquireTokenOperationParameters) {
                        CommandDispatcher.logInteractiveRequestParameters(":beginInteractive", (AcquireTokenOperationParameters)command.getParameters());
                    }
                    BroadcastReceiver resultReceiver = new BroadcastReceiver(){

                        public void onReceive(Context context, Intent intent) {
                            CommandDispatcher.completeInteractive(intent);
                        }
                    };
                    AcquireTokenResult result = null;
                    BaseException baseException = null;
                    try {
                        localBroadcastManager.registerReceiver(resultReceiver, new IntentFilter("return_interactive_request_result"));
                        sCommand = command;
                        result = command.execute();
                    }
                    catch (Exception e) {
                        Logger.errorPII(TAG + ":beginInteractive", "Interactive request failed with Exception", e);
                        baseException = e instanceof BaseException ? (BaseException)e : ExceptionAdapter.baseExceptionFromException(e);
                    }
                    finally {
                        sCommand = null;
                        localBroadcastManager.unregisterReceiver(resultReceiver);
                    }
                    Handler handler = new Handler(Looper.getMainLooper());
                    if (baseException != null) {
                        final BaseException finalException = baseException;
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                command.getCallback().onError(finalException);
                            }
                        });
                    } else if (null != result && result.getSucceeded().booleanValue()) {
                        final ILocalAuthenticationResult authenticationResult = result.getLocalAuthenticationResult();
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                command.getCallback().onTaskCompleted(authenticationResult);
                            }
                        });
                    } else {
                        baseException = ExceptionAdapter.exceptionFromAcquireTokenResult(result);
                        final BaseException finalException = baseException;
                        if (finalException instanceof UserCancelException) {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    command.getCallback().onCancel();
                                }
                            });
                        } else {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    command.getCallback().onError(finalException);
                                }
                            });
                        }
                    }
                    EstsTelemetry.getInstance().flush(correlationId, baseException);
                    Telemetry.getInstance().flush(correlationId);
                }
            });
        }
    }

    private static void logInteractiveRequestParameters(String methodName, AcquireTokenOperationParameters params) {
        Logger.info(TAG + methodName, "Requested " + params.getScopes().size() + " scopes");
        Logger.infoPII(TAG + methodName, "----\nRequested scopes:");
        for (String string : params.getScopes()) {
            Logger.infoPII(TAG + methodName, "\t" + string);
        }
        Logger.infoPII(TAG + methodName, "----");
        Logger.infoPII(TAG + methodName, "ClientId: [" + params.getClientId() + "]");
        Logger.infoPII(TAG + methodName, "RedirectUri: [" + params.getRedirectUri() + "]");
        Logger.infoPII(TAG + methodName, "Login hint: [" + params.getLoginHint() + "]");
        if (null != params.getExtraQueryStringParameters()) {
            Logger.infoPII(TAG + methodName, "Extra query params:");
            for (Pair pair : params.getExtraQueryStringParameters()) {
                Logger.infoPII(TAG + methodName, "\t\"" + (String)pair.first + "\":\"" + (String)pair.second + "\"");
            }
        }
        if (null != params.getExtraScopesToConsent()) {
            Logger.infoPII(TAG + methodName, "Extra scopes to consent:");
            for (String string : params.getExtraScopesToConsent()) {
                Logger.infoPII(TAG + methodName, "\t" + string);
            }
        }
        Logger.info(TAG + methodName, "Using authorization agent: " + params.getAuthorizationAgent().toString());
        if (null != params.getAccount()) {
            Logger.infoPII(TAG + methodName, "Using account: " + params.getAccount().getHomeAccountId());
        }
    }

    private static void logSilentRequestParams(String methodName, AcquireTokenSilentOperationParameters parameters) {
        Logger.infoPII(TAG + methodName, "ClientId: [" + parameters.getClientId() + "]");
        Logger.infoPII(TAG + methodName, "----\nRequested scopes:");
        for (String scope : parameters.getScopes()) {
            Logger.infoPII(TAG + methodName, "\t" + scope);
        }
        Logger.infoPII(TAG + methodName, "----");
        if (null != parameters.getAccount()) {
            Logger.infoPII(TAG + methodName, "Using account: " + parameters.getAccount().getHomeAccountId());
        }
        Logger.info(TAG + methodName, "Force refresh? [" + parameters.getForceRefresh() + "]");
    }

    private static void completeInteractive(Intent resultIntent) {
        String methodName = ":completeInteractive";
        int requestCode = resultIntent.getIntExtra("com.microsoft.identity.client.request.code", 0);
        int resultCode = resultIntent.getIntExtra("com.microsoft.identity.client.result.code", 0);
        if (sCommand != null) {
            sCommand.notify(requestCode, resultCode, resultIntent);
        } else {
            Logger.warn(TAG + ":completeInteractive", "sCommand is null, No interactive call in progress to complete.");
        }
    }

    public static String initializeDiagnosticContext(@Nullable String requestCorrelationId) {
        String methodName = ":initializeDiagnosticContext";
        String correlationId = TextUtils.isEmpty((CharSequence)requestCorrelationId) ? UUID.randomUUID().toString() : requestCorrelationId;
        RequestContext rc = new RequestContext();
        rc.put("correlation_id", correlationId);
        DiagnosticContext.setRequestContext(rc);
        Logger.verbose(TAG + ":initializeDiagnosticContext", "Initialized new DiagnosticContext");
        return correlationId;
    }

    public static int getCachedResultCount() {
        return sCommandResultCache.getSize();
    }
}

