/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import android.content.Intent;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.adal.internal.net.HttpWebRequest;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.authorities.Authority;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAudience;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.internal.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.internal.authscheme.ITokenAuthenticationSchemeInternal;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.cache.SchemaUtil;
import com.microsoft.identity.common.internal.dto.AccessTokenRecord;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.IdTokenRecord;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.net.ObjectMapper;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftTokenRequest;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftTokenResponse;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResponse;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.IResult;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.internal.providers.oauth2.OpenIdConnectPromptParameter;
import com.microsoft.identity.common.internal.providers.oauth2.TokenRequest;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResponse;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResult;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.BrokerAcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.request.SdkType;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.LocalAuthenticationResult;
import com.microsoft.identity.common.internal.telemetry.CliTelemInfo;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.CacheEndEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;

public abstract class BaseController {
    private static final String TAG = BaseController.class.getSimpleName();
    public static final Set<String> DEFAULT_SCOPES = new HashSet<String>();

    public static String getDelimitedDefaultScopeString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String scope : DEFAULT_SCOPES) {
            stringBuilder.append(scope);
            stringBuilder.append(' ');
        }
        return stringBuilder.toString().trim();
    }

    public abstract AcquireTokenResult acquireToken(AcquireTokenOperationParameters var1) throws Exception;

    public abstract void completeAcquireToken(int var1, int var2, Intent var3);

    public abstract AcquireTokenResult acquireTokenSilent(AcquireTokenSilentOperationParameters var1) throws Exception;

    public abstract List<ICacheRecord> getAccounts(OperationParameters var1) throws Exception;

    public abstract boolean removeAccount(OperationParameters var1) throws Exception;

    public abstract boolean getDeviceMode(OperationParameters var1) throws Exception;

    public abstract List<ICacheRecord> getCurrentAccount(OperationParameters var1) throws Exception;

    public abstract boolean removeCurrentAccount(OperationParameters var1) throws Exception;

    protected final AuthorizationRequest.Builder initializeAuthorizationRequestBuilder(@NonNull AuthorizationRequest.Builder builder, @NonNull OperationParameters parameters) {
        UUID correlationId = null;
        try {
            correlationId = UUID.fromString((String)DiagnosticContext.getRequestContext().get("correlation_id"));
        }
        catch (IllegalArgumentException ex) {
            Logger.error(TAG, "correlation id from diagnostic context is not a UUID", ex);
        }
        ((AuthorizationRequest.Builder)((AuthorizationRequest.Builder)builder.setClientId(parameters.getClientId())).setRedirectUri(parameters.getRedirectUri())).setCorrelationId(correlationId);
        if (parameters instanceof AcquireTokenOperationParameters) {
            AcquireTokenOperationParameters acquireTokenOperationParameters = (AcquireTokenOperationParameters)parameters;
            if (acquireTokenOperationParameters.getAuthority() instanceof AzureActiveDirectoryAuthority) {
                AzureActiveDirectoryAuthority requestAuthority = (AzureActiveDirectoryAuthority)acquireTokenOperationParameters.getAuthority();
                ((MicrosoftAuthorizationRequest.Builder)((MicrosoftAuthorizationRequest.Builder)((MicrosoftAuthorizationRequest.Builder)builder).setAuthority(requestAuthority.getAuthorityURL())).setMultipleCloudAware(requestAuthority.mMultipleCloudsSupported)).setSlice(requestAuthority.mSlice);
            }
            if (builder instanceof MicrosoftStsAuthorizationRequest.Builder) {
                ((MicrosoftStsAuthorizationRequest.Builder)builder).setTokenScope(TextUtils.join((CharSequence)" ", parameters.getScopes()));
            }
            if (acquireTokenOperationParameters.getExtraScopesToConsent() != null) {
                parameters.getScopes().addAll(acquireTokenOperationParameters.getExtraScopesToConsent());
            }
            ((AuthorizationRequest.Builder)((AuthorizationRequest.Builder)((AuthorizationRequest.Builder)((AuthorizationRequest.Builder)((AuthorizationRequest.Builder)builder.setLoginHint(acquireTokenOperationParameters.getLoginHint())).setExtraQueryParams(acquireTokenOperationParameters.getExtraQueryStringParameters())).setPrompt(acquireTokenOperationParameters.getOpenIdConnectPromptParameter().toString())).setClaims(parameters.getClaimsRequestJson())).setRequestHeaders(acquireTokenOperationParameters.getRequestHeaders())).setWebViewZoomEnabled(acquireTokenOperationParameters.isWebViewZoomEnabled()).setWebViewZoomControlsEnabled(acquireTokenOperationParameters.isWebViewZoomControlsEnabled());
            if (!StringExtensions.isNullOrBlank(acquireTokenOperationParameters.getLoginHint()) && acquireTokenOperationParameters.getOpenIdConnectPromptParameter() == OpenIdConnectPromptParameter.SELECT_ACCOUNT) {
                builder.setPrompt(null);
            }
        }
        builder.setScope(TextUtils.join((CharSequence)" ", parameters.getScopes()));
        return builder;
    }

    protected AuthorizationRequest getAuthorizationRequest(@NonNull OAuth2Strategy strategy, @NonNull OperationParameters parameters) {
        Object builder = strategy.createAuthorizationRequestBuilder(parameters.getAccount());
        this.initializeAuthorizationRequestBuilder((AuthorizationRequest.Builder)builder, parameters);
        return ((AuthorizationRequest.Builder)builder).build();
    }

    protected TokenResult performTokenRequest(@NonNull OAuth2Strategy strategy, @NonNull AuthorizationRequest request, @NonNull AuthorizationResponse response, @NonNull AcquireTokenOperationParameters parameters) throws IOException, ClientException {
        String methodName = ":performTokenRequest";
        HttpWebRequest.throwIfNetworkNotAvailable(parameters.getAppContext());
        Object tokenRequest = strategy.createTokenRequest(request, response, parameters.getAuthenticationScheme());
        BaseController.logExposedFieldsOfObject(TAG + ":performTokenRequest", tokenRequest);
        Object tokenResult = strategy.requestToken(tokenRequest);
        BaseController.logResult(TAG, tokenResult);
        return tokenResult;
    }

    protected void renewAccessToken(@NonNull AcquireTokenSilentOperationParameters parameters, @NonNull AcquireTokenResult acquireTokenSilentResult, @NonNull OAuth2TokenCache tokenCache, @NonNull OAuth2Strategy strategy, @NonNull ICacheRecord cacheRecord) throws IOException, ClientException {
        String methodName = ":renewAccessToken";
        Logger.info(TAG + ":renewAccessToken", "Renewing access token...");
        parameters.setRefreshToken(cacheRecord.getRefreshToken());
        this.logParameters(TAG, parameters);
        TokenResult tokenResult = this.performSilentTokenRequest(strategy, parameters);
        acquireTokenSilentResult.setTokenResult(tokenResult);
        BaseController.logResult(TAG + ":renewAccessToken", tokenResult);
        if (tokenResult.getSuccess()) {
            Logger.info(TAG + ":renewAccessToken", "Token request was successful");
            List<ICacheRecord> savedRecords = tokenCache.saveAndLoadAggregatedAccountData(strategy, this.getAuthorizationRequest(strategy, parameters), tokenResult.getTokenResponse());
            ICacheRecord savedRecord = savedRecords.get(0);
            LocalAuthenticationResult authenticationResult = new LocalAuthenticationResult(this.finalizeCacheRecordForResult(savedRecord, parameters.getAuthenticationScheme()), savedRecords, SdkType.MSAL);
            if (null != tokenResult.getCliTelemInfo()) {
                CliTelemInfo cliTelemInfo = tokenResult.getCliTelemInfo();
                authenticationResult.setSpeRing(cliTelemInfo.getSpeRing());
                authenticationResult.setRefreshTokenAge(cliTelemInfo.getRefreshTokenAge());
                Telemetry.emit(new CacheEndEvent().putSpeInfo(tokenResult.getCliTelemInfo().getSpeRing()));
            } else {
                Telemetry.emit(new CacheEndEvent());
            }
            acquireTokenSilentResult.setLocalAuthenticationResult(authenticationResult);
        }
    }

    public static void logResult(@NonNull String tag, @NonNull IResult result) {
        AuthorizationResult authResult;
        String TAG = tag + ":" + result.getClass().getSimpleName();
        if (result.getSuccess()) {
            Logger.info(TAG, "Success Result");
            BaseController.logExposedFieldsOfObject(TAG, result.getSuccessResponse());
        } else {
            Logger.warn(TAG, "Failure Result");
            if (result.getErrorResponse() != null) {
                if (result.getErrorResponse().getError() != null) {
                    Logger.warn(TAG, "Error: " + result.getErrorResponse().getError());
                }
                if (result.getErrorResponse().getErrorDescription() != null) {
                    Logger.warnPII(TAG, "Description: " + result.getErrorResponse().getErrorDescription());
                }
                BaseController.logExposedFieldsOfObject(TAG, result.getErrorResponse());
            }
        }
        if (result instanceof AuthorizationResult && (authResult = (AuthorizationResult)result).getAuthorizationStatus() != null) {
            Logger.info(TAG, "Authorization Status: " + authResult.getAuthorizationStatus().toString());
        }
    }

    protected void logParameters(String tag, Object parameters) {
        String TAG = tag + ":" + parameters.getClass().getSimpleName();
        if (Logger.getAllowPii()) {
            Logger.infoPII(TAG, ObjectMapper.serializeObjectToJsonString(parameters));
        } else {
            Logger.info(TAG, ObjectMapper.serializeExposedFieldsOfObjectToJsonString(parameters));
        }
    }

    protected static void logExposedFieldsOfObject(@NonNull String tag, @NonNull Object object) {
        String TAG = tag + ":" + object.getClass().getSimpleName();
        Logger.info(TAG, ObjectMapper.serializeExposedFieldsOfObjectToJsonString(object));
    }

    protected TokenResult performSilentTokenRequest(@NonNull OAuth2Strategy strategy, @NonNull AcquireTokenSilentOperationParameters parameters) throws ClientException, IOException {
        String methodName = ":performSilentTokenRequest";
        Logger.info(TAG + ":performSilentTokenRequest", "Requesting tokens...");
        HttpWebRequest.throwIfNetworkNotAvailable(parameters.getAppContext());
        Authority.KnownAuthorityResult authorityResult = Authority.getKnownAuthorityResult(parameters.getAuthority());
        if (!authorityResult.getKnown()) {
            throw authorityResult.getClientException();
        }
        Object refreshTokenRequest = strategy.createRefreshTokenRequest(parameters.getAuthenticationScheme());
        ((TokenRequest)refreshTokenRequest).setClientId(parameters.getClientId());
        ((TokenRequest)refreshTokenRequest).setScope(TextUtils.join((CharSequence)" ", parameters.getScopes()));
        ((TokenRequest)refreshTokenRequest).setRefreshToken(parameters.getRefreshToken().getSecret());
        if (refreshTokenRequest instanceof MicrosoftTokenRequest) {
            ((MicrosoftTokenRequest)refreshTokenRequest).setClaims(parameters.getClaimsRequestJson());
        }
        if (parameters.getSdkType() == SdkType.ADAL) {
            ((MicrosoftTokenRequest)refreshTokenRequest).setIdTokenVersion("1");
        }
        if (parameters instanceof BrokerAcquireTokenSilentOperationParameters) {
            ((MicrosoftTokenRequest)refreshTokenRequest).setBrokerVersion(((BrokerAcquireTokenSilentOperationParameters)parameters).getBrokerVersion());
        }
        if (!StringExtensions.isNullOrBlank(((TokenRequest)refreshTokenRequest).getScope())) {
            Logger.infoPII(TAG + ":performSilentTokenRequest", "Scopes: [" + ((TokenRequest)refreshTokenRequest).getScope() + "]");
        }
        return strategy.requestToken(refreshTokenRequest);
    }

    protected List<ICacheRecord> saveTokens(@NonNull OAuth2Strategy strategy, @NonNull AuthorizationRequest request, @NonNull TokenResponse tokenResponse, @NonNull OAuth2TokenCache tokenCache) throws ClientException {
        String methodName = ":saveTokens";
        Logger.info(TAG + ":saveTokens", "Saving tokens...");
        return tokenCache.saveAndLoadAggregatedAccountData(strategy, request, tokenResponse);
    }

    protected boolean refreshTokenIsNull(@NonNull ICacheRecord cacheRecord) {
        return null == cacheRecord.getRefreshToken();
    }

    protected boolean accessTokenIsNull(@NonNull ICacheRecord cacheRecord) {
        return null == cacheRecord.getAccessToken();
    }

    protected boolean idTokenIsNull(@NonNull ICacheRecord cacheRecord, @NonNull SdkType sdkType) {
        IdTokenRecord idTokenRecord = sdkType == SdkType.ADAL ? cacheRecord.getV1IdToken() : cacheRecord.getIdToken();
        return null == idTokenRecord;
    }

    protected void addDefaultScopes(@NonNull OperationParameters operationParameters) {
        Set<String> requestScopes = operationParameters.getScopes();
        requestScopes.addAll(DEFAULT_SCOPES);
        requestScopes.removeAll(Arrays.asList("", null));
        operationParameters.setScopes(requestScopes);
    }

    protected AccountRecord getCachedAccountRecord(@NonNull AcquireTokenSilentOperationParameters parameters) throws ClientException {
        if (parameters.getAccount() == null) {
            throw new ClientException("no_account_found", "No cached accounts found for the supplied homeAccountId and clientId");
        }
        boolean isB2CAuthority = "B2C".equalsIgnoreCase(parameters.getAuthority().getAuthorityTypeString());
        String clientId = parameters.getClientId();
        String homeAccountId = parameters.getAccount().getHomeAccountId();
        String localAccountId = parameters.getAccount().getLocalAccountId();
        AccountRecord targetAccount = isB2CAuthority ? parameters.getTokenCache().getAccountByHomeAccountId(null, clientId, homeAccountId) : parameters.getTokenCache().getAccountByLocalAccountId(null, clientId, localAccountId);
        if (null == targetAccount) {
            Logger.info(TAG, "No accounts found for clientId [" + clientId + ", ]", null);
            Logger.errorPII(TAG, "No accounts found for clientId, homeAccountId: [" + clientId + ", " + homeAccountId + "]", null);
            throw new ClientException("no_account_found", "No cached accounts found for the supplied homeAccountId");
        }
        return targetAccount;
    }

    protected boolean isRequestAuthorityRealmSameAsATRealm(@NonNull Authority requestAuthority, @NonNull AccessTokenRecord accessTokenRecord) throws ServiceException, ClientException {
        if (requestAuthority instanceof AzureActiveDirectoryAuthority) {
            String tenantId = ((AzureActiveDirectoryAuthority)requestAuthority).getAudience().getTenantId();
            if (AzureActiveDirectoryAudience.isHomeTenantAlias(tenantId)) {
                String utidFromHomeAccountId = accessTokenRecord.getHomeAccountId().split(Pattern.quote("."))[1];
                return utidFromHomeAccountId.equalsIgnoreCase(accessTokenRecord.getRealm());
            }
            tenantId = ((AzureActiveDirectoryAuthority)requestAuthority).getAudience().getTenantUuidForAlias(requestAuthority.getAuthorityURL().toString());
            return tenantId.equalsIgnoreCase(accessTokenRecord.getRealm());
        }
        return true;
    }

    protected boolean isMsaAccount(MicrosoftTokenResponse microsoftTokenResponse) {
        String tenantId = SchemaUtil.getTenantId(microsoftTokenResponse.getClientInfo(), microsoftTokenResponse.getIdToken());
        return "9188040d-6c67-4c5b-b112-36a304b66dad".equalsIgnoreCase(tenantId);
    }

    public ICacheRecord finalizeCacheRecordForResult(@NonNull ICacheRecord cacheRecord, @NonNull AbstractAuthenticationScheme scheme) throws ClientException {
        if (scheme instanceof ITokenAuthenticationSchemeInternal) {
            ITokenAuthenticationSchemeInternal tokenAuthScheme = (ITokenAuthenticationSchemeInternal)((Object)scheme);
            cacheRecord.getAccessToken().setSecret(tokenAuthScheme.getAccessTokenForScheme(cacheRecord.getAccessToken().getSecret()));
        }
        return cacheRecord;
    }

    static {
        DEFAULT_SCOPES.add("openid");
        DEFAULT_SCOPES.add("offline_access");
        DEFAULT_SCOPES.add("profile");
    }
}

