/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.security.keystore.KeyInfo;
import android.security.keystore.StrongBoxUnavailableException;
import android.text.TextUtils;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.controllers.TaskCompletedCallbackWithError;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.platform.IDevicePopManager;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.impl.RSAKeyUtils;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.security.auth.x500.X500Principal;
import org.json.JSONException;
import org.json.JSONObject;

class DevicePopManager
implements IDevicePopManager {
    private static final String TAG = DevicePopManager.class.getSimpleName();
    private static final String KEYSTORE_ENTRY_ALIAS = "microsoft-device-pop";
    private static final int RSA_KEY_SIZE = 2048;
    private final KeyStore mKeyStore = KeyStore.getInstance("AndroidKeyStore");
    private static final String ANDROID_KEYSTORE = "AndroidKeyStore";
    private static final ExecutorService sThreadExecutor = Executors.newCachedThreadPool();

    DevicePopManager() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        this.mKeyStore.load(null);
    }

    @Override
    public boolean asymmetricKeyExists() {
        boolean exists = false;
        try {
            exists = this.mKeyStore.containsAlias(KEYSTORE_ENTRY_ALIAS);
        }
        catch (KeyStoreException e) {
            Logger.error(TAG, "Error while querying KeyStore", e);
        }
        return exists;
    }

    @Override
    public boolean asymmetricKeyExists(@NonNull String thumbprint) {
        if (this.asymmetricKeyExists()) {
            try {
                return this.getAsymmetricKeyThumbprint().equals(thumbprint);
            }
            catch (ClientException e) {
                Logger.error(TAG, "Error while comparing thumbprints.", e);
            }
        }
        return false;
    }

    @Override
    public String getAsymmetricKeyThumbprint() throws ClientException {
        String errCode;
        Throwable exception;
        try {
            KeyStore.Entry keyEntry = this.mKeyStore.getEntry(KEYSTORE_ENTRY_ALIAS, null);
            KeyPair rsaKeyPair = DevicePopManager.getKeyPairForEntry(keyEntry);
            RSAKey rsaKey = DevicePopManager.getRsaKeyForKeyPair(rsaKeyPair);
            return DevicePopManager.getThumbprintForRsaKey(rsaKey);
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        catch (JOSEException e) {
            exception = e;
            errCode = "failed_to_compute_thumbprint_with_sha256";
        }
        throw new ClientException(errCode, exception.getMessage(), exception);
    }

    @Override
    public void generateAsymmetricKey(final @NonNull Context context, final @NonNull TaskCompletedCallbackWithError<String, ClientException> callback) {
        sThreadExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.onTaskCompleted(DevicePopManager.this.generateAsymmetricKey(context));
                }
                catch (ClientException e) {
                    callback.onError(e);
                }
            }
        });
    }

    @Override
    public String generateAsymmetricKey(@NonNull Context context) throws ClientException {
        String errCode;
        Throwable exception;
        try {
            KeyPair keyPair = this.generateNewRsaKeyPair(context, 2048);
            RSAKey rsaKey = DevicePopManager.getRsaKeyForKeyPair(keyPair);
            return DevicePopManager.getThumbprintForRsaKey(rsaKey);
        }
        catch (UnsupportedOperationException e) {
            exception = e;
            errCode = "keystore_produced_invalid_cert";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (NoSuchProviderException e) {
            exception = e;
            errCode = "android_keystore_unavailable";
        }
        catch (InvalidAlgorithmParameterException e) {
            exception = e;
            errCode = "keystore_initialization_failed";
        }
        catch (JOSEException e) {
            exception = e;
            errCode = "failed_to_compute_thumbprint_with_sha256";
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(TAG, clientException.getMessage(), clientException);
        throw clientException;
    }

    @Override
    public boolean clearAsymmetricKey() {
        boolean deleted = false;
        try {
            this.mKeyStore.deleteEntry(KEYSTORE_ENTRY_ALIAS);
            deleted = true;
        }
        catch (KeyStoreException e) {
            Logger.error(TAG, "Error while clearing KeyStore", e);
        }
        return deleted;
    }

    @Override
    public String getRequestConfirmation() throws ClientException {
        final CountDownLatch latch = new CountDownLatch(1);
        final String[] result = new String[1];
        final ClientException[] errorResult = new ClientException[1];
        this.getRequestConfirmation(new TaskCompletedCallbackWithError<String, ClientException>(){

            @Override
            public void onTaskCompleted(@NonNull String reqCnf) {
                result[0] = reqCnf;
                latch.countDown();
            }

            @Override
            public void onError(@NonNull ClientException error) {
                errorResult[0] = error;
                latch.countDown();
            }
        });
        try {
            latch.await();
            if (null != result[0]) {
                return result[0];
            }
            throw errorResult[0];
        }
        catch (InterruptedException e) {
            Logger.error(TAG, "Interrupted while waiting on callback.", e);
            throw new ClientException("operation_interrupted", e.getMessage(), e);
        }
    }

    @Override
    public void getRequestConfirmation(final @NonNull TaskCompletedCallbackWithError<String, ClientException> callback) {
        sThreadExecutor.submit(new Runnable(){

            @Override
            public void run() {
                String errCode;
                Throwable exception;
                try {
                    KeyStore.Entry keyEntry = DevicePopManager.this.mKeyStore.getEntry(DevicePopManager.KEYSTORE_ENTRY_ALIAS, null);
                    KeyPair rsaKeyPair = DevicePopManager.getKeyPairForEntry(keyEntry);
                    RSAKey rsaKey = DevicePopManager.getRsaKeyForKeyPair(rsaKeyPair);
                    String base64UrlEncodedJwkJsonStr = DevicePopManager.getReqCnfForRsaKey(rsaKey);
                    callback.onTaskCompleted(base64UrlEncodedJwkJsonStr);
                    return;
                }
                catch (KeyStoreException e) {
                    exception = e;
                    errCode = "keystore_not_initialized";
                }
                catch (NoSuchAlgorithmException e) {
                    exception = e;
                    errCode = "no_such_algorithm";
                }
                catch (UnrecoverableEntryException e) {
                    exception = e;
                    errCode = "protection_params_invalid";
                }
                catch (JOSEException e) {
                    exception = e;
                    errCode = "failed_to_compute_thumbprint_with_sha256";
                }
                catch (JSONException e) {
                    exception = e;
                    errCode = "json_construction_failed";
                }
                ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
                Logger.error(TAG, clientException.getMessage(), clientException);
                callback.onError(clientException);
            }
        });
    }

    @Override
    public String mintSignedAccessToken(@NonNull String httpMethod, @NonNull URL requestUrl, @NonNull String accessToken, @Nullable String nonce) throws ClientException {
        String errCode;
        Throwable exception;
        try {
            JWTClaimsSet.Builder claimsBuilder = new JWTClaimsSet.Builder();
            claimsBuilder.claim("at", (Object)accessToken);
            claimsBuilder.claim("ts", (Object)(System.currentTimeMillis() / 1000L));
            claimsBuilder.claim("m", (Object)httpMethod);
            claimsBuilder.claim("u", (Object)requestUrl.getHost());
            claimsBuilder.claim("p", (Object)requestUrl.getPath());
            claimsBuilder.claim("cnf", (Object)this.getDevicePopJwkMinifiedJson());
            if (!TextUtils.isEmpty((CharSequence)nonce)) {
                claimsBuilder.claim("nonce", (Object)nonce);
            }
            JWTClaimsSet claimsSet = claimsBuilder.build();
            KeyStore.Entry entry = this.mKeyStore.getEntry(KEYSTORE_ENTRY_ALIAS, null);
            PrivateKey privateKey = ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
            RSASSASigner signer = new RSASSASigner(privateKey);
            SignedJWT signedJWT = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.RS256).build(), claimsSet);
            signedJWT.sign((JWSSigner)signer);
            return signedJWT.serialize();
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (JOSEException e) {
            exception = e;
            errCode = "failed_to_sign_jwt";
        }
        catch (UnrecoverableEntryException e) {
            exception = e;
            errCode = "protection_params_invalid";
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), exception);
        Logger.error(TAG, clientException.getMessage(), clientException);
        throw clientException;
    }

    @SuppressLint(value={"NewApi"})
    private KeyPair generateNewRsaKeyPair(@NonNull Context context, int minKeySize) throws UnsupportedOperationException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        int MAX_RETRIES = 4;
        for (int ii = 0; ii < 4; ++ii) {
            KeyPair kp;
            try {
                kp = this.generateNewKeyPair(context, true);
            }
            catch (StrongBoxUnavailableException e) {
                Logger.error(TAG, "StrongBox unsupported - skipping hardware flags.", e);
                kp = this.generateNewKeyPair(context, false);
            }
            int length = RSAKeyUtils.keyBitLength((PrivateKey)kp.getPrivate());
            if (length < minKeySize && length >= 0) continue;
            this.logSecureHardwareState(kp);
            return kp;
        }
        this.clearAsymmetricKey();
        throw new UnsupportedOperationException("Failed to generate valid KeyPair. Attempted 4 times.");
    }

    private void logSecureHardwareState(@NonNull KeyPair kp) {
        String msg;
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                PrivateKey privateKey = kp.getPrivate();
                KeyFactory factory = KeyFactory.getInstance(privateKey.getAlgorithm(), ANDROID_KEYSTORE);
                KeyInfo info = factory.getKeySpec(privateKey, KeyInfo.class);
                boolean isInsideSecureHardware = info.isInsideSecureHardware();
                msg = "SecretKey is secure hardware backed? " + isInsideSecureHardware;
            }
            catch (Exception e) {
                msg = "Failed to query secure hardware state.";
            }
        } else {
            msg = "Cannot query secure hardware state (API unavailable <23)";
        }
        Logger.info(TAG, msg);
    }

    @RequiresApi(api=18)
    private KeyPair generateNewKeyPair(@NonNull Context context, boolean useStrongbox) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, StrongBoxUnavailableException {
        KeyPairGenerator kpg = this.getInitializedRsaKeyPairGenerator(context, 2048, useStrongbox);
        return kpg.generateKeyPair();
    }

    @RequiresApi(api=18)
    private KeyPairGenerator getInitializedRsaKeyPairGenerator(@NonNull Context context, int keySize, boolean useStrongbox) throws InvalidAlgorithmParameterException, NoSuchProviderException, NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", ANDROID_KEYSTORE);
        DevicePopManager.initialize(context, keyPairGenerator, keySize, useStrongbox);
        return keyPairGenerator;
    }

    @RequiresApi(api=18)
    private static void initialize(@NonNull Context context, @NonNull KeyPairGenerator keyPairGenerator, int keySize, boolean useStrongbox) throws InvalidAlgorithmParameterException {
        if (Build.VERSION.SDK_INT < 23) {
            DevicePopManager.initializePre23(context, keyPairGenerator, keySize);
        } else {
            DevicePopManager.initialize23(keyPairGenerator, keySize, useStrongbox);
        }
    }

    @SuppressLint(value={"InlinedApi"})
    @RequiresApi(api=23)
    private static void initialize23(@NonNull KeyPairGenerator keyPairGenerator, int keySize, boolean useStrongbox) throws InvalidAlgorithmParameterException {
        KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(KEYSTORE_ENTRY_ALIAS, 15).setKeySize(keySize).setSignaturePaddings(new String[]{"PKCS1"}).setDigests(new String[]{"SHA-256"});
        if (Build.VERSION.SDK_INT >= 28 && useStrongbox) {
            Logger.verbose(TAG, "Attempting to apply StrongBox isolation.");
            builder = DevicePopManager.applyHardwareIsolation(builder);
        }
        KeyGenParameterSpec spec = builder.build();
        keyPairGenerator.initialize((AlgorithmParameterSpec)spec);
    }

    @SuppressLint(value={"NewApi"})
    @RequiresApi(value=28)
    @NonNull
    private static KeyGenParameterSpec.Builder applyHardwareIsolation(@NonNull KeyGenParameterSpec.Builder builder) {
        return builder.setIsStrongBoxBacked(true);
    }

    @SuppressLint(value={"NewApi"})
    @RequiresApi(api=18)
    private static void initializePre23(@NonNull Context context, @NonNull KeyPairGenerator keyPairGenerator, int keySize) throws InvalidAlgorithmParameterException {
        Calendar calendar = Calendar.getInstance();
        Date start = DevicePopManager.getNow(calendar);
        calendar.add(1, 99);
        Date end = calendar.getTime();
        KeyPairGeneratorSpec.Builder specBuilder = new KeyPairGeneratorSpec.Builder(context).setAlias(KEYSTORE_ENTRY_ALIAS).setStartDate(start).setEndDate(end).setSerialNumber(CertificateProperties.SERIAL_NUMBER).setSubject(new X500Principal("CN=device-pop"));
        if (Build.VERSION.SDK_INT >= 19) {
            specBuilder.setAlgorithmParameterSpec((AlgorithmParameterSpec)new RSAKeyGenParameterSpec(keySize, RSAKeyGenParameterSpec.F4));
        }
        KeyPairGeneratorSpec spec = specBuilder.build();
        keyPairGenerator.initialize((AlgorithmParameterSpec)spec);
    }

    private static Date getNow(@NonNull Calendar calendar) {
        return calendar.getTime();
    }

    private static KeyPair getKeyPairForEntry(@NonNull KeyStore.Entry entry) {
        PrivateKey privateKey = ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
        PublicKey publicKey = ((KeyStore.PrivateKeyEntry)entry).getCertificate().getPublicKey();
        return new KeyPair(publicKey, privateKey);
    }

    private static RSAKey getRsaKeyForKeyPair(@NonNull KeyPair keyPair) {
        return new RSAKey.Builder((RSAPublicKey)keyPair.getPublic()).privateKey(keyPair.getPrivate()).keyUse(null).build();
    }

    private static String getReqCnfForRsaKey(@NonNull RSAKey rsaKey) throws JOSEException, JSONException {
        String thumbprintStr = DevicePopManager.getThumbprintForRsaKey(rsaKey);
        String thumbprintMinifiedJson = new JSONObject().put("kid", (Object)thumbprintStr).toString();
        return DevicePopManager.base64UrlEncode(thumbprintMinifiedJson);
    }

    private static String getThumbprintForRsaKey(@NonNull RSAKey rsaKey) throws JOSEException {
        Base64URL thumbprint = rsaKey.computeThumbprint();
        return thumbprint.toString();
    }

    private static String base64UrlEncode(@NonNull String input) {
        String result = null;
        try {
            byte[] encodeBytes = input.getBytes("UTF-8");
            result = Base64.encodeToString((byte[])encodeBytes, (int)11);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    private net.minidev.json.JSONObject getDevicePopJwkMinifiedJson() throws UnrecoverableEntryException, NoSuchAlgorithmException, KeyStoreException {
        KeyStore.Entry keyEntry = this.mKeyStore.getEntry(KEYSTORE_ENTRY_ALIAS, null);
        KeyPair rsaKeyPair = DevicePopManager.getKeyPairForEntry(keyEntry);
        RSAKey rsaKey = DevicePopManager.getRsaKeyForKeyPair(rsaKeyPair);
        RSAKey publicRsaKey = rsaKey.toPublicJWK();
        net.minidev.json.JSONObject jwkContents = publicRsaKey.toJSONObject();
        net.minidev.json.JSONObject wrappedJwk = new net.minidev.json.JSONObject();
        wrappedJwk.appendField("jwk", (Object)jwkContents);
        return wrappedJwk;
    }

    static final class KeyPairGeneratorAlgorithms {
        static final String RSA = "RSA";

        KeyPairGeneratorAlgorithms() {
        }
    }

    private static final class SignedHttpRequestJwtClaims {
        private static final String ACCESS_TOKEN = "at";
        private static final String TIMESTAMP = "ts";
        private static final String HTTP_METHOD = "m";
        private static final String HTTP_HOST = "u";
        private static final String HTTP_PATH = "p";
        private static final String CNF = "cnf";
        private static final String NONCE = "nonce";

        private SignedHttpRequestJwtClaims() {
        }
    }

    private static final class CertificateProperties {
        static final int CERTIFICATE_VALIDITY_YEARS = 99;
        static final BigInteger SERIAL_NUMBER = BigInteger.ONE;
        static final String COMMON_NAME = "CN=device-pop";

        private CertificateProperties() {
        }
    }
}

