/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.BaseAccount;
import com.microsoft.identity.common.internal.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.internal.cache.AbstractAccountCredentialCache;
import com.microsoft.identity.common.internal.cache.CacheRecord;
import com.microsoft.identity.common.internal.cache.IAccountCredentialAdapter;
import com.microsoft.identity.common.internal.cache.IAccountCredentialCache;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.internal.dto.AccessTokenRecord;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.Credential;
import com.microsoft.identity.common.internal.dto.CredentialType;
import com.microsoft.identity.common.internal.dto.IdTokenRecord;
import com.microsoft.identity.common.internal.dto.RefreshTokenRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResponse;
import java.util.ArrayList;
import java.util.List;

public class MicrosoftFamilyOAuth2TokenCache<GenericOAuth2Strategy extends OAuth2Strategy, GenericAuthorizationRequest extends AuthorizationRequest, GenericTokenResponse extends TokenResponse, GenericAccount extends BaseAccount, GenericRefreshToken extends RefreshToken>
extends MsalOAuth2TokenCache<GenericOAuth2Strategy, GenericAuthorizationRequest, GenericTokenResponse, GenericAccount, GenericRefreshToken> {
    private static final String TAG = MicrosoftFamilyOAuth2TokenCache.class.getSimpleName();

    public MicrosoftFamilyOAuth2TokenCache(Context context, IAccountCredentialCache accountCredentialCache, IAccountCredentialAdapter<GenericOAuth2Strategy, GenericAuthorizationRequest, GenericTokenResponse, GenericAccount, GenericRefreshToken> accountCredentialAdapter) {
        super(context, accountCredentialCache, accountCredentialAdapter);
    }

    public ICacheRecord loadByFamilyId(@Nullable String clientId, @Nullable String target, @NonNull AccountRecord accountRecord, @Nullable AbstractAuthenticationScheme authenticationScheme) {
        String methodName = ":loadByFamilyId";
        String familyId = "1";
        Logger.verbose(TAG + ":loadByFamilyId", "ClientId[" + clientId + ", " + "1" + "]");
        RefreshTokenRecord rtToReturn = null;
        Credential idTokenToReturn = null;
        AccessTokenRecord atRecordToReturn = null;
        List<Credential> allCredentials = this.getAccountCredentialCache().getCredentials();
        for (Credential credential : allCredentials) {
            RefreshTokenRecord rtRecord;
            if (!(credential instanceof RefreshTokenRecord) || !"1".equals((rtRecord = (RefreshTokenRecord)credential).getFamilyId()) || !accountRecord.getEnvironment().equals(rtRecord.getEnvironment()) || !accountRecord.getHomeAccountId().equals(rtRecord.getHomeAccountId())) continue;
            rtToReturn = rtRecord;
            break;
        }
        for (Credential credential : allCredentials) {
            if (!(credential instanceof IdTokenRecord)) continue;
            IdTokenRecord idTokenRecord = (IdTokenRecord)credential;
            if (null == clientId || !clientId.equals(idTokenRecord.getClientId()) || !accountRecord.getEnvironment().equals(idTokenRecord.getEnvironment()) || !accountRecord.getHomeAccountId().equals(idTokenRecord.getHomeAccountId()) || !accountRecord.getRealm().equals(idTokenRecord.getRealm())) continue;
            idTokenToReturn = idTokenRecord;
            break;
        }
        if (null != target && null != authenticationScheme) {
            for (Credential credential : allCredentials) {
                if (!(credential instanceof AccessTokenRecord)) continue;
                AccessTokenRecord atRecord = (AccessTokenRecord)credential;
                if (null == clientId || !clientId.equals(atRecord.getClientId()) || !accountRecord.getEnvironment().equals(atRecord.getEnvironment()) || !accountRecord.getHomeAccountId().equals(atRecord.getHomeAccountId()) || !accountRecord.getRealm().equals(atRecord.getRealm()) || !AbstractAccountCredentialCache.targetsIntersect(target, atRecord.getTarget(), true)) continue;
                if (CredentialType.AccessToken.name().equalsIgnoreCase(atRecord.getCredentialType()) && "Bearer".equalsIgnoreCase(authenticationScheme.getName())) {
                    atRecordToReturn = atRecord;
                    break;
                }
                if (!CredentialType.AccessToken_With_AuthScheme.name().equalsIgnoreCase(atRecord.getCredentialType()) || !"PoP".equalsIgnoreCase(authenticationScheme.getName())) continue;
                atRecordToReturn = atRecord;
                break;
            }
        }
        CacheRecord result = new CacheRecord();
        result.setAccount(accountRecord);
        result.setRefreshToken(rtToReturn);
        result.setAccessToken(atRecordToReturn);
        if (null != idTokenToReturn) {
            if (CredentialType.V1IdToken.name().equalsIgnoreCase(idTokenToReturn.getCredentialType())) {
                result.setV1IdToken((IdTokenRecord)idTokenToReturn);
            } else {
                result.setIdToken((IdTokenRecord)idTokenToReturn);
            }
        }
        return result;
    }

    public List<ICacheRecord> loadByFamilyIdWithAggregatedAccountData(@NonNull String clientId, @Nullable String target, @NonNull AccountRecord account, @Nullable AbstractAuthenticationScheme authenticationScheme) {
        String methodName = ":loadByFamilyIdWithAggregatedAccountData";
        ArrayList<ICacheRecord> result = new ArrayList<ICacheRecord>();
        result.add(this.loadByFamilyId(clientId, target, account, authenticationScheme));
        ArrayList<AccountRecord> accountsInOtherTenants = new ArrayList<AccountRecord>(this.getAllTenantAccountsForAccountByClientId(clientId, account));
        Logger.info(TAG + ":loadByFamilyIdWithAggregatedAccountData", "Found " + (accountsInOtherTenants.size() - 1) + " profiles for this account");
        accountsInOtherTenants.remove(0);
        if (!accountsInOtherTenants.isEmpty()) {
            for (AccountRecord accountRecord : accountsInOtherTenants) {
                CacheRecord cacheRecord = new CacheRecord();
                cacheRecord.setAccount(accountRecord);
                cacheRecord.setRefreshToken(((ICacheRecord)result.get(0)).getRefreshToken());
                List<IdTokenRecord> idTokensForAccount = this.getIdTokensForAccountRecord(clientId, accountRecord);
                for (IdTokenRecord idTokenRecord : idTokensForAccount) {
                    if (CredentialType.V1IdToken.name().equalsIgnoreCase(idTokenRecord.getCredentialType())) {
                        cacheRecord.setV1IdToken(idTokenRecord);
                        continue;
                    }
                    cacheRecord.setIdToken(idTokenRecord);
                }
                result.add(cacheRecord);
            }
        }
        return result;
    }
}

